/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;

public class DashEditor
extends TextFieldEditor {
    private static final Logger logger = Logger.getLogger(DashEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DashEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DashEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DashEditor.class.getName(), method, result);
    }

    public DashEditor() {
        super(true);
    }

    public DashEditor(boolean allowNull) {
        super(allowNull);
    }

    public DashEditor(TextFieldEditor sample) {
        super(sample);
    }

    @Override
    public CustomEditor clone() {
        return new DashEditor(this);
    }

    @Override
    protected Object getTextFieldValue() {
        String txt = this.getTextField().getText();
        if (txt != null && txt.length() > 0) {
            String[] itms = txt.split("\\s*,\\s*|\\s+");
            ArrayList<Float> res = new ArrayList<Float>();
            for (String itm : itms) {
                if (itm == null || !itm.matches("\\d+(\\.\\d+)?")) continue;
                Float f = Float.valueOf(Float.parseFloat(itm));
                res.add(f);
            }
            float[] dasharr = new float[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                dasharr[i] = ((Float)res.get(i)).floatValue();
            }
            return dasharr;
        }
        return null;
    }

    @Override
    protected void setTextFieldValue(Object value) {
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            Class<?> c = value.getClass();
            if (c.isArray()) {
                int l = Array.getLength(value);
                for (int i = 0; i < l; ++i) {
                    Object itm = Array.get(value, i);
                    if (itm == null) continue;
                    sb.append(itm).append(" ");
                }
                super.setTextFieldValue(sb.toString());
                return;
            }
        }
        super.setTextFieldValue(value);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

