/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import xyz.cofe.collection.Func2;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.GetDateFormat;
import xyz.cofe.gui.swing.cell.GetNumberFormat;
import xyz.cofe.gui.swing.cell.LabelRender;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.tree.FormattedValue;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;
import xyz.cofe.text.Text;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class DefaultLabelRender
extends LabelRender {
    private static final Logger logger = Logger.getLogger(DefaultLabelRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Func2<Object, Graphics, Rectangle> customPainter;
    protected static Icon blobIcon;
    protected static Icon clobIcon;
    protected static Icon nullIcon;
    protected NumberFormat numberFormat;
    protected DateFormat dateFormat;
    protected TypeCastGraph typeCastGraph;
    private static final byte[] byteArr1;
    private static final Byte[] byteArr2;
    private final AtomicReference renderValRef = new AtomicReference<Object>(null);

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DefaultLabelRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DefaultLabelRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DefaultLabelRender.class.getName(), method, result);
    }

    public DefaultLabelRender() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZZZ");
    }

    public DefaultLabelRender(CellFormat cellFormat) {
        super(cellFormat);
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZZZ");
        }
    }

    public DefaultLabelRender(LabelRender sample) {
        super(sample);
        this.dateFormat = sample instanceof DefaultLabelRender ? ((DefaultLabelRender)sample).dateFormat : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZZZ");
    }

    @Override
    public synchronized DefaultLabelRender clone() {
        return new DefaultLabelRender(this);
    }

    public synchronized NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public synchronized void setNumberFormat(NumberFormat df) {
        this.numberFormat = df;
    }

    public synchronized DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public synchronized void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public synchronized TypeCastGraph getTypeCastGraph() {
        if (this.typeCastGraph == null) {
            this.typeCastGraph = new ExtendedCastGraph();
        }
        return this.typeCastGraph;
    }

    public synchronized void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        this.typeCastGraph = typeCastGraph;
    }

    private String asText(Object renderval, CellFormat cf, String nullvalue) {
        StringBuilder sb;
        Object[] bytes;
        if (renderval == null) {
            return nullvalue;
        }
        if (renderval instanceof PropertyValue) {
            PropertyValue pv = (PropertyValue)renderval;
            renderval = pv.getValue();
        } else {
            if (renderval instanceof TreeTableNode) {
                TreeTableNode ttnode = (TreeTableNode)renderval;
                renderval = ttnode.getData();
            } else if (renderval instanceof TreeTableNodeValue) {
                TreeTableNodeValue ttnv = (TreeTableNodeValue)renderval;
                renderval = ttnv.getValue();
            }
            if (renderval instanceof Property) {
                renderval = ((Property)renderval).getName();
            }
        }
        if (renderval instanceof Number) {
            NumberFormat nf;
            NumberFormat cnf = cf instanceof GetNumberFormat ? cf.getNumberFormat() : null;
            NumberFormat numberFormat = nf = cnf != null ? cnf : this.numberFormat;
            if (nf != null) {
                return nf.format(renderval);
            }
        }
        if (renderval instanceof Date) {
            DateFormat df;
            DateFormat cdf = cf instanceof GetDateFormat ? cf.getDateFormat() : null;
            DateFormat dateFormat = df = cdf != null ? cdf : this.dateFormat;
            if (df != null) {
                return df.format(renderval);
            }
            return renderval.toString();
        }
        if (renderval instanceof Boolean) {
            return ((Boolean)renderval).toString();
        }
        if (Objects.equals(renderval.getClass(), byteArr1.getClass())) {
            bytes = (byte[])renderval;
            sb = new StringBuilder();
            sb.append("0x");
            int blimit = 64;
            for (int bptr = 0; bptr < bytes.length && (bptr < blimit || blimit <= 0); ++bptr) {
                sb.append(Text.getHex((byte)bytes[bptr]));
            }
            return sb.toString();
        }
        if (Objects.equals(renderval.getClass(), byteArr2.getClass())) {
            bytes = (Byte[])renderval;
            sb = new StringBuilder();
            sb.append("0x");
            int blimit = 64;
            for (int bptr = 0; bptr < bytes.length && (bptr < blimit || blimit <= 0); ++bptr) {
                sb.append(Text.getHex((byte)bytes[bptr].byteValue()));
            }
            return sb.toString();
        }
        TypeCastGraph tcast = this.getTypeCastGraph();
        if (tcast != null) {
            try {
                String str = (String)tcast.cast(renderval, String.class);
                return str;
            }
            catch (Throwable err) {
                return renderval.toString();
            }
        }
        return renderval.toString();
    }

    protected synchronized void prepareCellContext(Graphics2D gs, CellContext context, CellFormat cf, AtomicReference rendervalref) {
        Object renderval = rendervalref.get();
        if (renderval instanceof Number) {
            rendervalref.set(this.asText(renderval, cf, renderval.toString()));
        } else if (renderval instanceof Date) {
            rendervalref.set(this.asText(renderval, cf, renderval.toString()));
        } else if (renderval instanceof Boolean) {
            rendervalref.set(this.asText(renderval, cf, renderval.toString()));
        } else if (renderval != null) {
            String str = this.asText(renderval, cf, null);
            if (str != null) {
                rendervalref.set(str);
            } else {
                rendervalref.set("");
                cf.setIcon(nullIcon);
            }
        } else if (renderval == null) {
            rendervalref.set("");
            cf.setIcon(nullIcon);
        }
    }

    @Override
    public synchronized boolean prepare(Graphics2D gs, CellContext context, CellFormat cf) {
        this.customPainter = null;
        if (cf == null) {
            cf = this.getFormat().clone();
        }
        if (context != null) {
            Object val = context.getValue();
            TreeTableNodeGetFormat fmtval = val instanceof FormattedValue ? (FormattedValue)val : null;
            Object renderval = val;
            if (val instanceof TreeTableNodeValue) {
                TreeTableNodeValue ttnv = (TreeTableNodeValue)val;
                Func2<Object, Graphics, Rectangle> cutmp = ttnv.getCustomPainter();
                if (cutmp != null) {
                    this.customPainter = cutmp;
                } else {
                    renderval = ttnv.getValue();
                }
                fmtval = ttnv;
            }
            if (val instanceof PropertyValue) {
                PropertyValue pv = (PropertyValue)val;
                renderval = pv.getValue();
            }
            if (fmtval != null) {
                try {
                    TreeTableNodeFormat ttnf = fmtval.getTreeTableNodeFormat();
                    if (ttnf != null) {
                        if (ttnf.getIcons().size() > 0) {
                            cf.setIcon(ttnf.getIcons().get(0));
                            cf.iconPadRight(3.0);
                        }
                        if (ttnf.getFontFamily() != null) {
                            cf.font(ttnf.getFontFamily(), 11.0f, false, false);
                        }
                        if (ttnf.getItalic() != null) {
                            cf.italic(ttnf.getItalic());
                        }
                        if (ttnf.getBold() != null) {
                            cf.bold(ttnf.getBold());
                        }
                        if (ttnf.getForeground() != null) {
                            cf.color(ttnf.getForeground());
                        }
                        if (ttnf.getBackground() != null) {
                            cf.backgroundColor(ttnf.getBackground());
                        }
                    }
                }
                catch (Throwable err) {
                    DefaultLabelRender.logException(err);
                    String msg = err.getLocalizedMessage();
                    if (msg == null && (msg = err.getMessage()) == null) {
                        msg = err.getClass().getSimpleName();
                    }
                    context.value(msg);
                }
            }
            this.renderValRef.set(renderval);
            this.prepareCellContext(gs, context, cf, this.renderValRef);
            renderval = this.renderValRef.get();
            if (!Objects.equals(val, renderval)) {
                context.value(renderval);
            }
        }
        return super.prepare(gs, context, cf);
    }

    @Override
    public synchronized void cellRender(Graphics2D gs, CellContext context) {
        if (!this.prepare(gs, context, this.getFormat().clone())) {
            return;
        }
        if (this.customPainter != null && context != null) {
            this.backgroundRender(gs);
            Rectangle2D bnds = context.getBounds();
            if (bnds != null) {
                Rectangle r = new Rectangle((int)bnds.getMinX(), (int)bnds.getMinY(), (int)bnds.getWidth(), (int)bnds.getHeight());
                this.customPainter.apply((Object)gs, (Object)r);
            }
            this.borderRender(gs);
        } else {
            this.backgroundRender(gs);
            this.textRender(gs);
            this.imageRender(gs);
            this.borderRender(gs);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        URL uBlob = DefaultLabelRender.class.getResource("blob-23x14.png");
        if (uBlob != null) {
            blobIcon = new ImageIcon(uBlob);
        }
        URL uClob = DefaultLabelRender.class.getResource("clob-23x14.png");
        if (uBlob != null) {
            clobIcon = new ImageIcon(uClob);
        }
        URL uNull = DefaultLabelRender.class.getResource("null-23x14.png");
        if (uBlob != null) {
            nullIcon = new ImageIcon(uNull);
        }
        byteArr1 = new byte[0];
        byteArr2 = new Byte[0];
    }
}

