/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellRender;
import xyz.cofe.gui.swing.cell.TableContext;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.color.NColorModificator;

public class FillRender
implements CellRender {
    private static final Logger logger = Logger.getLogger(FillRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Color baseColor;
    protected Color color;
    protected double width = 1.0;
    protected boolean widthRelative = true;
    protected double height = 1.0;
    protected boolean heightRelative = true;
    protected double halign = 0.0;
    protected double valign = 0.0;
    protected List<NColorModificator> rowModificators = new ArrayList<NColorModificator>();
    protected List<NColorModificator> columnModificators = new ArrayList<NColorModificator>();
    protected ColorModificator selectModificator;
    protected ColorModificator focusModificator;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FillRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FillRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FillRender.class.getName(), method, result);
    }

    public FillRender() {
    }

    public FillRender(Color color) {
        this.baseColor = color;
    }

    public FillRender(FillRender sample) {
        if (sample != null) {
            this.baseColor = sample.baseColor;
            this.width = sample.width;
            this.widthRelative = sample.widthRelative;
            this.height = sample.height;
            this.heightRelative = sample.heightRelative;
            this.valign = sample.valign;
            this.halign = sample.halign;
            this.focusModificator = sample.focusModificator != null ? sample.focusModificator.clone() : null;
            this.selectModificator = sample.selectModificator != null ? sample.selectModificator.clone() : null;
            for (NColorModificator cm : sample.getRowModificators()) {
                if (cm == null) continue;
                this.getRowModificators().add(cm.clone());
            }
            for (NColorModificator cm : sample.getColumnModificators()) {
                if (cm == null) continue;
                this.getColumnModificators().add(cm.clone());
            }
        }
    }

    @Override
    public FillRender clone() {
        return new FillRender(this);
    }

    public synchronized Color getBaseColor() {
        return this.baseColor;
    }

    public synchronized void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    public synchronized FillRender baseColor(Color v) {
        this.setBaseColor(v);
        return this;
    }

    public synchronized Color getColor() {
        return this.color;
    }

    public synchronized void setColor(Color \u0441olor) {
        this.color = \u0441olor;
    }

    public synchronized FillRender \u0441olor(Color v) {
        this.setColor(v);
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public FillRender width(double v) {
        this.setWidth(v);
        return this;
    }

    public boolean isWidthRelative() {
        return this.widthRelative;
    }

    public void setWidthRelative(boolean widthRelative) {
        this.widthRelative = widthRelative;
    }

    public FillRender widthRelative(boolean v) {
        this.setWidthRelative(v);
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public FillRender height(double v) {
        this.setHeight(v);
        return this;
    }

    public boolean isHeightRelative() {
        return this.heightRelative;
    }

    public void setHeightRelative(boolean heightRelative) {
        this.heightRelative = heightRelative;
    }

    public FillRender heightRelative(boolean v) {
        this.setHeightRelative(v);
        return this;
    }

    public double getHalign() {
        return this.halign;
    }

    public void setHalign(double halign) {
        this.halign = halign;
    }

    public FillRender halign(double v) {
        this.setHalign(v);
        return this;
    }

    public double getValign() {
        return this.valign;
    }

    public void setValign(double valign) {
        this.valign = valign;
    }

    public FillRender valign(double v) {
        this.setValign(v);
        return this;
    }

    public synchronized List<NColorModificator> getRowModificators() {
        if (this.rowModificators == null) {
            this.rowModificators = new ArrayList<NColorModificator>();
        }
        return this.rowModificators;
    }

    public synchronized void setRowModificators(List<NColorModificator> mods) {
        this.rowModificators = mods;
    }

    public synchronized FillRender addRowModificator(NColorModificator cm) {
        if (cm != null) {
            this.getRowModificators().add(cm);
        }
        return this;
    }

    public synchronized List<NColorModificator> getColumnModificators() {
        if (this.columnModificators == null) {
            this.columnModificators = new ArrayList<NColorModificator>();
        }
        return this.columnModificators;
    }

    public synchronized void setColumnModificators(List<NColorModificator> mods) {
        this.columnModificators = mods;
    }

    public synchronized FillRender addColumnModificator(NColorModificator cm) {
        if (cm != null) {
            this.getColumnModificators().add(cm);
        }
        return this;
    }

    public synchronized ColorModificator getSelectModificator() {
        return this.selectModificator;
    }

    public synchronized void setSelectModificator(ColorModificator selectModificator) {
        this.selectModificator = selectModificator;
    }

    public synchronized FillRender selectModificator(ColorModificator cm) {
        this.setSelectModificator(cm);
        return this;
    }

    public synchronized ColorModificator getFocusModificator() {
        return this.focusModificator;
    }

    public synchronized void setFocusModificator(ColorModificator focusModificator) {
        this.focusModificator = focusModificator;
    }

    public synchronized FillRender focusModificator(ColorModificator cm) {
        this.setFocusModificator(cm);
        return this;
    }

    @Override
    public Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        return null;
    }

    @Override
    public synchronized void cellRender(Graphics2D gs, CellContext context) {
        Color c;
        if (gs == null) {
            return;
        }
        if (context == null) {
            return;
        }
        Rectangle2D ctxrect = context.getBounds();
        if (ctxrect == null) {
            return;
        }
        Color bc = gs.getColor();
        Color color = c = this.color != null ? this.color : this.baseColor;
        if (c == null) {
            return;
        }
        if (context instanceof TableContext && this.color == null && this.baseColor != null) {
            ColorModificator focMod;
            int ph;
            int cycle;
            int row = ((TableContext)((Object)context)).getRow();
            int col = ((TableContext)((Object)context)).getColumn();
            boolean sel = ((TableContext)((Object)context)).isSelected();
            boolean foc = ((TableContext)((Object)context)).isFocus();
            for (NColorModificator cm : this.getRowModificators()) {
                if (cm == null) continue;
                cycle = cm.getCycle();
                ph = cm.getPhase();
                if (cycle < 1) continue;
                if (cycle == 1) {
                    c = cm.apply(c);
                    continue;
                }
                if (row % cycle != ph) continue;
                c = cm.apply(c);
            }
            for (NColorModificator cm : this.getColumnModificators()) {
                if (cm == null) continue;
                cycle = cm.getCycle();
                ph = cm.getPhase();
                if (cycle < 1) continue;
                if (cycle == 1) {
                    c = cm.apply(c);
                    continue;
                }
                if (col % cycle != ph) continue;
                c = cm.apply(c);
            }
            ColorModificator selMod = this.selectModificator;
            if (selMod != null && sel) {
                c = selMod.apply(c);
            }
            if ((focMod = this.focusModificator) != null && foc) {
                c = focMod.apply(c);
            }
        }
        double w = this.widthRelative ? this.width * ctxrect.getWidth() : this.width;
        double h = this.heightRelative ? this.height * ctxrect.getHeight() : this.height;
        double x = ctxrect.getMinX() + (ctxrect.getWidth() - w) * this.halign;
        double y = ctxrect.getMinY() + (ctxrect.getHeight() - h) * this.valign;
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        gs.setColor(c);
        gs.fill(rect);
        gs.setColor(bc);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

