/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.map.LRUCache;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellRender;
import xyz.cofe.gui.swing.cell.TableContext;
import xyz.cofe.gui.swing.cell.TextAliasing;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.color.NColorModificator;
import xyz.cofe.gui.swing.text.FlatBlock;
import xyz.cofe.perfomance.TimeLaps;
import xyz.cofe.text.Text;

public class FlatTextRender
implements CellRender {
    protected Font font;
    protected TextAliasing aliasing = TextAliasing.ON;
    protected double textAlign = 0.0;
    protected double valign = 0.0;
    protected Double halign = 0.0;
    protected Color baseColor;
    protected Color color;
    protected List<NColorModificator> rowModificators = new ArrayList<NColorModificator>();
    protected List<NColorModificator> columnModificators = new ArrayList<NColorModificator>();
    protected ColorModificator selectModificator;
    protected ColorModificator focusModificator;
    protected double paddingLeft = 0.0;
    protected double paddingRight = 0.0;
    protected double paddingTop = 0.0;
    protected double paddingBottom = 0.0;
    protected int maxLinesCount = -1;
    protected int maxLineLength = -1;
    private Map<String, FlatBlock> cache;
    private TimeLaps timeLaps = new TimeLaps();
    private int minCachedTextLength = 150;
    private Checksum crc = new Adler32();

    public FlatTextRender() {
    }

    public FlatTextRender(FlatTextRender sample) {
        if (sample != null) {
            this.font = sample.font;
            this.aliasing = sample.aliasing;
            this.textAlign = sample.textAlign;
            this.valign = sample.valign;
            this.halign = sample.halign;
            this.baseColor = sample.baseColor;
            this.focusModificator = sample.focusModificator != null ? sample.focusModificator.clone() : null;
            this.selectModificator = sample.selectModificator != null ? sample.selectModificator.clone() : null;
            for (NColorModificator cm : sample.getRowModificators()) {
                if (cm == null) continue;
                this.getRowModificators().add(cm.clone());
            }
            for (NColorModificator cm : sample.getColumnModificators()) {
                if (cm == null) continue;
                this.getColumnModificators().add(cm.clone());
            }
            this.paddingLeft = sample.paddingLeft;
            this.paddingTop = sample.paddingTop;
            this.paddingRight = sample.paddingRight;
            this.paddingBottom = sample.paddingBottom;
        }
    }

    @Override
    public FlatTextRender clone() {
        return new FlatTextRender(this);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public FlatTextRender font(Font fnt) {
        this.setFont(fnt);
        return this;
    }

    public TextAliasing getAliasing() {
        return this.aliasing;
    }

    public void setAliasing(TextAliasing aliasing) {
        this.aliasing = aliasing;
    }

    public FlatTextRender aliasing(TextAliasing v) {
        this.setAliasing(v);
        return this;
    }

    public double getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(double textAlign) {
        this.textAlign = textAlign;
    }

    public FlatTextRender textAlign(double v) {
        this.setTextAlign(v);
        return this;
    }

    public double getValign() {
        return this.valign;
    }

    public void setValign(double valign) {
        this.valign = valign;
    }

    public FlatTextRender valign(double v) {
        this.setValign(v);
        return this;
    }

    public Double getHalign() {
        return this.halign;
    }

    public void setHalign(Double halign) {
        this.halign = halign;
    }

    public FlatTextRender halign(double v) {
        this.setHalign(v);
        return this;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    public FlatTextRender baseColor(Color v) {
        this.setBaseColor(v);
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public FlatTextRender color(Color v) {
        this.setColor(v);
        return this;
    }

    public List<NColorModificator> getRowModificators() {
        if (this.rowModificators == null) {
            this.rowModificators = new ArrayList<NColorModificator>();
        }
        return this.rowModificators;
    }

    public void setRowModificators(List<NColorModificator> mods) {
        this.rowModificators = mods;
    }

    public List<NColorModificator> getColumnModificators() {
        if (this.columnModificators == null) {
            this.columnModificators = new ArrayList<NColorModificator>();
        }
        return this.columnModificators;
    }

    public void setColumnModificators(List<NColorModificator> mods) {
        this.columnModificators = mods;
    }

    public ColorModificator getSelectModificator() {
        return this.selectModificator;
    }

    public void setSelectModificator(ColorModificator selectModificator) {
        this.selectModificator = selectModificator;
    }

    public FlatTextRender selectModificator(ColorModificator cm) {
        this.setSelectModificator(cm);
        return this;
    }

    public ColorModificator getFocusModificator() {
        return this.focusModificator;
    }

    public void setFocusModificator(ColorModificator focusModificator) {
        this.focusModificator = focusModificator;
    }

    public FlatTextRender focusModificator(ColorModificator cm) {
        this.setFocusModificator(cm);
        return this;
    }

    public double getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(double paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public FlatTextRender paddingLeft(double pad) {
        this.paddingLeft = pad;
        return this;
    }

    public double getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(double paddingRight) {
        this.paddingRight = paddingRight;
    }

    public FlatTextRender paddingRight(double pad) {
        this.paddingLeft = pad;
        return this;
    }

    public double getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(double paddingTop) {
        this.paddingTop = paddingTop;
    }

    public FlatTextRender paddingTop(double pad) {
        this.paddingTop = pad;
        return this;
    }

    public double getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(double paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public FlatTextRender paddingBottom(double pad) {
        this.paddingBottom = pad;
        return this;
    }

    public int getMaxLinesCount() {
        return this.maxLinesCount;
    }

    public void setMaxLinesCount(int maxLinesCount) {
        this.maxLinesCount = maxLinesCount;
    }

    public FlatTextRender maxLinesCount(int maxLinesCount) {
        this.maxLinesCount = maxLinesCount;
        return this;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public FlatTextRender maxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
        return this;
    }

    @Override
    public Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        TimeLaps tlap = this.timeLaps;
        if (tlap != null) {
            tlap.begin("cellRectangle");
        }
        FlatBlock tb = this.prepare(gs, context);
        Pair<Double, Double> pos = this.evalPosition(context, tb);
        Rectangle2D.Double rect = tb.getBounds();
        double x = (Double)pos.A() + this.paddingLeft;
        double y = (Double)pos.B() + this.paddingTop;
        rect = new Rectangle2D.Double(x - this.paddingLeft, y - this.paddingTop, rect.getWidth() + this.paddingLeft + this.paddingRight, rect.getHeight() + this.paddingTop + this.paddingBottom);
        if (tlap != null) {
            tlap.end("cellRectangle");
        }
        return rect;
    }

    @Override
    public void cellRender(Graphics2D gs, CellContext context) {
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        TimeLaps tlap = this.timeLaps;
        if (tlap != null) {
            tlap.begin("cellRender");
        }
        if (tlap != null) {
            tlap.begin("prepare");
        }
        FlatBlock tb = this.prepare(gs, context);
        if (tlap != null) {
            tlap.end("prepare");
        }
        Object taSave = gs.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Paint paintSave = gs.getPaint();
        TextAliasing ta = this.getAliasing();
        if (ta != null) {
            switch (ta) {
                case DEFAULT: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                    break;
                }
                case GASP: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                    break;
                }
                case LCD_HBGR: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR);
                    break;
                }
                case LCD_HRGB: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                    break;
                }
                case LCD_VBGR: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);
                    break;
                }
                case LCD_VRGB: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB);
                    break;
                }
                case OFF: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    break;
                }
                case ON: {
                    gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
            }
        }
        if (this.baseColor != null) {
            Color col = this.baseColor;
            if (context instanceof TableContext) {
                int ph;
                int cycle;
                TableContext tcc = (TableContext)((Object)context);
                int column = tcc.getColumn();
                int row = tcc.getRow();
                for (NColorModificator cm : this.getRowModificators()) {
                    if (cm == null) continue;
                    cycle = cm.getCycle();
                    ph = cm.getPhase();
                    if (cycle < 1) continue;
                    if (cycle == 1) {
                        col = cm.apply(col);
                        continue;
                    }
                    if (row % cycle != ph) continue;
                    col = cm.apply(col);
                }
                for (NColorModificator cm : this.getColumnModificators()) {
                    if (cm == null) continue;
                    cycle = cm.getCycle();
                    ph = cm.getPhase();
                    if (cycle < 1) continue;
                    if (cycle == 1) {
                        col = cm.apply(col);
                        continue;
                    }
                    if (column % cycle != ph) continue;
                    col = cm.apply(col);
                }
                if (this.selectModificator != null && tcc.isSelected()) {
                    col = this.selectModificator.apply(col);
                }
                if (this.focusModificator != null && tcc.isFocus()) {
                    col = this.focusModificator.apply(col);
                }
            }
            gs.setPaint(col);
        }
        if (this.color != null) {
            gs.setPaint(this.color);
        }
        if (tlap != null) {
            tlap.begin("evalPosition");
        }
        Pair<Double, Double> pos = this.evalPosition(context, tb);
        if (tlap != null) {
            tlap.end("evalPosition");
        }
        double x = (Double)pos.A() + this.paddingLeft;
        double y = (Double)pos.B() + this.paddingTop;
        if (tlap != null) {
            tlap.begin("render");
        }
        tb.render(gs, x, y, context.getBounds());
        if (tlap != null) {
            tlap.end("render");
        }
        gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, taSave);
        gs.setPaint(paintSave);
        if (tlap != null) {
            tlap.end("cellRender");
        }
    }

    public Map<String, FlatBlock> getCache() {
        return this.cache;
    }

    public void setCache(Map<String, FlatBlock> cache) {
        this.cache = cache;
    }

    public TimeLaps getTimeLaps() {
        return this.timeLaps;
    }

    public void setTimeLaps(TimeLaps tlap) {
        this.timeLaps = tlap;
    }

    public int getMinCachedTextLength() {
        return this.minCachedTextLength;
    }

    public void setMinCachedTextLength(int minCachedTextLength) {
        this.minCachedTextLength = minCachedTextLength;
    }

    public Checksum getCrc() {
        return this.crc;
    }

    public void setCrc(Checksum crc) {
        this.crc = crc;
    }

    private FlatBlock prepare(Graphics2D gs, CellContext context) {
        String txt;
        TimeLaps tlap = this.timeLaps;
        if (tlap != null) {
            tlap.begin("get ctx");
        }
        Font font = this.font != null ? this.font : gs.getFont();
        FontRenderContext fctx = gs.getFontRenderContext();
        Object value = context.getValue();
        String string = txt = value == null ? "" : value.toString();
        if (tlap != null) {
            tlap.end("get ctx");
        }
        if (this.maxLinesCount > 0) {
            String[] lines;
            if (tlap != null) {
                tlap.begin("split lines");
            }
            if ((lines = Text.splitNewLines((String)txt)).length > this.maxLinesCount) {
                txt = Text.join((String[])lines, (String)"\n", (int)0, (int)this.maxLinesCount) + "...";
            }
            if (tlap != null) {
                tlap.end("split lines");
            }
        }
        Map<String, FlatBlock> cache = this.cache;
        String hash = null;
        if (cache != null && txt.length() >= this.minCachedTextLength) {
            if (tlap != null) {
                tlap.begin("hash");
            }
            hash = FlatBlock.hash(txt, true, this.textAlign, font, this.crc);
            if (tlap != null) {
                tlap.end("hash");
            }
            if (tlap != null) {
                tlap.begin("cache read");
            }
            FlatBlock cached = cache.get(hash);
            if (tlap != null) {
                tlap.end("cache read");
            }
            if (cached != null) {
                return cached;
            }
        }
        if (tlap != null) {
            tlap.begin("FlatBlock");
        }
        FlatBlock tb = null;
        tb = new FlatBlock(txt, true, this.textAlign, font, fctx, hash);
        if (tlap != null) {
            tlap.end("FlatBlock");
        }
        if (cache != null && txt.length() >= this.minCachedTextLength) {
            if (tlap != null) {
                tlap.begin("cache write");
            }
            cache.put(hash, tb);
            if (tlap != null) {
                tlap.end("cache write");
            }
        }
        return tb;
    }

    private Pair<Double, Double> evalPosition(CellContext context, FlatBlock tb) {
        double x = 0.0;
        double y = 0.0;
        Rectangle2D ctxRect = context.getBounds();
        if (ctxRect != null) {
            x = ctxRect.getMinX();
            y = ctxRect.getMinY();
        }
        Rectangle2D.Double txtRect = tb.getBounds();
        if (this.halign != 0.0 && ctxRect != null && txtRect != null) {
            double wdiff = ctxRect.getWidth() - ((RectangularShape)txtRect).getWidth() - this.paddingLeft - this.paddingRight;
            x += wdiff * this.halign;
        }
        if (this.valign != 0.0 && ctxRect != null && txtRect != null) {
            double hdiff = ctxRect.getHeight() - ((RectangularShape)txtRect).getHeight() - this.paddingTop - this.paddingBottom;
            y += hdiff * this.valign;
        }
        return new BasicPair((Object)x, (Object)y);
    }

    public static class TLRUCache
    extends LRUCache<String, FlatBlock> {
        protected long lifetimeLimit = 15000L;
        protected final WeakHashMap<String, Long> cachedTime = new WeakHashMap();

        public TLRUCache(int cacheSizeMax, long lifetimeLimit) {
            super(cacheSizeMax);
            this.lifetimeLimit = lifetimeLimit;
        }

        public long getLifetimeLimit() {
            return this.lifetimeLimit;
        }

        public void setLifetimeLimit(long lifetimeLimit) {
            this.lifetimeLimit = lifetimeLimit;
        }

        public FlatBlock get(Object key) {
            if (key != null) {
                Long tdiff;
                Long t = this.cachedTime.get(key);
                Long l = tdiff = t != null ? Long.valueOf(Math.abs(System.currentTimeMillis() - t)) : null;
                if (tdiff != null && tdiff < this.lifetimeLimit && this.lifetimeLimit > 0L) {
                    return (FlatBlock)super.get(key);
                }
                this.remove(key);
                this.cachedTime.remove(key);
                return null;
            }
            return (FlatBlock)super.get(key);
        }

        public FlatBlock put(String key, FlatBlock value) {
            if (key != null && value != null) {
                this.cachedTime.put(key, System.currentTimeMillis());
            }
            return (FlatBlock)super.put((Object)key, (Object)value);
        }
    }
}

