/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellRender;
import xyz.cofe.gui.swing.cell.IconContext;
import xyz.cofe.gui.swing.cell.ImageContext;
import xyz.cofe.gui.swing.cell.TableCellContext;

public class ImageRender
implements CellRender {
    private static final Logger logger = Logger.getLogger(ImageRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected transient Component iconComponent;
    protected transient WeakReference<Component> iconComponentRef;
    protected double paddingLeft = 0.0;
    protected double paddingRight = 0.0;
    protected double paddingTop = 0.0;
    protected double paddingBottom = 0.0;
    protected double valign = 0.0;
    protected double halign = 0.0;
    protected volatile boolean enableImageContext = true;
    protected volatile boolean enableIconContext = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ImageRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ImageRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ImageRender.class.getName(), method, result);
    }

    public ImageRender() {
    }

    public ImageRender(ImageRender sample) {
        if (sample != null) {
            this.iconComponent = sample.iconComponent;
            this.iconComponentRef = sample.iconComponentRef;
            this.paddingLeft = sample.paddingLeft;
            this.paddingTop = sample.paddingTop;
            this.paddingRight = sample.paddingRight;
            this.paddingBottom = sample.paddingBottom;
            this.halign = sample.halign;
            this.valign = sample.valign;
        }
    }

    public ImageRender(Component cmpt, boolean weakRef) {
        this.setIconComponent(cmpt, weakRef);
    }

    @Override
    public synchronized ImageRender clone() {
        return new ImageRender(this);
    }

    public synchronized Component getIconComponent() {
        if (this.iconComponent != null) {
            return this.iconComponent;
        }
        return this.iconComponentRef != null ? (Component)this.iconComponentRef.get() : null;
    }

    public synchronized void setIconComponent(Component component, boolean weak) {
        this.iconComponent = weak ? null : component;
        this.iconComponentRef = weak && component != null ? new WeakReference<Component>(component) : null;
    }

    public synchronized ImageRender iconComponent(Component component, boolean weak) {
        this.setIconComponent(component, weak);
        return this;
    }

    public synchronized double getPaddingLeft() {
        return this.paddingLeft;
    }

    public synchronized void setPaddingLeft(double paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public synchronized ImageRender paddingLeft(double pad) {
        this.paddingLeft = pad;
        return this;
    }

    public synchronized double getPaddingRight() {
        return this.paddingRight;
    }

    public synchronized void setPaddingRight(double paddingRight) {
        this.paddingRight = paddingRight;
    }

    public synchronized ImageRender paddingRight(double pad) {
        this.paddingLeft = pad;
        return this;
    }

    public synchronized double getPaddingTop() {
        return this.paddingTop;
    }

    public synchronized void setPaddingTop(double paddingTop) {
        this.paddingTop = paddingTop;
    }

    public synchronized ImageRender paddingTop(double pad) {
        this.paddingTop = pad;
        return this;
    }

    public synchronized double getPaddingBottom() {
        return this.paddingBottom;
    }

    public synchronized void setPaddingBottom(double paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public synchronized ImageRender paddingBottom(double pad) {
        this.paddingBottom = pad;
        return this;
    }

    public synchronized double getValign() {
        return this.valign;
    }

    public synchronized void setValign(double valign) {
        this.valign = valign;
    }

    public synchronized ImageRender valign(double valign) {
        this.setValign(valign);
        return this;
    }

    public double getHalign() {
        return this.halign;
    }

    public void setHalign(double halign) {
        this.halign = halign;
    }

    public synchronized ImageRender halign(double halign) {
        this.setHalign(halign);
        return this;
    }

    public synchronized boolean isEnableImageContext() {
        return this.enableImageContext;
    }

    public synchronized void setEnableImageContext(boolean enableImageContext) {
        this.enableImageContext = enableImageContext;
    }

    public synchronized boolean isEnableIconContext() {
        return this.enableIconContext;
    }

    public synchronized void setEnableIconContext(boolean enableIconContext) {
        this.enableIconContext = enableIconContext;
    }

    @Override
    public synchronized Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        Object value = context.getValue();
        if (value instanceof Image) {
            return this.rectOf(gs, (Image)value, context.getBounds());
        }
        if (value instanceof Icon) {
            return this.rectOf(gs, (Icon)value, context.getBounds());
        }
        if (context instanceof ImageContext && this.enableImageContext) {
            return this.rectOf(gs, ((ImageContext)((Object)context)).getImage(), context.getBounds());
        }
        if (context instanceof IconContext && this.enableIconContext) {
            return this.rectOf(gs, ((IconContext)((Object)context)).getIcon(), context.getBounds());
        }
        return null;
    }

    @Override
    public synchronized void cellRender(Graphics2D gs, CellContext context) {
        if (gs == null) {
            return;
        }
        if (context == null) {
            return;
        }
        Object value = context.getValue();
        if (value instanceof Image) {
            this.render(gs, (Image)value, context.getBounds());
        } else if (value instanceof Icon) {
            this.render(gs, (Icon)value, context.getBounds(), context);
        } else if (context instanceof ImageContext && this.enableImageContext) {
            this.render(gs, ((ImageContext)((Object)context)).getImage(), context.getBounds());
        } else if (context instanceof IconContext && this.enableIconContext) {
            this.render(gs, ((IconContext)((Object)context)).getIcon(), context.getBounds(), context);
        }
    }

    private synchronized void render(Graphics2D gs, Image im, Rectangle2D crect) {
        if (im == null || gs == null || crect == null) {
            return;
        }
        double x = crect.getMinX();
        double y = crect.getMinY();
        double iw = (double)im.getWidth(null) + this.paddingLeft + this.paddingRight;
        double ih = (double)im.getHeight(null) + this.paddingTop + this.paddingBottom;
        double xdiff = (double)((int)crect.getWidth()) - iw;
        double ydiff = (double)((int)crect.getHeight()) - ih;
        if (this.halign != 0.0) {
            x += xdiff * this.halign;
        }
        if (this.valign != 0.0) {
            y += ydiff * this.valign;
        }
        gs.drawImage(im, (int)(x + this.paddingLeft), (int)(y + this.paddingTop), null);
    }

    private synchronized Rectangle2D rectOf(Graphics2D gs, Image im, Rectangle2D crect) {
        if (im == null || gs == null || crect == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double iw = (double)im.getWidth(null) + this.paddingLeft + this.paddingRight;
        double ih = (double)im.getHeight(null) + this.paddingTop + this.paddingBottom;
        int x = (int)crect.getMinX();
        int y = (int)crect.getMinY();
        double xdiff = (double)((int)crect.getWidth()) - iw;
        double ydiff = (double)((int)crect.getHeight()) - ih;
        if (this.halign != 0.0) {
            x = (int)((double)x + xdiff * this.halign);
        }
        if (this.valign != 0.0) {
            y = (int)((double)y + ydiff * this.valign);
        }
        return new Rectangle2D.Double(x, y, iw, ih);
    }

    private synchronized void render(Graphics2D gs, Icon im, Rectangle2D crect, CellContext cctx) {
        Image img;
        if (im == null || gs == null || crect == null) {
            return;
        }
        Component c = this.getIconComponent();
        if (c == null && cctx instanceof TableCellContext) {
            c = ((TableCellContext)cctx).getTable();
        }
        if (c != null) {
            int x = (int)crect.getMinX() + (int)this.paddingLeft;
            int y = (int)crect.getMinY() + (int)this.paddingTop;
            int iw = im.getIconWidth() + (int)this.paddingLeft + (int)this.paddingRight;
            int ih = im.getIconHeight() + (int)this.paddingTop + (int)this.paddingBottom;
            double xdiff = (int)crect.getWidth() - iw;
            double ydiff = (int)crect.getHeight() - ih;
            if (this.halign != 0.0) {
                x = (int)((double)x + xdiff * this.halign);
            }
            if (this.valign != 0.0) {
                y = (int)((double)y + ydiff * this.valign);
            }
            im.paintIcon(c, gs, x, y);
        } else if (im instanceof ImageIcon && (img = ((ImageIcon)im).getImage()) != null) {
            this.render(gs, img, crect);
        }
    }

    private synchronized Rectangle2D rectOf(Graphics2D gs, Icon im, Rectangle2D crect) {
        if (im == null || gs == null || crect == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        int iw = im.getIconWidth() + (int)this.paddingLeft + (int)this.paddingRight;
        int ih = im.getIconHeight() + (int)this.paddingTop + (int)this.paddingBottom;
        int x = (int)crect.getMinX();
        int y = (int)crect.getMinY();
        double xdiff = (int)crect.getWidth() - iw;
        double ydiff = (int)crect.getHeight() - ih;
        if (this.halign != 0.0) {
            x = (int)((double)x + xdiff * this.halign);
        }
        if (this.valign != 0.0) {
            y = (int)((double)y + ydiff * this.valign);
        }
        return new Rectangle2D.Double(x, y, iw, ih);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

