/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import xyz.cofe.collection.Func2;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.CellRender;
import xyz.cofe.gui.swing.cell.FillRender;
import xyz.cofe.gui.swing.cell.FlatTextRender;
import xyz.cofe.gui.swing.cell.ImageRender;
import xyz.cofe.gui.swing.cell.LineBorderRender;
import xyz.cofe.gui.swing.cell.TextAliasing;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.color.NColorModificator;

public class LabelRender
implements CellRender {
    private static final Logger logger = Logger.getLogger(LabelRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private volatile boolean backgroundVisible;
    private volatile FillRender backgroundRender;
    private volatile FlatTextRender textRender;
    private volatile boolean textVisible;
    private volatile ImageRender imageRender;
    private volatile boolean imageVisible;
    private volatile LineBorderRender borderRender;
    private boolean borderVisible;
    private volatile CellFormat format;
    private volatile List<Func2<CellFormat, CellContext, CellFormat>> formatters;
    private volatile CellContext context;
    private volatile CellContext bodyContext;
    private volatile CellContext textContext;
    private volatile CellContext icoContext;
    private volatile CellContext backgroundContext;
    private volatile CellContext borderContext;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LabelRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LabelRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LabelRender.class.getName(), method, result);
    }

    public LabelRender() {
        this.init();
    }

    public LabelRender(CellFormat cellformat) {
        this.init();
        if (cellformat != null) {
            this.format = cellformat;
        }
    }

    private synchronized void init() {
        this.textRender = new FlatTextRender().aliasing(TextAliasing.ON).baseColor(Color.black).focusModificator(new ColorModificator().bright(1.0f));
        this.backgroundRender = new FillRender().width(1.0).widthRelative(true).height(1.0).heightRelative(true).baseColor(Color.white).addRowModificator(new NColorModificator(1, 2, new ColorModificator().brighter(-0.1f))).selectModificator(new ColorModificator().sate(0.3f).hue(230)).focusModificator(new ColorModificator().saturation(0.0f).brighter(-0.5f));
        this.borderRender = new LineBorderRender();
        this.imageRender = new ImageRender();
        this.backgroundVisible = true;
        this.imageVisible = true;
        this.textVisible = true;
        this.borderVisible = true;
    }

    public synchronized boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public synchronized void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible = backgroundVisible;
    }

    public synchronized FillRender getBackgroundRender() {
        return this.backgroundRender;
    }

    public synchronized void setBackgroundRender(FillRender render) {
        if (render == null) {
            throw new IllegalArgumentException("render == null");
        }
        this.backgroundRender = render;
    }

    public synchronized List<NColorModificator> getBgRowModificators() {
        if (this.backgroundRender == null) {
            return null;
        }
        return this.backgroundRender.getRowModificators();
    }

    public synchronized void setBgRowModificators(List<NColorModificator> mods) {
        if (this.backgroundRender == null) {
            throw new IllegalStateException("backgroundRender == null");
        }
        if (mods == null) {
            throw new IllegalStateException("mods == null");
        }
        this.backgroundRender.setRowModificators(mods);
    }

    public synchronized List<NColorModificator> getBgColumnModificators() {
        if (this.backgroundRender == null) {
            return null;
        }
        return this.backgroundRender.getColumnModificators();
    }

    public synchronized void setBgColumnModificators(List<NColorModificator> mods) {
        if (this.backgroundRender == null) {
            throw new IllegalStateException("backgroundRender == null");
        }
        if (mods == null) {
            throw new IllegalStateException("mods == null");
        }
        this.backgroundRender.setColumnModificators(mods);
    }

    public synchronized ColorModificator getBgSelectModificator() {
        if (this.backgroundRender == null) {
            return null;
        }
        return this.backgroundRender.getSelectModificator();
    }

    public synchronized void setBgSelectModificator(ColorModificator mod) {
        if (this.backgroundRender == null) {
            throw new IllegalStateException("backgroundRender == null");
        }
        if (mod == null) {
            throw new IllegalStateException("mod == null");
        }
        this.backgroundRender.setSelectModificator(mod);
    }

    public synchronized ColorModificator getBgFocusModificator() {
        if (this.backgroundRender == null) {
            return null;
        }
        return this.backgroundRender.getFocusModificator();
    }

    public synchronized void setBgFocusModificator(ColorModificator mod) {
        if (this.backgroundRender == null) {
            throw new IllegalStateException("backgroundRender == null");
        }
        if (mod == null) {
            throw new IllegalStateException("mod == null");
        }
        this.backgroundRender.setFocusModificator(mod);
    }

    public synchronized Color getBgBaseColor() {
        if (this.backgroundRender == null) {
            return null;
        }
        return this.backgroundRender.getBaseColor();
    }

    public synchronized void setBgBaseColor(Color col) {
        if (this.backgroundRender == null) {
            throw new IllegalStateException("backgroundRender == null");
        }
        this.backgroundRender.setBaseColor(col);
    }

    public synchronized FlatTextRender getTextRender() {
        return this.textRender;
    }

    public synchronized void setTextRender(FlatTextRender render) {
        if (render == null) {
            throw new IllegalArgumentException("render == null");
        }
        this.textRender = render;
    }

    public synchronized boolean isTextVisible() {
        return this.textVisible;
    }

    public synchronized void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    public synchronized List<NColorModificator> getFgRowModificators() {
        if (this.textRender == null) {
            return null;
        }
        return this.textRender.getRowModificators();
    }

    public synchronized void setFgRowModificators(List<NColorModificator> mods) {
        if (this.textRender == null) {
            throw new IllegalStateException("textRender == null");
        }
        if (mods == null) {
            throw new IllegalStateException("mods == null");
        }
        this.textRender.setRowModificators(mods);
    }

    public synchronized List<NColorModificator> getFgColumnModificators() {
        if (this.textRender == null) {
            return null;
        }
        return this.textRender.getColumnModificators();
    }

    public synchronized void setFgColumnModificators(List<NColorModificator> mods) {
        if (this.textRender == null) {
            throw new IllegalStateException("textRender == null");
        }
        if (mods == null) {
            throw new IllegalStateException("mods == null");
        }
        this.textRender.setColumnModificators(mods);
    }

    public synchronized ColorModificator getFgSelectModificator() {
        if (this.textRender == null) {
            return null;
        }
        return this.textRender.getSelectModificator();
    }

    public synchronized void setFgSelectModificator(ColorModificator mod) {
        if (this.textRender == null) {
            throw new IllegalStateException("textRender == null");
        }
        if (mod == null) {
            throw new IllegalStateException("mod == null");
        }
        this.textRender.setSelectModificator(mod);
    }

    public synchronized ColorModificator getFgFocusModificator() {
        if (this.textRender == null) {
            return null;
        }
        return this.textRender.getFocusModificator();
    }

    public synchronized void setFgFocusModificator(ColorModificator mod) {
        if (this.textRender == null) {
            throw new IllegalStateException("textRender == null");
        }
        if (mod == null) {
            throw new IllegalStateException("mod == null");
        }
        this.textRender.setFocusModificator(mod);
    }

    public synchronized Color getFgBaseColor() {
        if (this.textRender == null) {
            return null;
        }
        return this.textRender.getBaseColor();
    }

    public synchronized void setFgBaseColor(Color col) {
        if (this.textRender == null) {
            throw new IllegalStateException("textRender == null");
        }
        this.textRender.setBaseColor(col);
    }

    public synchronized ImageRender getImageRender() {
        return this.imageRender;
    }

    public synchronized void setImageRender(ImageRender render) {
        if (render == null) {
            throw new IllegalArgumentException("render == null");
        }
        this.imageRender = render;
    }

    public synchronized boolean isImageVisible() {
        return this.imageVisible;
    }

    public synchronized void setImageVisible(boolean imageVisible) {
        this.imageVisible = imageVisible;
    }

    public synchronized Component getIconComponent() {
        ImageRender ir = this.imageRender;
        return ir != null ? ir.getIconComponent() : null;
    }

    public synchronized void setIconComponent(Component component, boolean weak) {
        ImageRender ir = this.imageRender;
        if (ir != null) {
            ir.setIconComponent(component, weak);
        }
    }

    public synchronized LineBorderRender getBorderRender() {
        return this.borderRender;
    }

    public synchronized void setBorderRender(LineBorderRender render) {
        if (render == null) {
            throw new IllegalArgumentException("render == null");
        }
        this.borderRender = render;
    }

    public synchronized boolean isBorderVisible() {
        return this.borderVisible;
    }

    public synchronized void setBorderVisible(boolean imageVisible) {
        this.borderVisible = imageVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellFormat getFormat() {
        if (this.format != null) {
            return this.format;
        }
        LabelRender labelRender = this;
        synchronized (labelRender) {
            if (this.format != null) {
                return this.format;
            }
            this.format = new CellFormat();
            return this.format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(CellFormat cf) {
        LabelRender labelRender = this;
        synchronized (labelRender) {
            this.format = cf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Func2<CellFormat, CellContext, CellFormat>> getFormatters() {
        if (this.formatters != null) {
            return this.formatters;
        }
        LabelRender labelRender = this;
        synchronized (labelRender) {
            if (this.formatters != null) {
                return this.formatters;
            }
            this.formatters = new CopyOnWriteArrayList<Func2<CellFormat, CellContext, CellFormat>>();
            return this.formatters;
        }
    }

    public synchronized <CtxType extends CellContext> Closeable addFormatter(final Class<CtxType> cls, final Func2<CellFormat, CtxType, CellFormat> formatter) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("formatter == null");
        }
        if (CellContext.class.equals(cls)) {
            this.getFormatters().add(formatter);
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    LabelRender.this.getFormatters().remove(formatter);
                }
            };
        }
        Func2<CellFormat, CellContext, CellFormat> ff = new Func2<CellFormat, CellContext, CellFormat>(){

            public CellFormat apply(CellContext cc, CellFormat cf) {
                if (cc != null && cls.isAssignableFrom(cc.getClass())) {
                    CellContext cct = cc;
                    return (CellFormat)formatter.apply((Object)cct, (Object)cf);
                }
                return null;
            }
        };
        this.getFormatters().add(ff);
        return new Closeable((Func2)ff){
            final /* synthetic */ Func2 val$ff;
            {
                this.val$ff = func2;
            }

            @Override
            public void close() throws IOException {
                LabelRender.this.getFormatters().remove(this.val$ff);
            }
        };
    }

    @Override
    public synchronized LabelRender clone() {
        return new LabelRender(this);
    }

    public LabelRender(LabelRender sample) {
        if (sample != null) {
            this.textRender = sample.textRender != null ? sample.textRender.clone() : new FlatTextRender().aliasing(TextAliasing.ON).baseColor(Color.black).focusModificator(new ColorModificator().bright(1.0f));
            this.backgroundRender = sample.backgroundRender != null ? sample.backgroundRender.clone() : new FillRender().width(1.0).widthRelative(true).height(1.0).heightRelative(true).baseColor(Color.white).addRowModificator(new NColorModificator(1, 2, new ColorModificator().brighter(-0.1f))).selectModificator(new ColorModificator().sate(0.3f).hue(230)).focusModificator(new ColorModificator().saturation(0.0f).brighter(-0.5f));
            this.borderRender = sample.borderRender != null ? sample.borderRender.clone() : new LineBorderRender();
            this.imageRender = sample.imageRender != null ? sample.imageRender.clone() : new ImageRender();
            if (sample.format != null) {
                this.format = sample.format.clone();
            }
            if (sample.formatters != null) {
                this.getFormatters().addAll(sample.formatters);
            }
            this.backgroundVisible = sample.backgroundVisible;
        } else {
            this.init();
        }
    }

    public CellContext getBodyContext() {
        return this.bodyContext;
    }

    public CellContext getTextContext() {
        return this.textContext;
    }

    public CellContext getIcoContext() {
        return this.icoContext;
    }

    public CellContext getBackgroundContext() {
        return this.backgroundContext;
    }

    public CellContext getBorderContext() {
        return this.borderContext;
    }

    protected synchronized boolean prepare(Graphics2D gs, CellContext context, CellFormat cf) {
        if (gs == null || context == null) {
            return false;
        }
        if (cf == null) {
            cf = this.getFormat().clone();
        }
        this.getTextRender().setColor(null);
        this.getTextRender().setMaxLineLength(-1);
        this.getTextRender().setMaxLinesCount(-1);
        this.getBackgroundRender().setColor(null);
        this.getBorderRender().reset();
        for (Func2<CellFormat, CellContext, CellFormat> ff : this.getFormatters()) {
            CellFormat ncf;
            if (ff == null || (ncf = (CellFormat)ff.apply((Object)context, (Object)cf)) == null) continue;
            cf = ncf;
        }
        if (cf != null) {
            LineBorderRender lbr;
            ImageRender ir;
            FillRender fr;
            FlatTextRender tr = this.getTextRender();
            if (tr != null) {
                tr.setTextAlign(cf.getTextAlign(0.0));
                tr.setHalign(cf.getHalign(0.0));
                tr.setValign(cf.getValign(0.0));
                tr.setPaddingLeft(cf.getTextPadLeft(0.0));
                tr.setPaddingTop(cf.getTextPadTop(0.0));
                tr.setPaddingRight(cf.getTextPadRight(0.0));
                tr.setPaddingBottom(cf.getTextPadBottom(0.0));
                tr.setColor(cf.getColor());
                tr.setFont(cf.getFont());
                if (cf.getMaxLineLength() != null) {
                    tr.setMaxLineLength(cf.getMaxLineLength());
                }
                if (cf.getMaxLinesCount() != null) {
                    tr.setMaxLinesCount(cf.getMaxLinesCount());
                }
            }
            if ((fr = this.getBackgroundRender()) != null) {
                fr.setColor(cf.getBackgroundColor());
            }
            if ((ir = this.getImageRender()) != null) {
                // empty if block
            }
            if ((lbr = this.getBorderRender()) != null) {
                cf.applyBorder(lbr);
            }
        }
        this.context = context;
        this.bodyContext = context.clone();
        this.bodyContext = this.bodyContext.padLeft(cf.getPadLeft(0.0));
        this.bodyContext = this.bodyContext.padRight(cf.getPadRight(0.0));
        this.bodyContext = this.bodyContext.padTop(cf.getPadTop(0.0));
        this.bodyContext = this.bodyContext.padBottom(cf.getPadBottom(0.0));
        this.textContext = this.bodyContext.clone();
        Icon ico = cf.getIcon();
        Dimension icoPlacehld = cf.getIconPlaceholder();
        if (icoPlacehld != null) {
            this.textContext.padLeft(icoPlacehld.getWidth());
        } else if (cf.isAutoIconPlaceholder() && ico != null && icoPlacehld == null) {
            double pl = cf.getIconPadLeft(0.0);
            double pr = cf.getIconPadRight(0.0);
            double pt = cf.getIconPadTop(0.0);
            double pb = cf.getIconPadBottom(0.0);
            icoPlacehld = new Dimension((int)((double)ico.getIconWidth() + pl + pr), (int)((double)ico.getIconHeight() + pt + pb));
            this.textContext.padLeft(icoPlacehld.getWidth());
        }
        Rectangle2D textRect = this.getTextRender().cellRectangle(gs, this.textContext);
        this.icoContext = context.clone().value(ico);
        this.getImageRender().setHalign(0.0);
        this.getImageRender().setValign(0.0);
        Rectangle2D.Double icoBnd = icoPlacehld != null ? new Rectangle2D.Double(textRect.getMinX() - icoPlacehld.getWidth() + cf.getIconPadLeft(0.0), textRect.getMinY() + cf.getIconPadTop(0.0), icoPlacehld.getWidth(), icoPlacehld.getHeight()) : new Rectangle2D.Double(textRect.getMinX() - cf.getIconPadLeft(0.0), textRect.getMinY() + cf.getIconPadTop(0.0), 0.0, 0.0);
        this.icoContext.setBounds(icoBnd);
        this.backgroundContext = context;
        this.borderContext = context;
        return true;
    }

    @Override
    public synchronized Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        if (!this.prepare(gs, context, this.getFormat().clone())) {
            return null;
        }
        Rectangle2D textRect = null;
        if (this.textVisible && this.textContext != null) {
            textRect = this.getTextRender().cellRectangle(gs, this.textContext);
        }
        Rectangle2D imgRect = null;
        if (this.imageVisible && this.icoContext != null) {
            imgRect = this.getImageRender().cellRectangle(gs, this.icoContext);
        }
        Double minx = null;
        Double miny = null;
        Double maxx = null;
        Double maxy = null;
        for (Rectangle2D rect : new Rectangle2D[]{textRect, imgRect}) {
            if (rect == null) continue;
            minx = minx == null ? rect.getMinX() : Math.min(minx, rect.getMinX());
            miny = miny == null ? rect.getMinY() : Math.min(miny, rect.getMinY());
            maxx = maxx == null ? rect.getMaxX() : Math.max(maxx, rect.getMaxX());
            maxy = maxy == null ? rect.getMaxY() : Math.max(maxy, rect.getMaxY());
        }
        if (minx != null && miny != null && maxx != null && maxy != null) {
            return new Rectangle2D.Double(Math.min(minx, maxx), Math.min(miny, maxy), Math.abs(maxx - minx), Math.abs(maxy - miny));
        }
        return null;
    }

    @Override
    public synchronized void cellRender(Graphics2D gs, CellContext context) {
        if (!this.prepare(gs, context, this.getFormat().clone())) {
            return;
        }
        this.backgroundRender(gs);
        this.textRender(gs);
        this.imageRender(gs);
        this.borderRender(gs);
    }

    protected synchronized void backgroundRender(Graphics2D gs) {
        if (gs == null) {
            return;
        }
        if (this.backgroundVisible && this.backgroundContext != null) {
            this.getBackgroundRender().cellRender(gs, this.backgroundContext);
        }
    }

    protected synchronized void textRender(Graphics2D gs) {
        if (gs == null) {
            return;
        }
        if (this.textVisible && this.textContext != null) {
            this.getTextRender().cellRender(gs, this.textContext);
        }
    }

    protected synchronized void imageRender(Graphics2D gs) {
        if (gs == null) {
            return;
        }
        if (this.imageVisible && this.icoContext != null) {
            this.getImageRender().cellRender(gs, this.icoContext);
        }
    }

    protected synchronized void borderRender(Graphics2D gs) {
        if (gs == null) {
            return;
        }
        if (this.borderVisible && this.borderContext != null) {
            this.getBorderRender().cellRender(gs, this.borderContext);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

