/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellRender;

public class LineBorderRender
implements CellRender {
    private static final Logger logger = Logger.getLogger(LineBorderRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Color leftColor;
    protected Stroke leftStroke;
    protected Color rightColor;
    protected Stroke rightStroke;
    protected Color topColor;
    protected Stroke topStroke;
    protected Color bottomColor;
    protected Stroke bottomStroke;
    protected double inside = 1.0;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LineBorderRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LineBorderRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LineBorderRender.class.getName(), method, result);
    }

    public LineBorderRender() {
    }

    public LineBorderRender(double width, Color color) {
        this.set().all(width, color).apply();
    }

    public LineBorderRender(double width, Color color, float[] dash) {
        this.set().all(width, color, dash).apply();
    }

    public LineBorderRender(LineBorderRender sample) {
        if (sample != null) {
            this.leftColor = sample.leftColor;
            this.leftStroke = sample.leftStroke;
            this.rightColor = sample.rightColor;
            this.rightStroke = sample.rightStroke;
            this.topColor = sample.topColor;
            this.topStroke = sample.topStroke;
            this.bottomColor = sample.bottomColor;
            this.bottomStroke = sample.bottomStroke;
            this.inside = sample.inside;
        }
    }

    public Settings set() {
        return new Settings(this);
    }

    public LineBorderRender reset() {
        this.left(null, 0.0f, new float[0]);
        this.top(null, 0.0f, new float[0]);
        this.right(null, 0.0f, new float[0]);
        this.bottom(null, 0.0f, new float[0]);
        return this;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public LineBorderRender leftColor(Color color) {
        this.leftColor = color;
        return this;
    }

    public Stroke getLeftStroke() {
        return this.leftStroke;
    }

    public void setLeftStroke(Stroke leftStroke) {
        this.leftStroke = leftStroke;
    }

    public LineBorderRender leftStroke(Stroke stroke) {
        this.leftStroke = stroke;
        return this;
    }

    public LineBorderRender leftStroke(float width, float ... dash) {
        this.leftStroke = dash != null && dash.length > 0 ? new BasicStroke(width, 0, 2, 10.0f, dash, 0.0f) : new BasicStroke(width, 0, 2);
        return this;
    }

    public LineBorderRender left(Color color, float width, float ... dash) {
        this.leftColor(color);
        this.leftStroke(width, dash);
        return this;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    public LineBorderRender rightColor(Color color) {
        this.rightColor = color;
        return this;
    }

    public Stroke getRightStroke() {
        return this.rightStroke;
    }

    public void setRightStroke(Stroke stroke) {
        this.rightStroke = stroke;
    }

    public LineBorderRender rightStroke(Stroke stroke) {
        this.rightStroke = stroke;
        return this;
    }

    public LineBorderRender rightStroke(float width, float ... dash) {
        this.rightStroke = dash != null && dash.length > 0 ? new BasicStroke(width, 0, 2, 10.0f, dash, 0.0f) : new BasicStroke(width, 0, 2);
        return this;
    }

    public LineBorderRender right(Color color, float width, float ... dash) {
        this.rightColor(color);
        this.rightStroke(width, dash);
        return this;
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public void setTopColor(Color topColor) {
        this.topColor = topColor;
    }

    public LineBorderRender topColor(Color color) {
        this.topColor = color;
        return this;
    }

    public Stroke getTopStroke() {
        return this.topStroke;
    }

    public void setTopStroke(Stroke stroke) {
        this.topStroke = stroke;
    }

    public LineBorderRender topStroke(Stroke stroke) {
        this.topStroke = stroke;
        return this;
    }

    public LineBorderRender topStroke(float width, float ... dash) {
        this.topStroke = dash != null && dash.length > 0 ? new BasicStroke(width, 0, 2, 10.0f, dash, 0.0f) : new BasicStroke(width, 0, 2);
        return this;
    }

    public LineBorderRender top(Color color, float width, float ... dash) {
        this.topColor(color);
        this.topStroke(width, dash);
        return this;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public void setBottomColor(Color bottomColor) {
        this.bottomColor = bottomColor;
    }

    public LineBorderRender bottomColor(Color color) {
        this.bottomColor = color;
        return this;
    }

    public Stroke getBottomStroke() {
        return this.bottomStroke;
    }

    public void setBottomStroke(Stroke stroke) {
        this.bottomStroke = stroke;
    }

    public LineBorderRender bottomStroke(Stroke stroke) {
        this.bottomStroke = stroke;
        return this;
    }

    public LineBorderRender bottomStroke(float width, float ... dash) {
        this.bottomStroke = dash != null && dash.length > 0 ? new BasicStroke(width, 0, 2, 10.0f, dash, 0.0f) : new BasicStroke(width, 0, 2);
        return this;
    }

    public LineBorderRender bottom(Color color, float width, float ... dash) {
        this.bottomColor(color);
        this.bottomStroke(width, dash);
        return this;
    }

    public double getInside() {
        return this.inside;
    }

    public void setInside(double inside) {
        this.inside = inside;
    }

    public LineBorderRender inside(double inside) {
        this.inside = inside;
        return this;
    }

    @Override
    public LineBorderRender clone() {
        return new LineBorderRender(this);
    }

    @Override
    public Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        if (gs == null || context == null) {
            return null;
        }
        return null;
    }

    @Override
    public void cellRender(Graphics2D gs, CellContext context) {
        Path2D.Double path;
        double off;
        if (gs == null || context == null) {
            return;
        }
        Rectangle2D rect = context.getBounds();
        if (rect == null) {
            return;
        }
        AffineTransform saveTransfrm = (AffineTransform)gs.getTransform().clone();
        Stroke saveStroke = gs.getStroke();
        Paint savePaint = gs.getPaint();
        if (this.topColor != null && this.topStroke != null) {
            off = 0.0;
            if (this.topStroke instanceof BasicStroke) {
                off = (double)((BasicStroke)this.topStroke).getLineWidth() / 2.0 * this.inside;
            }
            path = new Path2D.Double();
            ((Path2D)path).moveTo(rect.getMinX(), rect.getMinY() + off);
            ((Path2D)path).lineTo(rect.getMaxX(), rect.getMinY() + off);
            gs.setPaint(this.topColor);
            gs.setStroke(this.topStroke);
            gs.draw(path);
        }
        if (this.rightColor != null && this.rightStroke != null) {
            off = 0.0;
            if (this.rightStroke instanceof BasicStroke) {
                off = (double)((BasicStroke)this.rightStroke).getLineWidth() / 2.0;
            }
            path = new Path2D.Double();
            ((Path2D)path).moveTo(rect.getMaxX() - off, rect.getMinY());
            ((Path2D)path).lineTo(rect.getMaxX() - off, rect.getMaxY());
            gs.setPaint(this.rightColor);
            gs.setStroke(this.rightStroke);
            gs.draw(path);
        }
        if (this.bottomColor != null && this.bottomStroke != null) {
            off = 0.0;
            if (this.bottomStroke instanceof BasicStroke) {
                off = (double)((BasicStroke)this.bottomStroke).getLineWidth() / 2.0;
            }
            path = new Path2D.Double();
            ((Path2D)path).moveTo(rect.getMaxX(), rect.getMaxY() - off);
            ((Path2D)path).lineTo(rect.getMinX(), rect.getMaxY() - off);
            gs.setPaint(this.bottomColor);
            gs.setStroke(this.bottomStroke);
            gs.draw(path);
        }
        if (this.leftColor != null && this.leftStroke != null) {
            off = 0.0;
            if (this.leftStroke instanceof BasicStroke) {
                off = (double)((BasicStroke)this.leftStroke).getLineWidth() / 2.0;
            }
            path = new Path2D.Double();
            ((Path2D)path).moveTo(rect.getMinX() + off, rect.getMaxY());
            ((Path2D)path).lineTo(rect.getMinX() + off, rect.getMinY());
            gs.setPaint(this.leftColor);
            gs.setStroke(this.leftStroke);
            gs.draw(path);
        }
        gs.setTransform((AffineTransform)saveTransfrm.clone());
        gs.setPaint(savePaint);
        gs.setStroke(saveStroke);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class Settings {
        protected List<Reciver<LineBorderRender>> settings = new ArrayList<Reciver<LineBorderRender>>();
        protected LineBorderRender border;

        public Settings(LineBorderRender brd) {
            this.border = brd;
        }

        public LineBorderRender apply() {
            if (this.border != null && this.settings != null) {
                for (Reciver<LineBorderRender> set : this.settings) {
                    if (set == null) continue;
                    set.recive((Object)this.border);
                }
            }
            return this.border;
        }

        public Settings all(double width, Color color) {
            SideSettings ss = new SideSettings(true, true, true, true);
            ss.setWidth(width);
            ss.setColor(color);
            this.settings.add(ss);
            return this;
        }

        public Settings all(double width, Color color, float[] dash) {
            SideSettings ss = new SideSettings(true, true, true, true);
            ss.setWidth(width);
            ss.setColor(color);
            ss.setDash(dash);
            this.settings.add(ss);
            return this;
        }

        public Settings top(double width, Color color) {
            SideSettings ss = new SideSettings(false, true, false, false);
            ss.setWidth(width);
            ss.setColor(color);
            this.settings.add(ss);
            return this;
        }

        public Settings left(double width, Color color) {
            SideSettings ss = new SideSettings(false, false, true, false);
            ss.setWidth(width);
            ss.setColor(color);
            this.settings.add(ss);
            return this;
        }

        public Settings right(double width, Color color) {
            SideSettings ss = new SideSettings(true, false, false, false);
            ss.setWidth(width);
            ss.setColor(color);
            this.settings.add(ss);
            return this;
        }

        public Settings bottom(double width, Color color) {
            SideSettings ss = new SideSettings(false, false, false, true);
            ss.setWidth(width);
            ss.setColor(color);
            this.settings.add(ss);
            return this;
        }
    }

    public static class SideSettings
    implements Reciver<LineBorderRender> {
        protected boolean leftSide;
        protected boolean rightSide;
        protected boolean topSide;
        protected boolean bottomSide;
        protected Color color;
        protected Double width;
        protected float[] dash;
        protected float dashPhase;

        public SideSettings() {
        }

        public SideSettings(boolean right, boolean top, boolean left, boolean bottom) {
            this.leftSide = left;
            this.rightSide = right;
            this.topSide = top;
            this.bottomSide = bottom;
        }

        public boolean isLeftSide() {
            return this.leftSide;
        }

        public void setLeftSide(boolean leftSide) {
            this.leftSide = leftSide;
        }

        public boolean isRightSide() {
            return this.rightSide;
        }

        public void setRightSide(boolean rightSide) {
            this.rightSide = rightSide;
        }

        public boolean isTopSide() {
            return this.topSide;
        }

        public void setTopSide(boolean topSide) {
            this.topSide = topSide;
        }

        public boolean isBottomSide() {
            return this.bottomSide;
        }

        public void setBottomSide(boolean bottomSide) {
            this.bottomSide = bottomSide;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Double getWidth() {
            return this.width;
        }

        public void setWidth(Double width) {
            this.width = width;
        }

        public float[] getDash() {
            return this.dash;
        }

        public void setDash(float[] dash) {
            this.dash = dash;
        }

        public float getDashPhase() {
            return this.dashPhase;
        }

        public void setDashPhase(float dashPhase) {
            this.dashPhase = dashPhase;
        }

        public void apply(LineBorderRender brd) {
            if (brd == null) {
                return;
            }
            if (this.color != null) {
                if (this.leftSide) {
                    brd.setLeftColor(this.color);
                }
                if (this.topSide) {
                    brd.setTopColor(this.color);
                }
                if (this.rightSide) {
                    brd.setRightColor(this.color);
                }
                if (this.bottomSide) {
                    brd.setBottomColor(this.color);
                }
            }
            if (this.width != null) {
                if (this.width > 0.0) {
                    BasicStroke str;
                    BasicStroke basicStroke = str = this.dash != null && this.dash.length > 0 ? new BasicStroke(this.width.floatValue(), 0, 2, 10.0f, this.dash, this.dashPhase) : new BasicStroke(this.width.floatValue(), 0, 2);
                    if (this.leftSide) {
                        brd.setLeftStroke(str);
                    }
                    if (this.topSide) {
                        brd.setTopStroke(str);
                    }
                    if (this.rightSide) {
                        brd.setRightStroke(str);
                    }
                    if (this.bottomSide) {
                        brd.setBottomStroke(str);
                    }
                } else {
                    Stroke str = null;
                    if (this.leftSide) {
                        brd.setLeftStroke(str);
                    }
                    if (this.topSide) {
                        brd.setTopStroke(str);
                    }
                    if (this.rightSide) {
                        brd.setRightStroke(str);
                    }
                    if (this.bottomSide) {
                        brd.setBottomStroke(str);
                    }
                }
            }
        }

        public void recive(LineBorderRender brd) {
            if (brd != null) {
                this.apply(brd);
            }
        }
    }
}

