/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellRender;

public class StackRender
extends ArrayList<CellRender>
implements CellRender {
    private static final Logger logger = Logger.getLogger(StackRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(StackRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(StackRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(StackRender.class.getName(), method, result);
    }

    public StackRender() {
    }

    public StackRender(StackRender sample) {
        if (sample != null) {
            for (CellRender cr : sample) {
                this.add(cr != null ? cr.clone() : null);
            }
        }
    }

    @Override
    public StackRender clone() {
        return new StackRender(this);
    }

    public StackRender append(CellRender cr) {
        if (cr == null) {
            throw new IllegalArgumentException("cr==null");
        }
        this.add(cr);
        return this;
    }

    @Override
    public Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        Rectangle2D rect = null;
        for (CellRender cr : this) {
            if (cr == null) continue;
            Rectangle2D r = cr.cellRectangle(gs, context);
            if (rect == null) {
                if (r == null) continue;
                rect = r;
                continue;
            }
            if (r == null) continue;
            double x1 = Math.min(rect.getMinX(), r.getMinX());
            double y1 = Math.min(rect.getMinY(), r.getMinY());
            double x2 = Math.max(rect.getMaxX(), r.getMaxX());
            double y2 = Math.max(rect.getMaxY(), r.getMaxY());
            rect = new Rectangle((int)Math.min(x1, x2), (int)Math.min(y1, y2), (int)Math.abs(x1 - x2), (int)Math.abs(y1 - y2));
        }
        return rect;
    }

    @Override
    public void cellRender(Graphics2D gs, CellContext context) {
        for (CellRender cr : this) {
            if (cr == null) continue;
            cr.cellRender(gs, context);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

