/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import xyz.cofe.gui.swing.cell.DefaultLabelRender;
import xyz.cofe.gui.swing.cell.LabelRender;
import xyz.cofe.gui.swing.cell.TableCellContext;

public class TCRenderer
extends JComponent
implements TableCellRenderer {
    private static final Logger logger = Logger.getLogger(TCRenderer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected TableCellContext cellContext;
    protected LabelRender labelRender;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TCRenderer.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TCRenderer.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TCRenderer.class.getName(), method, result);
    }

    public TCRenderer() {
    }

    public TCRenderer(LabelRender lrender) {
        this.labelRender = lrender;
    }

    public synchronized TableCellContext getCellContext() {
        if (this.cellContext != null) {
            return this.cellContext;
        }
        this.cellContext = new TableCellContext();
        return this.cellContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellContext(TableCellContext tcc) {
        TCRenderer tCRenderer = this;
        synchronized (tCRenderer) {
            this.cellContext = tcc;
        }
    }

    public synchronized LabelRender getLabelRender() {
        if (this.labelRender != null) {
            return this.labelRender;
        }
        this.labelRender = new DefaultLabelRender();
        return this.labelRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelRender(LabelRender lRender) {
        TCRenderer tCRenderer = this;
        synchronized (tCRenderer) {
            this.labelRender = lRender;
        }
    }

    protected Rectangle2D computeCellContextBound(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (table != null) {
            TableColumn tc;
            TableColumnModel tcm = table.getColumnModel();
            if (tcm != null && (tc = tcm.getColumn(column)) != null) {
                w = tc.getWidth();
            }
            h = table.getRowHeight(row);
        }
        return new Rectangle2D.Double(0.0, 0.0, w, h);
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.getCellContext().setBounds(this.computeCellContextBound(table, value, isSelected, hasFocus, row, column));
        this.getCellContext().setTable(table);
        this.getCellContext().setFocus(hasFocus);
        this.getCellContext().setSelected(isSelected);
        this.getCellContext().setRow(row);
        this.getCellContext().setColumn(column);
        this.getCellContext().setValue(value);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D gs = (Graphics2D)g;
            this.getLabelRender().cellRender(gs, this.getCellContext());
            return;
        }
        super.paintComponent(g);
    }

    public Rectangle2D computeRect(Graphics2D gs) {
        if (gs == null) {
            return null;
        }
        return this.getLabelRender().cellRectangle(gs, this.getCellContext());
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

