/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.TableContext;
import xyz.cofe.j2d.RectangleFn;

public class TableCellContext<T extends TableCellContext<?>>
implements CellContext,
TableContext {
    private static final Logger logger = Logger.getLogger(TableCellContext.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Rectangle2D bounds;
    protected Object value;
    protected JTable table;
    protected int row;
    protected int column;
    protected boolean selected;
    protected boolean focus;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TableCellContext.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TableCellContext.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TableCellContext.class.getName(), method, result);
    }

    public TableCellContext() {
    }

    public TableCellContext(TableCellContext sample) {
        if (sample != null) {
            this.bounds = sample.bounds;
            this.value = sample.value;
            this.table = sample.table;
            this.row = sample.row;
            this.column = sample.column;
            this.selected = sample.selected;
            this.focus = sample.focus;
        }
    }

    public TableCellContext(Object value, Rectangle2D bounds) {
        this.value = value;
        this.bounds = bounds;
    }

    @Override
    public TableCellContext clone() {
        return new TableCellContext<T>(this);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public TableCellContext padLeft(double pad) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.paddingLeft(rect, pad);
        }
        return this;
    }

    @Override
    public TableCellContext padTop(double pad) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.paddingTop(rect, pad);
        }
        return this;
    }

    @Override
    public TableCellContext padRight(double pad) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.paddingRight(rect, pad);
        }
        return this;
    }

    @Override
    public TableCellContext padBottom(double pad) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.paddingBottom(rect, pad);
        }
        return this;
    }

    public T move(double x, double y) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.move(rect, x, y);
        }
        return (T)this;
    }

    public T size(double width, double height) {
        Rectangle2D rect = this.bounds;
        if (rect != null) {
            this.bounds = RectangleFn.size(rect, width, height);
        }
        return (T)this;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public T value(Object value) {
        this.value = value;
        return (T)this;
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public T table(JTable table) {
        this.table = table;
        return (T)this;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public T row(int row) {
        this.row = row;
        return (T)this;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public T column(int column) {
        this.column = column;
        return (T)this;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public T selected(boolean sel) {
        this.selected = sel;
        return (T)this;
    }

    @Override
    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public T focus(boolean focus) {
        this.focus = focus;
        return (T)this;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

