/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.DefaultLabelRender;
import xyz.cofe.gui.swing.cell.TableCellContext;
import xyz.cofe.gui.swing.cell.TreeNodeContext;
import xyz.cofe.gui.swing.tree.ColumnScroll;
import xyz.cofe.gui.swing.tree.ColumnScrollModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpander;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetText;
import xyz.cofe.j2d.RectangleFn;

public class TreeNodeCellRender
extends DefaultLabelRender {
    private static final Logger logger = Logger.getLogger(TreeNodeCellRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static Icon minusIconDefault;
    protected static Icon plusIconDefault;
    protected static Icon leafIconDefault;
    protected CellContext treeIconContext;
    protected Icon minusIcon;
    protected Icon plusIcon;
    protected Icon leafIcon;
    protected double prefferedIconWidth;
    protected double oneLevelOffset = 16.0;
    protected double treeIconPadLeft = 1.0;
    protected double treeIconPadRight = 3.0;
    protected double treeIconPadTop = 3.0;
    protected double treeIconPadBottom = 0.0;
    private double scrollX = 0.0;
    protected Icon preparedTreeIcon;
    protected ColumnScrollModel columnScrollModel;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeCellRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeCellRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeCellRender.class.getName(), method, result);
    }

    public TreeNodeCellRender() {
        this((CellFormat)null);
    }

    public TreeNodeCellRender(CellFormat cellFormat) {
        super(cellFormat);
        this.minusIcon = minusIconDefault;
        this.plusIcon = plusIconDefault;
        this.leafIcon = leafIconDefault;
        double icow = 0.0;
        for (Icon ico : new Icon[]{this.minusIcon, this.plusIcon, this.leafIcon}) {
            if (ico == null) continue;
            icow = Math.max(icow, (double)ico.getIconWidth());
        }
        this.prefferedIconWidth = icow;
    }

    public TreeNodeCellRender(CellFormat cellFormat, ColumnScrollModel csm) {
        super(cellFormat);
        this.columnScrollModel = csm;
        this.minusIcon = minusIconDefault;
        this.plusIcon = plusIconDefault;
        this.leafIcon = leafIconDefault;
        double icow = 0.0;
        for (Icon ico : new Icon[]{this.minusIcon, this.plusIcon, this.leafIcon}) {
            if (ico == null) continue;
            icow = Math.max(icow, (double)ico.getIconWidth());
        }
        this.prefferedIconWidth = icow;
    }

    public TreeNodeCellRender(TreeNodeCellRender sample) {
        super(sample);
        if (sample != null) {
            this.minusIcon = sample.minusIcon;
            this.plusIcon = sample.plusIcon;
            this.leafIcon = sample.leafIcon;
            this.prefferedIconWidth = sample.prefferedIconWidth;
            this.oneLevelOffset = sample.oneLevelOffset;
            this.columnScrollModel = sample.columnScrollModel;
        }
    }

    @Override
    public synchronized TreeNodeCellRender clone() {
        return new TreeNodeCellRender(this);
    }

    public CellContext getTreeIconContext() {
        return this.treeIconContext;
    }

    public Icon getMinusIcon() {
        return this.minusIcon;
    }

    public void setMinusIcon(Icon minusIcon) {
        this.minusIcon = minusIcon;
    }

    public Icon getPlusIcon() {
        return this.plusIcon;
    }

    public void setPlusIcon(Icon plusIcon) {
        this.plusIcon = plusIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon plusIcon) {
        this.leafIcon = plusIcon;
    }

    public double getPrefferedIconWidth() {
        return this.prefferedIconWidth;
    }

    public void setPrefferedIconWidth(double prefferedIconWidth) {
        this.prefferedIconWidth = prefferedIconWidth;
    }

    public double getOneLevelOffset() {
        return this.oneLevelOffset;
    }

    public void setOneLevelOffset(double oneLevelOffset) {
        this.oneLevelOffset = oneLevelOffset;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(double scrollX) {
        this.scrollX = scrollX;
    }

    protected void prepareTreeTableNode(Graphics2D gs, TreeNodeContext ctx, CellFormat cf, TreeTableNode node) {
        int lvl = ctx.getVisibleTreeLevel();
        double lvlStepOffset = this.oneLevelOffset;
        double lvlOffset = lvlStepOffset * (double)lvl;
        if (this.getIcoContext() != null) {
            this.getIcoContext().move(lvlOffset, 0.0);
            this.getIcoContext().move(-this.scrollX, 0.0);
        }
        if (this.getTextContext() != null) {
            this.getTextContext().move(lvlOffset, 0.0);
            this.getTextContext().move(-this.scrollX, 0.0);
        }
        if (node instanceof TreeTableNodeGetText) {
            String text = ((TreeTableNodeGetText)((Object)node)).treeTableNodeGetText();
            if (text != null) {
                this.getTextContext().setValue(text);
            } else {
                Object data = node.getData();
                if (data != null) {
                    this.getTextContext().setValue(data);
                } else {
                    this.getTextContext().setValue("");
                    this.getIcoContext().setValue(nullIcon);
                }
            }
        }
        Icon treeIco = null;
        boolean hasChildren = false;
        if (node.getChildrenList().size() > 0) {
            hasChildren = true;
        } else if (node instanceof TreeTableNodeBasic) {
            TreeTableNodeBasic tnode = (TreeTableNodeBasic)node;
            if (tnode instanceof TreeTableNodeExpander) {
                hasChildren = true;
            } else {
                Func1<Boolean, Object> extractable = tnode.getPreferredDataFollowable();
                Object data = tnode.getData();
                if (extractable != null) {
                    boolean canExtract = (Boolean)extractable.apply(data);
                    if (canExtract) {
                        hasChildren = true;
                    }
                } else {
                    NodesExtracter<Object, Object> extracter = tnode.getPreferredDataFollower();
                    Date extractFinished = tnode.getFollowFinished();
                    if (extracter != null && extractFinished == null) {
                        hasChildren = true;
                    }
                }
            }
        }
        if (hasChildren) {
            treeIco = node.isExpanded() ? this.getMinusIcon() : this.getPlusIcon();
        }
        if (this.getBorderContext() != null) {
            this.treeIconContext = this.getBorderContext().clone();
            this.treeIconContext.size(this.getPrefferedIconWidth() + this.treeIconPadLeft + this.treeIconPadRight, treeIco != null ? (double)treeIco.getIconHeight() + this.treeIconPadTop + this.treeIconPadBottom : this.getPrefferedIconWidth() + this.treeIconPadTop + this.treeIconPadBottom);
            this.treeIconContext.move(lvlOffset, 0.0);
            this.treeIconContext.move(-this.scrollX, 0.0);
            this.preparedTreeIcon = treeIco;
            if (this.getIcoContext() != null) {
                this.getIcoContext().move(this.treeIconContext.getBounds().getWidth(), 0.0);
            }
            if (this.getTextContext() != null) {
                this.getTextContext().move(this.treeIconContext.getBounds().getWidth(), 0.0);
            }
        }
    }

    @Override
    public synchronized boolean prepare(Graphics2D gs, CellContext context, CellFormat cf) {
        TreeNodeContext ctx;
        TreeTableNode node;
        TreeNodeContext ctx2;
        TreeTableNode node2;
        this.preparedTreeIcon = null;
        this.treeIconContext = null;
        TreeTableNodeFormat fmt = null;
        if (context instanceof TreeNodeContext && (node2 = (ctx2 = (TreeNodeContext)context).getNode()) instanceof TreeTableNodeGetFormat) {
            fmt = ((TreeTableNodeGetFormat)((Object)node2)).getTreeTableNodeFormat();
        }
        if (fmt != null) {
            CellFormat cellFormat = cf = cf != null ? cf.clone() : this.getFormat().clone();
            if (fmt.getIcons().size() > 0) {
                cf.icon(fmt.getIcons().get(0));
                cf.iconPadRight(3.0);
            }
            if (fmt.getFontFamily() != null) {
                if (fmt.getFontSize() != null) {
                    cf.font(fmt.getFontFamily(), fmt.getFontSize().floatValue(), false, false);
                } else {
                    cf.font(fmt.getFontFamily(), 11.0f, false, false);
                }
            }
            if (fmt.getBold() != null) {
                cf.bold(fmt.getBold());
            }
            if (fmt.getItalic() != null) {
                cf.italic(fmt.getItalic());
            }
            if (fmt.getBackground() != null) {
                cf.backgroundColor(fmt.getBackground());
            }
            if (fmt.getForeground() != null) {
                cf.color(fmt.getForeground());
            }
        }
        boolean res = super.prepare(gs, context, cf);
        if (context instanceof TreeNodeContext && (node = (ctx = (TreeNodeContext)context).getNode()) != null) {
            this.prepareTreeTableNode(gs, ctx, cf, node);
        }
        return res;
    }

    @Override
    public synchronized void cellRender(Graphics2D gs, CellContext context) {
        if (!this.prepare(gs, context, this.getFormat().clone())) {
            return;
        }
        this.backgroundRender(gs);
        this.textRender(gs);
        this.imageRender(gs);
        if (gs != null && context != null) {
            Rectangle2D rect;
            Rectangle2D treeIcoRect = null;
            if (this.treeIconContext != null && this.preparedTreeIcon != null) {
                treeIcoRect = this.treeIconContext.getBounds();
                this.preparedTreeIcon.paintIcon(null, gs, (int)(treeIcoRect.getMinX() + this.treeIconPadLeft), (int)(treeIcoRect.getMinY() + this.treeIconPadTop));
            }
            Rectangle2D textRect = null;
            if (this.isTextVisible() && this.getTextContext() != null) {
                textRect = this.getTextRender().cellRectangle(gs, this.getTextContext());
            }
            Rectangle2D imgRect = null;
            if (this.isImageVisible() && this.getIcoContext() != null) {
                imgRect = this.getImageRender().cellRectangle(gs, this.getIcoContext());
            }
            if ((rect = RectangleFn.union(textRect, imgRect, treeIcoRect)) != null) {
                this.onRenderedContentBounds(rect, context);
            }
        }
        this.borderRender(gs);
    }

    @Override
    public synchronized Rectangle2D cellRectangle(Graphics2D gs, CellContext context) {
        Rectangle2D srect = super.cellRectangle(gs, context);
        if (srect == null) {
            return null;
        }
        if (this.treeIconContext == null) {
            return srect;
        }
        return RectangleFn.union(srect, this.treeIconContext.getBounds());
    }

    public ColumnScrollModel getColumnScrollModel() {
        return this.columnScrollModel;
    }

    public void setColumnScrollModel(ColumnScrollModel columnScrollModel) {
        this.columnScrollModel = columnScrollModel;
    }

    protected void onRenderedContentBounds(Rectangle2D rect, CellContext cctx) {
        ColumnScroll cscrl;
        TableCellContext tctx;
        int col;
        ColumnScrollModel csm = this.getColumnScrollModel();
        if (cctx instanceof TableCellContext && rect != null && csm != null && (col = (tctx = (TableCellContext)cctx).getColumn()) >= 0 && (cscrl = csm.getColumnScroll(col)) != null) {
            cscrl.updateNodeRenderBounds(rect);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        URL uMinus = TreeNodeCellRender.class.getResource("/xyz/cofe/gui/swing/table/node-minus-v1-12x12.png");
        minusIconDefault = new ImageIcon(uMinus);
        URL uPlus = TreeNodeCellRender.class.getResource("/xyz/cofe/gui/swing/table/node-plus-v1-12x12.png");
        plusIconDefault = new ImageIcon(uPlus);
        URL uLeaf = TreeNodeCellRender.class.getResource("/xyz/cofe/gui/swing/table/node-leaf-v1-6x6.png");
        leafIconDefault = new ImageIcon(uLeaf);
    }
}

