/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import xyz.cofe.gui.swing.cell.TableCellContext;
import xyz.cofe.gui.swing.tree.TreeTableModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;

public class TreeNodeContext
extends TableCellContext<TreeNodeContext> {
    private static final Logger logger = Logger.getLogger(TreeNodeContext.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected TreeTableNode node;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeContext.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeContext.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeContext.class.getName(), method, result);
    }

    public TreeNodeContext() {
    }

    public TreeNodeContext(TreeNodeContext sample) {
        super(sample);
        if (sample != null) {
            this.node = sample.node;
        }
    }

    @Override
    public TreeNodeContext clone() {
        return new TreeNodeContext(this);
    }

    public TreeTableNode getNode() {
        return this.node;
    }

    public void setNode(TreeTableNode node) {
        this.node = node;
    }

    public boolean isRootVisible() {
        TreeTableModel ttm = this.getTreeTableModel();
        return ttm != null ? ttm.getDirectModel().isRootVisible() : true;
    }

    public TreeTableModel getTreeTableModel() {
        JTable tbl = super.getTable();
        TreeTableModel ttm = tbl != null && tbl.getModel() != null ? (tbl.getModel() instanceof TreeTableModel ? (TreeTableModel)tbl.getModel() : null) : null;
        return ttm;
    }

    public int getVisibleTreeLevel() {
        TreeTableNode n = this.node;
        if (n == null) {
            return 0;
        }
        boolean rv = this.isRootVisible();
        int lvl = n.getTreeLevel();
        --lvl;
        return lvl += rv ? 0 : -1;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

