/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.color;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorModificator {
    private static final Logger logger = Logger.getLogger(ColorModificator.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Float sourceHueFactor;
    private Float newHueFactor;
    private Float newHue;
    private Float sourceBrightFactor;
    private Float newBrightFactor;
    private Float newBright;
    private Float sourceSaturationFactor;
    private Float newSaturationFactor;
    private Float newSaturation;
    private Float sourceOpacityFactor;
    private Float newOpacityFactor;
    private Float newOpacity;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public ColorModificator() {
        this.sourceHueFactor = Float.valueOf(1.0f);
        this.newHueFactor = Float.valueOf(0.0f);
        this.newHue = Float.valueOf(0.0f);
        this.sourceBrightFactor = Float.valueOf(1.0f);
        this.newBrightFactor = Float.valueOf(0.0f);
        this.newBright = Float.valueOf(0.0f);
        this.sourceSaturationFactor = Float.valueOf(1.0f);
        this.newSaturationFactor = Float.valueOf(0.0f);
        this.newSaturation = Float.valueOf(0.0f);
        this.sourceOpacityFactor = Float.valueOf(1.0f);
        this.newOpacityFactor = Float.valueOf(0.0f);
        this.newOpacity = Float.valueOf(0.0f);
    }

    public ColorModificator(ColorModificator src) {
        if (src != null) {
            this.sourceHueFactor = src.sourceHueFactor;
            this.newHueFactor = src.newHueFactor;
            this.newHue = src.newHue;
            this.sourceBrightFactor = src.sourceBrightFactor;
            this.newBrightFactor = src.newBrightFactor;
            this.newBright = src.newBright;
            this.sourceSaturationFactor = src.sourceSaturationFactor;
            this.newSaturationFactor = src.newSaturationFactor;
            this.newSaturation = src.newSaturation;
            this.sourceOpacityFactor = src.sourceOpacityFactor;
            this.newOpacityFactor = src.newOpacityFactor;
            this.newOpacity = src.newOpacity;
        } else {
            this.sourceHueFactor = Float.valueOf(1.0f);
            this.newHueFactor = Float.valueOf(0.0f);
            this.newHue = Float.valueOf(0.0f);
            this.sourceBrightFactor = Float.valueOf(1.0f);
            this.newBrightFactor = Float.valueOf(0.0f);
            this.newBright = Float.valueOf(0.0f);
            this.sourceSaturationFactor = Float.valueOf(1.0f);
            this.newSaturationFactor = Float.valueOf(0.0f);
            this.newSaturation = Float.valueOf(0.0f);
            this.sourceOpacityFactor = Float.valueOf(1.0f);
            this.newOpacityFactor = Float.valueOf(0.0f);
            this.newOpacity = Float.valueOf(0.0f);
        }
    }

    public ColorModificator clone() {
        return new ColorModificator(this);
    }

    public Float getSourceHueFactor() {
        return this.sourceHueFactor;
    }

    public Float getNewHueFactor() {
        return this.newHueFactor;
    }

    public Float getNewHue() {
        return this.newHue;
    }

    public Float getSourceBrightFactor() {
        return this.sourceBrightFactor;
    }

    public Float getNewBrightFactor() {
        return this.newBrightFactor;
    }

    public Float getNewBright() {
        return this.newBright;
    }

    public Float getSourceSaturationFactor() {
        return this.sourceSaturationFactor;
    }

    public Float getNewSaturationFactor() {
        return this.newSaturationFactor;
    }

    public Float getNewSaturation() {
        return this.newSaturation;
    }

    public Float getSourceOpacityFactor() {
        return this.sourceOpacityFactor;
    }

    public Float getNewOpacityFactor() {
        return this.newOpacityFactor;
    }

    public Float getNewOpacity() {
        return this.newOpacity;
    }

    public Color apply(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color==null");
        }
        float[] hsb_arr = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float s_hue = hsb_arr[0];
        float s_saturation = hsb_arr[1];
        float s_bright = hsb_arr[2];
        float r_hue = s_hue * (this.sourceHueFactor == null ? 0.0f : this.sourceHueFactor.floatValue()) + (this.newHue == null ? 0.0f : this.newHue.floatValue()) * (this.newHueFactor == null ? 0.0f : this.newHueFactor.floatValue());
        if (r_hue > 1.0f) {
            int sub = (int)r_hue;
            r_hue -= (float)sub;
        } else if (r_hue < 0.0f) {
            int add_i = (int)(-r_hue) + 1;
            r_hue += (float)add_i;
        }
        float r_saturation = s_saturation * (this.sourceSaturationFactor == null ? 0.0f : this.sourceSaturationFactor.floatValue()) + (this.newSaturation == null ? 0.0f : this.newSaturation.floatValue()) * (this.newSaturationFactor == null ? 0.0f : this.newSaturationFactor.floatValue());
        r_saturation = r_saturation < 0.0f ? 0.0f : r_saturation;
        r_saturation = r_saturation > 1.0f ? 1.0f : r_saturation;
        float r_bright = s_bright * (this.sourceBrightFactor == null ? 0.0f : this.sourceBrightFactor.floatValue()) + (this.newBright == null ? 0.0f : this.newBright.floatValue()) * (this.newBrightFactor == null ? 0.0f : this.newBrightFactor.floatValue());
        r_bright = r_bright < 0.0f ? 0.0f : r_bright;
        r_bright = r_bright > 1.0f ? 1.0f : r_bright;
        float s_alpha = (float)color.getAlpha() / 255.0f;
        float r_opacity = s_alpha * (this.sourceOpacityFactor == null ? 0.0f : this.sourceOpacityFactor.floatValue()) + (this.newOpacity == null ? 0.0f : this.newOpacity.floatValue()) * (this.newOpacityFactor == null ? 0.0f : this.newOpacityFactor.floatValue());
        r_opacity = r_opacity < 0.0f ? 0.0f : r_opacity;
        r_opacity = r_opacity > 1.0f ? 1.0f : r_opacity;
        Color col = Color.getHSBColor(r_hue, r_saturation, r_bright);
        int c_red = col.getRed();
        int c_green = col.getGreen();
        int c_blue = col.getBlue();
        col = new Color(c_red, c_green, c_blue, (int)(r_opacity * 255.0f));
        return col;
    }

    public ColorModificator bright(float newBright) {
        ColorModificator cm = this.clone();
        cm.sourceBrightFactor = Float.valueOf(0.0f);
        cm.newBrightFactor = Float.valueOf(1.0f);
        cm.newBright = Float.valueOf(newBright);
        return cm;
    }

    public ColorModificator brighter(float addBright) {
        ColorModificator cm = this.clone();
        cm.sourceBrightFactor = Float.valueOf(1.0f);
        cm.newBrightFactor = Float.valueOf(1.0f);
        cm.newBright = Float.valueOf(addBright);
        return cm;
    }

    public ColorModificator saturation(float newSaturation) {
        ColorModificator cm = this.clone();
        cm.sourceSaturationFactor = Float.valueOf(0.0f);
        cm.newSaturationFactor = Float.valueOf(1.0f);
        cm.newSaturation = Float.valueOf(newSaturation);
        return cm;
    }

    public ColorModificator sate(float addSaturation) {
        ColorModificator cm = this.clone();
        cm.sourceSaturationFactor = Float.valueOf(1.0f);
        cm.newSaturationFactor = Float.valueOf(1.0f);
        cm.newSaturation = Float.valueOf(addSaturation);
        return cm;
    }

    public ColorModificator hue(float newHue) {
        ColorModificator cm = this.clone();
        cm.sourceHueFactor = Float.valueOf(0.0f);
        cm.newHueFactor = Float.valueOf(1.0f);
        cm.newHue = Float.valueOf(newHue);
        return cm;
    }

    public ColorModificator hue(int newHue) {
        return this.hue((float)newHue / 360.0f);
    }

    public ColorModificator rotate(float rotateHue) {
        ColorModificator cm = this.clone();
        cm.sourceHueFactor = Float.valueOf(1.0f);
        cm.newHueFactor = Float.valueOf(1.0f);
        cm.newHue = Float.valueOf(rotateHue);
        return cm;
    }

    public ColorModificator rotate(int rotateHue) {
        return this.rotate((float)rotateHue / 360.0f);
    }

    public ColorModificator alpher(float addAplha) {
        ColorModificator cm = this.clone();
        cm.sourceOpacityFactor = Float.valueOf(1.0f);
        cm.newOpacityFactor = Float.valueOf(1.0f);
        cm.newOpacity = Float.valueOf(addAplha);
        return cm;
    }

    public ColorModificator alpha(float alpha) {
        ColorModificator cm = this.clone();
        cm.sourceOpacityFactor = Float.valueOf(0.0f);
        cm.newOpacityFactor = Float.valueOf(1.0f);
        cm.newOpacity = Float.valueOf(alpha);
        return cm;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

