/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.color;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HSV {
    private static final Logger logger = Logger.getLogger(HSV.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(HSV.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(HSV.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(HSV.class.getName(), method, result);
    }

    public static Color hsv2rgb(float H, float S, float V) {
        float B;
        float G;
        float R;
        if (S == 0.0f) {
            R = V * 255.0f;
            G = V * 255.0f;
            B = V * 255.0f;
        } else {
            float var_b;
            float var_g;
            float var_r;
            float var_h = H * 6.0f;
            if (var_h == 6.0f) {
                var_h = 0.0f;
            }
            int var_i = (int)Math.floor(var_h);
            float var_1 = V * (1.0f - S);
            float var_2 = V * (1.0f - S * (var_h - (float)var_i));
            float var_3 = V * (1.0f - S * (1.0f - (var_h - (float)var_i)));
            if (var_i == 0) {
                var_r = V;
                var_g = var_3;
                var_b = var_1;
            } else if (var_i == 1) {
                var_r = var_2;
                var_g = V;
                var_b = var_1;
            } else if (var_i == 2) {
                var_r = var_1;
                var_g = V;
                var_b = var_3;
            } else if (var_i == 3) {
                var_r = var_1;
                var_g = var_2;
                var_b = V;
            } else if (var_i == 4) {
                var_r = var_3;
                var_g = var_1;
                var_b = V;
            } else {
                var_r = V;
                var_g = var_1;
                var_b = var_2;
            }
            R = var_r * 255.0f;
            G = var_g * 255.0f;
            B = var_b * 255.0f;
        }
        return new Color((int)R, (int)G, (int)B);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

