/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.data;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SyncEventList;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.data.DataCellUpdated;
import xyz.cofe.data.DataColumn;
import xyz.cofe.data.DataColumnAdded;
import xyz.cofe.data.DataColumnRemoved;
import xyz.cofe.data.DataEvent;
import xyz.cofe.data.DataEventListener;
import xyz.cofe.data.DataRow;
import xyz.cofe.data.DataRowDeleted;
import xyz.cofe.data.DataRowErased;
import xyz.cofe.data.DataRowInserted;
import xyz.cofe.data.DataRowState;
import xyz.cofe.data.DataRowStateChanged;
import xyz.cofe.data.DataRowUndeleted;
import xyz.cofe.data.DataTable;
import xyz.cofe.data.DataTableDropped;
import xyz.cofe.gui.swing.data.DataTableModelColumn;
import xyz.cofe.gui.swing.data.ReadOnlyError;
import xyz.cofe.gui.swing.table.EventSupport;

public class DataTableModel
implements TableModel {
    private static final Logger logger = Logger.getLogger(DataTableModel.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final EventSupport esupport;
    private final Object sync;
    protected final ConcurrentLinkedQueue<Runnable> swingRunQueue = new ConcurrentLinkedQueue();
    private boolean deletedVisible = false;
    protected final EventList<DataRow> newRows;
    private DataTable dataTable;
    private final List<DataRow> deletedCache = new ArrayList<DataRow>();
    protected final CloseableSet dataTableListeners;
    protected EventList<DataTableModelColumn> extraColumns;
    protected boolean readOnlyThrowException = true;
    protected boolean readOnly = false;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTableModel.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTableModel.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTableModel.class.getName(), method, result);
    }

    public DataTableModel() {
        this.esupport = new EventSupport(this);
        this.sync = this;
        this.dataTableListeners = new CloseableSet();
        this.newRows = new SyncEventList(new ArrayList(), this.sync);
    }

    public DataTableModel(DataTable dt) {
        this.esupport = new EventSupport(this);
        this.sync = this;
        this.newRows = new SyncEventList(new ArrayList(), this.sync);
        this.dataTableListeners = new CloseableSet();
        this.setDataTable(dt);
    }

    protected void swingRun(Runnable run) {
        if (run == null) {
            return;
        }
        this.swingRunQueue.add(run);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Runnable r;
                while ((r = DataTableModel.this.swingRunQueue.poll()) != null) {
                    r.run();
                }
            }
        });
    }

    protected PropertyChangeSupport propertySupport() {
        return this.esupport.propertySupport();
    }

    public EventSupport getEventSupport() {
        return this.esupport;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.esupport.firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.esupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.esupport.removePropertyChangeListener(listener);
    }

    public boolean isNotifyInAwtThread() {
        return this.esupport.isNotifyInAwtThread();
    }

    public void setNotifyInAwtThread(boolean notifyInAwtThread) {
        this.esupport.setNotifyInAwtThread(notifyInAwtThread);
    }

    public boolean isAwtInvokeAndWait() {
        return this.esupport.isAwtInvokeAndWait();
    }

    public void setAwtInvokeAndWait(boolean awtInvokeAndWait) {
        this.esupport.setAwtInvokeAndWait(awtInvokeAndWait);
    }

    public void fireAllChanged() {
        this.esupport.fireAllChanged();
    }

    public void fireColumnsChanged() {
        this.esupport.fireColumnsChanged();
    }

    public void fireRowUpdated(int row) {
        this.esupport.fireRowUpdated(row);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        this.esupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        this.esupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        this.esupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        this.esupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireTableModelEvent(TableModelEvent e) {
        this.esupport.fireTableModelEvent(e);
    }

    public Collection<TableModelListener> getListenersCollection() {
        return this.esupport.getListenersCollection();
    }

    public TableModelListener[] getListeners() {
        return this.esupport.getListeners();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.esupport.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.esupport.removeTableModelListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeletedVisible() {
        Object object = this.sync;
        synchronized (object) {
            return this.deletedVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeletedVisible(boolean deletedVisible) {
        Boolean cur;
        Boolean old;
        Object object = this.sync;
        synchronized (object) {
            old = this.deletedVisible;
            this.deletedVisible = deletedVisible;
            this.rebuildDeletedCache();
            cur = this.deletedVisible;
        }
        this.firePropertyChange("deletedVisible", old, cur);
        this.fireAllChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<DataRow, Integer> newRow() {
        DataRow dr = null;
        int rowidx = -2;
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                throw new IllegalStateException("dataTable not set");
            }
            if (this.readOnly) {
                if (this.readOnlyThrowException) {
                    throw new ReadOnlyError();
                }
                return null;
            }
            dr = new DataRow(this.dataTable, new Object[0]);
            this.newRows.add((Object)dr);
            rowidx = this.indexOf(dr);
        }
        if (rowidx >= 0) {
            this.fireRowsInserted(rowidx, rowidx);
        }
        return new BasicPair((Object)dr, (Object)rowidx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<DataRow, Integer>> getNewRows() {
        Object object = this.sync;
        synchronized (object) {
            ArrayList<Pair<DataRow, Integer>> list = new ArrayList<Pair<DataRow, Integer>>();
            for (DataRow dr : this.newRows) {
                if (dr == null) continue;
                list.add((Pair<DataRow, Integer>)new BasicPair((Object)dr, (Object)this.indexOf(dr)));
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<DataRow, Integer>> insertNewRows() {
        Object object = this.sync;
        synchronized (object) {
            ArrayList<Pair<DataRow, Integer>> inserted = new ArrayList<Pair<DataRow, Integer>>();
            if (this.readOnly) {
                if (this.readOnlyThrowException) {
                    throw new ReadOnlyError();
                }
                return inserted;
            }
            List<Pair<DataRow, Integer>> created = this.getNewRows();
            for (Pair<DataRow, Integer> pdr : created) {
                int ri = this.insertRow((DataRow)pdr.A());
                if (ri < 0) continue;
                inserted.add((Pair<DataRow, Integer>)new BasicPair(pdr.A(), (Object)ri));
            }
            return inserted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<DataRow, Integer>> clearNewRows() {
        ArrayList<DataRow> removedRows = new ArrayList<DataRow>();
        ArrayList<Pair<DataRow, Integer>> removed = new ArrayList<Pair<DataRow, Integer>>();
        int from = -1;
        int to = -1;
        Object object = this.sync;
        synchronized (object) {
            int nrc = this.newRows.size();
            if (nrc > 0) {
                if (nrc == 1) {
                    to = from = this.indexOf((DataRow)this.newRows.get(0));
                } else {
                    from = this.indexOf((DataRow)this.newRows.get(0));
                    to = this.indexOf((DataRow)this.newRows.get(nrc - 1));
                }
            }
            removedRows.addAll((Collection<DataRow>)this.newRows);
            this.newRows.clear();
        }
        if (from >= 0) {
            this.fireRowsDeleted(from, to);
        }
        int idxFrom = from;
        for (DataRow dr : removedRows) {
            removed.add((Pair<DataRow, Integer>)new BasicPair((Object)dr, (Object)idxFrom));
            if (idxFrom < 0) continue;
            ++idxFrom;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertRow(DataRow dr) {
        if (dr == null) {
            throw new IllegalArgumentException("dr == null");
        }
        DataTable dt = null;
        int newRowIdx = -2;
        Object object = this.sync;
        synchronized (object) {
            dt = this.dataTable;
            if (dt == null) {
                throw new IllegalStateException("dataTable not set");
            }
            if (this.readOnly) {
                if (this.readOnlyThrowException) {
                    throw new ReadOnlyError();
                }
                return -1;
            }
            newRowIdx = this.newRows.indexOf((Object)dr);
            if (newRowIdx >= 0) {
                this.newRows.remove(newRowIdx);
            }
        }
        if (newRowIdx >= 0) {
            this.fireRowsDeleted(newRowIdx, newRowIdx);
        }
        dt.insert(dr);
        return newRowIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable getDataTable() {
        Object object = this.sync;
        synchronized (object) {
            return this.dataTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataTable(DataTable dataTable) {
        DataTable cur;
        DataTable old;
        Object object = this.sync;
        synchronized (object) {
            old = this.dataTable;
            this.dataTable = dataTable;
            this.rebuildDeletedCache();
            this.newRows.clear();
            cur = this.dataTable;
        }
        this.firePropertyChange("dataTable", old, cur);
        this.listen(dataTable);
        this.fireColumnsChanged();
        this.fireAllChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDeletedCache() {
        Object object = this.sync;
        synchronized (object) {
            this.deletedCache.clear();
            if (this.dataTable != null && this.deletedVisible) {
                this.deletedCache.addAll(this.dataTable.rowsList(new DataRowState[]{DataRowState.Deleted}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListenDataTable() {
        CloseableSet closeableSet = this.dataTableListeners;
        synchronized (closeableSet) {
            Object[] cls = this.dataTableListeners.getCloseables();
            return cls != null && cls.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListenDataTable(boolean listen) {
        CloseableSet closeableSet = this.dataTableListeners;
        synchronized (closeableSet) {
            Object object = this.sync;
            synchronized (object) {
                this.dataTableListeners.closeAll();
                if (listen) {
                    if (this.dataTable != null) {
                        this.listen(this.dataTable);
                    } else {
                        throw new IllegalStateException("dataTable not set");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen(DataTable tbl) {
        CloseableSet closeableSet = this.dataTableListeners;
        synchronized (closeableSet) {
            this.dataTableListeners.closeAll();
            if (tbl == null) {
                return;
            }
            Closeable cl = tbl.addDataEventListener(new DataEventListener(){

                public void dataEvent(DataEvent ev) {
                    DataRowInserted e;
                    if (ev instanceof DataRowInserted) {
                        e = (DataRowInserted)ev;
                        DataTableModel.this.onDataRowInserted(e);
                    }
                    if (ev instanceof DataRowDeleted) {
                        e = (DataRowDeleted)ev;
                        DataTableModel.this.onDataRowDeleted((DataRowDeleted)e);
                    }
                    if (ev instanceof DataRowUndeleted) {
                        e = (DataRowUndeleted)ev;
                        DataTableModel.this.onDataRowUndeleted((DataRowUndeleted)e);
                    }
                    if (ev instanceof DataRowErased) {
                        e = (DataRowErased)ev;
                        DataTableModel.this.onDataRowErased((DataRowErased)e);
                    }
                    if (ev instanceof DataRowStateChanged) {
                        e = (DataRowStateChanged)ev;
                        DataTableModel.this.onDataRowStateChanged((DataRowStateChanged)e);
                    }
                    if (ev instanceof DataCellUpdated) {
                        e = (DataCellUpdated)ev;
                        DataTableModel.this.onDataCellUpdated((DataCellUpdated)e);
                    }
                    if (ev instanceof DataTableDropped) {
                        e = (DataTableDropped)ev;
                        DataTableModel.this.onDataTableDropped((DataTableDropped)e);
                    }
                }
            });
            this.dataTableListeners.add(cl);
            cl = tbl.onRowDeleted((Reciver)new Reciver<DataRowDeleted>(){

                public void recive(DataRowDeleted ev) {
                    DataTableModel.this.onDeletedAdded(ev.getRow());
                }
            });
            this.dataTableListeners.add(cl);
            cl = tbl.onRowErased((Reciver)new Reciver<DataRowErased>(){

                public void recive(DataRowErased ev) {
                    DataTableModel.this.onDeletedRemoved(ev.getRow());
                }
            });
            this.dataTableListeners.add(cl);
            cl = tbl.onRowUndeleted((Reciver)new Reciver<DataRowUndeleted>(){

                public void recive(DataRowUndeleted ev) {
                    DataTableModel.this.onDeletedRemoved(ev.getRow());
                }
            });
            this.dataTableListeners.add(cl);
            cl = tbl.onColumnAdded((Reciver)new Reciver<DataColumnAdded>(){

                public void recive(DataColumnAdded ev) {
                    DataTableModel.this.onDataColumnAdded(ev.getColumn());
                }
            });
            this.dataTableListeners.add(cl);
            cl = tbl.onColumnRemoved((Reciver)new Reciver<DataColumnRemoved>(){

                public void recive(DataColumnRemoved ev) {
                    DataTableModel.this.onDataColumnRemoved(ev.getColumn());
                }
            });
            this.dataTableListeners.add(cl);
        }
    }

    protected void onDataColumnAdded(DataColumn dc) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DataTableModel.this.fireColumnsChanged();
            }
        };
        this.swingRun(r);
    }

    protected void onDataColumnRemoved(DataColumn dc) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DataTableModel.this.fireColumnsChanged();
            }
        };
        this.swingRun(r);
    }

    protected void onDataRowStateChanged(DataRowStateChanged e) {
        int ri;
        if (this.dataTable == null) {
            return;
        }
        if ((e.getFromState() == DataRowState.Updated && e.getToState() == DataRowState.Fixed || e.getFromState() == DataRowState.Fixed && e.getToState() == DataRowState.Updated) && (ri = this.indexOf(e.getRow())) >= 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DataTableModel.this.fireRowUpdated(ri);
                }
            };
            this.swingRun(r);
        }
    }

    protected void onDataRowInserted(DataRowInserted e) {
        final int ri = e.getRowIndex();
        if (ri >= 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DataTableModel.this.fireRowsInserted(ri, ri);
                }
            };
            this.swingRun(r);
        }
    }

    protected void onDataRowUndeleted(DataRowUndeleted e) {
        DataRow dr = e.getRow();
        final int ri = this.indexOf(dr);
        if (ri >= 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DataTableModel.this.fireRowsInserted(ri, ri);
                }
            };
            this.swingRun(r);
        }
    }

    protected void onDataRowDeleted(DataRowDeleted e) {
        final int ri = e.getRowIndex();
        if (ri >= 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DataTableModel.this.fireRowsDeleted(ri, ri);
                }
            };
            this.swingRun(r);
        }
    }

    protected void onDataRowErased(DataRowErased e) {
        final int ri = e.getRowIndex();
        if (ri >= 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DataTableModel.this.fireRowsDeleted(ri, ri);
                }
            };
            this.swingRun(r);
        }
    }

    protected void onDeletedAdded(final DataRow dr) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int ri = -1;
                boolean fire = false;
                Object object = DataTableModel.this.sync;
                synchronized (object) {
                    if (DataTableModel.this.deletedVisible && DataTableModel.this.dataTable != null) {
                        DataTableModel.this.deletedCache.add(dr);
                        ri = DataTableModel.this.indexOf(dr);
                        fire = true;
                    }
                }
                if (ri >= 0 && fire) {
                    DataTableModel.this.fireRowsInserted(ri, ri);
                }
            }
        };
        this.swingRun(r);
    }

    protected void onDeletedRemoved(final DataRow dr) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int ri = -1;
                boolean fire = false;
                Object object = DataTableModel.this.sync;
                synchronized (object) {
                    if (DataTableModel.this.deletedVisible) {
                        int dri = DataTableModel.this.deletedCache.indexOf(dr);
                        if (dri >= 0) {
                            DataTableModel.this.deletedCache.remove(dri);
                        }
                        if (dri >= 0 && DataTableModel.this.dataTable != null) {
                            int rc = DataTableModel.this.dataTable.getRowsCount();
                            ri = rc + dri;
                            fire = true;
                        }
                    }
                }
                if (fire && ri >= 0) {
                    DataTableModel.this.fireRowsDeleted(ri, ri);
                }
            }
        };
        this.swingRun(r);
    }

    protected void onDataCellUpdated(final DataCellUpdated e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DataRow dr = e.getRow();
                int ri = DataTableModel.this.indexOf(dr);
                if (ri < 0) {
                    return;
                }
                int ci = e.getColumn();
                if (ci < 0) {
                    return;
                }
                int ecc = DataTableModel.this.getExtraColumns().size();
                DataTableModel.this.fireCellChanged(ri, ci + ecc);
            }
        };
        this.swingRun(r);
    }

    protected void onDataTableDropped(DataTableDropped e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DataTableModel.this.deletedCache.clear();
                DataTableModel.this.newRows.clear();
                DataTableModel.this.fireColumnsChanged();
                DataTableModel.this.fireAllChanged();
            }
        };
        this.swingRun(r);
    }

    public Map<Integer, DataRow> rowmap(Iterable<Integer> rows) {
        return this.rowmap(rows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, DataRow> rowmap(Iterable<Integer> rows, boolean skipNull) {
        LinkedHashMap<Integer, DataRow> map = new LinkedHashMap<Integer, DataRow>();
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return map;
            }
            if (rows != null) {
                for (Integer r : rows) {
                    if (r == null || map.containsKey(r)) continue;
                    DataRow dr = this.row(r);
                    if (skipNull && dr == null) continue;
                    map.put(r, dr);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRow row(int row) {
        if (row < 0) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return null;
            }
            int dataRowCnt = this.dataTable.getRowsCount();
            int deletedRowCnt = this.deletedVisible ? this.deletedCache.size() : 0;
            int newRowCnt = this.newRows.size();
            if (row < dataRowCnt) {
                return this.dataTable.getRow(row);
            }
            if (row < dataRowCnt + deletedRowCnt && deletedRowCnt > 0) {
                return this.deletedCache.get(row - dataRowCnt);
            }
            if (row < dataRowCnt + dataRowCnt + newRowCnt && newRowCnt > 0) {
                return (DataRow)this.newRows.get(row - dataRowCnt - deletedRowCnt);
            }
            return null;
        }
    }

    public Map<DataRow, Integer> indexOfMap(Iterable<DataRow> rows) {
        return this.indexOfMap(rows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DataRow, Integer> indexOfMap(Iterable<DataRow> rows, boolean skipNegative) {
        LinkedHashMap<DataRow, Integer> map = new LinkedHashMap<DataRow, Integer>();
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return map;
            }
            for (DataRow dr : rows) {
                if (dr == null) continue;
                int ri = this.indexOf(dr);
                if (skipNegative && ri < 0) continue;
                map.put(dr, ri);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(DataRow row) {
        if (row == null) {
            return -1;
        }
        Object object = this.sync;
        synchronized (object) {
            int dri;
            if (this.dataTable == null) {
                return -1;
            }
            if (this.deletedVisible && (dri = this.deletedCache.indexOf(row)) >= 0) {
                int rc = this.dataTable.getRowsCount();
                return rc + dri;
            }
            int dtIdx = this.dataTable.indexOf(row);
            if (dtIdx >= 0) {
                return dtIdx;
            }
            int nrIdx = this.newRows.indexOf((Object)row);
            if (nrIdx >= 0) {
                int deletedRowCnt = this.deletedVisible ? this.deletedCache.size() : 0;
                return this.dataTable.getRowsCount() + deletedRowCnt + nrIdx;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return 0;
            }
            int dataRCnt = this.dataTable.getRowsCount();
            int deletedRCnt = this.deletedCache.size();
            int newRCnt = this.newRows.size();
            if (this.deletedVisible) {
                return dataRCnt + deletedRCnt + newRCnt;
            }
            return dataRCnt + newRCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<DataTableModelColumn> getExtraColumns() {
        Object object = this.sync;
        synchronized (object) {
            if (this.extraColumns != null) {
                return this.extraColumns;
            }
            this.extraColumns = new IndexEventList();
            this.extraColumns.onChanged((Func3)new Func3<Object, Integer, DataTableModelColumn, DataTableModelColumn>(){

                public Object apply(Integer ci, DataTableModelColumn oldcol, DataTableModelColumn newcol) {
                    DataTableModel.this.fireColumnsChanged();
                    DataTableModel.this.fireAllChanged();
                    return true;
                }
            });
            return this.extraColumns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Object object = this.sync;
        synchronized (object) {
            DataTable dt = this.dataTable;
            if (dt == null) {
                return this.getExtraColumns().size();
            }
            DataTable dataTable = dt;
            synchronized (dataTable) {
                int ecc = this.getExtraColumns().size();
                int dcc = dt.getColumnsCount();
                int cc = ecc + dcc;
                DataTableModel.logFinest("getColumnCount()={0} ecc={1} dcc={2}", cc, ecc, dcc);
                return cc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int columnIndex) {
        Object object = this.sync;
        synchronized (object) {
            DataTable dataTable = this.dataTable;
            if (dataTable == null) {
                return "?columnName";
            }
            DataTable dataTable2 = dataTable;
            synchronized (dataTable2) {
                if (columnIndex < 0) {
                    throw new IllegalArgumentException("columnIndex(" + columnIndex + ")<0");
                }
                if (columnIndex >= this.getColumnCount()) {
                    throw new IllegalArgumentException("columnIndex(" + columnIndex + ")>=columnCount(" + this.getColumnCount() + ")");
                }
                int ecc = this.getExtraColumns().size();
                if (columnIndex >= 0 && columnIndex < ecc) {
                    return ((DataTableModelColumn)this.getExtraColumns().get(columnIndex)).getName();
                }
                return dataTable.getColumn(columnIndex - ecc).getName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataColumn getDataColumn(int col) {
        if (col < 0) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            int extraCcnt = this.getExtraColumns().size();
            if (extraCcnt > 0 && col >= 0 && col < extraCcnt) {
                return null;
            }
            int tcol = col - extraCcnt;
            DataTable dt = this.getDataTable();
            if (dt == null) {
                DataTableModel.logWarning("DataTable not set", new Object[0]);
                return null;
            }
            int cc = dt.getColumnsCount();
            if (tcol >= cc) {
                return null;
            }
            return dt.getColumn(tcol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTableModelColumn getExtraColumn(int col) {
        if (col < 0) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (col >= this.getExtraColumns().size()) {
                return null;
            }
            return (DataTableModelColumn)this.getExtraColumns().get(col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object object = this.sync;
        synchronized (object) {
            DataTable dt = this.dataTable;
            if (dt == null) {
                return String.class;
            }
            DataTable dataTable = dt;
            synchronized (dataTable) {
                if (columnIndex < 0) {
                    throw new IllegalArgumentException("columnIndex(" + columnIndex + ")<0");
                }
                if (columnIndex >= this.getColumnCount()) {
                    throw new IllegalArgumentException("columnIndex(" + columnIndex + ")>=columnCount(" + this.getColumnCount() + ")");
                }
                int extraCcnt = this.getExtraColumns().size();
                if (columnIndex >= 0 && columnIndex < extraCcnt) {
                    return ((DataTableModelColumn)this.getExtraColumns().get(columnIndex)).getDataType();
                }
                return dt.getColumn(columnIndex - extraCcnt).getDataType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnlyThrowException() {
        Object object = this.sync;
        synchronized (object) {
            return this.readOnlyThrowException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnlyThrowException(boolean readOnlyThrowException) {
        Boolean cur;
        Boolean old;
        Object object = this.sync;
        synchronized (object) {
            old = this.readOnlyThrowException;
            this.readOnlyThrowException = readOnlyThrowException;
            cur = this.readOnlyThrowException;
        }
        this.firePropertyChange("readOnlyThrowException", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getReadOnly() {
        Object object = this.sync;
        synchronized (object) {
            return this.readOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean readOnly) {
        Boolean cur;
        Boolean old;
        Object object = this.sync;
        synchronized (object) {
            old = this.readOnly;
            this.readOnly = readOnly;
            cur = this.readOnly;
        }
        this.firePropertyChange("readOnly", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            DataTable dt = this.dataTable;
            if (dt == null) {
                return false;
            }
            DataTable dataTable = dt;
            synchronized (dataTable) {
                if (rowIndex >= this.getRowCount()) {
                    return false;
                }
                if (columnIndex >= this.getColumnCount()) {
                    return false;
                }
                int ecc = this.getExtraColumns().size();
                if (columnIndex >= 0 && columnIndex < ecc) {
                    return false;
                }
                return !this.readOnly;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return null;
            }
            int rowCnt = this.getRowCount();
            if (rowIndex >= rowCnt) {
                return null;
            }
            if (columnIndex >= this.getColumnCount()) {
                return null;
            }
            DataRow dr = this.row(rowIndex);
            if (dr == null) {
                int dataRcnt = this.dataTable.getRowsCount();
                int deletedRcnt = this.deletedCache.size();
                DataTableModel.logWarning("getValueAt({0},{1}) fetched null row (rc={2}, dataTable.rc={3}, cached.rc={4})", rowIndex, columnIndex, rowCnt, dataRcnt, deletedRcnt);
                return null;
            }
            int extraCcnt = this.getExtraColumns().size();
            if (columnIndex >= 0 && columnIndex < extraCcnt) {
                DataTableModelColumn ec = (DataTableModelColumn)this.getExtraColumns().get(columnIndex);
                Object v = ec.getValueFor(dr, rowIndex, this);
                DataTableModel.logFinest("extra row={1} col={2} value={0}", v, rowIndex, columnIndex);
                return v;
            }
            int ti = columnIndex - extraCcnt;
            Object v = dr.get(ti);
            DataTableModel.logFinest("data row={1} col={2} ti={3} value={0}", v, rowIndex, columnIndex, ti);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.dataTable == null) {
                return;
            }
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            if (columnIndex >= this.getColumnCount()) {
                return;
            }
            if (this.readOnly) {
                if (this.readOnlyThrowException) {
                    throw new ReadOnlyError();
                }
                return;
            }
            DataRow dr = this.row(rowIndex);
            if (dr == null) {
                int drc = this.dataTable.getRowsCount();
                int crc = this.deletedCache.size();
                int rc = this.deletedVisible ? drc + crc : drc;
                DataTableModel.logWarning("getValueAt({0},{1}) fetched null row (rc={2}, dataTable.rc={3}, cached.rc={4})", rowIndex, columnIndex, rc, drc, crc);
            }
            int extraCcnt = this.getExtraColumns().size();
            dr.set(columnIndex - extraCcnt, aValue);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

