/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.data;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.DataRow;
import xyz.cofe.data.DataRowState;
import xyz.cofe.gui.swing.data.DataTableModel;
import xyz.cofe.gui.swing.data.DataTableModelColumn;

public class DataTableStateColumn
extends DataTableModelColumn {
    private static final Logger logger = Logger.getLogger(DataTableStateColumn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected String name;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTableStateColumn.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTableStateColumn.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTableStateColumn.class.getName(), method, result);
    }

    public DataTableStateColumn() {
        this.name = "#state";
    }

    public DataTableStateColumn(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "#state";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class getDataType() {
        return String.class;
    }

    @Override
    public Object getValueFor(DataRow dr, int rowIndex, DataTableModel dtModel) {
        if (dr == null) {
            return "row null";
        }
        DataRowState st = dr.getState();
        return st == null ? "null" : st.toString();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

