/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.data;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.Reciver;
import xyz.cofe.data.DataColumn;
import xyz.cofe.data.DataRow;
import xyz.cofe.data.DataTable;
import xyz.cofe.data.store.CSVDesc;
import xyz.cofe.data.store.CSVUtil;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.GuiUtil;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.DefaultLabelRender;
import xyz.cofe.gui.swing.cell.FlatTextRender;
import xyz.cofe.gui.swing.cell.LabelRender;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.cell.TableCellContext;
import xyz.cofe.gui.swing.data.DataRowFocusChanged;
import xyz.cofe.gui.swing.data.DataTableModel;
import xyz.cofe.gui.swing.data.DataTableModelColumn;
import xyz.cofe.gui.swing.data.PreparedCopyCell;
import xyz.cofe.gui.swing.data.PreparedCopyCells;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.editor.DateEditor;
import xyz.cofe.gui.swing.properties.editor.TextFieldEditor;
import xyz.cofe.gui.swing.table.Table;
import xyz.cofe.gui.swing.table.TableEvent;
import xyz.cofe.gui.swing.text.FlatBlock;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditorDef;
import xyz.cofe.perfomance.TimeLaps;
import xyz.cofe.text.EndLine;

public class DataTableView
extends Table {
    private static final Logger logger = Logger.getLogger(DataTableView.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private PropertyDB pdb;
    private Icon detachedIcon;
    private Icon deletedIcon;
    private Icon fixedIcon;
    private Icon modifiedIcon;
    private Icon insertedIcon;
    private int iconMaxWidth = 0;
    private int iconMaxHeight = 0;
    private Dimension iconMaxSize;
    private LabelRender labelRender;
    protected TCRenderer tcRender;
    private DataTableModel dataTableModel;
    private final BasicAction copyAction = new BasicAction("copy", new Runnable(){

        @Override
        public void run() {
            DataTableView.this.copy();
        }
    });

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTableView.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTableView.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTableView.class.getName(), method, result);
    }

    public DataTableView() {
        this.initDefaultCellRenders();
        this.setModel(this.getDataTableModel());
        this.initIcons();
        this.initStateCellFormat();
        this.initColumnsPopup();
        this.initInnerLines();
        this.initCopy();
        this.initTypeEditors();
        FlatTextRender.TLRUCache cache = new FlatTextRender.TLRUCache(20000, 15000L);
        this.getLabelRender().getTextRender().setCache((Map<String, FlatBlock>)((Object)cache));
        this.getLabelRender().getTextRender().setMinCachedTextLength(0);
        TimeLaps tlPrepare = new TimeLaps();
        this.getLabelRender().getTextRender().setTimeLaps(tlPrepare);
    }

    public PropertyDB getPDB() {
        if (this.pdb == null) {
            this.pdb = new PropertyDB();
        }
        return this.pdb;
    }

    public void setPDB(PropertyDB pdb) {
        this.pdb = pdb;
    }

    private void initTypeEditors() {
        TreeTableNodeValueEditorDef edtr = new TreeTableNodeValueEditorDef();
        edtr.setEditorFinder(new TreeTableNodeValueEditor.EditorFinder(){

            @Override
            public TreeTableNodeValueEditor.Editor findEditor(JTable table, Object value, boolean isSelected, int row, int column) {
                DataTableModel dtm = DataTableView.this.getDataTableModel();
                if (dtm == null) {
                    throw new IllegalStateException("DataTableModel == null");
                }
                DataColumn dc = dtm.getDataColumn(column);
                if (dc == null) {
                    return null;
                }
                Class<Number> dataType = dc.getDataType();
                if (dataType == null) {
                    return null;
                }
                if (Objects.equals(dataType, Date.class)) {
                    CellFormat cf = DataTableView.this.getCellFormat(row, column);
                    DateFormat df = cf == null ? null : cf.getDateFormat();
                    String dfPtrn = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : null;
                    return DateEditor.getDateEditor(dc.isAllowNull(), dfPtrn);
                }
                if (Objects.equals(dataType, java.sql.Date.class)) {
                    CellFormat cf = DataTableView.this.getCellFormat(row, column);
                    DateFormat df = cf == null ? null : cf.getDateFormat();
                    String dfPtrn = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : null;
                    return DateEditor.getSQLDateEditor(dc.isAllowNull(), dfPtrn);
                }
                if (Objects.equals(dataType, Time.class)) {
                    CellFormat cf = DataTableView.this.getCellFormat(row, column);
                    DateFormat df = cf == null ? null : cf.getDateFormat();
                    String dfPtrn = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : null;
                    return DateEditor.getSQLTimeEditor(dc.isAllowNull(), dfPtrn);
                }
                if (Objects.equals(dataType, Timestamp.class)) {
                    CellFormat cf = DataTableView.this.getCellFormat(row, column);
                    DateFormat df = cf == null ? null : cf.getDateFormat();
                    String dfPtrn = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : null;
                    return DateEditor.getSQLTimestampEditor(dc.isAllowNull(), dfPtrn);
                }
                PropertyDB pdb = DataTableView.this.getPDB();
                if (pdb == null) {
                    return null;
                }
                if (!dc.isAllowNull()) {
                    if (Objects.equals(dataType, Byte.class)) {
                        dataType = Byte.TYPE;
                    }
                    if (Objects.equals(dataType, Short.class)) {
                        dataType = Short.TYPE;
                    }
                    if (Objects.equals(dataType, Integer.class)) {
                        dataType = Integer.TYPE;
                    }
                    if (Objects.equals(dataType, Long.class)) {
                        dataType = Long.TYPE;
                    }
                    if (Objects.equals(dataType, Float.class)) {
                        dataType = Float.TYPE;
                    }
                    if (Objects.equals(dataType, Double.class)) {
                        dataType = Double.TYPE;
                    }
                }
                PropertyEditor oEd = null;
                Set editors = (Set)pdb.getTypeEditors().fetch(dataType);
                if (editors != null && editors.size() > 0) {
                    ArrayList editorsList = new ArrayList(editors);
                    while (editorsList.size() > 1) {
                        double w2;
                        TextFieldEditor tfe;
                        oEd = (PropertyEditor)editorsList.get(0);
                        if (oEd instanceof TextFieldEditor && !Objects.equals((tfe = (TextFieldEditor)oEd).isAllowNull(), dc.isAllowNull())) {
                            editorsList.remove(0);
                            continue;
                        }
                        PropertyEditor oEd2 = (PropertyEditor)editorsList.get(1);
                        double w1 = pdb.getWeightOf(oEd);
                        if (w1 > (w2 = pdb.getWeightOf(oEd2))) {
                            editorsList.remove(1);
                            continue;
                        }
                        if (!(w1 < w2)) break;
                        editorsList.remove(0);
                    }
                    oEd = (PropertyEditor)editorsList.get(0);
                }
                if (!(oEd instanceof TreeTableNodeValueEditor.Editor)) {
                    return null;
                }
                return oEd != null ? (TreeTableNodeValueEditor.Editor)((Object)oEd) : null;
            }
        });
        PropertyDB pdb = this.getPDB();
        if (pdb != null) {
            for (Class edType : pdb.getTypeEditors().keySet()) {
                this.setDefaultEditor(edType, edtr);
            }
        }
    }

    @Override
    public void fireTableEvent(TableEvent event) {
        if (event instanceof TableEvent.FocusedRowChanged && !(event instanceof DataRowFocusChanged)) {
            super.fireTableEvent(new DataRowFocusChanged((TableEvent.FocusedRowChanged)event));
            return;
        }
        super.fireTableEvent(event);
    }

    protected void initDefaultCellRenders() {
        TCRenderer tcr = this.getTCRenderer();
        for (Class dataType : new Class[]{String.class, Number.class, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE, Icon.class, Object.class}) {
            this.setDefaultRenderer(dataType, tcr);
        }
    }

    private void initIcons() {
        URL u1 = DataTableView.class.getResource("datarow-state-deleted.png");
        this.deletedIcon = u1 == null ? null : new ImageIcon(u1);
        URL u2 = DataTableView.class.getResource("datarow-state-detached.png");
        this.detachedIcon = u2 == null ? null : new ImageIcon(u2);
        URL u3 = DataTableView.class.getResource("datarow-state-fixed.png");
        this.fixedIcon = u3 == null ? null : new ImageIcon(u3);
        URL u4 = DataTableView.class.getResource("datarow-state-inserted.png");
        this.insertedIcon = u4 == null ? null : new ImageIcon(u4);
        URL u5 = DataTableView.class.getResource("datarow-state-modified.png");
        this.modifiedIcon = u5 == null ? null : new ImageIcon(u5);
        for (Icon ic : new Icon[]{this.deletedIcon, this.detachedIcon, this.fixedIcon, this.insertedIcon, this.modifiedIcon}) {
            if (ic == null) continue;
            this.iconMaxWidth = Math.max(ic.getIconWidth(), this.iconMaxWidth);
            this.iconMaxHeight = Math.max(ic.getIconHeight(), this.iconMaxHeight);
        }
        this.iconMaxSize = new Dimension(this.iconMaxWidth, this.iconMaxHeight);
    }

    private void initStateCellFormat() {
        this.getTCRenderer().getLabelRender().addFormatter(DataTableCellContext.class, new Func2<CellFormat, DataTableCellContext, CellFormat>(){

            public CellFormat apply(DataTableCellContext tcx, CellFormat cf) {
                if (!tcx.isExtraColumn()) {
                    return cf;
                }
                cf.setIconPlaceholder(DataTableView.this.iconMaxSize);
                DataRow dr = tcx.getDataRow();
                if (dr != null) {
                    switch (dr.getState()) {
                        case Deleted: {
                            cf.setIcon(DataTableView.this.deletedIcon);
                            break;
                        }
                        case Detached: {
                            cf.setIcon(DataTableView.this.detachedIcon);
                            break;
                        }
                        case Fixed: {
                            cf.setIcon(DataTableView.this.fixedIcon);
                            break;
                        }
                        case Inserted: {
                            cf.setIcon(DataTableView.this.insertedIcon);
                            break;
                        }
                        case Updated: {
                            cf.setIcon(DataTableView.this.modifiedIcon);
                            break;
                        }
                    }
                }
                cf.setTextPadLeft(3.0);
                return cf;
            }
        });
    }

    protected void initInnerLines() {
        this.getTCRenderer().getLabelRender().addFormatter(TableCellContext.class, new Func2<CellFormat, TableCellContext, CellFormat>(){

            public CellFormat apply(TableCellContext tcx, CellFormat cf) {
                if (tcx != null && tcx.getColumn() > 0) {
                    cf.borderLeft(Color.gray, 1.0f, 3.0f, 2.0f);
                    cf.padLeft(2.0);
                }
                return cf;
            }
        });
    }

    public LabelRender getLabelRender() {
        if (this.labelRender != null) {
            return this.labelRender;
        }
        this.labelRender = new DefaultLabelRender();
        return this.labelRender;
    }

    public TCRenderer getTCRenderer() {
        if (this.tcRender != null) {
            return this.tcRender;
        }
        LabelRender labelRender = this.getLabelRender();
        this.tcRender = new TCRenderer(labelRender){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cmpt = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                TableCellContext cc = this.getCellContext();
                if (cc instanceof DataTableCellContext) {
                    DataTableCellContext dtcc = (DataTableCellContext)cc;
                    dtcc.setDataTable(DataTableView.this.getDataTable());
                    dtcc.setDataRow(DataTableView.this.dataRow(row));
                    dtcc.setTableColumn(DataTableView.this.getColumnModel().getColumn(column));
                    dtcc.setDataTableModel(DataTableView.this.getDataTableModel());
                }
                return cmpt;
            }
        };
        this.tcRender.setCellContext(new DataTableCellContext());
        return this.tcRender;
    }

    public DataTableModel getDataTableModel() {
        if (this.dataTableModel != null) {
            return this.dataTableModel;
        }
        this.dataTableModel = new DataTableModel();
        return this.dataTableModel;
    }

    public void setDataTableModel(DataTableModel dataTableModel) {
        this.dataTableModel = dataTableModel;
    }

    public DataTable getDataTable() {
        return this.getDataTableModel().getDataTable();
    }

    public void setDataTable(DataTable dt) {
        if (dt == null) {
            throw new IllegalArgumentException("dt==null");
        }
        DataTableModel dtm = this.getDataTableModel();
        dtm.setDataTable(dt);
        TableModel tm = this.getModel();
        if (tm != null && Objects.equals(tm.getClass(), DefaultTableModel.class)) {
            this.setModel(dtm);
        }
    }

    public boolean isDeletedVisible() {
        return this.getDataTableModel().isDeletedVisible();
    }

    public void setDeletedVisible(boolean deletedVisible) {
        this.getDataTableModel().setDeletedVisible(deletedVisible);
    }

    public boolean isListenDataTable() {
        if (this.dataTableModel == null) {
            throw new IllegalStateException("dataTableModel == null");
        }
        return this.dataTableModel.isListenDataTable();
    }

    public void setListenDataTable(boolean listen) {
        if (this.dataTableModel == null) {
            throw new IllegalStateException("dataTableModel == null");
        }
        this.dataTableModel.setListenDataTable(listen);
    }

    public Pair<DataRow, Integer> newRow() {
        Pair<DataRow, Integer> r = this.dataTableModel.newRow();
        return r;
    }

    public Pair<DataRow, Integer> insertRow(DataRow dr) {
        int r = this.dataTableModel.insertRow(dr);
        if (r < 0) {
            return null;
        }
        return new BasicPair((Object)dr, (Object)r);
    }

    public List<Pair<DataRow, Integer>> insertNewRows() {
        return this.dataTableModel.insertNewRows();
    }

    public List<Pair<DataRow, Integer>> clearNewRows() {
        return this.dataTableModel.clearNewRows();
    }

    public DataRow dataRow(int row) {
        return this.dataTableModel.row(row);
    }

    public int indexOf(DataRow dr) {
        if (dr == null) {
            return -1;
        }
        DataTableModel dtm = this.getDataTableModel();
        if (dtm == null) {
            return -1;
        }
        return dtm.indexOf(dr);
    }

    public List<Pair<DataRow, Integer>> getSelectedDataRows() {
        int[] selectedRows;
        ArrayList<Pair<DataRow, Integer>> list = new ArrayList<Pair<DataRow, Integer>>();
        for (int ri : selectedRows = this.getSelectedRows()) {
            DataRow dr = this.dataRow(ri);
            list.add((Pair<DataRow, Integer>)new BasicPair((Object)dr, (Object)ri));
        }
        return list;
    }

    public Pair<DataRow, Integer> getFocusedDataRow() {
        int focRow = this.getFocusedRow();
        if (focRow < 0) {
            return null;
        }
        return new BasicPair((Object)this.dataRow(focRow), (Object)focRow);
    }

    public CellFormat getCellFormat(int row, int col) {
        DefaultLabelRender dlrnd;
        LabelRender lrnd = this.getLabelRender();
        CellFormat cf = lrnd.getFormat().clone();
        if (row < 0 || col < 0) {
            return cf;
        }
        DefaultLabelRender defaultLabelRender = dlrnd = lrnd instanceof DefaultLabelRender ? (DefaultLabelRender)lrnd : null;
        if (dlrnd == null) {
            return cf;
        }
        TCRenderer tcRender = this.getTCRenderer();
        if (tcRender == null) {
            return cf;
        }
        TableModel tm = this.getModel();
        if (tm == null) {
            return cf;
        }
        int rowcnt = tm.getRowCount();
        int colcnt = tm.getColumnCount();
        if (row >= rowcnt) {
            return cf;
        }
        if (col >= colcnt) {
            return cf;
        }
        Object val = tm.getValueAt(row, col);
        tcRender.getTableCellRendererComponent(this, val, false, false, row, col);
        TableCellContext tcc = tcRender.getCellContext().clone();
        dlrnd.prepare(this.getMemGraphics2D(), tcc, cf);
        return cf;
    }

    public String getCellText(int row, int col) {
        if (row < 0 || col < 0) {
            return null;
        }
        TableModel tm = this.getModel();
        if (tm != null) {
            DefaultLabelRender dlrnd;
            int rowcnt = tm.getRowCount();
            int colcnt = tm.getColumnCount();
            if (row >= rowcnt) {
                return null;
            }
            if (col >= colcnt) {
                return null;
            }
            Object val = tm.getValueAt(row, col);
            TCRenderer tcRender = this.getTCRenderer();
            if (tcRender == null) {
                return val.toString();
            }
            LabelRender lrnd = this.getLabelRender();
            DefaultLabelRender defaultLabelRender = dlrnd = lrnd instanceof DefaultLabelRender ? (DefaultLabelRender)lrnd : null;
            if (dlrnd != null) {
                tcRender.getTableCellRendererComponent(this, val, false, false, row, col);
                CellFormat cf = dlrnd.getFormat().clone();
                TableCellContext tcc = tcRender.getCellContext().clone();
                dlrnd.prepare(this.getMemGraphics2D(), tcc, cf);
                Object oval = tcc.getValue();
                if (oval instanceof String) {
                    return (String)oval;
                }
                return val.toString();
            }
            if (val != null) {
                return val.toString();
            }
        }
        return null;
    }

    public List<PreparedCopyCells> prepareCopy() {
        int[] selectedRows;
        ArrayList<PreparedCopyCells> list = new ArrayList<PreparedCopyCells>();
        int[] selectedCols = null;
        if (this.getColumnModel().getColumnSelectionAllowed()) {
            selectedCols = this.getColumnModel().getSelectedColumns();
        } else {
            selectedCols = new int[this.getColumnModel().getColumnCount()];
            for (int ci = 0; ci < selectedCols.length; ++ci) {
                selectedCols[ci] = ci;
            }
        }
        if (selectedCols.length < 1) {
            return list;
        }
        TableColumnModel tcm = this.getColumnModel();
        TableModel tm = this.getModel();
        for (int ri : selectedRows = this.getSelectedRows()) {
            ArrayList<PreparedCopyCell> lpcc = new ArrayList<PreparedCopyCell>();
            for (int ci : selectedCols) {
                PreparedCopyCell pcc = new PreparedCopyCell();
                pcc.setText(this.getCellText(ri, ci));
                TableColumn tc = tcm.getColumn(ci);
                if (tc != null && tc.getModelIndex() >= 0 && tm != null) {
                    pcc.setColumnName(tm.getColumnName(tc.getModelIndex()));
                }
                if (tm instanceof DataTableModel && tc != null && tc.getModelIndex() >= 0) {
                    DataTableModel dtm = (DataTableModel)tm;
                    DataTableModelColumn dtmc = dtm.getExtraColumn(tc.getModelIndex());
                    DataTable dt = dtm.getDataTable();
                    pcc.setDataColumn(dtmc == null && dt != null ? dt.getColumn(tc.getModelIndex()) : null);
                }
                pcc.setValue(this.getValueAt(ri, ci));
                lpcc.add(pcc);
            }
            PreparedCopyCells pccRow = new PreparedCopyCells(ri, this.dataRow(ri), lpcc);
            list.add(pccRow);
        }
        return list;
    }

    public void copy() {
        List<PreparedCopyCells> preparedValues = this.prepareCopy();
        if (preparedValues == null || preparedValues.isEmpty()) {
            return;
        }
        CSVDesc csvDesc = new CSVDesc();
        csvDesc.setFixedWidth(false);
        csvDesc.setQuoteVariants(CSVDesc.QuoteVariants.Always);
        CSVUtil csvUtl = new CSVUtil();
        StringBuilder sb = new StringBuilder();
        int lineIdx = -1;
        for (PreparedCopyCells pccs : preparedValues) {
            if (++lineIdx > 0) {
                sb.append(EndLine.Default.get());
            }
            if (pccs.getCells().size() == 1) {
                String txt = pccs.getCells().get(0).getText();
                sb.append(txt == null ? "" : txt);
                continue;
            }
            String[] txts = new String[pccs.getCells().size()];
            for (int i = 0; i < txts.length; ++i) {
                String txt = pccs.getCells().get(i).getText();
                txts[i] = txt == null ? "" : txt;
            }
            String line = csvUtl.toString(txts, csvDesc);
            sb.append(line);
        }
        StringSelection stringSelection = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void initCopy() {
        final KeyStroke ksCopy = KeyStroke.getKeyStroke("control pressed C");
        SwingListener.onKeyPressed(this, new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                if (GuiUtil.match(ke, ksCopy)) {
                    DataTableView.this.copy();
                    ke.consume();
                }
            }
        });
    }

    public boolean isModelColumnVisible(int mi) {
        TableColumnModel tcm = this.getColumnModel();
        for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            if (tc == null || tc.getModelIndex() != mi) continue;
            return true;
        }
        return false;
    }

    public void setModelColumnVisible(int mi, boolean visible) {
        TableColumnModel tcm = this.getColumnModel();
        if (visible) {
            TableColumn tc;
            for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
                tc = tcm.getColumn(ci);
                if (tc == null || tc.getModelIndex() != mi) continue;
                return;
            }
            TableModel tm = this.getModel();
            if (tm != null) {
                tc = new TableColumn(mi);
                tc.setCellRenderer(this.getTCRenderer());
                tc.setHeaderValue(tm.getColumnName(mi));
                tcm.addColumn(tc);
            }
        } else {
            LinkedHashSet<TableColumn> removeSet = new LinkedHashSet<TableColumn>();
            for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
                TableColumn tc = tcm.getColumn(ci);
                if (tc == null || tc.getModelIndex() != mi) continue;
                removeSet.add(tc);
            }
            for (TableColumn tc : removeSet) {
                tcm.removeColumn(tc);
            }
        }
    }

    protected JMenu createToggleModelColumnsVisibilityMenu() {
        JMenu visibleColumns = new JMenu("Model columns");
        TableModel tm = this.getModel();
        if (tm != null) {
            int added = 0;
            for (int ci2 = 0; ci2 < tm.getColumnCount(); ++ci2) {
                String cname = tm.getColumnName(ci2);
                if (cname == null) continue;
                final int mi = ci2;
                JCheckBoxMenuItem miVisible = new JCheckBoxMenuItem(cname);
                miVisible.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean visible = DataTableView.this.isModelColumnVisible(mi);
                        DataTableView.this.setModelColumnVisible(mi, !visible);
                    }
                });
                miVisible.setSelected(this.isModelColumnVisible(mi));
                visibleColumns.add(miVisible);
                ++added;
            }
            if (added > 0) {
                return visibleColumns;
            }
        }
        return null;
    }

    protected JMenu createAutoresizeModeMenu() {
        JMenu menuResize = new JMenu("Auto resize");
        int amode = this.getAutoResizeMode();
        JRadioButtonMenuItem mi1 = new JRadioButtonMenuItem("all columns");
        ButtonGroup bg = new ButtonGroup();
        mi1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableView.this.setAutoResizeMode(4);
            }
        });
        mi1.setSelected(amode == 4);
        JRadioButtonMenuItem mi2 = new JRadioButtonMenuItem("Subsequent columns");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableView.this.setAutoResizeMode(2);
            }
        });
        mi2.setSelected(amode == 2);
        JRadioButtonMenuItem mi3 = new JRadioButtonMenuItem("Next column");
        mi3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableView.this.setAutoResizeMode(1);
            }
        });
        mi3.setSelected(amode == 1);
        JRadioButtonMenuItem mi4 = new JRadioButtonMenuItem("Last column");
        mi4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableView.this.setAutoResizeMode(3);
            }
        });
        mi4.setSelected(amode == 3);
        JRadioButtonMenuItem mi5 = new JRadioButtonMenuItem("Off");
        mi5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTableView.this.setAutoResizeMode(0);
            }
        });
        mi5.setSelected(amode == 0);
        for (JRadioButtonMenuItem mi : new JRadioButtonMenuItem[]{mi1, mi2, mi3, mi4, mi5}) {
            bg.add(mi);
            menuResize.add(mi);
        }
        return menuResize;
    }

    protected JMenuItem createColumnSelectableMenu() {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Column selectable");
        mi.setSelected(this.getColumnModel().getColumnSelectionAllowed());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataTableView.this.getColumnModel().getColumnSelectionAllowed();
                DataTableView.this.getColumnModel().setColumnSelectionAllowed(!b);
            }
        });
        return mi;
    }

    protected List<JMenuItem> createColumnsPopupItems() {
        JMenuItem miColSelectable;
        JMenu autoresizeColumns;
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        JMenu visibleColumns = this.createToggleModelColumnsVisibilityMenu();
        if (visibleColumns != null) {
            list.add(visibleColumns);
        }
        if ((autoresizeColumns = this.createAutoresizeModeMenu()) != null) {
            list.add(autoresizeColumns);
        }
        if ((miColSelectable = this.createColumnSelectableMenu()) != null) {
            list.add(miColSelectable);
        }
        return list;
    }

    protected JPopupMenu createColumnsPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        List<JMenuItem> itms = this.createColumnsPopupItems();
        if (itms != null) {
            for (JMenuItem en : itms) {
                if (en == null) continue;
                if (en instanceof JSeparator) {
                    popup.addSeparator();
                    continue;
                }
                if (en instanceof JMenuItem) {
                    popup.add(en);
                    continue;
                }
                if (!(en instanceof Action)) continue;
                popup.add((Action)((Object)en));
            }
        }
        return popup;
    }

    public void showColumnsPopup(MouseEvent me) {
        if (me == null) {
            return;
        }
        this.showColumnsPopup(me.getComponent(), me.getX(), me.getY());
    }

    public void showColumnsPopup(Component cmpt, int mouseX, int mouseY) {
        if (cmpt == null) {
            return;
        }
        JPopupMenu menu = this.createColumnsPopupMenu();
        if (menu != null) {
            menu.show(cmpt, mouseX, mouseY);
        }
    }

    protected void initColumnsPopup() {
        JTableHeader th = this.getTableHeader();
        if (th != null) {
            th.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        DataTableView.this.showColumnsPopup(e);
                    }
                }
            });
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class DataTableCellContext
    extends TableCellContext {
        private DataRow dataRow;
        protected DataTable dataTable;
        protected DataTableModel dataTableModel;
        protected TableColumn tableColumn;

        public DataRow getDataRow() {
            return this.dataRow;
        }

        public void setDataRow(DataRow dataRow) {
            this.dataRow = dataRow;
        }

        public DataTable getDataTable() {
            return this.dataTable;
        }

        public void setDataTable(DataTable dataTable) {
            this.dataTable = dataTable;
        }

        public DataTableModel getDataTableModel() {
            return this.dataTableModel;
        }

        public void setDataTableModel(DataTableModel dataTableModel) {
            this.dataTableModel = dataTableModel;
        }

        public TableColumn getTableColumn() {
            return this.tableColumn;
        }

        public void setTableColumn(TableColumn tableColumn) {
            this.tableColumn = tableColumn;
        }

        public boolean isExtraColumn() {
            DataTableModel dtm = this.getDataTableModel();
            TableColumn tc = this.getTableColumn();
            if (dtm != null && tc != null && tc.getModelIndex() >= 0) {
                int mi = tc.getModelIndex();
                return dtm.getExtraColumn(mi) != null;
            }
            return false;
        }

        public DataColumn getDataColumn() {
            DataTableModel dtm = this.getDataTableModel();
            TableColumn tc = this.getTableColumn();
            DataTable dt = this.getDataTable();
            if (tc == null || dtm == null || dt == null) {
                return null;
            }
            int mi = tc.getModelIndex();
            if (this.isExtraColumn()) {
                return null;
            }
            if (mi >= 0 && mi < dt.getColumnsCount()) {
                return dt.getColumn(mi);
            }
            return null;
        }
    }
}

