/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.font;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import xyz.cofe.collection.Func1;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.font.FontChooserPanel;

public class FontChooser
extends JDialog {
    protected Font selectedFont;
    private JButton cancelButton;
    private FontChooserPanel fontChooserPanel1;
    private JButton okButton;

    public FontChooser(Frame parent, boolean modal) {
        super(parent, modal);
        String resname;
        this.initComponents();
        SwingListener.onActionPerformed(this.okButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                FontChooser.this.selectedFont = FontChooser.this.fontChooserPanel1.getUserFont();
                FontChooser.this.setVisible(false);
            }
        });
        SwingListener.onActionPerformed(this.cancelButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                FontChooser.this.selectedFont = null;
                FontChooser.this.setVisible(false);
            }
        });
        Locale loc = Locale.getDefault();
        URL url = null;
        String[] stringArray = new String[]{FontChooser.class.getSimpleName() + "_" + loc.getLanguage() + "_" + loc.getCountry() + ".properties", FontChooser.class.getSimpleName() + "_" + loc.getLanguage() + ".properties", FontChooser.class.getSimpleName() + ".properties"};
        int n = stringArray.length;
        for (int i = 0; i < n && (url = FontChooser.class.getResource(resname = stringArray[i])) == null; ++i) {
        }
        if (url != null) {
            final Properties props = new Properties();
            try {
                InputStream inp = url.openStream();
                props.load(inp);
                inp.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FontChooser.class.getName()).log(Level.SEVERE, null, ex);
            }
            Func1<String, String> translFn = new Func1<String, String>(){

                public String apply(String arg) {
                    if (arg == null) {
                        return null;
                    }
                    return props.getProperty(arg);
                }
            };
            this.translate(translFn);
        }
    }

    private String tr(String txt, Func1<String, String> fn) {
        if (txt == null) {
            return null;
        }
        if (fn == null) {
            return txt;
        }
        String t = (String)fn.apply((Object)txt);
        return t != null ? t : txt;
    }

    public void translate(Func1<String, String> fn) {
        if (fn == null) {
            return;
        }
        this.okButton.setText(this.tr(this.okButton.getText(), fn));
        this.cancelButton.setText(this.tr(this.cancelButton.getText(), fn));
        this.setTitle(this.tr(this.getTitle(), fn));
        this.fontChooserPanel1.translate(fn);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font fnt) {
        this.selectedFont = fnt;
    }

    public void select(Font font) {
        this.fontChooserPanel1.setUserFont(font);
    }

    public static Font choose(Font currentFont, Frame parent, boolean modal, Func1<String, String> translate, final Reciver<Font> consumer) {
        final FontChooser fc = new FontChooser(parent, modal);
        if (translate != null) {
            fc.translate(translate);
        }
        if (parent != null) {
            fc.setLocationRelativeTo(parent);
        }
        fc.select(currentFont);
        fc.setVisible(true);
        fc.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f;
                if (consumer != null && (f = fc.getSelectedFont()) != null) {
                    consumer.recive((Object)f);
                }
            }
        });
        return fc.getSelectedFont();
    }

    public static Font choose(Font currentFont, boolean modal, Reciver<Font> consumer) {
        return FontChooser.choose(currentFont, null, modal, null, consumer);
    }

    public static Font choose(Font currentFont, Reciver<Font> consumer) {
        return FontChooser.choose(currentFont, null, false, null, consumer);
    }

    public static Font choose(Font currentFont) {
        return FontChooser.choose(currentFont, null, true, null, null);
    }

    private void initComponents() {
        this.fontChooserPanel1 = new FontChooserPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select font");
        this.okButton.setText("ok");
        this.cancelButton.setText("cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addComponent(this.fontChooserPanel1, -1, 388, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fontChooserPanel1, -2, 255, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FontChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FontChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FontChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FontChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontChooser dialog = new FontChooser((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

