/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.font;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import xyz.cofe.collection.Func1;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;

public class FontChooserPanel
extends JPanel {
    private volatile boolean setUserFontCalled;
    private JRadioButton boldRB;
    private ButtonGroup buttonGroup1;
    private JList<String> fontNamesList;
    private JRadioButton italicBoldRB;
    private JRadioButton italicRB;
    private JScrollPane jScrollPane1;
    private JRadioButton plainRB;
    private JTextField previewTextField;
    private JSpinner sizeSpinner;

    public FontChooserPanel() {
        this.initComponents();
        this.initFontNames();
        this.setUserFontCalled = false;
        Reciver preview = new Reciver(){

            public void recive(Object obj) {
                if (FontChooserPanel.this.setUserFontCalled) {
                    return;
                }
                FontChooserPanel.this.preview(FontChooserPanel.this.getUserFont());
            }
        };
        SwingListener.onValueChanged(this.fontNamesList, (Reciver<ListSelectionEvent>)preview);
        SwingListener.onActionPerformed(this.plainRB, (Reciver<ActionEvent>)preview);
        SwingListener.onActionPerformed(this.boldRB, (Reciver<ActionEvent>)preview);
        SwingListener.onActionPerformed(this.italicRB, (Reciver<ActionEvent>)preview);
        SwingListener.onActionPerformed(this.italicBoldRB, (Reciver<ActionEvent>)preview);
        SwingListener.onStateChanged(this.sizeSpinner, (Reciver<ChangeEvent>)preview);
        SwingListener.onMouseWheelMoved(this.sizeSpinner, new Reciver<MouseWheelEvent>(){

            public void recive(MouseWheelEvent me) {
                Object prevv;
                if (me.getWheelRotation() > 0) {
                    Object nextv = FontChooserPanel.this.sizeSpinner.getModel().getNextValue();
                    if (nextv != null) {
                        FontChooserPanel.this.sizeSpinner.getModel().setValue(nextv);
                    }
                } else if (me.getWheelRotation() < 0 && (prevv = FontChooserPanel.this.sizeSpinner.getModel().getPreviousValue()) != null) {
                    FontChooserPanel.this.sizeSpinner.getModel().setValue(prevv);
                }
            }
        });
    }

    protected void initFontNames() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        DefaultListModel<String> mdl = new DefaultListModel<String>();
        mdl.addElement("Dialog");
        mdl.addElement("DialogInput");
        mdl.addElement("Monospaced");
        mdl.addElement("SansSerif");
        mdl.addElement("Serif");
        for (String fnt : fonts) {
            if (fnt == null || fnt.trim().length() < 1) continue;
            mdl.addElement(fnt);
        }
        this.fontNamesList.setModel(mdl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUserFont(Font fnt) {
        try {
            boolean itl;
            this.setUserFontCalled = true;
            if (fnt == null) {
                return;
            }
            this.fontNamesList.setSelectedValue(fnt.getName(), true);
            int stl = fnt.getStyle();
            boolean bld = (stl & 1) == 1;
            boolean bl = itl = (stl & 2) == 2;
            if (stl == 0) {
                this.plainRB.setSelected(true);
            } else if (bld && !itl) {
                this.boldRB.setSelected(true);
            } else if (!bld && itl) {
                this.italicRB.setSelected(true);
            } else if (bld && itl) {
                this.italicBoldRB.setSelected(true);
            }
            this.sizeSpinner.setValue(fnt.getSize());
        }
        finally {
            this.setUserFontCalled = false;
        }
    }

    public synchronized Font getUserFont() {
        String selfnt = this.fontNamesList.getSelectedValue();
        if (selfnt == null) {
            selfnt = "Dialog";
        }
        int stl = 0;
        if (this.boldRB.isSelected()) {
            stl = 1;
        } else if (this.italicRB.isSelected()) {
            stl = 2;
        } else if (this.italicBoldRB.isSelected()) {
            stl = 3;
        } else if (this.plainRB.isSelected()) {
            stl = 0;
        }
        int size = 10;
        Object osize = this.sizeSpinner.getValue();
        if (osize instanceof Number) {
            size = ((Number)osize).intValue();
        }
        if (size < 1) {
            size = 1;
        }
        return new Font(selfnt, stl, size);
    }

    private String tr(String txt, Func1<String, String> fn) {
        if (txt == null) {
            return null;
        }
        if (fn == null) {
            return txt;
        }
        String t = (String)fn.apply((Object)txt);
        return t != null ? t : txt;
    }

    public void translate(Func1<String, String> fn) {
        if (fn == null) {
            return;
        }
        this.boldRB.setText(this.tr(this.boldRB.getText(), fn));
        this.italicBoldRB.setText(this.tr(this.italicBoldRB.getText(), fn));
        this.italicRB.setText(this.tr(this.italicRB.getText(), fn));
        this.plainRB.setText(this.tr(this.plainRB.getText(), fn));
        this.previewTextField.setText(this.tr(this.previewTextField.getText(), fn));
    }

    public void preview(Font fnt) {
        if (fnt == null) {
            return;
        }
        this.previewTextField.setFont(fnt);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.fontNamesList = new JList();
        this.plainRB = new JRadioButton();
        this.italicRB = new JRadioButton();
        this.boldRB = new JRadioButton();
        this.italicBoldRB = new JRadioButton();
        this.previewTextField = new JTextField();
        this.sizeSpinner = new JSpinner();
        this.setLayout(new GridBagLayout());
        this.fontNamesList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.fontNamesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.fontNamesList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 150;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonGroup1.add(this.plainRB);
        this.plainRB.setText("Plain");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.plainRB, gridBagConstraints);
        this.buttonGroup1.add(this.italicRB);
        this.italicRB.setFont(this.italicRB.getFont().deriveFont(this.italicRB.getFont().getStyle() | 2));
        this.italicRB.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 37;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.italicRB, gridBagConstraints);
        this.buttonGroup1.add(this.boldRB);
        this.boldRB.setFont(this.boldRB.getFont().deriveFont(this.boldRB.getFont().getStyle() | 1));
        this.boldRB.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 36;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.boldRB, gridBagConstraints);
        this.buttonGroup1.add(this.italicBoldRB);
        this.italicBoldRB.setFont(this.italicBoldRB.getFont().deriveFont(this.italicBoldRB.getFont().getStyle() | 2 | 1));
        this.italicBoldRB.setText("Italic Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.italicBoldRB, gridBagConstraints);
        this.previewTextField.setText("Sample text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 73;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.previewTextField, gridBagConstraints);
        this.sizeSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 46;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.sizeSpinner, gridBagConstraints);
    }
}

