/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.font;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.GuiUtil;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.font.FontChooser;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;

public class FontPropertyEditor
extends CustomEditor
implements PropertyDBService {
    private static final Logger logger = Logger.getLogger(FontPropertyEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected JPanel panel;
    protected JLabel label;
    protected JButton editButton;
    protected Font font;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FontPropertyEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FontPropertyEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FontPropertyEditor.class.getName(), method, result);
    }

    public FontPropertyEditor() {
    }

    public FontPropertyEditor(FontPropertyEditor sample) {
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb != null) {
            pdb.registerTypeEditor(Font.class, this);
        }
    }

    @Override
    public FontPropertyEditor clone() {
        return new FontPropertyEditor(this);
    }

    protected synchronized JPanel getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panel.add((Component)this.getLabel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        this.panel.add((Component)this.getEditButton(), gbc);
        return this.panel;
    }

    protected synchronized JLabel getLabel() {
        if (this.label != null) {
            return this.label;
        }
        this.label = new JLabel();
        return this.label;
    }

    protected synchronized JButton getEditButton() {
        if (this.editButton != null) {
            return this.editButton;
        }
        this.editButton = new JButton("..");
        SwingListener.onActionPerformed(this.editButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                Frame frm = GuiUtil.getFrameOfComponent(FontPropertyEditor.this.editButton);
                Font nfnt = FontChooser.choose(FontPropertyEditor.this.font, frm, true, null, null);
                if (nfnt != null) {
                    FontPropertyEditor.this.setFont(nfnt);
                    FontPropertyEditor.this.fireEditingStopped(FontPropertyEditor.this);
                }
            }
        });
        return this.editButton;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (font != null) {
            this.getLabel().setText(font.getName() + " size=" + font.getSize() + " style" + font.getStyle());
        } else {
            this.getLabel().setText("null");
        }
    }

    @Override
    protected JComponent createComponent() {
        return this.getPanel();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Font) {
            this.setFont((Font)value);
        } else {
            this.setFont(null);
        }
    }

    @Override
    public Object getValue() {
        return this.getFont();
    }

    @Override
    public String getJavaInitializationString() {
        return "";
    }

    @Override
    public String getAsText() {
        if (this.font != null) {
            return "name=" + this.font.getName() + "; size=" + this.font.getSize() + "; style=" + this.font.getStyle();
        }
        return "null";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

