/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.log.ChainAction;
import xyz.cofe.gui.swing.log.ChainElement;
import xyz.cofe.gui.swing.log.MaskFilter;

public class ChainFilters
implements Filter {
    private static final Logger logger = Logger.getLogger(ChainFilters.class.getName());
    private ChainAction defaultAction = ChainAction.Include;
    protected final List<ChainElement> filters = new ArrayList<ChainElement>();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ChainFilters.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ChainFilters.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ChainFilters.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainAction getDefaultAction() {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            return this.defaultAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAction(ChainAction defaultAction) {
        if (defaultAction == null) {
            throw new IllegalArgumentException("defaultAction == null");
        }
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            this.defaultAction = defaultAction;
        }
    }

    public ChainFilters defaultAction(ChainAction act) {
        this.setDefaultAction(act);
        return this;
    }

    protected void onAdded(ChainElement member) {
        if (member instanceof MaskFilter) {
            ((MaskFilter)member).setFiltersChain(this);
        }
    }

    protected void onRemoved(ChainElement member) {
        if (member instanceof MaskFilter) {
            ((MaskFilter)member).setFiltersChain(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ChainElement member) {
        if (member == null) {
            throw new IllegalArgumentException("member == null");
        }
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            this.filters.add(member);
            this.onAdded(member);
            return this.filters.indexOf(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(int idx, ChainElement member) {
        if (member == null) {
            throw new IllegalArgumentException("member == null");
        }
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            this.filters.add(idx, member);
            this.onAdded(member);
            return this.filters.indexOf(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainElement remove(int idx) {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            ChainElement e = this.filters.remove(idx);
            this.onRemoved(e);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(ChainElement member) {
        if (member == null) {
            throw new IllegalArgumentException("member == null");
        }
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            int idx = this.filters.indexOf(member);
            this.remove(idx);
            return idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainFilters clear() {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            this.filters.clear();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainElement get(int idx) {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            return this.filters.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainElement set(int idx, ChainElement newMember) {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            return this.filters.set(idx, newMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainElement[] array() {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            return this.filters.toArray(new ChainElement[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            return this.filters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoggable(LogRecord record) {
        ChainFilters chainFilters = this;
        synchronized (chainFilters) {
            for (int i = 0; i < this.size(); ++i) {
                ChainAction act;
                ChainElement e = this.get(i);
                if (e == null || !e.isEnabled() || (act = e.isLoggable(record)) == null) continue;
                if (ChainAction.Include.equals((Object)act)) {
                    return true;
                }
                if (!ChainAction.Exclude.equals((Object)act)) continue;
                return false;
            }
            ChainAction defAct = this.getDefaultAction();
            return ChainAction.Include.equals((Object)defAct);
            {
            }
        }
    }
}

