/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.log.ChainAction;
import xyz.cofe.gui.swing.log.LogHandlerPanel;
import xyz.cofe.gui.swing.log.LoggerLevel;

public class LogHandlerFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(LogHandlerFrame.class.getName());
    protected OnClose onClose = new OnClose(this);
    protected OnOpen onOpen = new OnOpen(this);
    private final LogHandlerPanel logHandlerPanel = new LogHandlerPanel();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LogHandlerFrame.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LogHandlerFrame.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LogHandlerFrame.class.getName(), method, result);
    }

    public LogHandlerFrame() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.logHandlerPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setTitle("Log handler");
        this.setDefaultCloseOperation(2);
        SwingListener.onWindowClosing(this, new Reciver<WindowEvent>(){

            public void recive(WindowEvent obj) {
                if (LogHandlerFrame.this.onClose().stopAll) {
                    LogHandlerFrame.this.logHandlerPanel.stop();
                }
            }
        });
    }

    public OnClose onClose() {
        return this.onClose;
    }

    public OnOpen onOpen() {
        return this.onOpen;
    }

    public LogHandlerPanel getLogHandlerPanel() {
        return this.logHandlerPanel;
    }

    public Handler getLogHandler() {
        return this.logHandlerPanel.getLogHandler();
    }

    public Configure configure() {
        return new Configure(this);
    }

    public static class ConfigureSources
    extends LogHandlerPanel.ConfigureSources {
        protected final LogHandlerFrame frame;

        public ConfigureSources(LogHandlerFrame frame) {
            super(frame.logHandlerPanel);
            this.frame = frame;
        }

        @Override
        public Configure conf() {
            return new Configure(this.frame);
        }

        @Override
        public Configure listen(String ... loggers) {
            super.listen(loggers);
            return new Configure(this.frame);
        }

        @Override
        public Configure listen(LoggerLevel lvl, String ... loggers) {
            super.listen(lvl, loggers);
            return new Configure(this.frame);
        }

        @Override
        public ConfigureSources add(String loggerName, boolean start) {
            super.add(loggerName, start);
            return this;
        }

        @Override
        public ConfigureSources add(String loggerName, LoggerLevel lvl, boolean start) {
            super.add(loggerName, lvl, start);
            return this;
        }

        @Override
        public ConfigureSources add(String loggerName, LoggerLevel lvl) {
            super.add(loggerName, lvl);
            return this;
        }

        @Override
        public ConfigureSources add(String loggerName) {
            super.add(loggerName);
            return this;
        }

        @Override
        public ConfigureSources clear() {
            super.clear();
            return this;
        }
    }

    public static class ConfigureFilters
    extends LogHandlerPanel.ConfigureFilters {
        protected final LogHandlerFrame frame;

        public ConfigureFilters(LogHandlerFrame frame) {
            super(frame.logHandlerPanel);
            this.frame = frame;
        }

        @Override
        public Configure conf() {
            return new Configure(this.frame);
        }

        @Override
        public ConfigureFilters include(String loggerMaskMask, String messageMask) {
            super.include(loggerMaskMask, messageMask);
            return this;
        }

        @Override
        public ConfigureFilters exclude(String loggerMaskMask, String messageMask) {
            super.exclude(loggerMaskMask, messageMask);
            return this;
        }

        @Override
        public ConfigureFilters policy(ChainAction act) {
            super.policy(act);
            return this;
        }

        @Override
        public ConfigureFilters clear() {
            super.clear();
            return this;
        }
    }

    public static class Configure
    extends LogHandlerPanel.Configure {
        protected final LogHandlerFrame frame;

        public Configure(LogHandlerFrame frame) {
            super(frame.logHandlerPanel);
            this.frame = frame;
        }

        @Override
        public Configure stop() {
            super.stop();
            return this;
        }

        @Override
        public Configure start() {
            super.start();
            return this;
        }

        @Override
        public Configure start(LoggerLevel level) {
            super.start(level);
            return this;
        }

        @Override
        public ConfigureFilters filters() {
            super.filters();
            return new ConfigureFilters(this.frame);
        }

        public void show() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Configure.this.frame.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        public OnOpen onOpen() {
            return this.frame.onOpen();
        }

        public OnClose onClose() {
            return this.frame.onClose();
        }
    }

    public static class OnOpen {
        public final LogHandlerFrame frame;
        public Double alignX = null;
        public Double alignY = null;

        public OnOpen(LogHandlerFrame frame) {
            this.frame = frame;
        }

        public OnOpen align(Double x, Double y) {
            this.alignX = x;
            this.alignY = y;
            return this;
        }

        public Configure conf() {
            return new Configure(this.frame);
        }
    }

    public static class OnClose {
        public final LogHandlerFrame frame;
        public boolean stopAll = true;

        public OnClose(LogHandlerFrame frame) {
            this.frame = frame;
        }

        public OnClose stopAll(boolean stop) {
            this.stopAll = stop;
            return this;
        }

        public Configure conf() {
            return new Configure(this.frame);
        }
    }
}

