/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.xml.stream.XMLStreamException;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.set.SyncEventSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.AWTReciver;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.log.ChainAction;
import xyz.cofe.gui.swing.log.ChainElement;
import xyz.cofe.gui.swing.log.ChainFilters;
import xyz.cofe.gui.swing.log.LogSource;
import xyz.cofe.gui.swing.log.LogTable;
import xyz.cofe.gui.swing.log.LoggerLevel;
import xyz.cofe.gui.swing.log.MaskFilter;
import xyz.cofe.gui.swing.log.XmlConfig;
import xyz.cofe.gui.swing.log.XmlConfigFrame;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.table.CachedTM;
import xyz.cofe.gui.swing.table.PropertyColumn;
import xyz.cofe.gui.swing.text.ValidatedTextField;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeRender;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditorDef;

public class LogHandlerPanel
extends JPanel {
    protected final Object handlerSync;
    protected boolean unlimitedMessageCount = true;
    protected int limitMessageCount = -1;
    private volatile long lastScrolled = System.currentTimeMillis();
    private volatile long scrollMessageToLastLast = System.currentTimeMillis();
    private final Handler logHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            if (record == null) {
                return;
            }
            if (!this.isLoggable(record)) {
                return;
            }
            LogHandlerPanel.this.logTable.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private Level stoppedLevel = null;
    private boolean uiRefreshLevelCall = false;
    protected volatile TreeTableNodeRender propertyRender;
    protected volatile TreeTableNodeValueEditor propertyEditor;
    protected volatile SyncEventSet<LogSource> sources;
    protected TreeTableNodeFormat rootLoggerFormat = new TreeTableNodeFormatBasic().convertor(new Convertor<Object, String>(){

        public String convert(Object from) {
            if (from instanceof String) {
                if (((String)from).equals("")) {
                    return "root";
                }
                return from.toString();
            }
            return null;
        }
    }).foreground(Color.gray).italic(true);
    protected CachedTM<LogSource> sourcesCacheTM;
    protected final ChainFilters filters = new ChainFilters().defaultAction(ChainAction.Include).clear();
    private Iterable<ChainElement> filtersElements = new Iterable<ChainElement>(){

        @Override
        public Iterator<ChainElement> iterator() {
            final ChainElement[] arr = LogHandlerPanel.this.filters.array();
            Iterator<ChainElement> iter = new Iterator<ChainElement>(){
                int ptr = 0;

                @Override
                public boolean hasNext() {
                    return this.ptr < arr.length;
                }

                @Override
                public ChainElement next() {
                    if (this.ptr < arr.length) {
                        ChainElement e = arr[this.ptr];
                        ++this.ptr;
                        return e;
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            return iter;
        }
    };
    private CachedTM<ChainElement> filtersCacheTM;
    protected XmlConfig xmlConfig;
    protected JPopupMenu confMenu;
    private File settingsFile = null;
    private JButton addFilterButton;
    private ButtonGroup addFilterButtonGroup;
    private JButton addSourceButton;
    private JComboBox<String> addSourceLevelComboBox;
    private ValidatedTextField addSourceTextField;
    private JButton clearButton;
    private JButton confButton;
    private JRadioButton defExcActionRButton;
    private ButtonGroup defFilterButtonGroup;
    private JRadioButton defIncActionRButton;
    private JButton deleteSourcesButton;
    private JPanel editFilterPanel;
    private JRadioButton excludeRButton;
    private JPanel filtersPanel;
    private JTable filtersTable;
    private JRadioButton includeRButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JComboBox<String> levelComboBox;
    private JCheckBox limitCheckBox;
    private ValidatedTextField limitFTextField;
    private JScrollPane logScrollPane;
    private LogTable logTable;
    private ValidatedTextField loggerNameTField;
    private ValidatedTextField messageTField;
    private JButton removeFilterButton;
    private JToolBar.Separator scrollSeparator;
    private JToggleButton scrollToggleButton;
    private JPanel sourcesPanel;
    private JTable sourcesTable;
    private JButton startButton;
    private JButton stopButton;
    private JToolBar toolBar;

    public LogHandlerPanel() {
        this.initComponents();
        this.handlerSync = new Object();
        this.initPredefinedValues();
        this.initLimitFTextListeners();
        this.initLimitAndScroll();
        this.initLevelComboBox();
        this.initClearButton();
        this.initSourcesTable();
        this.initFiltersTable();
        this.initConfMenu();
        this.logHandler.setFilter(this.filters);
    }

    private void initClearButton() {
        SwingListener.onActionPerformed(this.clearButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.clearMessages();
            }
        });
    }

    private void initLimitAndScroll() {
        SwingListener.onActionPerformed(this.limitCheckBox, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.updateUnlimitedMessageCount();
            }
        });
        AWTReciver<LogRecord> a = new AWTReciver<LogRecord>(){

            @Override
            public synchronized void recive(LogRecord obj) {
                if (!LogHandlerPanel.this.isUnlimitedMessageCount()) {
                    LogHandlerPanel.this.limitMessages();
                }
                if (LogHandlerPanel.this.isAutoScrollMessages()) {
                    LogHandlerPanel.this.scrollMessageToLast();
                }
            }
        };
        a.setAwtSync(false);
        this.logTable.getRecords().onAdded((Reciver)a);
    }

    private void initPredefinedValues() {
        this.unlimitedMessageCount = false;
        this.limitMessageCount = 1000;
        this.uiRefreshLimitMessageCount();
        this.uiRefreshUnlimitedMessageCount();
        this.setAutoScrollMessages(true);
        this.logHandler.setLevel(Level.FINER);
        this.stoppedLevel = Level.FINER;
        this.uiRefreshLevel();
    }

    private void initLimitFTextListeners() {
        SwingListener.onFocusLost(this.limitFTextField, new Reciver<FocusEvent>(){

            public void recive(FocusEvent obj) {
                LogHandlerPanel.this.updateLimitMessageCount();
            }
        });
        SwingListener.onKeyPressed(this.limitFTextField, new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    LogHandlerPanel.this.updateLimitMessageCount();
                }
            }
        });
    }

    public Configure configure() {
        return new Configure(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnlimitedMessageCount() {
        Object object = this.handlerSync;
        synchronized (object) {
            return this.unlimitedMessageCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnlimitedMessageCount(boolean unlim) {
        Boolean cur;
        Boolean old;
        Object object = this.handlerSync;
        synchronized (object) {
            old = this.unlimitedMessageCount;
            this.unlimitedMessageCount = unlim;
            cur = this.unlimitedMessageCount;
        }
        this.uiRefreshUnlimitedMessageCount();
        this.firePropertyChange("unlimitedMessageCount", old, cur);
    }

    protected void uiRefreshUnlimitedMessageCount() {
        final boolean unlim = this.isUnlimitedMessageCount();
        Runnable rn = new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.limitCheckBox.setSelected(!unlim);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rn.run();
        } else {
            SwingUtilities.invokeLater(rn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUnlimitedMessageCount() {
        boolean unlim = !this.limitCheckBox.isSelected();
        Object object = this.handlerSync;
        synchronized (object) {
            this.unlimitedMessageCount = unlim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLimitMessageCount() {
        Object object = this.handlerSync;
        synchronized (object) {
            return this.limitMessageCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimitMessageCount(int newLimit) {
        Integer cur;
        Integer old;
        Object object = this.handlerSync;
        synchronized (object) {
            old = this.limitMessageCount;
            this.limitMessageCount = newLimit;
            cur = this.limitMessageCount;
        }
        this.uiRefreshLimitMessageCount();
        this.firePropertyChange("limitMessageCount", old, cur);
    }

    protected Integer readLimitTextField() {
        String str = this.limitFTextField.getText();
        if (str == null || str.trim().length() < 1) {
            return null;
        }
        if (!(str = str.trim()).matches("^([\\-\\s]+)?\\d+")) {
            return null;
        }
        return Integer.parseInt(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLimitMessageCount() {
        Integer v = this.readLimitTextField();
        if (v == 0) {
            return;
        }
        Object object = this.handlerSync;
        synchronized (object) {
            this.limitMessageCount = v;
        }
    }

    protected void uiRefreshLimitMessageCount() {
        final int cnt = this.getLimitMessageCount();
        Runnable rn = new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.limitFTextField.setText(Integer.toString(cnt));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rn.run();
        } else {
            SwingUtilities.invokeLater(rn);
        }
    }

    public boolean isAutoScrollMessages() {
        return this.scrollToggleButton.isSelected();
    }

    public void setAutoScrollMessages(boolean v) {
        this.scrollToggleButton.setSelected(v);
    }

    public void scrollMessageToLast() {
        final Runnable scroll = new Runnable(){

            @Override
            public void run() {
                int max;
                int v = LogHandlerPanel.this.logScrollPane.getVerticalScrollBar().getValue();
                if (v < (max = LogHandlerPanel.this.logScrollPane.getVerticalScrollBar().getMaximum())) {
                    LogHandlerPanel.this.logScrollPane.getVerticalScrollBar().setValue(max);
                }
                LogHandlerPanel.this.lastScrolled = System.currentTimeMillis();
            }
        };
        this.scrollMessageToLastLast = System.currentTimeMillis();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Timer timer = new Timer(50, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LogHandlerPanel.this.scrollMessageToLastLast > LogHandlerPanel.this.lastScrolled) {
                            scroll.run();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.setInitialDelay(50);
                timer.start();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void clearMessages() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.logTable.getRecords().clear();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void limitMessages() {
        final int limitSize = this.getLimitMessageCount();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                int size = LogHandlerPanel.this.logTable.getRecords().size();
                if (size > limitSize && limitSize > 0) {
                    int removeCount = size - limitSize;
                    for (int i = 0; i < removeCount; ++i) {
                        LogHandlerPanel.this.logTable.getRecords().remove(0);
                    }
                }
            }
        };
        if (limitSize < 1) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public Handler getLogHandler() {
        return this.logHandler;
    }

    protected void initLevelComboBox(JComboBox cbox) {
        cbox.setModel(new DefaultComboBoxModel<String>(new String[]{Level.ALL.getName(), Level.FINEST.getName(), Level.FINER.getName(), Level.FINE.getName(), Level.CONFIG.getName(), Level.INFO.getName(), Level.WARNING.getName(), Level.SEVERE.getName(), Level.OFF.getName()}));
    }

    protected void uiWriteLevel(JComboBox cbox, Level level) {
        if (level == null) {
            cbox.setSelectedItem(Level.ALL.getName());
        } else if (level.intValue() == Level.ALL.intValue()) {
            cbox.setSelectedItem(Level.ALL.getName());
        } else if (level.intValue() == Level.FINEST.intValue()) {
            cbox.setSelectedItem(Level.FINEST.getName());
        } else if (level.intValue() == Level.FINER.intValue()) {
            cbox.setSelectedItem(Level.FINER.getName());
        } else if (level.intValue() == Level.FINE.intValue()) {
            cbox.setSelectedItem(Level.FINE.getName());
        } else if (level.intValue() == Level.CONFIG.intValue()) {
            cbox.setSelectedItem(Level.CONFIG.getName());
        } else if (level.intValue() == Level.INFO.intValue()) {
            cbox.setSelectedItem(Level.INFO.getName());
        } else if (level.intValue() == Level.WARNING.intValue()) {
            cbox.setSelectedItem(Level.WARNING.getName());
        } else if (level.intValue() == Level.SEVERE.intValue()) {
            cbox.setSelectedItem(Level.SEVERE.getName());
        } else if (level.intValue() == Level.OFF.intValue()) {
            cbox.setSelectedItem(Level.OFF.getName());
        }
    }

    protected Level readLevel(JComboBox cbox) {
        Object sel = cbox.getSelectedItem();
        if (sel == null) {
            return null;
        }
        Level lvl = null;
        if (sel.toString().equalsIgnoreCase(Level.OFF.getName())) {
            lvl = Level.OFF;
        } else if (sel.toString().equalsIgnoreCase(Level.SEVERE.getName())) {
            lvl = Level.SEVERE;
        } else if (sel.toString().equalsIgnoreCase(Level.WARNING.getName())) {
            lvl = Level.WARNING;
        } else if (sel.toString().equalsIgnoreCase(Level.INFO.getName())) {
            lvl = Level.INFO;
        } else if (sel.toString().equalsIgnoreCase(Level.CONFIG.getName())) {
            lvl = Level.CONFIG;
        } else if (sel.toString().equalsIgnoreCase(Level.FINE.getName())) {
            lvl = Level.FINE;
        } else if (sel.toString().equalsIgnoreCase(Level.FINER.getName())) {
            lvl = Level.FINER;
        } else if (sel.toString().equalsIgnoreCase(Level.FINEST.getName())) {
            lvl = Level.FINEST;
        } else if (sel.toString().equalsIgnoreCase(Level.ALL.getName())) {
            lvl = Level.ALL;
        }
        return lvl;
    }

    protected void initLevelComboBox() {
        this.initLevelComboBox(this.levelComboBox);
        SwingListener.onActionPerformed(this.levelComboBox, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.updateLevel();
            }
        });
        this.levelComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LogHandlerPanel.this.uiRefreshLevelCall) {
                    return;
                }
                LogHandlerPanel.this.updateLevel();
            }
        });
        this.uiRefreshLevel();
        SwingListener.onActionPerformed(this.startButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.start();
            }
        });
        SwingListener.onActionPerformed(this.stopButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.stop();
            }
        });
    }

    public void start() {
        if (this.stoppedLevel == null || this.stoppedLevel.intValue() == Level.OFF.intValue()) {
            this.getLogHandler().setLevel(Level.FINER);
        } else {
            this.getLogHandler().setLevel(this.stoppedLevel);
        }
        this.uiRefreshLevel();
    }

    public void start(Level level) {
        if (level == null) {
            level = this.stoppedLevel == null || this.stoppedLevel.intValue() != Level.OFF.intValue() ? Level.FINER : this.stoppedLevel;
        }
        this.getLogHandler().setLevel(level);
        this.uiRefreshLevel();
    }

    public void stop() {
        Level lvl = this.getLogHandler().getLevel();
        if (lvl != null && lvl.intValue() != Level.OFF.intValue()) {
            this.stoppedLevel = lvl;
            this.getLogHandler().setLevel(Level.OFF);
            this.uiRefreshLevel();
        }
    }

    public void uiRefreshLevel() {
        try {
            this.uiRefreshLevelCall = true;
            Level lvl = this.getLogHandler().getLevel();
            this.uiWriteLevel(this.levelComboBox, lvl);
        }
        finally {
            this.uiRefreshLevelCall = false;
        }
    }

    public void updateLevel() {
        Level lvl = this.readLevel(this.levelComboBox);
        Object sel = this.levelComboBox.getSelectedItem();
        if (sel == null || lvl == null) {
            return;
        }
        Level clvl = this.getLogHandler().getLevel();
        if (clvl == null || clvl.intValue() != lvl.intValue()) {
            this.getLogHandler().setLevel(lvl);
        }
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public JToggleButton getScrollToggleButton() {
        return this.scrollToggleButton;
    }

    public JCheckBox getLimitCheckBox() {
        return this.limitCheckBox;
    }

    public ValidatedTextField getLimitTextField() {
        return this.limitFTextField;
    }

    public LogTable getLogTable() {
        return this.logTable;
    }

    public JTable getFiltersTable() {
        return this.filtersTable;
    }

    public JTable getSourcesTable() {
        return this.sourcesTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeTableNodeRender getPropertyRender() {
        if (this.propertyRender != null) {
            return this.propertyRender;
        }
        LogHandlerPanel logHandlerPanel = this;
        synchronized (logHandlerPanel) {
            if (this.propertyRender != null) {
                return this.propertyRender;
            }
            this.propertyRender = new TreeTableNodeRender();
            return this.propertyRender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeTableNodeValueEditor getPropertyEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor;
        }
        LogHandlerPanel logHandlerPanel = this;
        synchronized (logHandlerPanel) {
            if (this.propertyEditor != null) {
                return this.propertyEditor;
            }
            this.propertyEditor = new TreeTableNodeValueEditorDef();
            return this.propertyEditor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncEventSet<LogSource> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        LogHandlerPanel logHandlerPanel = this;
        synchronized (logHandlerPanel) {
            if (this.sources != null) {
                return this.sources;
            }
            this.sources = new SyncEventSet(this.handlerSync);
            this.sources.onAdded((Reciver)new Reciver<LogSource>(){

                public void recive(LogSource ls) {
                    if (ls != null) {
                        ls.setHandler(LogHandlerPanel.this.getLogHandler());
                    }
                }
            });
            this.sources.onRemoved((Reciver)new Reciver<LogSource>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void recive(LogSource ls) {
                    if (ls != null) {
                        LogSource logSource = ls;
                        synchronized (logSource) {
                            if (ls.isListen()) {
                                ls.stop();
                            }
                            ls.setHandler(null);
                        }
                    }
                }
            });
            return this.sources;
        }
    }

    public CachedTM<LogSource> getSourcesCacheTM() {
        if (this.sourcesCacheTM != null) {
            return this.sourcesCacheTM;
        }
        this.sourcesCacheTM = new CachedTM();
        PropertyColumn lgrName = new PropertyColumn("loggerName");
        lgrName.addValueFormat(String.class, new Func1<TreeTableNodeFormat, String>(){

            public TreeTableNodeFormat apply(String lgrName) {
                if (lgrName == null) {
                    return null;
                }
                if (lgrName instanceof String && lgrName.equalsIgnoreCase("")) {
                    return LogHandlerPanel.this.rootLoggerFormat;
                }
                return null;
            }
        });
        this.sourcesCacheTM.getColumns().add(lgrName);
        PropertyColumn lgrLevel = new PropertyColumn("loggerLevel");
        this.sourcesCacheTM.getColumns().add(lgrLevel);
        PropertyColumn lgrListen = new PropertyColumn("listen");
        this.sourcesCacheTM.getColumns().add(lgrListen);
        this.sourcesCacheTM.setSource((Iterable<LogSource>)this.getSources());
        this.sourcesCacheTM.fetch();
        return this.sourcesCacheTM;
    }

    public void initSourcesTable() {
        this.sourcesTable.setDefaultRenderer(PropertyValue.class, this.getPropertyRender());
        this.sourcesTable.setDefaultEditor(PropertyValue.class, this.getPropertyEditor());
        this.sourcesTable.setModel(this.getSourcesCacheTM());
        this.initLevelComboBox(this.addSourceLevelComboBox);
        SwingListener.onActionPerformed(this.addSourceButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.addSource();
            }
        });
        SwingListener.onActionPerformed(this.deleteSourcesButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.deleteSources();
            }
        });
    }

    protected void addSource() {
        String loggerName = this.addSourceTextField.getText();
        Level lvl = this.readLevel(this.addSourceLevelComboBox);
        if (loggerName == null) {
            return;
        }
        LoggerLevel llvl = LoggerLevel.level(lvl);
        this.getSources().add((Object)new LogSource(loggerName, llvl));
    }

    public LogHandlerPanel addSource(String loggerName, LoggerLevel level, boolean start) {
        if (loggerName == null) {
            throw new IllegalArgumentException("loggerName");
        }
        LogSource ls = new LogSource(loggerName, level);
        ls.setHandler(this.getLogHandler());
        this.getSources().add((Object)ls);
        if (start) {
            ls.start();
        }
        return this;
    }

    public LogHandlerPanel addSource(String loggerName) {
        if (loggerName == null) {
            throw new IllegalArgumentException("loggerName");
        }
        return this.addSource(loggerName, LoggerLevel.UNDEFINED, false);
    }

    protected void deleteSources() {
        for (int selrow : this.sourcesTable.getSelectedRows()) {
            Object itm = this.getSourcesCacheTM().getItemByIndex(selrow);
            if (!(itm instanceof LogSource)) continue;
            this.getSources().remove((Object)((LogSource)itm));
        }
        this.getSourcesCacheTM().fetch();
    }

    public ChainFilters getFilters() {
        return this.filters;
    }

    protected CachedTM<ChainElement> getFiltersCacheTM() {
        if (this.filtersCacheTM != null) {
            return this.filtersCacheTM;
        }
        this.filtersCacheTM = new CachedTM();
        this.filtersCacheTM.setSource(this.filtersElements);
        PropertyColumn lgrNameCol = new PropertyColumn("loggerName");
        this.filtersCacheTM.getColumns().add(lgrNameCol);
        PropertyColumn messageCol = new PropertyColumn("message");
        this.filtersCacheTM.getColumns().add(messageCol);
        PropertyColumn actionCol = new PropertyColumn("action");
        this.filtersCacheTM.getColumns().add(actionCol);
        PropertyColumn enabledCol = new PropertyColumn("enabled");
        this.filtersCacheTM.getColumns().add(enabledCol);
        return this.filtersCacheTM;
    }

    protected void initFiltersTable() {
        this.filtersTable.setDefaultEditor(PropertyValue.class, this.getPropertyEditor());
        this.filtersTable.setDefaultRenderer(PropertyValue.class, this.getPropertyRender());
        this.filtersTable.setModel(this.getFiltersCacheTM());
        if (ChainAction.Include.equals((Object)this.filters.getDefaultAction())) {
            this.defIncActionRButton.setSelected(true);
        }
        if (ChainAction.Exclude.equals((Object)this.filters.getDefaultAction())) {
            this.defExcActionRButton.setSelected(true);
        }
        final Runnable updatePolicy = new Runnable(){

            @Override
            public void run() {
                if (LogHandlerPanel.this.defIncActionRButton.isSelected()) {
                    LogHandlerPanel.this.filters.setDefaultAction(ChainAction.Include);
                }
                if (LogHandlerPanel.this.defExcActionRButton.isSelected()) {
                    LogHandlerPanel.this.filters.setDefaultAction(ChainAction.Exclude);
                }
            }
        };
        Reciver<ActionEvent> rUpdatePolicy = new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                updatePolicy.run();
            }
        };
        SwingListener.onActionPerformed(this.defIncActionRButton, rUpdatePolicy);
        SwingListener.onActionPerformed(this.defExcActionRButton, rUpdatePolicy);
        SwingListener.onActionPerformed(this.addFilterButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.addFilter();
            }
        });
        SwingListener.onActionPerformed(this.removeFilterButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.removeSelectedFilters();
            }
        });
    }

    protected void addFilter() {
        String lgr = this.loggerNameTField.getText();
        String msg = this.messageTField.getText();
        ChainAction act = ChainAction.Exclude;
        if (this.includeRButton.isSelected()) {
            act = ChainAction.Include;
        }
        if (this.excludeRButton.isSelected()) {
            act = ChainAction.Exclude;
        }
        MaskFilter mf = new MaskFilter();
        mf.setAction(act);
        mf.setLoggerName(lgr);
        mf.setMessage(msg);
        this.filters.add(mf);
        this.getFiltersCacheTM().refresh();
    }

    protected void removeSelectedFilters() {
        for (int selrow : this.filtersTable.getSelectedRows()) {
            Object selitm = this.getFiltersCacheTM().getItemByIndex(selrow);
            if (!(selitm instanceof ChainElement)) continue;
            this.filters.remove((ChainElement)selitm);
        }
        this.getFiltersCacheTM().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfig getXmlConfig() {
        LogHandlerPanel logHandlerPanel = this;
        synchronized (logHandlerPanel) {
            if (this.xmlConfig != null) {
                return this.xmlConfig;
            }
            this.xmlConfig = new XmlConfig();
            return this.xmlConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlConfig(XmlConfig xc) {
        LogHandlerPanel logHandlerPanel = this;
        synchronized (logHandlerPanel) {
            this.xmlConfig = xc;
        }
    }

    private void initConfMenu() {
        this.confMenu = new JPopupMenu();
        this.confMenu.add(new BasicAction("export/import xml settings", new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.exportImportXmlConfig();
            }
        }));
        this.confMenu.add(new JSeparator());
        this.confMenu.add(new BasicAction("save xml settings", new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.saveSettings();
            }
        }));
        this.confMenu.add(new BasicAction("save xml settings as", new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.saveSettingsAs();
            }
        }));
        this.confMenu.add(new BasicAction("open xml settiongs", new Runnable(){

            @Override
            public void run() {
                LogHandlerPanel.this.openSettings();
            }
        }));
        SwingListener.onActionPerformed(this.confButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                LogHandlerPanel.this.confMenu.show(LogHandlerPanel.this.confButton, LogHandlerPanel.this.confButton.getWidth() / 2, LogHandlerPanel.this.confButton.getHeight() / 2);
            }
        });
    }

    public void exportImportXmlConfig() {
        XmlConfigFrame xcframe = new XmlConfigFrame();
        xcframe.setXmlConfig(this.getXmlConfig());
        xcframe.setLogHandlerPanel(this);
        xcframe.setLocationRelativeTo(this);
        xcframe.setVisible(true);
    }

    public void openSettings() {
        File curd;
        JFileChooser fc = new JFileChooser();
        File curf = this.settingsFile;
        File file = curd = curf != null ? curf.getParentFile() : null;
        if (curd != null) {
            fc.setCurrentDirectory(curd);
        }
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("load settings");
        fc.setMultiSelectionEnabled(false);
        int r = fc.showOpenDialog(this);
        if (r == 0) {
            this.openSettings(fc.getSelectedFile());
        }
    }

    public void openSettings(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        XmlConfig cfg = this.getXmlConfig();
        try {
            cfg.read(this, file);
        }
        catch (IOException | XMLStreamException err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), err.getClass().getSimpleName(), 0);
        }
    }

    public void saveSettings() {
        if (this.settingsFile != null) {
            this.saveSettings(this.settingsFile);
        } else {
            this.saveSettingsAs();
        }
    }

    public void saveSettingsAs() {
        File curd;
        JFileChooser fc = new JFileChooser();
        File curf = this.settingsFile;
        File file = curd = curf != null ? curf.getParentFile() : null;
        if (curd != null) {
            fc.setCurrentDirectory(curd);
        }
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("save settings");
        int r = fc.showSaveDialog(this);
        if (r == 0) {
            this.saveSettings(fc.getSelectedFile());
        }
    }

    public void saveSettings(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        try {
            XmlConfig cfg = this.getXmlConfig();
            cfg.write(file, this);
            this.settingsFile = file;
        }
        catch (Throwable err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), err.getClass().getSimpleName(), 0);
        }
    }

    private void initComponents() {
        this.addFilterButtonGroup = new ButtonGroup();
        this.defFilterButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.clearButton = new JButton();
        this.scrollSeparator = new JToolBar.Separator();
        this.scrollToggleButton = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.limitCheckBox = new JCheckBox();
        this.limitFTextField = new ValidatedTextField();
        this.jSeparator1 = new JToolBar.Separator();
        this.jPanel2 = new JPanel();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.levelComboBox = new JComboBox();
        this.jSeparator2 = new JToolBar.Separator();
        this.confButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.logScrollPane = new JScrollPane();
        this.logTable = new LogTable();
        this.filtersPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.filtersTable = new JTable();
        this.editFilterPanel = new JPanel();
        this.loggerNameTField = new ValidatedTextField();
        this.messageTField = new ValidatedTextField();
        this.addFilterButton = new JButton();
        this.removeFilterButton = new JButton();
        this.includeRButton = new JRadioButton();
        this.excludeRButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.defIncActionRButton = new JRadioButton();
        this.defExcActionRButton = new JRadioButton();
        this.sourcesPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesTable = new JTable();
        this.jPanel4 = new JPanel();
        this.addSourceLevelComboBox = new JComboBox();
        this.addSourceButton = new JButton();
        this.deleteSourcesButton = new JButton();
        this.addSourceTextField = new ValidatedTextField();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/xyz/cofe/gui/swing/ico/trash/user-trash-24.png")));
        this.clearButton.setText("clear");
        this.clearButton.setToolTipText("clear messages");
        this.clearButton.setFocusable(false);
        this.clearButton.setHorizontalTextPosition(0);
        this.clearButton.setVerticalTextPosition(3);
        this.toolBar.add(this.clearButton);
        this.toolBar.add(this.scrollSeparator);
        this.scrollToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/xyz/cofe/gui/swing/ico/autoscroll/autoscroll-24.png")));
        this.scrollToggleButton.setText("scroll");
        this.scrollToggleButton.setToolTipText("auto scroll");
        this.scrollToggleButton.setFocusable(false);
        this.scrollToggleButton.setHorizontalTextPosition(0);
        this.scrollToggleButton.setVerticalTextPosition(3);
        this.toolBar.add(this.scrollToggleButton);
        this.jPanel1.setLayout(new BorderLayout());
        this.limitCheckBox.setText("limit");
        this.jPanel1.add((Component)this.limitCheckBox, "First");
        this.limitFTextField.setPlaceholder("1000");
        this.limitFTextField.setPreferredSize(new Dimension(75, 27));
        this.jPanel1.add((Component)this.limitFTextField, "Center");
        this.toolBar.add(this.jPanel1);
        this.toolBar.add(this.jSeparator1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.startButton.setIcon(new ImageIcon(this.getClass().getResource("/xyz/cofe/gui/swing/ico/start/start-icon-16x16.png")));
        this.startButton.setToolTipText("start");
        this.startButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.startButton.setBorderPainted(false);
        this.startButton.setContentAreaFilled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.startButton, gridBagConstraints);
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/xyz/cofe/gui/swing/ico/stop/stop-icon-16.png")));
        this.stopButton.setToolTipText("stop");
        this.stopButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.stopButton.setContentAreaFilled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.stopButton, gridBagConstraints);
        this.levelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add(this.levelComboBox, gridBagConstraints);
        this.toolBar.add(this.jPanel2);
        this.toolBar.add(this.jSeparator2);
        this.confButton.setIcon(new ImageIcon(this.getClass().getResource("/xyz/cofe/gui/swing/ico/settings/settings-32.png")));
        this.confButton.setToolTipText("settings");
        this.confButton.setFocusable(false);
        this.confButton.setHorizontalTextPosition(0);
        this.confButton.setVerticalTextPosition(3);
        this.toolBar.add(this.confButton);
        this.add((Component)this.toolBar, "First");
        this.jTabbedPane1.setTabPlacement(3);
        this.logScrollPane.setViewportView(this.logTable);
        this.jTabbedPane1.addTab("messages", this.logScrollPane);
        this.filtersPanel.setLayout(new BorderLayout());
        this.filtersTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.filtersTable);
        this.filtersPanel.add((Component)this.jScrollPane2, "Center");
        this.editFilterPanel.setLayout(new GridBagLayout());
        this.loggerNameTField.setPlaceholder("logger name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editFilterPanel.add((Component)this.loggerNameTField, gridBagConstraints);
        this.messageTField.setPlaceholder("message text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editFilterPanel.add((Component)this.messageTField, gridBagConstraints);
        this.addFilterButton.setText("Add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.editFilterPanel.add((Component)this.addFilterButton, gridBagConstraints);
        this.removeFilterButton.setText("Del");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.editFilterPanel.add((Component)this.removeFilterButton, gridBagConstraints);
        this.addFilterButtonGroup.add(this.includeRButton);
        this.includeRButton.setText("include");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.editFilterPanel.add((Component)this.includeRButton, gridBagConstraints);
        this.addFilterButtonGroup.add(this.excludeRButton);
        this.excludeRButton.setSelected(true);
        this.excludeRButton.setText("exclude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.editFilterPanel.add((Component)this.excludeRButton, gridBagConstraints);
        this.jLabel1.setText("Default policy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.editFilterPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.defFilterButtonGroup.add(this.defIncActionRButton);
        this.defIncActionRButton.setSelected(true);
        this.defIncActionRButton.setText("Include");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.editFilterPanel.add((Component)this.defIncActionRButton, gridBagConstraints);
        this.defFilterButtonGroup.add(this.defExcActionRButton);
        this.defExcActionRButton.setText("Exclude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.editFilterPanel.add((Component)this.defExcActionRButton, gridBagConstraints);
        this.filtersPanel.add((Component)this.editFilterPanel, "Last");
        this.jTabbedPane1.addTab("filters", this.filtersPanel);
        this.sourcesPanel.setLayout(new BorderLayout());
        this.sourcesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.sourcesTable);
        this.sourcesPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.setLayout(new GridBagLayout());
        this.addSourceLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add(this.addSourceLevelComboBox, gridBagConstraints);
        this.addSourceButton.setText("add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.addSourceButton, gridBagConstraints);
        this.deleteSourcesButton.setText("delete");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.jPanel4.add((Component)this.deleteSourcesButton, gridBagConstraints);
        this.addSourceTextField.setPlaceholder("logger name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.addSourceTextField, gridBagConstraints);
        this.sourcesPanel.add((Component)this.jPanel4, "Last");
        this.jTabbedPane1.addTab("sources", this.sourcesPanel);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    public static class Configure {
        protected final LogHandlerPanel panel;

        public Configure(LogHandlerPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException("panel == null");
            }
            this.panel = panel;
        }

        public ConfigureSources sources() {
            return new ConfigureSources(this.panel);
        }

        public ConfigureFilters filters() {
            return new ConfigureFilters(this.panel);
        }

        public Configure start(LoggerLevel level) {
            if (level != null) {
                this.panel.getLogHandler().setLevel(level.level());
                this.panel.uiRefreshLevel();
            }
            return this;
        }

        public Configure start() {
            this.panel.start();
            return this;
        }

        public Configure stop() {
            return this;
        }
    }

    public static class ConfigureFilters {
        protected final LogHandlerPanel panel;

        public ConfigureFilters(LogHandlerPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException("panel == null");
            }
            this.panel = panel;
        }

        public ConfigureFilters clear() {
            this.panel.getFilters().clear();
            return this;
        }

        public ConfigureFilters policy(ChainAction act) {
            if (act == null) {
                throw new IllegalArgumentException("act == null");
            }
            this.panel.getFilters().setDefaultAction(act);
            return this;
        }

        public ConfigureFilters exclude(String loggerMaskMask, String messageMask) {
            MaskFilter mf = new MaskFilter();
            mf.setAction(ChainAction.Exclude);
            mf.setEnabled(true);
            mf.setLoggerName(loggerMaskMask);
            mf.setMessage(messageMask);
            this.panel.getFilters().add(mf);
            return this;
        }

        public ConfigureFilters include(String loggerMaskMask, String messageMask) {
            MaskFilter mf = new MaskFilter();
            mf.setAction(ChainAction.Include);
            mf.setEnabled(true);
            mf.setLoggerName(loggerMaskMask);
            mf.setMessage(messageMask);
            this.panel.getFilters().add(mf);
            return this;
        }

        public Configure conf() {
            return new Configure(this.panel);
        }
    }

    public static class ConfigureSources {
        protected final LogHandlerPanel panel;

        public ConfigureSources(LogHandlerPanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException("panel == null");
            }
            this.panel = panel;
        }

        public ConfigureSources clear() {
            this.panel.getSources().clear();
            return this;
        }

        public ConfigureSources add(String loggerName) {
            if (loggerName == null) {
                throw new IllegalArgumentException("loggerName == null");
            }
            this.panel.getSources().add((Object)new LogSource(loggerName, LoggerLevel.UNDEFINED));
            return this;
        }

        public ConfigureSources add(String loggerName, LoggerLevel lvl) {
            if (loggerName == null) {
                throw new IllegalArgumentException("loggerName == null");
            }
            this.panel.getSources().add((Object)new LogSource(loggerName, lvl));
            return this;
        }

        public ConfigureSources add(String loggerName, LoggerLevel lvl, boolean start) {
            if (loggerName == null) {
                throw new IllegalArgumentException("loggerName == null");
            }
            LogSource ls = new LogSource(loggerName, lvl);
            this.panel.getSources().add((Object)ls);
            if (start) {
                ls.start();
            }
            return this;
        }

        public ConfigureSources add(String loggerName, boolean start) {
            if (loggerName == null) {
                throw new IllegalArgumentException("loggerName == null");
            }
            LogSource ls = new LogSource(loggerName, LoggerLevel.UNDEFINED);
            this.panel.getSources().add((Object)ls);
            if (start) {
                ls.start();
            }
            return this;
        }

        public Configure listen(LoggerLevel lvl, String ... loggers) {
            for (String lgr : loggers) {
                this.add(lgr, lvl, true);
            }
            return new Configure(this.panel);
        }

        public Configure listen(String ... loggers) {
            for (String lgr : loggers) {
                this.add(lgr, true);
            }
            return new Configure(this.panel);
        }

        public Configure conf() {
            return new Configure(this.panel);
        }
    }
}

