/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func1;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.tree.FormattedValue;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;

public class LogRecordColumn
extends Column {
    private static final Logger logger = Logger.getLogger(LogRecordColumn.class.getName());
    private static final float bgBright = 0.0f;
    private static final float bgSat = 0.5f;
    private static final TreeTableNodeFormatBasic severeFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.0f).saturation(0.5f));
    private static final TreeTableNodeFormatBasic warningFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.083333336f).sate(0.5f));
    private static final TreeTableNodeFormatBasic infoFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.25f).sate(0.5f));
    private static final TreeTableNodeFormatBasic fineFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.5555556f).sate(0.5f));
    private static final TreeTableNodeFormatBasic finerFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.625f).sate(0.5f));
    private static final TreeTableNodeFormatBasic finestFmt = new TreeTableNodeFormatBasic().base(new ColorModificator().brighter(0.0f).hue(0.6666667f).sate(0.5f));
    public static final LogRecordColumn levelNameColumn = new LogRecordColumn().name("levelName").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            Level lvl;
            if (from instanceof LogRecord && (lvl = ((LogRecord)from).getLevel()) != null) {
                TreeTableNodeFormatBasic fmt = null;
                int ilvl = lvl.intValue();
                if (ilvl >= Level.SEVERE.intValue()) {
                    fmt = severeFmt;
                } else if (ilvl >= Level.WARNING.intValue()) {
                    fmt = warningFmt;
                } else if (ilvl >= Level.INFO.intValue()) {
                    fmt = infoFmt;
                } else if (ilvl >= Level.FINE.intValue()) {
                    fmt = fineFmt;
                } else if (ilvl < Level.FINE.intValue()) {
                    fmt = finerFmt;
                }
                FormattedValue fv = new FormattedValue(lvl.getName(), fmt);
                return fv;
            }
            return null;
        }
    });
    public static final LogRecordColumn levelValueColumn = new LogRecordColumn().name("levelValue").type(Integer.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            Level lvl;
            if (from instanceof LogRecord && (lvl = ((LogRecord)from).getLevel()) != null) {
                return lvl.intValue();
            }
            return null;
        }
    });
    public static final LogRecordColumn loggerNameColumn = new LogRecordColumn().name("loggerName").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                return ((LogRecord)from).getLoggerName();
            }
            return null;
        }
    });
    public static final LogRecordColumn rawMessageColumn = new LogRecordColumn().name("rawMessage").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                return ((LogRecord)from).getMessage();
            }
            return null;
        }
    });
    public static final LogRecordColumn messageColumn = new LogRecordColumn().name("message").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return LogRecordColumn.formatMessage(lr);
            }
            return null;
        }
    });
    public static final LogRecordColumn millisColumn = new LogRecordColumn().name("millis").type(Long.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return lr.getMillis();
            }
            return null;
        }
    });
    public static LogRecordColumn dateColumn = LogRecordColumn.dateColumn("date", new SimpleDateFormat("yyyy-MM-dd"));
    public static LogRecordColumn timeColumn = LogRecordColumn.dateColumn("time", new SimpleDateFormat("HH:mm:ss"));
    public static final LogRecordColumn sequenceNumberColumn = new LogRecordColumn().name("scn").type(Long.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return lr.getSequenceNumber();
            }
            return null;
        }
    });
    public static final LogRecordColumn threadIdColumn = new LogRecordColumn().name("threadId").type(Integer.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return lr.getThreadID();
            }
            return null;
        }
    });
    public static final LogRecordColumn sourceClassColumn = new LogRecordColumn().name("sourceClass").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return lr.getSourceClassName();
            }
            return null;
        }
    });
    public static final LogRecordColumn sourceMethodColumn = new LogRecordColumn().name("sourceMethod").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                return lr.getSourceMethodName();
            }
            return null;
        }
    });
    public static final LogRecordColumn errorClassColumn = new LogRecordColumn().name("errorClass").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                Throwable err = lr.getThrown();
                return err != null ? err.getClass().getName() : null;
            }
            return null;
        }
    });
    public static final LogRecordColumn errorMessageColumn = new LogRecordColumn().name("errorMessage").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                Throwable err = lr.getThrown();
                return err != null ? err.getMessage() : null;
            }
            return null;
        }
    });
    public static final LogRecordColumn errorLocalizedMessageColumn = new LogRecordColumn().name("errorLocalizedMessage").type(String.class).reader((Convertor)new Convertor<Object, Object>(){

        public Object convert(Object from) {
            if (from instanceof LogRecord) {
                LogRecord lr = (LogRecord)from;
                Throwable err = lr.getThrown();
                return err != null ? err.getLocalizedMessage() : null;
            }
            return null;
        }
    });

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LogRecordColumn.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LogRecordColumn.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LogRecordColumn.class.getName(), method, result);
    }

    public LogRecordColumn() {
    }

    public LogRecordColumn(LogRecordColumn column) {
        super(column);
    }

    public LogRecordColumn(Object sync, LogRecordColumn src) {
        super(sync, src);
    }

    @Override
    public LogRecordColumn type(Class type) {
        super.type(type);
        return this;
    }

    @Override
    public LogRecordColumn writer(Convertor<Column.Cell, Boolean> writer) {
        super.writer(writer);
        return this;
    }

    @Override
    public LogRecordColumn rowReader(Func1<Convertor<Object, Object>, Integer> rowReader) {
        super.rowReader(rowReader);
        return this;
    }

    @Override
    public LogRecordColumn reader(Convertor<Object, Object> reader) {
        super.reader(reader);
        return this;
    }

    @Override
    public LogRecordColumn name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public LogRecordColumn clone() {
        return new LogRecordColumn(this);
    }

    @Override
    public LogRecordColumn cloneWith(Object sync) {
        return new LogRecordColumn(sync, this);
    }

    public static String formatMessage(LogRecord lr) {
        if (lr == null) {
            return null;
        }
        String msg = lr.getMessage();
        if (msg == null) {
            return null;
        }
        Object[] params = lr.getParameters();
        if (params == null || params.length < 1) {
            return msg;
        }
        for (int pi = 0; pi < params.length; ++pi) {
            Object param = params[pi];
            String str = param == null ? "null" : param.toString();
            String fnd = "{" + pi + "}";
            msg = msg.replace(fnd, str);
        }
        return msg;
    }

    public static LogRecordColumn dateColumn(String name, final DateFormat fmt) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (fmt == null) {
            throw new IllegalArgumentException("fmt==null");
        }
        return new LogRecordColumn().name(name).type(String.class).reader((Convertor)new Convertor<Object, Object>(){

            public Object convert(Object from) {
                if (from instanceof LogRecord) {
                    LogRecord lr = (LogRecord)from;
                    long t = lr.getMillis();
                    Date date = new Date(t);
                    return fmt.format(date);
                }
                return null;
            }
        });
    }
}

