/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.beans.PropertyChangeSupport;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.log.LoggerLevel;

public class LogSource
implements Comparable<LogSource> {
    private final PropertyChangeSupport psupport = new PropertyChangeSupport(this);
    private long scn = 0L;
    protected Logger logger;
    protected Handler handler;
    protected String loggerName;

    public LogSource() {
    }

    public LogSource(String loggerName, LoggerLevel level) {
        if (loggerName != null) {
            this.setLoggerName(loggerName);
        }
        if (level != null) {
            this.setLoggerLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this.isListen()) {
                this.stop();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScn() {
        LogSource logSource = this;
        synchronized (logSource) {
            return this.scn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger() {
        LogSource logSource = this;
        synchronized (logSource) {
            return this.logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLogger(Logger logger) {
        LogSource logSource = this;
        synchronized (logSource) {
            this.logger = logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler getHandler() {
        LogSource logSource = this;
        synchronized (logSource) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandler(Handler handler) {
        LogSource logSource = this;
        synchronized (logSource) {
            this.handler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListen() {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this.handler == null) {
                return false;
            }
            if (this.logger == null) {
                return false;
            }
            Handler[] hndlrs = this.logger.getHandlers();
            if (hndlrs == null || hndlrs.length < 1) {
                return false;
            }
            for (Handler hdlr : hndlrs) {
                if (!Objects.equals(hdlr, this.handler)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListen(boolean lstn) {
        LogSource logSource = this;
        synchronized (logSource) {
            if (lstn) {
                if (this.isListen()) {
                    return;
                }
                this.start();
            } else {
                if (!this.isListen()) {
                    return;
                }
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this.handler == null) {
                throw new IllegalStateException("handler == null");
            }
            if (this.logger == null) {
                throw new IllegalStateException("logger == null");
            }
            if (!this.isListen()) {
                this.logger.addHandler(this.handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this.handler == null) {
                throw new IllegalStateException("handler == null");
            }
            if (this.logger == null) {
                throw new IllegalStateException("logger == null");
            }
            if (this.isListen()) {
                this.logger.removeHandler(this.handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoggerName() {
        LogSource logSource = this;
        synchronized (logSource) {
            return this.loggerName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggerName(String loggerName) {
        String cur;
        String old;
        LogSource logSource = this;
        synchronized (logSource) {
            boolean isLstn = this.isListen();
            if (isLstn) {
                this.stop();
            }
            old = this.loggerName;
            cur = this.loggerName = loggerName;
            this.logger = loggerName != null ? Logger.getLogger(loggerName) : null;
            if (this.handler != null && this.logger != null && isLstn) {
                this.start();
            }
            ++this.scn;
        }
        this.psupport.firePropertyChange("loggerName", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerLevel getLoggerLevel() {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this.logger == null) {
                return LoggerLevel.UNDEFINED;
            }
            return LoggerLevel.level(this.logger.getLevel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiBean(forceNotNull=true)
    public void setLoggerLevel(LoggerLevel loggerLevel) {
        LoggerLevel old;
        LoggerLevel cur = null;
        boolean chng = false;
        LogSource logSource = this;
        synchronized (logSource) {
            old = this.getLoggerLevel();
            if (this.logger != null) {
                Level lvl;
                Level level = lvl = loggerLevel != null ? loggerLevel.level() : null;
                if (lvl != null) {
                    this.logger.setLevel(lvl);
                    cur = this.getLoggerLevel();
                    chng = true;
                }
            }
        }
        if (chng) {
            this.psupport.firePropertyChange("loggerName", (Object)old, (Object)cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        LogSource logSource = this;
        synchronized (logSource) {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.loggerName);
            return hash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        LogSource logSource = this;
        synchronized (logSource) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogSource other = (LogSource)obj;
            return Objects.equals(this.loggerName, other.loggerName);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(LogSource o) {
        if (o == null) {
            return -1;
        }
        LogSource logSource = this;
        synchronized (logSource) {
            int cmpLgrName;
            String lgrn = this.loggerName;
            String slgrn = o.loggerName;
            if (Objects.equals(lgrn, slgrn)) {
                return 0;
            }
            int n = lgrn == null && slgrn == null ? 0 : (lgrn != null && slgrn == null ? -1 : (cmpLgrName = lgrn == null && slgrn != null ? 1 : lgrn.compareTo(slgrn)));
            if (lgrn == null && slgrn == null) {
                return 0;
            }
            if (lgrn != null && slgrn == null) {
                return -1;
            }
            if (lgrn == null && slgrn != null) {
                return 1;
            }
            return cmpLgrName;
        }
    }
}

