/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.set.BasicEventSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.data.store.CSVDesc;
import xyz.cofe.data.store.CSVUtil;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.cell.TableCellContext;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.color.NColorModificator;
import xyz.cofe.gui.swing.log.LogRecordColumn;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.ListTM;
import xyz.cofe.gui.swing.table.Table;
import xyz.cofe.gui.swing.tree.FormattedValue;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.text.EndLine;
import xyz.cofe.typeconv.ExtendedCastGraph;

public class LogTable
extends Table {
    private static final Logger logger = Logger.getLogger(LogTable.class.getName());
    private TreeMap<Integer, Color> bgByLevelUpper;
    private List<NColorModificator> bgMod;
    private final TCRenderer renderer = new TCRenderer();
    private String[] avaliableColumnsNames;
    private Set<ManagedColumn> managedColumns;
    protected final ListTM<LogRecord> listTM;
    protected final IndexEventList<LogRecord> records;
    protected final Queue<LogRecord> queue;
    private final Object releaseSync = new Object();
    private long releaseStarted = 0L;
    private long releaseFinished = 0L;
    private long releaseCount = 0L;
    private long addTime = 0L;
    private long scn = 0L;
    private long requestScn = 0L;
    private long refreshStartScn = 0L;
    private long refreshEndScn = 0L;
    private final Runnable releaseQueue = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogRecord lr;
            Object object = LogTable.this.releaseSync;
            synchronized (object) {
                LogTable.this.releaseStarted = System.currentTimeMillis();
                LogTable.this.releaseCount = 0L;
                LogTable.this.refreshStartScn = LogTable.this.scn;
            }
            while ((lr = LogTable.this.queue.poll()) != null) {
                LogTable.this.records.add((Object)lr);
                Object object2 = LogTable.this.releaseSync;
                synchronized (object2) {
                    LogTable.this.releaseCount++;
                }
            }
            object = LogTable.this.releaseSync;
            synchronized (object) {
                LogTable.this.releaseFinished = System.currentTimeMillis();
                LogTable.this.refreshEndScn = LogTable.this.scn;
            }
        }
    };

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LogTable.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LogTable.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LogTable.class.getName(), method, result);
    }

    public LogTable() {
        this.records = new IndexEventList();
        this.queue = new LinkedBlockingQueue<LogRecord>();
        this.listTM = new ListTM();
        this.initModel();
        this.setDefaultRenderer(FormattedValue.class, this.renderer);
        this.setDefaultRenderer(PropertyValue.class, this.renderer);
        this.setDefaultRenderer(TreeTableNode.class, this.renderer);
        this.setDefaultRenderer(TreeTableNodeBasic.class, this.renderer);
        this.initColumnConf();
        this.initFormatting();
        this.initSelectMode();
        this.initClipboard();
    }

    private void initSelectMode() {
        this.getColumnModel().setColumnSelectionAllowed(true);
    }

    private void initClipboard() {
        SwingListener.onKeyPressed(this, new Reciver<KeyEvent>(){

            public void recive(KeyEvent ke) {
                if (!ke.isControlDown()) {
                    return;
                }
                if (ke.getKeyCode() == 67 || ke.getKeyCode() == 65485) {
                    LogTable.this.copy(ke);
                }
            }
        });
    }

    private void copy(KeyEvent ke) {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.length < 1) {
            return;
        }
        if (this.getColumnModel().getColumnSelectionAllowed()) {
            int[] selectedColumns = this.getColumnModel().getSelectedColumns();
            if (selectedColumns == null || selectedColumns.length < 1) {
                return;
            }
            if (this.copyCells(selectedRows, selectedColumns)) {
                ke.consume();
            }
        } else {
            int[] selectedColumns = new int[this.getColumnCount()];
            for (int ci = 0; ci < this.getColumnCount(); ++ci) {
                selectedColumns[ci] = ci;
            }
            if (this.copyCells(selectedRows, selectedColumns)) {
                ke.consume();
            }
        }
    }

    private boolean copyCells(int[] rows, int[] columns) {
        if (this.listTM == null) {
            return false;
        }
        if (columns.length < 1) {
            return false;
        }
        if (rows.length < 1) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX");
        ExtendedCastGraph tcast = new ExtendedCastGraph();
        CSVDesc csvDesc = new CSVDesc();
        csvDesc.setFixedWidth(false);
        csvDesc.setQuoteVariants(CSVDesc.QuoteVariants.Always);
        CSVUtil csvUtl = new CSVUtil();
        StringBuilder sb = new StringBuilder();
        int rcnt = 0;
        for (int row : rows) {
            if (++rcnt > 1) {
                sb.append(EndLine.Default.get());
            }
            String[] txtCells = new String[columns.length];
            int ci = -1;
            for (int col : columns) {
                ++ci;
                TableColumn tc = this.getColumnModel().getColumn(col);
                if (tc == null) {
                    txtCells[ci] = "";
                    continue;
                }
                int mi = tc.getModelIndex();
                Object val = this.listTM.getValueAt(row, mi);
                if (val instanceof FormattedValue) {
                    val = ((FormattedValue)val).getValue();
                }
                if (val == null) {
                    txtCells[ci] = "null";
                    continue;
                }
                if (val instanceof Date) {
                    txtCells[ci] = sdf.format((Date)val);
                    continue;
                }
                try {
                    String str = (String)tcast.cast(val, String.class);
                    if (str != null) {
                        txtCells[ci] = str;
                        continue;
                    }
                    txtCells[ci] = "null";
                }
                catch (Throwable err) {
                    LogTable.logException(err);
                    txtCells[ci] = val.toString();
                }
            }
            if (txtCells.length == 1) {
                sb.append(txtCells[0]);
                continue;
            }
            String line = csvUtl.toString(txtCells, csvDesc).trim();
            sb.append(line);
        }
        StringSelection stringSelection = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        return true;
    }

    private void initFormatting() {
        this.bgByLevelUpper = new TreeMap();
        this.bgByLevelUpper.put(Level.FINEST.intValue(), Color.white);
        this.bgByLevelUpper.put(Level.FINER.intValue(), new Color(Color.HSBtoRGB(0.5833334f, 0.2f, 1.0f)));
        this.bgByLevelUpper.put(Level.FINE.intValue(), new Color(Color.HSBtoRGB(0.2916667f, 0.2f, 1.0f)));
        this.bgByLevelUpper.put(Level.CONFIG.intValue(), new Color(Color.HSBtoRGB(0.20833334f, 0.2f, 1.0f)));
        this.bgByLevelUpper.put(Level.INFO.intValue(), new Color(Color.HSBtoRGB(0.16666667f, 0.2f, 1.0f)));
        this.bgByLevelUpper.put(Level.WARNING.intValue(), new Color(Color.HSBtoRGB(0.083333336f, 0.2f, 1.0f)));
        this.bgByLevelUpper.put(Level.SEVERE.intValue(), new Color(Color.HSBtoRGB(0.0f, 0.2f, 1.0f)));
        this.bgMod = new ArrayList<NColorModificator>();
        this.bgMod.add(new NColorModificator(1, 2, new ColorModificator().brighter(-0.15f)));
        this.renderer.getLabelRender().addFormatter(TableCellContext.class, new Func2<CellFormat, TableCellContext, CellFormat>(){

            public CellFormat apply(TableCellContext cx, CellFormat cf) {
                if (cf != null && cx != null) {
                    if (cx.isFocus() || cx.isSelected()) {
                        return cf;
                    }
                    int row = cx.getRow();
                    LogRecord orec = LogTable.this.listTM.getItemByIndex(row);
                    if (orec instanceof LogRecord) {
                        LogRecord lr = orec;
                        int lvl = lr.getLevel().intValue();
                        Map.Entry colEn = LogTable.this.bgByLevelUpper.floorEntry(lvl);
                        if (colEn != null) {
                            Color bg = (Color)colEn.getValue();
                            if (LogTable.this.bgMod != null && bg != null) {
                                for (NColorModificator ncMod : LogTable.this.bgMod) {
                                    int c = ncMod.getCycle();
                                    int p = ncMod.getPhase();
                                    if (c > 1 && row % c != p) continue;
                                    bg = ncMod.apply(bg);
                                }
                            }
                            if (bg != null) {
                                cf.bgColor(bg);
                            }
                        }
                    }
                }
                return cf;
            }
        });
    }

    private void initColumnConf() {
        final JTableHeader header = this.getTableHeader();
        if (header != null) {
            SwingListener.onMousePressed(header, new Reciver<MouseEvent>(){

                public void recive(MouseEvent me) {
                    if (me.getButton() != 3) {
                        return;
                    }
                    JPopupMenu popup = new JPopupMenu();
                    ArrayList<ManagedColumn> mcList = new ArrayList<ManagedColumn>();
                    for (final ManagedColumn mc : LogTable.this.getManagedColumns()) {
                        mcList.add(mc);
                    }
                    Collections.sort(mcList, new Comparator<ManagedColumn>(){

                        @Override
                        public int compare(ManagedColumn mc1, ManagedColumn mc2) {
                            return Objects.compare(mc1, mc2, new Comparator<ManagedColumn>(){

                                @Override
                                public int compare(ManagedColumn c1, ManagedColumn c2) {
                                    int di1 = c1.getDisplayIndex();
                                    int di2 = c2.getDisplayIndex();
                                    String n1 = c1.getName();
                                    String n2 = c2.getName();
                                    if (di1 != di2) {
                                        return di1 - di2;
                                    }
                                    return n1.compareTo(n2);
                                }
                            });
                        }
                    });
                    for (final ManagedColumn mc : mcList) {
                        JCheckBoxMenuItem cbMenuItm = new JCheckBoxMenuItem(mc.getName());
                        cbMenuItm.setSelected(mc.isVisible());
                        SwingListener.onActionPerformed(cbMenuItm, new Reciver<ActionEvent>(){

                            public void recive(ActionEvent obj) {
                                mc.setVisible(!mc.isVisible());
                            }
                        });
                        popup.add(cbMenuItm);
                    }
                    popup.show(header, me.getX(), me.getY());
                }
            });
        }
    }

    public String[] getAvaliableColumnNames() {
        if (this.avaliableColumnsNames != null) {
            return this.avaliableColumnsNames;
        }
        String[] colNames = new String[]{};
        Iterator iterator = this.listTM.getColumns().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            colNames = Arrays.copyOf(colNames, colNames.length + 1);
            colNames[colNames.length - 1] = col.getName();
        }
        this.avaliableColumnsNames = colNames;
        return colNames;
    }

    public int modelIndexOfColumn(String name) {
        if (name == null) {
            return -1;
        }
        String[] cols = this.getAvaliableColumnNames();
        for (int ci = 0; ci < cols.length; ++ci) {
            if (!name.equals(cols[ci])) continue;
            return ci;
        }
        return -1;
    }

    public TableColumn[] getTableColumns(String columnName) {
        if (columnName == null) {
            return new TableColumn[0];
        }
        int mi = this.modelIndexOfColumn(columnName);
        if (mi < 0) {
            return new TableColumn[0];
        }
        TableColumnModel tcm = this.getColumnModel();
        TableColumn[] res = new TableColumn[]{};
        for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            int m = tc.getModelIndex();
            if (m != mi) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = tc;
        }
        return res;
    }

    public boolean isColumnVisible(String columnName) {
        if (columnName == null) {
            return false;
        }
        return this.getTableColumns(columnName).length > 0;
    }

    public void setColumnVisible(String columnName, boolean visible) {
        int mi = this.modelIndexOfColumn(columnName);
        if (mi < 0) {
            return;
        }
        TableColumn[] tcs = this.getTableColumns(columnName);
        if (visible) {
            if (tcs.length > 0) {
                return;
            }
            TableColumn tc = this.createTableColumn(columnName);
            if (tc == null) {
                return;
            }
            this.getColumnModel().addColumn(tc);
        } else {
            for (TableColumn tc : tcs) {
                this.getColumnModel().removeColumn(tc);
            }
        }
    }

    public int getColumnDisplayIndex(String columnName) {
        if (columnName == null) {
            return -1;
        }
        int mi = this.modelIndexOfColumn(columnName);
        if (mi < 0) {
            return -1;
        }
        TableColumnModel tcm = this.getColumnModel();
        for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            int m = tc.getModelIndex();
            if (m != mi) continue;
            return ci;
        }
        return -1;
    }

    public void setColumnDisplayIndex(String columnName, int vi) {
        if (columnName == null) {
            return;
        }
        if (vi < 0) {
            this.setColumnVisible(columnName, false);
            return;
        }
        int mi = this.modelIndexOfColumn(columnName);
        if (mi < 0) {
            return;
        }
        TableColumnModel tcm = this.getColumnModel();
        LinkedHashMap<TableColumn, Integer> cols = new LinkedHashMap<TableColumn, Integer>();
        TableColumn firstColumn = null;
        for (int ci = 0; ci < tcm.getColumnCount(); ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            int m = tc.getModelIndex();
            if (m != mi) continue;
            cols.put(tc, ci);
            if (firstColumn != null) continue;
            firstColumn = tc;
        }
        if (firstColumn != null) {
            int idxFrom = (Integer)cols.get(firstColumn);
            this.getColumnModel().moveColumn(idxFrom, vi);
        } else {
            TableColumn tc = this.createTableColumn(columnName);
            this.getColumnModel().addColumn(tc);
            int cnt = this.getColumnModel().getColumnCount();
            if (vi < cnt - 1) {
                this.getColumnModel().moveColumn(cnt - 1, vi);
            }
        }
    }

    public int getColumnWidth(String columnName) {
        if (columnName == null) {
            return -1;
        }
        TableColumn[] tcs = this.getTableColumns(columnName);
        return tcs.length > 0 ? tcs[0].getWidth() : -1;
    }

    public void setColumnWidth(String columnName, int newWidth) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName");
        }
        if (newWidth < 1) {
            throw new IllegalArgumentException("neWidth < 1");
        }
        TableColumn[] tcs = this.getTableColumns(columnName);
        if (tcs.length < 1) {
            TableColumn tc = this.createTableColumn(columnName);
            if (tc == null) {
                throw new IllegalArgumentException("columnName(" + columnName + ") not exists");
            }
            tc.setPreferredWidth(newWidth);
            this.addColumn(tc);
            return;
        }
        tcs[0].setPreferredWidth(newWidth);
    }

    public TableColumn createTableColumn(String name) {
        int mi = this.modelIndexOfColumn(name);
        if (mi < 0) {
            return null;
        }
        TableColumn tc = new TableColumn(mi);
        tc.setIdentifier(name);
        tc.setHeaderValue(name);
        tc.setModelIndex(mi);
        tc.setPreferredWidth(50);
        tc.setCellRenderer(this.renderer);
        return tc;
    }

    public TableColumn createTableColumn(int mi) {
        if (mi < 0) {
            return null;
        }
        TableColumn tc = new TableColumn(mi);
        return tc;
    }

    public Set<ManagedColumn> getManagedColumns() {
        if (this.managedColumns != null) {
            return this.managedColumns;
        }
        this.managedColumns = new BasicEventSet();
        Iterator iterator = this.listTM.getColumns().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            if (!(col instanceof LogRecordColumn)) continue;
            this.managedColumns.add(new ManagedColumn((LogRecordColumn)col));
        }
        return this.managedColumns;
    }

    public ManagedColumn add(LogRecordColumn col) {
        if (col == null) {
            throw new IllegalArgumentException("col == null");
        }
        int mi = this.listTM.getColumns().indexOf(col);
        if (mi < 0) {
            this.listTM.getColumns().add(col);
            mi = this.listTM.getColumns().size() - 1;
            this.avaliableColumnsNames = null;
        }
        ManagedColumn ic = new ManagedColumn(col);
        return ic;
    }

    public ManagedColumn set(LogRecordColumn col) {
        if (col == null) {
            throw new IllegalArgumentException("col == null");
        }
        int mi = this.listTM.getColumns().indexOf(col);
        if (mi < 0) {
            this.listTM.getColumns().add(col);
            mi = this.listTM.getColumns().size() - 1;
            this.avaliableColumnsNames = null;
        }
        ManagedColumn ic = new ManagedColumn(col);
        return ic;
    }

    protected void initModel() {
        this.setAutoCreateColumnsFromModel(false);
        this.add(LogRecordColumn.sequenceNumberColumn);
        this.add(LogRecordColumn.levelNameColumn);
        this.add(LogRecordColumn.loggerNameColumn);
        this.add(LogRecordColumn.messageColumn);
        this.add(LogRecordColumn.dateColumn);
        this.add(LogRecordColumn.timeColumn);
        this.add(LogRecordColumn.errorClassColumn);
        this.add(LogRecordColumn.errorLocalizedMessageColumn);
        this.add(LogRecordColumn.errorMessageColumn);
        this.add(LogRecordColumn.levelValueColumn);
        this.add(LogRecordColumn.millisColumn);
        this.add(LogRecordColumn.rawMessageColumn);
        this.add(LogRecordColumn.sourceClassColumn);
        this.add(LogRecordColumn.sourceMethodColumn);
        this.add(LogRecordColumn.threadIdColumn);
        this.setModel(this.listTM);
        this.listTM.setList(this.records);
        this.set(LogRecordColumn.sequenceNumberColumn).visible();
        this.set(LogRecordColumn.levelNameColumn).visible();
        this.set(LogRecordColumn.loggerNameColumn).visible();
        this.set(LogRecordColumn.messageColumn).visible();
        this.listTM.getColumns().onChanged((Func3)new Func3<Object, Integer, Column, Column>(){

            public Object apply(Integer idx, Column old, Column cur) {
                if (old != null) {
                    LinkedHashSet<ManagedColumn> removeCols = new LinkedHashSet<ManagedColumn>();
                    for (ManagedColumn mc : LogTable.this.getManagedColumns()) {
                        LogRecordColumn lrc;
                        if (mc == null || (lrc = mc.getDataColumn()) != old) continue;
                        removeCols.add(mc);
                    }
                    LogTable.this.getManagedColumns().removeAll(removeCols);
                }
                if (cur != null && cur instanceof LogRecordColumn) {
                    LogTable.this.getManagedColumns().add(new ManagedColumn((LogRecordColumn)cur));
                }
                return null;
            }
        });
    }

    public IndexEventList<LogRecord> getRecords() {
        return this.records;
    }

    public Queue<LogRecord> getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LogRecord lr) {
        if (lr == null) {
            return;
        }
        int qs = this.queue.size();
        this.queue.add(lr);
        Object object = this.releaseSync;
        synchronized (object) {
            ++this.scn;
            if (qs == 0) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.releaseQueue.run();
                } else {
                    SwingUtilities.invokeLater(this.releaseQueue);
                }
            }
        }
    }

    public class ManagedColumn {
        private LogRecordColumn column;

        public ManagedColumn(LogRecordColumn lrc) {
            if (lrc == null) {
                throw new IllegalArgumentException("lrc==null");
            }
            this.column = lrc;
        }

        public LogRecordColumn getDataColumn() {
            return this.column;
        }

        public String getName() {
            return this.column.getName();
        }

        public ManagedColumn visible() {
            LogTable.this.setColumnVisible(this.column.getName(), true);
            return this;
        }

        public boolean isVisible() {
            return LogTable.this.isColumnVisible(this.column.getName());
        }

        public void setVisible(boolean visible) {
            LogTable.this.setColumnVisible(this.column.getName(), visible);
        }

        public int getDisplayIndex() {
            return LogTable.this.getColumnDisplayIndex(this.getName());
        }

        public void setDisplayIndex(int idx) {
            LogTable.this.setColumnDisplayIndex(this.getName(), idx);
        }

        public int getWidth() {
            return LogTable.this.getColumnWidth(this.getName());
        }

        public void setWidth(int w) {
            LogTable.this.setColumnWidth(this.getName(), w);
        }
    }
}

