/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import xyz.cofe.gui.swing.log.ChainAction;
import xyz.cofe.gui.swing.log.ChainElement;
import xyz.cofe.gui.swing.log.ChainFilters;
import xyz.cofe.gui.swing.log.LogRecordColumn;
import xyz.cofe.text.Text;

public class MaskFilter
implements ChainElement {
    private static final Logger logger = Logger.getLogger(MaskFilter.class.getName());
    private volatile ChainFilters filtersChain;
    private boolean enabled = true;
    private volatile String loggerName;
    private volatile Pattern loggerNamePattern;
    private volatile String message;
    private volatile Pattern messagePattern;
    private volatile ChainAction action = ChainAction.Include;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(MaskFilter.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(MaskFilter.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(MaskFilter.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainFilters getFiltersChain() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            return this.filtersChain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiltersChain(ChainFilters filtersChain) {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            this.filtersChain = filtersChain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean enabled) {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.filtersChain != null) {
                ChainFilters chainFilters = this.filtersChain;
                synchronized (chainFilters) {
                    this.enabled = enabled;
                }
            } else {
                this.enabled = enabled;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoggerName() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            return this.loggerName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggerName(String loggerName) {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.filtersChain != null) {
                ChainFilters chainFilters = this.filtersChain;
                synchronized (chainFilters) {
                    this.loggerName = loggerName;
                }
            } else {
                this.loggerName = loggerName;
            }
            this.loggerNamePattern = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getLoggerNamePattern() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.loggerNamePattern != null) {
                return this.loggerNamePattern;
            }
            if (this.loggerName == null) {
                return null;
            }
            this.loggerNamePattern = Text.wildcard((String)this.loggerName, (boolean)false, (boolean)true);
            return this.loggerNamePattern;
        }
    }

    private boolean matchLoggerName(LogRecord rec) {
        String lgrName = rec.getLoggerName();
        Pattern ptrn = this.getLoggerNamePattern();
        if (ptrn == null || lgrName == null) {
            return false;
        }
        return ptrn.matcher(lgrName).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            return this.message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String message) {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.filtersChain != null) {
                ChainFilters chainFilters = this.filtersChain;
                synchronized (chainFilters) {
                    this.message = message;
                }
            } else {
                this.message = message;
            }
            this.messagePattern = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getMessagePattern() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.messagePattern != null) {
                return this.messagePattern;
            }
            if (this.message == null) {
                return null;
            }
            this.messagePattern = Text.wildcard((String)this.message, (boolean)false, (boolean)true);
            return this.messagePattern;
        }
    }

    private boolean matchMessage(LogRecord rec) {
        String msg = rec.getMessage();
        if (msg == null) {
            return false;
        }
        msg = LogRecordColumn.formatMessage(rec);
        Pattern ptrn = this.getMessagePattern();
        if (ptrn == null || msg == null) {
            return false;
        }
        return ptrn.matcher(msg).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainAction getAction() {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            return this.action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAction(ChainAction action) {
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            if (this.filtersChain != null) {
                ChainFilters chainFilters = this.filtersChain;
                synchronized (chainFilters) {
                    this.action = action;
                }
            } else {
                this.action = action;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChainAction isLoggable(LogRecord rec) {
        if (rec == null) {
            return null;
        }
        MaskFilter maskFilter = this;
        synchronized (maskFilter) {
            boolean mtcMsg;
            boolean mtcLgr;
            boolean defMsg;
            boolean defLgr;
            int condCnt = 0;
            int mtchCnt = 0;
            boolean bl = defLgr = this.getLoggerNamePattern() != null;
            if (defLgr) {
                ++condCnt;
            }
            boolean bl2 = defMsg = this.getMessagePattern() != null;
            if (defMsg) {
                ++condCnt;
            }
            if (mtcLgr = this.matchLoggerName(rec)) {
                ++mtchCnt;
            }
            if (mtcMsg = this.matchMessage(rec)) {
                ++mtchCnt;
            }
            if (mtchCnt == condCnt && mtchCnt > 0) {
                return this.getAction();
            }
            return null;
        }
    }
}

