/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import xyz.cofe.gui.swing.log.ChainAction;
import xyz.cofe.gui.swing.log.ChainElement;
import xyz.cofe.gui.swing.log.ChainFilters;
import xyz.cofe.gui.swing.log.LogHandlerPanel;
import xyz.cofe.gui.swing.log.LogSource;
import xyz.cofe.gui.swing.log.LogTable;
import xyz.cofe.gui.swing.log.LoggerLevel;
import xyz.cofe.gui.swing.log.MaskFilter;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.stream.path.PathExpression;
import xyz.cofe.xml.stream.path.PathParser;
import xyz.cofe.xml.stream.path.XEventPath;
import xyz.cofe.xml.stream.path.XVisitor;
import xyz.cofe.xml.stream.path.XVisitorAdapter;
import xyz.cofe.xml.stream.path.XmlReader;

public class XmlConfig {
    private static final Logger logger = Logger.getLogger(XmlConfig.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private static final PathExpression sourcesExp;
    private static final PathExpression logSourceExp;
    private static final PathExpression filtersExp;
    private static final PathExpression maskFilterExp;
    private static final PathExpression columnsExp;
    private static final PathExpression columnExp;
    private Map<Integer, Set<LogTable.ManagedColumn>> columnsOrder = new TreeMap<Integer, Set<LogTable.ManagedColumn>>();
    private Map<LogTable.ManagedColumn, Integer> columnsWidth = new LinkedHashMap<LogTable.ManagedColumn, Integer>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(XmlConfig.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(XmlConfig.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(XmlConfig.class.getName(), method, result);
    }

    public void write(File out, LogHandlerPanel lp) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        try {
            FileOutputStream fo = new FileOutputStream(out);
            FormatXMLWriter fxw = new FormatXMLWriter((OutputStream)fo, "utf-8");
            this.write((XMLStreamWriter)fxw, lp);
            fxw.flush();
            fo.close();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XmlConfig.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XmlConfig.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public void write(OutputStream out, LogHandlerPanel lp) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        try {
            FormatXMLWriter fxw = new FormatXMLWriter(out, "utf-8");
            this.write((XMLStreamWriter)fxw, lp);
            fxw.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XmlConfig.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public void write(Writer out, LogHandlerPanel lp) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        try {
            FormatXMLWriter fxw = new FormatXMLWriter(out);
            this.write((XMLStreamWriter)fxw, lp);
            fxw.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XmlConfig.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public void write(XMLStreamWriter out, LogHandlerPanel lp) throws XMLStreamException {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        out.writeStartElement("logHandlerPanel");
        this.writeSources(out, lp);
        this.writeFilters(out, lp.getFilters());
        this.writeColumns(out, lp.getLogTable().getManagedColumns());
        out.writeEndElement();
    }

    public void readXml(LogHandlerPanel lp, String input) throws XMLStreamException {
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        new XmlReader(input, this.createXVisitor(lp));
    }

    public void readXml(LogHandlerPanel lp, Reader input) throws XMLStreamException {
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        new XmlReader(input, this.createXVisitor(lp));
    }

    public void read(LogHandlerPanel lp, File input) throws XMLStreamException, IOException {
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        new XmlReader(input, Charset.forName("utf-8"), this.createXVisitor(lp));
    }

    public void read(LogHandlerPanel lp, XMLStreamReader input) throws XMLStreamException {
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input == null");
        }
        new XmlReader(input, this.createXVisitor(lp));
    }

    private XVisitor createXVisitor(final LogHandlerPanel lp) {
        if (lp == null) {
            throw new IllegalArgumentException("lp == null");
        }
        XVisitorAdapter visitor = new XVisitorAdapter(){

            public void characters(XEventPath path, String text) {
            }

            public void exit(XEventPath path) {
                if (filtersExp.validate((Object)path)) {
                    lp.getFiltersCacheTM().refresh();
                } else if (sourcesExp.validate((Object)path)) {
                    lp.getSourcesCacheTM().refresh();
                } else if (columnsExp.validate((Object)path)) {
                    XmlConfig.this.readColumnsFinish();
                }
            }

            public void enter(XEventPath path) {
                if (sourcesExp.validate((Object)path)) {
                    XmlConfig.this.readLogSourcesStart(lp);
                } else if (logSourceExp.validate((Object)path)) {
                    XmlConfig.this.readLogSource(lp, path);
                } else if (filtersExp.validate((Object)path)) {
                    XmlConfig.this.readFiltersStart(lp, path);
                } else if (maskFilterExp.validate((Object)path)) {
                    XmlConfig.this.readMaskFilter(lp, path);
                } else if (columnExp.validate((Object)path)) {
                    XmlConfig.this.readColumnStart(lp, path);
                } else if (columnsExp.validate((Object)path)) {
                    XmlConfig.this.readColumnsStart();
                }
            }
        };
        return visitor;
    }

    private void write(XMLStreamWriter out, LogSource ls) throws XMLStreamException {
        boolean listen;
        LoggerLevel ll;
        out.writeStartElement("logSource");
        String lgrName = ls.getLoggerName();
        if (lgrName != null) {
            out.writeAttribute("loggerName", lgrName);
        }
        if ((ll = ls.getLoggerLevel()) != null) {
            out.writeAttribute("loggerLevel", ll.name());
        }
        out.writeAttribute("listen", (listen = ls.isListen()) ? "true" : "false");
        out.writeEndElement();
    }

    private void writeSources(XMLStreamWriter out, LogHandlerPanel lp) throws XMLStreamException {
        out.writeStartElement("sources");
        for (LogSource ls : lp.getSources()) {
            if (ls == null) continue;
            this.write(out, ls);
        }
        out.writeEndElement();
    }

    private void readLogSource(LogHandlerPanel lp, XEventPath xpath) {
        String lgrName = xpath.getAttributeValue("loggerName");
        String lgrLvl = xpath.getAttributeValue("loggerLevel");
        boolean listen = xpath.readAttributeAsBoolean("listen", Boolean.valueOf(false));
        LogSource ls = new LogSource();
        if (lgrName != null) {
            ls.setLoggerName(lgrName);
        }
        if (lgrLvl != null) {
            ls.setLoggerLevel(LoggerLevel.valueOf(lgrLvl));
        }
        lp.getSources().add((Object)ls);
        if (listen) {
            ls.start();
        }
    }

    private void readLogSourcesStart(LogHandlerPanel lp) {
        lp.getSources().clear();
    }

    private void writeMskFilter(XMLStreamWriter out, MaskFilter mf) throws XMLStreamException {
        boolean en;
        ChainAction ca;
        String msg;
        out.writeStartElement("maskFilter");
        String lgrName = mf.getLoggerName();
        if (lgrName != null) {
            out.writeAttribute("loggerName", lgrName);
        }
        if ((msg = mf.getMessage()) != null) {
            out.writeAttribute("message", lgrName);
        }
        if ((ca = mf.getAction()) != null) {
            out.writeAttribute("action", ca.name());
        }
        out.writeAttribute("enabled", (en = mf.isEnabled()) ? "true" : "false");
        out.writeEndElement();
    }

    private void readMaskFilter(LogHandlerPanel lp, XEventPath xpath) {
        String lgrName = xpath.getAttributeValue("loggerName");
        String message = xpath.getAttributeValue("message");
        String action = xpath.getAttributeValue("action");
        boolean enabled = xpath.readAttributeAsBoolean("enabled", Boolean.valueOf(true));
        MaskFilter mf = new MaskFilter();
        if (lgrName != null) {
            mf.setLoggerName(lgrName);
        }
        if (message != null) {
            mf.setMessage(message);
        }
        if (action != null) {
            mf.setAction(ChainAction.valueOf(action));
        }
        mf.setEnabled(enabled);
        lp.getFilters().add(mf);
    }

    private void writeFilters(XMLStreamWriter out, ChainFilters cf) throws XMLStreamException {
        out.writeStartElement("filters");
        ChainAction ca = cf.getDefaultAction();
        if (ca != null) {
            out.writeAttribute("defaultAction", ca.name());
        }
        for (ChainElement o : cf.array()) {
            if (!(o instanceof MaskFilter)) continue;
            this.writeMskFilter(out, (MaskFilter)o);
        }
        out.writeEndElement();
    }

    private void readFiltersStart(LogHandlerPanel lp, XEventPath xpath) {
        lp.getFilters().clear();
        String action = xpath.getAttributeValue("action");
        if (action != null) {
            lp.getFilters().setDefaultAction(ChainAction.valueOf(action));
        }
    }

    private void writeColumn(XMLStreamWriter out, LogTable.ManagedColumn mc) throws XMLStreamException {
        out.writeStartElement("column");
        out.writeAttribute("name", mc.getName());
        out.writeAttribute("displayIndex", Integer.toString(mc.getDisplayIndex()));
        out.writeAttribute("width", Integer.toString(mc.getWidth()));
        out.writeAttribute("visible", Boolean.toString(mc.isVisible()));
        out.writeEndElement();
    }

    private void writeColumns(XMLStreamWriter out, Iterable<LogTable.ManagedColumn> mcs) throws XMLStreamException {
        out.writeStartElement("columns");
        ArrayList<LogTable.ManagedColumn> mcList = new ArrayList<LogTable.ManagedColumn>();
        for (LogTable.ManagedColumn mc : mcs) {
            mcList.add(mc);
        }
        Collections.sort(mcList, new Comparator<LogTable.ManagedColumn>(){

            @Override
            public int compare(LogTable.ManagedColumn mc1, LogTable.ManagedColumn mc2) {
                return Objects.compare(mc1, mc2, new Comparator<LogTable.ManagedColumn>(){

                    @Override
                    public int compare(LogTable.ManagedColumn c1, LogTable.ManagedColumn c2) {
                        int di1 = c1.getDisplayIndex();
                        int di2 = c2.getDisplayIndex();
                        String n1 = c1.getName();
                        String n2 = c2.getName();
                        if (di1 != di2) {
                            return di1 - di2;
                        }
                        return n1.compareTo(n2);
                    }
                });
            }
        });
        for (LogTable.ManagedColumn mc : mcList) {
            if (mc == null) continue;
            this.writeColumn(out, mc);
        }
        out.writeEndElement();
    }

    private void readColumnStart(LogHandlerPanel lp, XEventPath xpath) {
        int di;
        Set<LogTable.ManagedColumn> scols;
        String name = xpath.getAttributeValue("name");
        if (name == null) {
            return;
        }
        LogTable.ManagedColumn mc = null;
        for (LogTable.ManagedColumn c : lp.getLogTable().getManagedColumns()) {
            if (c == null || c.getName() == null || !c.getName().equals(name)) continue;
            mc = c;
            break;
        }
        if (mc == null) {
            return;
        }
        boolean visible = xpath.readAttributeAsBoolean("visible", Boolean.valueOf(false));
        if (!visible) {
            return;
        }
        mc.setVisible(true);
        int width = xpath.readAttributeAsInteger("width", Integer.valueOf(-1));
        if (width >= 1) {
            this.columnsWidth.put(mc, width);
        }
        if ((scols = this.columnsOrder.get(di = xpath.readAttributeAsInteger("displayIndex", Integer.valueOf(-1)).intValue())) == null) {
            scols = new LinkedHashSet<LogTable.ManagedColumn>();
            this.columnsOrder.put(di, scols);
        }
        scols.add(mc);
    }

    private void readColumnsFinish() {
        int di = -1;
        for (Set<LogTable.ManagedColumn> mcset : this.columnsOrder.values()) {
            for (LogTable.ManagedColumn mc : mcset) {
                mc.setDisplayIndex(++di);
            }
        }
        for (LogTable.ManagedColumn mc : this.columnsWidth.keySet()) {
            mc.setWidth(this.columnsWidth.get(mc));
        }
    }

    private void readColumnsStart() {
        this.columnsOrder.clear();
        this.columnsWidth.clear();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        PathParser pp = new PathParser();
        sourcesExp = pp.parse("sources");
        logSourceExp = pp.parse("logSource");
        filtersExp = pp.parse("filters");
        maskFilterExp = pp.parse("maskFilter");
        columnsExp = pp.parse("columns");
        columnExp = pp.parse("column");
    }
}

