/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.log;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.log.LogHandlerPanel;
import xyz.cofe.gui.swing.log.XmlConfig;

public class XmlConfigFrame
extends JFrame {
    protected LogHandlerPanel logHandlerPanel;
    protected XmlConfig xmlConfig;
    private JButton exportButton;
    private JButton importButton;
    private JScrollPane jScrollPane1;
    private JTextPane xmlText;

    public XmlConfigFrame() {
        this.initComponents();
        SwingListener.onActionPerformed(this.exportButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                XmlConfigFrame.this.exportXml();
            }
        });
        SwingListener.onActionPerformed(this.importButton, new Reciver<ActionEvent>(){

            public void recive(ActionEvent obj) {
                XmlConfigFrame.this.importXml();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Log xml config");
    }

    public LogHandlerPanel getLogHandlerPanel() {
        return this.logHandlerPanel;
    }

    public void setLogHandlerPanel(LogHandlerPanel logHandlerPanel) {
        this.logHandlerPanel = logHandlerPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfig getXmlConfig() {
        XmlConfigFrame xmlConfigFrame = this;
        synchronized (xmlConfigFrame) {
            if (this.xmlConfig != null) {
                return this.xmlConfig;
            }
            this.xmlConfig = new XmlConfig();
            return this.xmlConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlConfig(XmlConfig xc) {
        XmlConfigFrame xmlConfigFrame = this;
        synchronized (xmlConfigFrame) {
            this.xmlConfig = xc;
        }
    }

    protected void exportXml() {
        LogHandlerPanel lhp = this.logHandlerPanel;
        if (lhp == null) {
            return;
        }
        XmlConfig xconf = this.getXmlConfig();
        StringWriter sw = new StringWriter();
        xconf.write(sw, lhp);
        this.xmlText.setText(sw.toString());
    }

    protected void importXml() {
        LogHandlerPanel lhp = this.logHandlerPanel;
        if (lhp == null) {
            return;
        }
        try {
            XmlConfig xconf = this.getXmlConfig();
            xconf.readXml(lhp, this.xmlText.getText());
        }
        catch (Throwable err) {
            JOptionPane.showMessageDialog(this, err.getMessage(), err.getClass().getName(), 0);
        }
    }

    private void initComponents() {
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.xmlText = new JTextPane();
        this.setDefaultCloseOperation(3);
        this.importButton.setText("import");
        this.exportButton.setText("export");
        this.xmlText.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane1.setViewportView(this.xmlText);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 252, Short.MAX_VALUE).addComponent(this.exportButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importButton).addComponent(this.exportButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 255, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(XmlConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(XmlConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(XmlConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(XmlConfigFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new XmlConfigFrame().setVisible(true);
            }
        });
    }
}

