/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.MenuScriptAction;
import xyz.cofe.gui.swing.menu.ObserverMenuPopup;
import xyz.cofe.gui.swing.menu.XmlMenuBuilder;

public class ContextMenuBuilder {
    private static final Logger logger = Logger.getLogger(ContextMenuBuilder.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Iterable<Action> actions;
    protected Predicate<Action> actionFilter;
    protected Iterable<MenuItem> menuItems;
    protected Predicate<MenuItem> menuFilter;
    protected Func1<MenuItem, Action> menuFromAction = new Func1<MenuItem, Action>(){

        public MenuItem apply(Action act) {
            String type;
            if (act == null) {
                return null;
            }
            MenuActionItem ma = new MenuActionItem(act);
            if (act instanceof MenuScriptAction && (type = XmlMenuBuilder.readAttrOrText(((MenuScriptAction)act).getMenuElement(), "type", "Default")) != null && MenuActionItem.Type.Checked.name().equalsIgnoreCase(type)) {
                ma.setType(MenuActionItem.Type.Checked);
            }
            return ma;
        }
    };

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Iterable<Action> getActions() {
        return this.actions;
    }

    public void setActions(Iterable<Action> actions) {
        this.actions = actions;
    }

    public ContextMenuBuilder actionsOf(MenuItem mi) {
        if (mi == null) {
            this.actions = null;
            return this;
        }
        this.actions = MenuItem.actionsOf(mi);
        return this;
    }

    public Predicate<Action> getActionFilter() {
        return this.actionFilter;
    }

    public void setActionFilter(Predicate<Action> actionFilter) {
        this.actionFilter = actionFilter;
    }

    public ContextMenuBuilder targets(Class ... targets) {
        if (targets == null || targets.length == 0) {
            this.actionFilter = null;
            return this;
        }
        this.actionFilter = BasicAction.Filter.targetAssignableFrom(targets);
        return this;
    }

    protected MenuItem menu() {
        Iterable<Action> acts;
        MenuContainer mc = new MenuContainer(){

            @Override
            protected void assignParentToChild(MenuItem child) {
            }
        };
        if (this.menuItems != null) {
            for (MenuItem mi : this.menuItems) {
                if (mi == null) continue;
                if (this.menuFilter != null && this.menuFilter.validate((Object)mi)) {
                    MenuItem.addChild(mc, mi);
                    continue;
                }
                MenuItem.addChild(mc, mi);
            }
        }
        if ((acts = this.actions) != null) {
            for (Action a : acts) {
                MenuItem mi;
                if (a == null || this.actionFilter != null && !this.actionFilter.validate((Object)a) || (mi = (MenuItem)this.menuFromAction.apply((Object)a)) == null) continue;
                MenuItem.addChild(mc, mi);
            }
        }
        return mc;
    }

    public ObserverMenuPopup popup(JComponent popupOwner) {
        ObserverMenuPopup popup = new ObserverMenuPopup();
        popup.setMenu(this.menu());
        if (popupOwner != null) {
            popupOwner.setComponentPopupMenu(popup);
        }
        return popup;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

