/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import javax.swing.Icon;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.menu.MenuEvent;
import xyz.cofe.gui.swing.menu.MenuItem;

public class MenuContainer
extends MenuItem {
    private Children children = null;
    protected SimpleListAdapter<MenuItem> adapter = new SimpleListAdapter<MenuItem>(){

        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            if (position == null) {
                throw new IllegalStateException("\u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0438\u043d\u0434\u0435\u043a\u0441 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043c\u0435\u043d\u044e");
            }
            MenuContainer.this.fireMenuEvent(new ItemRemovedEvent(MenuContainer.this, mi, position));
        }

        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuContainer.this.assignParentToChild(e);
            MenuContainer.this.fireMenuEvent(new ItemAddedEvent(MenuContainer.this, e));
        }
    };
    protected String text = null;
    protected Icon icon = null;

    public MenuContainer() {
    }

    public MenuContainer(String text) {
        this.setText(text);
    }

    public MenuContainer(MenuContainer parent, String text) {
        this.setText(text);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    public Children getChildren() {
        if (this.children == null) {
            this.children = new Children(this);
            this.children.addEventListListener((EventListListener)this.adapter);
        }
        return this.children;
    }

    protected void assignParentToChild(MenuItem child) {
        if (child != null) {
            child.setParent(this);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChanged("icon", old, this.icon);
        this.fireMenuEvent(new MenuItem.PropertyChangedEvent(this, this, "icon", old, this.icon));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String old = this.text;
        this.text = text;
        this.firePropertyChanged("text", old, this.text);
        this.fireMenuEvent(new MenuItem.PropertyChangedEvent(this, this, "text", old, this.text));
    }

    public static class Children
    extends IndexEventList<MenuItem> {
        private MenuContainer owner = null;

        public Children(MenuContainer owner) {
            if (owner == null) {
                throw new IllegalArgumentException("owner == null");
            }
            this.owner = owner;
        }

        public MenuContainer getOwner() {
            return this.owner;
        }
    }

    public static class ItemRemovedEvent
    extends MenuContainerEvent {
        private int position;

        public ItemRemovedEvent(MenuContainer parent, MenuItem item, int pos) {
            super(parent, item);
            this.position = pos;
        }

        public int getRemovedItemPosition() {
            return this.position;
        }
    }

    public static class ItemAddedEvent
    extends MenuContainerEvent {
        public ItemAddedEvent(MenuContainer parent, MenuItem item) {
            super(parent, item);
        }
    }

    public static class MenuContainerEvent
    extends MenuEvent {
        private MenuItem item = null;

        public MenuContainerEvent(MenuContainer parent, MenuItem item) {
            super(parent);
            this.item = item;
        }

        public MenuItem getMenuItem() {
            return this.item;
        }
    }
}

