/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuEvent;
import xyz.cofe.gui.swing.menu.MenuItemNodesExtracter;
import xyz.cofe.gui.swing.menu.MenuListener;

public abstract class MenuItem {
    private String id = null;
    private MenuContainer parent = null;
    protected Collection<MenuListener> menuListener = null;
    protected Collection<PropertyChangeListener> propertiesListeners = new HashSet<PropertyChangeListener>();
    private static Convertor<MenuItem, Action> convertMenuItemToAction = new Convertor<MenuItem, Action>(){

        public Action convert(MenuItem from) {
            if (from instanceof MenuActionItem) {
                MenuActionItem mai = (MenuActionItem)from;
                return mai.getAction();
            }
            return null;
        }
    };

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String old = this.id;
        this.id = id;
        this.firePropertyChanged("id", old, this.id);
        this.fireMenuEvent(new PropertyChangedEvent(this, "id", old, this.id));
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    public void setParent(MenuContainer parent) {
        MenuContainer old = this.parent;
        this.parent = parent;
        this.firePropertyChanged("parent", old, this.parent);
    }

    public List<MenuItem> getPath() {
        ArrayList<MenuItem> path = new ArrayList<MenuItem>();
        MenuItem mi = this;
        while (!path.contains(mi)) {
            if (path.size() > 0) {
                path.add(0, mi);
            } else {
                path.add(mi);
            }
            if ((mi = mi.getParent()) != null) continue;
            break;
        }
        return path;
    }

    public void addMenuListener(MenuListener listener) {
        if (listener == null) {
            return;
        }
        if (this.menuListener == null) {
            this.menuListener = new HashSet<MenuListener>();
        }
        this.menuListener.add(listener);
    }

    public void removeMenuListener(MenuListener listener) {
        if (this.menuListener == null) {
            return;
        }
        this.menuListener.remove(listener);
    }

    protected void fireMenuEvent(MenuEvent event) {
        if (event == null) {
            return;
        }
        if (this.menuListener != null) {
            for (MenuListener l : this.menuListener) {
                l.menuEvent(event);
            }
        }
        if (this.parent != null) {
            this.parent.fireMenuEvent(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.propertiesListeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertiesListeners.remove(l);
    }

    public Collection<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertiesListeners;
    }

    protected void firePropertyChanged(String name, Object old, Object _new) {
        for (Object o : this.propertiesListeners.toArray()) {
            if (!(o instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)o).propertyChange(new PropertyChangeEvent(this, name, old, _new));
        }
    }

    public static List<MenuItem> findMenuItemById(MenuItem root, String id) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id==null");
        }
        ArrayList<MenuItem> res = new ArrayList<MenuItem>();
        for (MenuItem mi : MenuItem.iterable(root)) {
            String mid;
            boolean eq;
            if (mi == null || !(eq = id.equals(mid = mi.getId()))) continue;
            res.add(mi);
        }
        return res;
    }

    public static MenuItem findById(MenuItem root, String id) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id==null");
        }
        List<MenuItem> lmi = MenuItem.findMenuItemById(root, id);
        if (lmi.size() > 0) {
            return lmi.get(0);
        }
        return null;
    }

    public static Iterable<MenuItem> iterable(MenuItem root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        return Iterators.tree((Object)root, (NodesExtracter)new MenuItemNodesExtracter());
    }

    public static Predicate<MenuItem> menuIdPredicate(String id) {
        final String targetId = id;
        return new Predicate<MenuItem>(){

            public boolean validate(MenuItem value) {
                if (value != null) {
                    String srcId = value.getId();
                    if (srcId == null && targetId == null) {
                        return true;
                    }
                    if (srcId != null && targetId == null) {
                        return false;
                    }
                    if (srcId == null && targetId != null) {
                        return true;
                    }
                    return srcId.equals(targetId);
                }
                return false;
            }
        };
    }

    public static Map<MenuContainer, List<MenuItem>> clearChildren(Iterable<MenuItem> mi) {
        LinkedHashMap<MenuContainer, List<MenuItem>> removed = new LinkedHashMap<MenuContainer, List<MenuItem>>();
        if (mi == null) {
            return removed;
        }
        for (MenuItem mi1 : mi) {
            if (mi1 == null || !(mi1 instanceof MenuContainer)) continue;
            removed.put((MenuContainer)mi1, MenuItem.clearChildren(mi1));
        }
        return removed;
    }

    public static List<MenuItem> clearChildren(MenuItem mi) {
        MenuItem[] mch;
        ArrayList<MenuItem> removed = new ArrayList<MenuItem>();
        if (mi == null) {
            return removed;
        }
        if (!(mi instanceof MenuContainer)) {
            return removed;
        }
        MenuContainer mc = (MenuContainer)mi;
        for (MenuItem m : mch = (MenuItem[])mc.getChildren().toArray(new MenuItem[0])) {
            if (m == null) continue;
            mc.getChildren().remove(m);
            removed.add(m);
        }
        return removed;
    }

    public static boolean addChild(MenuItem parent, MenuItem child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent==null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        if (parent instanceof MenuContainer) {
            MenuContainer mc = (MenuContainer)parent;
            return mc.getChildren().add(child);
        }
        return false;
    }

    public static int addChild(Iterable<MenuItem> parents, Iterable<MenuItem> childs) {
        int co = 0;
        if (parents == null) {
            throw new IllegalArgumentException("parents==null");
        }
        if (childs == null) {
            throw new IllegalArgumentException("childs==null");
        }
        for (MenuItem miParent : parents) {
            if (miParent == null) continue;
            for (MenuItem miChild : childs) {
                if (miChild == null || !MenuItem.addChild(miParent, miChild)) continue;
                ++co;
            }
        }
        return co;
    }

    public static void removeChild(MenuItem parent, MenuItem child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent==null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        if (parent instanceof MenuContainer) {
            MenuContainer mc = (MenuContainer)parent;
            mc.getChildren().remove(child);
        }
    }

    public static void removeChild(Iterable<MenuItem> parent, Iterable<MenuItem> child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent==null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        for (MenuItem miP : parent) {
            if (miP == null) continue;
            for (MenuItem miC : child) {
                if (miC == null) continue;
                MenuItem.removeChild(miP, miC);
            }
        }
    }

    public static Iterable<MenuItem> single(MenuItem mi) {
        return Iterators.single((Object)mi);
    }

    public static List<String> pathof(MenuItem mi) {
        MenuContainer miParent;
        ArrayList<String> path = new ArrayList<String>();
        if (mi == null) {
            return path;
        }
        if (mi instanceof MenuContainer) {
            path.add(((MenuContainer)mi).getText());
        }
        while ((miParent = mi.getParent()) != null) {
            path.add(miParent.getText());
            mi = miParent;
        }
        Collections.reverse(path);
        return path;
    }

    public static Iterable<Action> actionsOf(Iterable<MenuItem> mis) {
        if (mis == null) {
            return Iterators.empty();
        }
        Iterable itr = Iterators.empty();
        int idx = -1;
        for (MenuItem mi : mis) {
            if (mi == null) continue;
            if (++idx > 0) {
                itr = Iterators.sequence((Iterable[])new Iterable[]{itr, MenuItem.actionsOf(mi)});
                continue;
            }
            itr = MenuItem.actionsOf(mi);
        }
        return itr;
    }

    public static Iterable<Action> actionsOf(MenuItem mi) {
        if (mi == null) {
            return Iterators.empty();
        }
        Iterable<MenuItem> allMi = MenuItem.iterable(mi);
        Iterable acts = Iterators.convert(allMi, convertMenuItemToAction);
        Iterable actsWoNulls = Iterators.notNullFilter((Iterable)acts);
        return actsWoNulls;
    }

    public static Iterable<Action> filteredActionsOf(MenuItem mi, Predicate<Action> targetPredicate) {
        if (mi == null) {
            return Iterators.empty();
        }
        if (targetPredicate == null) {
            return MenuItem.actionsOf(mi);
        }
        return Iterators.predicate(MenuItem.actionsOf(mi), targetPredicate);
    }

    public static Iterable<Action> filteredActionsOf(Iterable<MenuItem> mis, Predicate<Action> targetPredicate) {
        if (mis == null) {
            return Iterators.empty();
        }
        if (targetPredicate == null) {
            return MenuItem.actionsOf(mis);
        }
        return Iterators.predicate(MenuItem.actionsOf(mis), targetPredicate);
    }

    public static Iterable<Action> targetedActionsOf(MenuItem mi, Class ... targets) {
        if (mi == null || targets == null || targets.length == 0) {
            return Iterators.empty();
        }
        return MenuItem.filteredActionsOf(mi, BasicAction.Filter.targetAssignableFrom(targets));
    }

    public static Iterable<Action> targetedActionsOf(Iterable<MenuItem> mis, Class ... targets) {
        if (mis == null || targets == null || targets.length == 0) {
            return Iterators.empty();
        }
        return MenuItem.filteredActionsOf(mis, BasicAction.Filter.targetAssignableFrom(targets));
    }

    public class PropertyChangedEvent
    extends MenuEvent {
        private String name;
        private Object oldValue;
        private Object newValue;

        public PropertyChangedEvent(Object source, String name, Object oldValue, Object newValue) {
            super(source);
            this.name = null;
            this.oldValue = null;
            this.newValue = null;
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getProperty() {
            return this.name;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public MenuItem getMenuItem() {
            return (MenuItem)this.source;
        }
    }
}

