/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.w3c.dom.Element;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.FocusFinder;
import xyz.cofe.gui.swing.GetFocusedObject;
import xyz.cofe.gui.swing.GetTarget;
import xyz.cofe.gui.swing.menu.UpdateUI;
import xyz.cofe.gui.swing.menu.XmlMenuBuilder;

public class MenuScriptAction
extends BasicAction
implements UpdateUI,
GetTarget {
    private String script;
    private ScriptEngine scriptEngine;
    private Element menuElement;
    private String targetVar;
    private String actionVar = null;
    private String updateScript = null;
    private Boolean iterableTargets;
    private Boolean autoUpdateEnabled;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(MenuScriptAction.class.getName()).log(Level.SEVERE, null, ex);
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
        MenuScriptAction.logFiner("setScript():\n{0}", script);
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        MenuScriptAction.logFiner("setScriptEngine():\n{0}", scriptEngine);
    }

    public Element getMenuElement() {
        return this.menuElement;
    }

    public void setMenuElement(Element menuElement) {
        this.menuElement = menuElement;
        MenuScriptAction.logFiner("setMenuElement():\n{0}", menuElement);
    }

    public String getTargetVar() {
        if (this.targetVar == null) {
            this.targetVar = "target";
        }
        return this.targetVar;
    }

    public void setTargetVar(String targetVar) {
        this.targetVar = targetVar;
        MenuScriptAction.logFiner("setTargetVar():\n{0}", targetVar);
    }

    public String getActionVar() {
        if (this.actionVar == null) {
            String val;
            this.actionVar = this.menuElement != null ? ((val = XmlMenuBuilder.readAttrOrText(this.menuElement, "actionVar", "action")) == null ? "action" : val) : "action";
        }
        return this.actionVar;
    }

    public void setActionVar(String actionVar) {
        this.actionVar = actionVar;
        MenuScriptAction.logFiner("setActionVar():\n{0}", actionVar);
    }

    public String getUpdateScript() {
        return this.updateScript;
    }

    public void setUpdateScript(String updateScript) {
        this.updateScript = updateScript;
        MenuScriptAction.logFiner("setUpdateScript():\n{0}", updateScript);
    }

    public boolean isIterableTargets() {
        if (this.iterableTargets == null) {
            String val;
            this.iterableTargets = this.menuElement != null ? ((val = XmlMenuBuilder.readAttrOrText(this.menuElement, "iterableTargets", "true")) == null ? Boolean.valueOf(true) : Boolean.valueOf(val.equalsIgnoreCase("true"))) : Boolean.valueOf(true);
        }
        return this.iterableTargets;
    }

    public void setIterableTargets(boolean iterableTargets) {
        this.iterableTargets = iterableTargets;
    }

    protected void runScript(String script, Object targetObject) {
        if (this.scriptEngine == null) {
            MenuScriptAction.logFiner("scriptEngine is null", new Object[0]);
            return;
        }
        if (script == null) {
            MenuScriptAction.logFiner("script is null", new Object[0]);
            return;
        }
        Bindings bnd = this.scriptEngine.getBindings(100);
        if (bnd == null) {
            MenuScriptAction.logFiner("bindings not exists", new Object[0]);
            return;
        }
        Class target = this.getTarget();
        if (target != null) {
            String tvar = this.getTargetVar();
            if (tvar == null) {
                MenuScriptAction.logFiner("targetVar is null", new Object[0]);
                return;
            }
            Object targetObj = targetObject;
            Object object = targetObj = targetObj != null ? targetObject : FocusFinder.findThroughFocus(target);
            if (targetObj == null) {
                targetObj = FocusFinder.findThroughMouse(target);
            }
            if (targetObj == null) {
                MenuScriptAction.logFiner("target not found", new Object[0]);
                return;
            }
            bnd.put(tvar, targetObj);
            if (targetObj instanceof Iterable && this.isIterableTargets()) {
                for (Object t : (Iterable)targetObj) {
                    if (t == null) continue;
                    if (this.actionVar != null) {
                        bnd.put(this.actionVar, (Object)this);
                    }
                    bnd.put(tvar, t);
                    try {
                        MenuScriptAction.logFiner("runScript:\n{0}", script);
                        this.scriptEngine.eval(script);
                    }
                    catch (ScriptException ex) {
                        MenuScriptAction.logException(ex);
                    }
                }
            } else {
                bnd.put(tvar, targetObj);
                if (this.actionVar != null) {
                    bnd.put(this.actionVar, (Object)this);
                }
                try {
                    MenuScriptAction.logFiner("runScript:\n{0}", script);
                    this.scriptEngine.eval(script);
                }
                catch (ScriptException ex) {
                    MenuScriptAction.logException(ex);
                }
            }
        } else {
            if (this.actionVar != null) {
                bnd.put(this.actionVar, (Object)this);
            }
            try {
                MenuScriptAction.logFiner("runScript:\n{0}", script);
                this.scriptEngine.eval(script);
            }
            catch (ScriptException ex) {
                MenuScriptAction.logException(ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MenuScriptAction.logFine("actionPerformed:\n{0}", this.script);
        if (e instanceof GetFocusedObject) {
            this.runScript(this.script, ((GetFocusedObject)((Object)e)).getFocusedObject());
        } else {
            this.runScript(this.script, null);
        }
    }

    public boolean isAutoUpdateEnabled() {
        if (this.autoUpdateEnabled == null) {
            String val;
            this.autoUpdateEnabled = this.menuElement != null ? ((val = XmlMenuBuilder.readAttrOrText(this.menuElement, "autoUpdateEnabled", "true")) == null ? Boolean.valueOf(true) : Boolean.valueOf(val.equalsIgnoreCase("true"))) : Boolean.valueOf(true);
        }
        return this.autoUpdateEnabled;
    }

    public void setAutoUpdateEnabled(boolean autoUpdateEnabled) {
        this.autoUpdateEnabled = autoUpdateEnabled;
    }

    @Override
    public void updateUI() {
        MenuScriptAction.logFine("updateUI:\n{0}", this.updateScript);
        Object targetObj = null;
        Class target = this.getTarget();
        if (target != null) {
            String tvar = this.getTargetVar();
            if (tvar == null) {
                MenuScriptAction.logFiner("targetVar is null", new Object[0]);
                if (this.isAutoUpdateEnabled()) {
                    this.setEnabled(false);
                }
            } else {
                Object trgt = FocusFinder.findThroughFocus(target);
                if (trgt == null) {
                    trgt = FocusFinder.findThroughMouse(target);
                }
                if (trgt == null) {
                    MenuScriptAction.logFiner("target not found", new Object[0]);
                    this.setEnabled(false);
                } else if (trgt instanceof Iterable && this.isIterableTargets()) {
                    if (trgt instanceof Collection) {
                        if (!((Collection)trgt).isEmpty()) {
                            targetObj = trgt;
                            this.setEnabled(true);
                        }
                    } else {
                        targetObj = trgt;
                        this.setEnabled(true);
                    }
                } else {
                    targetObj = trgt;
                    this.setEnabled(true);
                }
            }
        } else {
            this.setEnabled(true);
        }
        this.runScript(this.updateScript, targetObj);
    }
}

