/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.FocusFinder;
import xyz.cofe.gui.swing.GetTarget;
import xyz.cofe.gui.swing.menu.ReflectMenuBuilder;
import xyz.cofe.gui.swing.menu.UpdateUI;
import xyz.cofe.gui.swing.shortcuts.ShortcutManager;

public class MethodCallAction
extends BasicAction
implements GetTarget,
UpdateUI {
    private static final Logger logger = Logger.getLogger(MethodCallAction.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Method method;
    protected Object owner;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public MethodCallAction() {
    }

    public MethodCallAction(String name) {
        super(name);
    }

    public MethodCallAction(String name, Object own, Method meth) {
        super(name);
        this.owner = own;
        this.method = meth;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    protected Collection getTargets() {
        Class targetCls = this.getTarget();
        if (targetCls == null) {
            return new LinkedHashSet();
        }
        Object trgt = FocusFinder.findThroughFocus(targetCls);
        if (trgt == null) {
            trgt = FocusFinder.findThroughMouse(targetCls);
        }
        if (trgt instanceof Collection) {
            return (Collection)trgt;
        }
        LinkedHashSet<Object> res = new LinkedHashSet<Object>();
        if (trgt != null) {
            res.add(trgt);
        }
        return res;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Method m = this.method;
        Object own = this.owner;
        try {
            if (m != null) {
                Object target = null;
                Object firstTarget = null;
                Collection col = null;
                target = e instanceof ShortcutManager.FocusedObjectActionEvent ? ((ShortcutManager.FocusedObjectActionEvent)e).getFocusedObject() : this.getTargets();
                if (target instanceof Collection) {
                    col = (Collection)target;
                    if (col.isEmpty()) {
                        firstTarget = null;
                    } else {
                        Iterator itr = col.iterator();
                        if (itr.hasNext()) {
                            firstTarget = itr.next();
                        }
                    }
                } else {
                    firstTarget = target;
                }
                Class<?>[] params = m.getParameterTypes();
                if (params.length > 0) {
                    if (params.length == 1) {
                        Class<?> param = params[0];
                        if (firstTarget != null && param.isAssignableFrom(firstTarget.getClass())) {
                            m.invoke(own, firstTarget);
                        }
                    }
                } else {
                    m.invoke(own, new Object[0]);
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ReflectMenuBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ReflectMenuBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(ReflectMenuBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void updateUI() {
        Class targetCls = this.getTarget();
        if (targetCls == null) {
            this.setEnabled(true);
            return;
        }
        Collection targets = this.getTargets();
        if (targets.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

