/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.ObserverMenu;
import xyz.cofe.gui.swing.menu.ObserverMenuContainer;
import xyz.cofe.gui.swing.menu.ObserverMenuItem;
import xyz.cofe.gui.swing.menu.ObserverMenuItemCheked;

public class ObserverMenuBar
extends JMenuBar
implements EventListListener<MenuItem>,
ObserverMenu {
    private MenuItem menu = null;
    private boolean rootVisible = false;
    private SimpleListAdapter<MenuItem> mlAdapter = new SimpleListAdapter<MenuItem>(){

        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            ObserverMenuBar.this.remove(mi);
        }

        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            ObserverMenuBar.this.add(position == null ? 0 : position, mi);
        }
    };

    @Override
    public MenuItem getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(MenuItem menu) {
        this.detach();
        MenuItem old = this.menu;
        this.menu = menu;
        this.attach();
        this.refresh();
        this.firePropertyChange("menu", old, menu);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean rootVisible) {
        Boolean old = this.rootVisible;
        this.rootVisible = rootVisible;
        this.firePropertyChange("rootVisible", old, (Object)rootVisible);
    }

    private void detach() {
        HashSet<Component> removeList = new HashSet<Component>();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu c = this.getMenu(i);
            if (!(c instanceof ObserverMenu)) continue;
            ((ObserverMenu)((Object)c)).setMenu(null);
            removeList.add(c);
        }
        for (Component c : this.getComponents()) {
            if (!(c instanceof ObserverMenu)) continue;
            ((ObserverMenu)((Object)c)).setMenu(null);
            removeList.add(c);
        }
        for (Component c : removeList) {
            this.remove(c);
        }
        if (this.menu instanceof MenuContainer) {
            ((MenuContainer)this.menu).getChildren().removeEventListListener(this);
        }
    }

    private void attach() {
        if (this.menu instanceof MenuContainer) {
            MenuContainer mc = (MenuContainer)this.menu;
            int idx = -1;
            Iterator iterator = mc.getChildren().iterator();
            while (iterator.hasNext()) {
                MenuItem mi = (MenuItem)iterator.next();
                this.add(++idx, mi);
            }
        }
        if (this.menu instanceof MenuContainer) {
            ((MenuContainer)this.menu).getChildren().addEventListListener(this);
        }
    }

    protected ObserverMenuItem createObserverMenuItem() {
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked() {
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer() {
        return new ObserverMenuContainer();
    }

    private void add(int idx, MenuItem mi) {
        int size = this.getMenuCount();
        if (idx > size) {
            idx = size;
        }
        if (idx < -1) {
            idx = -1;
        }
        if (mi instanceof MenuActionItem) {
            MenuActionItem mai = (MenuActionItem)mi;
            switch (mai.getType()) {
                case Checked: {
                    ObserverMenuItemCheked coa = this.createObserverMenuItemCheked();
                    coa.setMenu((MenuActionItem)mi);
                    super.add((Component)coa, idx);
                    break;
                }
                default: {
                    ObserverMenuItem oa = this.createObserverMenuItem();
                    oa.setMenu((MenuActionItem)mi);
                    super.add((Component)oa, idx);
                }
            }
        }
        if (mi instanceof MenuContainer) {
            ObserverMenuContainer oc = this.createObserverMenuContainer();
            oc.setMenu((MenuContainer)mi);
            super.add((Component)oc, idx);
        }
        this.refresh();
    }

    private void remove(MenuItem mi) {
        HashSet<Component> removeList = new HashSet<Component>();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            MenuItem cmi;
            JMenu c = this.getMenu(i);
            if (!(c instanceof ObserverMenu) || (cmi = ((ObserverMenu)((Object)c)).getMenu()) == null || cmi != mi) continue;
            ((ObserverMenu)((Object)c)).setMenu(null);
            removeList.add(c);
        }
        for (Component c : this.getComponents()) {
            MenuItem cmi;
            if (!(c instanceof ObserverMenu) || (cmi = ((ObserverMenu)((Object)c)).getMenu()) == null || cmi != mi) continue;
            ((ObserverMenu)((Object)c)).setMenu(null);
            removeList.add(c);
        }
        for (Component c : removeList) {
            this.remove(c);
        }
        this.refresh();
    }

    public void listItemsChanged(Object evnt) {
        this.mlAdapter.listItemsChanged(evnt);
    }

    private void refresh() {
        this.validate();
    }
}

