/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.MenuSeparatorItem;
import xyz.cofe.gui.swing.menu.ObserverMenu;
import xyz.cofe.gui.swing.menu.ObserverMenuItem;
import xyz.cofe.gui.swing.menu.ObserverMenuItemCheked;
import xyz.cofe.gui.swing.menu.ObserverMenuSeparator;
import xyz.cofe.gui.swing.menu.UpdateUI;

public class ObserverMenuContainer
extends JMenu
implements PropertyChangeListener,
EventListListener<MenuItem>,
ObserverMenu {
    private MenuItem menu = null;
    private SimpleListAdapter<MenuItem> mlAdapter = new SimpleListAdapter<MenuItem>(){

        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            ObserverMenuContainer.this.remove(mi);
        }

        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            int idx = position == null ? 0 : position;
            ObserverMenuContainer.this.add(idx, mi);
        }
    };

    public ObserverMenuContainer() {
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ObserverMenuContainer.this.onSelected(e);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    protected void onSelected(MenuEvent ev) {
        if (this.menu != null) {
            for (Action o : MenuItem.actionsOf(this.menu)) {
                if (!(o instanceof UpdateUI)) continue;
                ((UpdateUI)((Object)o)).updateUI();
            }
        }
    }

    @Override
    public MenuItem getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(MenuItem menu) {
        if (this.menu != null) {
            this.detach();
        }
        this.unbindChildren();
        this.menu = menu;
        this.refreshView();
        this.bindChildren();
        if (this.menu != null) {
            this.attach();
        }
    }

    private void detach() {
        this.menu.removePropertyChangeListener(this);
        if (this.menu instanceof MenuContainer) {
            ((MenuContainer)this.menu).getChildren().removeEventListListener(this);
        }
    }

    private void attach() {
        this.menu.addPropertyChangeListener(this);
        if (this.menu instanceof MenuContainer) {
            ((MenuContainer)this.menu).getChildren().addEventListListener(this);
        }
    }

    private void refreshView() {
        this.setText();
        this.setIcon(this.menu == null || !(this.menu instanceof MenuContainer) ? null : ((MenuContainer)this.menu).getIcon());
    }

    private void unbindChildren() {
        ArrayList<Component> toRemove = new ArrayList<Component>();
        for (Component c : this.getMenuComponents()) {
            if (c == null || !(c instanceof ObserverMenu)) continue;
            toRemove.add(c);
            ((ObserverMenu)((Object)c)).setMenu(null);
        }
        for (Component c : toRemove) {
            this.remove(c);
        }
    }

    private void bindChildren() {
        if (this.menu instanceof MenuContainer) {
            MenuContainer mc = (MenuContainer)this.menu;
            int idx = -1;
            Iterator iterator = mc.getChildren().iterator();
            while (iterator.hasNext()) {
                MenuItem mi = (MenuItem)iterator.next();
                this.add(++idx, mi);
            }
        }
    }

    private void setText() {
        String text;
        String string = text = this.menu == null || !(this.menu instanceof MenuContainer) ? null : ((MenuContainer)this.menu).getText();
        if (text == null) {
            String string2 = text = this.menu != null ? this.menu.getId() : null;
        }
        if (text == null) {
            text = "???";
        }
        this.setText(text);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        this.refreshView();
    }

    private void remove(MenuItem mi) {
        ArrayList<Component> toRemove = new ArrayList<Component>();
        for (Component c : this.getMenuComponents()) {
            MenuItem cmi;
            if (c == null || !(c instanceof ObserverMenu) || (cmi = ((ObserverMenu)((Object)c)).getMenu()) == null || cmi != mi) continue;
            toRemove.add(c);
            ((ObserverMenu)((Object)c)).setMenu(null);
        }
        for (Component c : toRemove) {
            this.remove(c);
        }
    }

    protected ObserverMenuItem createObserverMenuItem() {
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked() {
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer() {
        return new ObserverMenuContainer();
    }

    protected ObserverMenuSeparator createObserverMenuSeparator() {
        return new ObserverMenuSeparator();
    }

    private void add(int idx, MenuItem mi) {
        int size = this.getMenuComponentCount();
        if (idx > size) {
            idx = size;
        }
        if (mi instanceof MenuActionItem) {
            JMenuItem c = null;
            JMenuItem om = null;
            switch (((MenuActionItem)mi).getType()) {
                case Checked: {
                    ObserverMenuItemCheked coa;
                    c = coa = this.createObserverMenuItemCheked();
                    om = coa;
                    break;
                }
                default: {
                    ObserverMenuItem oa = this.createObserverMenuItem();
                    c = oa;
                    om = oa;
                }
            }
            om.setMenu((MenuActionItem)mi);
            if (idx >= 0) {
                super.add((Component)c, idx);
            } else {
                super.add((Component)c);
            }
        }
        if (mi instanceof MenuContainer) {
            ObserverMenuContainer oc = this.createObserverMenuContainer();
            oc.setMenu((MenuContainer)mi);
            if (idx >= 0) {
                super.add((Component)oc, idx);
            } else {
                super.add(oc);
            }
        }
        if (mi instanceof MenuSeparatorItem) {
            ObserverMenuSeparator os = this.createObserverMenuSeparator();
            os.setMenu(mi);
            if (idx >= 0) {
                super.add((Component)os, idx);
            } else {
                super.add(os);
            }
        }
    }

    public void listItemsChanged(Object evnt) {
        this.mlAdapter.listItemsChanged(evnt);
    }
}

