/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.button.DropDownButton;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.MenuSeparatorItem;
import xyz.cofe.gui.swing.menu.ObserverMenu;
import xyz.cofe.gui.swing.menu.ObserverMenuContainer;
import xyz.cofe.gui.swing.menu.ObserverMenuItem;
import xyz.cofe.gui.swing.menu.ObserverMenuItemCheked;
import xyz.cofe.gui.swing.menu.ObserverMenuSeparator;

public class ObserverMenuDropDownButton
extends DropDownButton
implements ObserverMenu {
    private MenuItem menu = null;
    private PropertyChangeListener menuPropListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null) {
                return;
            }
            if (propName.equals("text")) {
                ObserverMenuDropDownButton.this.refreshMenuContainerProperties();
            } else if (propName.equals("icon")) {
                ObserverMenuDropDownButton.this.refreshMenuContainerProperties();
            } else if (propName.equals("id")) {
                ObserverMenuDropDownButton.this.refreshMenuContainerProperties();
            }
        }
    };
    private SimpleListAdapter<MenuItem> menuContainerListener = new SimpleListAdapter<MenuItem>(){

        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            ObserverMenuDropDownButton.this.onChildDeleted(e);
        }

        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            int idx = position == null ? 0 : position;
            MenuItem mi = e;
            ObserverMenuDropDownButton.this.onChildInserted(idx, mi);
        }
    };

    private JPopupMenu getPopupMenu() {
        JPopupMenu popup = this.getComponentPopupMenu();
        if (popup == null) {
            popup = new JPopupMenu();
            this.setComponentPopupMenu(popup);
        }
        return popup;
    }

    @Override
    public MenuItem getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(MenuItem menu) {
        MenuItem old = this.menu;
        if (this.menu != null) {
            this.detach();
        }
        this.menu = menu;
        if (this.menu != null) {
            this.attach();
        }
        this.firePropertyChange("menu", old, menu);
    }

    private void attach() {
        if (this.menu instanceof MenuActionItem) {
            MenuActionItem mai = (MenuActionItem)this.menu;
            this.setAction(mai.getAction());
        } else if (this.menu instanceof MenuContainer) {
            this.bindChildren();
            this.refreshMenuContainerProperties();
            this.menu.addPropertyChangeListener(this.menuPropListener);
        }
        this.setEnabled(true);
    }

    private void detach() {
        if (this.menu instanceof MenuActionItem) {
            this.setAction(null);
        } else if (this.menu instanceof MenuContainer) {
            this.unbindChildren();
            this.menu.removePropertyChangeListener(this.menuPropListener);
        }
        this.setEnabled(false);
    }

    private void refreshMenuContainerProperties() {
        if (!(this.menu instanceof MenuContainer)) {
            return;
        }
        MenuContainer mc = (MenuContainer)this.menu;
        Icon ico = mc.getIcon();
        String text = mc.getText();
        if (ico != null) {
            this.setIcon(ico);
            this.setText("");
            this.setToolTipText(text == null ? null : text);
        } else {
            String id = mc.getId();
            if (text == null) {
                text = id;
            }
            if (text == null) {
                text = "?";
            }
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText(text);
        }
    }

    private void unbindChildren() {
        MenuContainer mc = (MenuContainer)this.menu;
        mc.getChildren().removeEventListListener((EventListListener)this.menuContainerListener);
        this.clearChildren();
    }

    private void bindChildren() {
        MenuContainer mc = (MenuContainer)this.menu;
        mc.getChildren().addEventListListener((EventListListener)this.menuContainerListener);
        Iterator iterator = mc.getChildren().iterator();
        while (iterator.hasNext()) {
            MenuItem mi = (MenuItem)iterator.next();
            this.onChildInserted(mi);
        }
    }

    private void clearChildren() {
        MenuElement[] elements;
        JPopupMenu popup = this.getComponentPopupMenu();
        if (popup == null) {
            return;
        }
        for (MenuElement e : elements = popup.getSubElements()) {
            if (e instanceof Component) {
                Component c = (Component)((Object)e);
                popup.remove(c);
            }
            if (!(e instanceof ObserverMenu)) continue;
            ObserverMenu om = (ObserverMenu)((Object)e);
            om.setMenu(null);
        }
    }

    private void onChildDeleted(MenuItem mi) {
        if (mi == null) {
            return;
        }
        JPopupMenu popup = this.getComponentPopupMenu();
        if (popup == null) {
            return;
        }
        HashSet<MenuElement> forDelete = new HashSet<MenuElement>();
        MenuElement[] elements = popup.getSubElements();
        for (MenuElement e : elements) {
            ObserverMenu om;
            if (!(e instanceof ObserverMenu) || mi != (om = (ObserverMenu)((Object)e)).getMenu()) continue;
            forDelete.add(e);
        }
        for (Object e : forDelete) {
            if (e instanceof Component) {
                Component c = (Component)e;
                popup.remove(c);
            }
            ObserverMenu om = (ObserverMenu)e;
            om.setMenu(null);
        }
    }

    protected ObserverMenuItem createObserverMenuItem() {
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked() {
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer() {
        return new ObserverMenuContainer();
    }

    protected ObserverMenuSeparator createObserverMenuSeparator() {
        return new ObserverMenuSeparator();
    }

    private void onChildInserted(int idx, MenuItem mi) {
        int subElementsCount = this.getPopupMenu().getSubElements().length;
        boolean append = idx < 0 || idx >= subElementsCount;
        JComponent miComponent = null;
        if (mi instanceof MenuSeparatorItem) {
            ObserverMenuSeparator oms = this.createObserverMenuSeparator();
            oms.setMenu(mi);
            miComponent = oms;
        } else if (mi instanceof MenuActionItem) {
            ObserverMenuItem omi = this.createObserverMenuItem();
            omi.setMenu(mi);
            miComponent = omi;
        } else if (mi instanceof MenuContainer) {
            ObserverMenuContainer omc = this.createObserverMenuContainer();
            omc.setMenu(mi);
            miComponent = omc;
        }
        if (miComponent != null) {
            if (append) {
                this.getPopupMenu().add(miComponent);
            } else {
                this.getPopupMenu().insert(miComponent, idx);
            }
        }
    }

    private void onChildInserted(MenuItem mi) {
        this.onChildInserted(-1, mi);
    }
}

