/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import xyz.cofe.collection.graph.Graph;
import xyz.cofe.collection.graph.GraphTools;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.collection.graph.SimpleSDGraph;
import xyz.cofe.gui.swing.KeyboardShortcut;
import xyz.cofe.gui.swing.menu.MenuAction;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.MethodCallAction;
import xyz.cofe.gui.swing.menu.Shortcut;

public class ReflectMenuBuilder {
    private static final Logger logger = Logger.getLogger(ReflectMenuBuilder.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected MenuItem menu;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public MenuItem getMenu() {
        if (this.menu != null) {
            return this.menu;
        }
        MenuContainer mc = new MenuContainer();
        this.menu = mc;
        return this.menu;
    }

    public void setMenu(MenuItem menu) {
        this.menu = menu;
    }

    protected void registerNewAction(Action action, MenuAction act) {
    }

    protected MenuContainer createMenuContainer(MenuAction act) {
        String menuId = act.menuContainerId();
        MenuContainer miFound = new MenuContainer(menuId);
        miFound.setId(menuId);
        return miFound;
    }

    protected MenuActionItem createMenuActionItem(Action action, MenuAction act) {
        MenuActionItem ma = new MenuActionItem(action);
        String menuID = act.menuId();
        if (menuID != null && menuID.length() > 0) {
            ma.setId(menuID);
        }
        return ma;
    }

    public void inspect(Object obj) {
        List children;
        Method[] methods;
        if (obj == null) {
            return;
        }
        LinkedHashMap<Object, MenuItem> assignMenuItems = new LinkedHashMap<Object, MenuItem>();
        final LinkedHashMap<MenuItem, Integer> order = new LinkedHashMap<MenuItem, Integer>();
        LinkedHashMap<String, MenuActionItem> menuById = new LinkedHashMap<String, MenuActionItem>();
        LinkedHashMap<MenuActionItem, String> menuAfter = new LinkedHashMap<MenuActionItem, String>();
        boolean defOrder = false;
        MenuItem miRoot = this.getMenu();
        for (Method m : methods = obj.getClass().getMethods()) {
            String menuContainerId;
            MethodCallAction metCallAct;
            MenuAction menuAction = m.getAnnotation(MenuAction.class);
            if (menuAction == null || (metCallAct = this.createAction(obj, m, menuAction)) == null || (menuContainerId = menuAction.menuContainerId()) == null || menuContainerId.length() <= 0 || miRoot == null) continue;
            List<MenuItem> li = MenuItem.findMenuItemById(miRoot, menuContainerId);
            if (li == null || li.isEmpty()) {
                for (MenuItem mi : assignMenuItems.keySet()) {
                    if (!menuContainerId.equals(mi.getId())) continue;
                    li = new ArrayList<MenuItem>();
                    li.add(mi);
                    break;
                }
            }
            if (li == null || li.isEmpty()) {
                MenuContainer miFound = this.createMenuContainer(menuAction);
                li = new ArrayList<MenuItem>();
                li.add(miFound);
                assignMenuItems.put(miFound, miRoot);
            }
            for (MenuItem mic : li) {
                String after;
                MenuActionItem ma = this.createMenuActionItem(metCallAct, menuAction);
                assignMenuItems.put(ma, mic);
                order.put(ma, menuAction.menuOrder());
                String mid = menuAction.menuId();
                if (mid != null && mid.length() > 0) {
                    menuById.put(mid, ma);
                }
                if ((after = menuAction.menuOrderAfter()) == null || after.length() <= 0) continue;
                menuAfter.put(ma, after);
            }
        }
        LinkedHashMap<MenuItem, ArrayList<MenuItem>> orderdMap = new LinkedHashMap<MenuItem, ArrayList<MenuItem>>();
        for (Map.Entry me : assignMenuItems.entrySet()) {
            MenuItem child = (MenuItem)me.getKey();
            MenuItem menuItem = (MenuItem)me.getValue();
            children = (ArrayList<MenuItem>)orderdMap.get(menuItem);
            if (children == null) {
                children = new ArrayList<MenuItem>();
                orderdMap.put(menuItem, (ArrayList<MenuItem>)children);
            }
            children.add(child);
        }
        SimpleSDGraph orderRefs = new SimpleSDGraph();
        TreeMap<Integer, LinkedHashSet<MenuItem>> orderRefsResolv = new TreeMap<Integer, LinkedHashSet<MenuItem>>();
        for (MenuItem menuItem : menuAfter.keySet()) {
            String refMid;
            String mid = menuItem.getId();
            if (mid == null || (refMid = (String)menuAfter.get(menuItem)) == null) continue;
            orderRefs.set((Object)mid, (Object)refMid, (Object)mid);
        }
        for (String string : orderRefs.getNodes()) {
            int len;
            MenuItem mi = (MenuItem)menuById.get(string);
            if (mi == null || (len = GraphTools.getMaxPathLength((Graph)orderRefs, (Object)string, (Path.Direction)Path.Direction.AB)) < 0) continue;
            LinkedHashSet<MenuItem> sm = (LinkedHashSet<MenuItem>)orderRefsResolv.get(len);
            if (sm == null) {
                sm = new LinkedHashSet<MenuItem>();
                orderRefsResolv.put(len, sm);
            }
            sm.add(mi);
        }
        for (Integer n : orderRefsResolv.keySet()) {
            Set sm = (Set)orderRefsResolv.get(n);
            for (MenuItem mi : sm) {
                String refMI = (String)menuAfter.get(mi);
                if (refMI == null || !menuById.containsKey(refMI)) continue;
                int refOrder = (Integer)order.get(menuById.get(refMI));
                order.put(mi, refOrder + 1);
            }
        }
        for (Map.Entry entry : orderdMap.entrySet()) {
            children = (List)entry.getValue();
            if (children.isEmpty()) continue;
            Collections.sort(children, new Comparator<MenuItem>(){

                @Override
                public int compare(MenuItem mi1, MenuItem mi2) {
                    int o2;
                    int o1 = order.containsKey(mi1) ? (Integer)order.get(mi1) : 0;
                    int n = o2 = order.containsKey(mi2) ? (Integer)order.get(mi2) : 0;
                    return o1 == o2 ? 0 : (o1 < o2 ? -1 : 1);
                }
            });
        }
        for (MenuItem menuItem : orderdMap.keySet()) {
            for (MenuItem chld : (List)orderdMap.get(menuItem)) {
                MenuItem.addChild(menuItem, chld);
            }
        }
    }

    public MethodCallAction createAction(Object owner, Method method, MenuAction act) {
        if (act == null) {
            return null;
        }
        if (method == null) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers()) && owner == null) {
            return null;
        }
        String actName = act.name();
        if (actName == null || actName.length() == 0) {
            actName = method.getName();
        }
        Class cTarget = act.target();
        Class paramTarget = null;
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 0) {
            if (params.length == 1) {
                cTarget = paramTarget = params[0];
            } else {
                return null;
            }
        }
        MethodCallAction ba = new MethodCallAction(actName, owner, method);
        Shortcut[] shortcuts = act.shortcuts();
        if (shortcuts != null) {
            Shortcut sc;
            if (shortcuts.length > 1) {
                for (Shortcut sc2 : shortcuts) {
                    Class c;
                    KeyStroke ks;
                    if (sc2.keys() == null || sc2.keys().length() <= 0 || (ks = KeyStroke.getKeyStroke(sc2.keys())) == null) continue;
                    KeyboardShortcut ksc = new KeyboardShortcut();
                    ksc.setKeyStroke(ks);
                    Class clazz = c = paramTarget != null ? paramTarget : sc2.target();
                    if (c != null && !c.equals(Void.class)) {
                        ksc.setTarget(c);
                    }
                    ba.getKeyboardShortcuts().add((Object)ksc);
                }
            } else if (shortcuts.length == 1 && shortcuts[0] != null && (sc = shortcuts[0]).keys() != null && sc.keys().length() > 0) {
                Class c;
                KeyStroke ks = KeyStroke.getKeyStroke(sc.keys());
                ba.setAccelerator(ks);
                Class clazz = c = paramTarget != null ? paramTarget : sc.target();
                if (c != null && !c.equals(Void.class)) {
                    ba.setTarget(c);
                }
            }
        }
        if (cTarget != null && !cTarget.equals(Void.class)) {
            ba.setTarget(cTarget);
        }
        this.registerNewAction(ba, act);
        return ba;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

