/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.menu;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.EventMapListener;
import xyz.cofe.collection.map.MapEvent;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.Icon;
import xyz.cofe.gui.swing.KeyboardShortcut;
import xyz.cofe.gui.swing.menu.MenuActionItem;
import xyz.cofe.gui.swing.menu.MenuContainer;
import xyz.cofe.gui.swing.menu.MenuItem;
import xyz.cofe.gui.swing.menu.MenuScriptAction;
import xyz.cofe.gui.swing.menu.MenuSeparatorItem;
import xyz.cofe.xml.XmlUtil;

public class XmlMenuBuilder {
    protected boolean listenTranslation = false;
    protected Convertor<String, String> translate = null;
    protected Convertor<String, Action> actionByNameResolver = null;
    protected Convertor<OnClick, Action> actionByOnClickResolver = null;
    protected Reciver<RegAction> actionReciver = null;
    private ScriptEngineManager scriptEngineManager = null;
    private WeakHashMap<String, ScriptEngine> scriptEngineMap = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.SEVERE, null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem parseXML(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        InputStream in = null;
        try {
            try {
                in = url.openStream();
            }
            catch (IOException ex) {
                XmlMenuBuilder.logException(ex);
            }
            MenuItem menuItem = this.parseXML(in);
            return menuItem;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    XmlMenuBuilder.logException(ex);
                }
            }
        }
    }

    public MenuItem parseXML(File file) {
        try {
            if (file == null) {
                throw new IllegalArgumentException("file==null");
            }
            return this.parseXML(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            XmlMenuBuilder.logException(ex);
            return null;
        }
    }

    public MenuItem parseXML(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("input==null");
        }
        Document doc = XmlUtil.parseXml((InputStream)input);
        return this.parseXML(doc);
    }

    public MenuItem parseXML(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("xml==null");
        }
        Document xdoc = XmlUtil.parseXml((String)xml);
        Element root = xdoc.getDocumentElement();
        return this.parseElement(root);
    }

    public MenuItem parseXML(Document xmlDoc) {
        if (xmlDoc == null) {
            throw new IllegalArgumentException("xmlDoc==null");
        }
        Element root = xmlDoc.getDocumentElement();
        return this.parseElement(root);
    }

    public boolean isListenTranslation() {
        return this.listenTranslation;
    }

    public void setListenTranslation(boolean listenTranslation) {
        this.listenTranslation = listenTranslation;
    }

    public Convertor<String, String> getTranslate() {
        return this.translate;
    }

    public void setTranslate(Convertor<String, String> translate) {
        this.translate = translate;
    }

    protected String translate(String text) {
        String t;
        if (this.translate != null && (t = (String)this.translate.convert((Object)text)) != null) {
            return t;
        }
        return text;
    }

    public MenuItem parseElement(Element el) {
        Stack<VisitElement> stack = new Stack<VisitElement>();
        MenuItem mi = this.parseElement(el, stack);
        return mi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MenuItem parseElement(Element el, Stack<VisitElement> stack) {
        if (el == null) {
            throw new IllegalArgumentException("el==null");
        }
        if (stack == null) {
            throw new IllegalArgumentException("stack==null");
        }
        VisitElement ve = new VisitElement(el);
        stack.push(ve);
        try {
            String name = el.getNodeName();
            if (name.equalsIgnoreCase("menu")) {
                String id;
                MContainer mc = new MContainer();
                String txt = XmlMenuBuilder.readAttrOrText(el, "text", null);
                if (txt != null) {
                    String text = txt;
                    if (this.listenTranslation && this.translate instanceof EventMap) {
                        EventMap emap = (EventMap)this.translate;
                        emap.addEventMapListener((EventMapListener)mc, true);
                    }
                    mc.setText(this.translate(text));
                }
                if ((id = XmlMenuBuilder.readAttrOrText(el, "id", null)) != null) {
                    mc.setId(id);
                }
                if (el.hasChildNodes()) {
                    NodeList nl = el.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        MenuItem mi;
                        Node o = nl.item(i);
                        if (!(o instanceof Element) || (mi = this.parseElement((Element)o, stack)) == null) continue;
                        mi.setParent(mc);
                        mc.getChildren().add(mi);
                    }
                }
                MContainer mContainer = mc;
                return mContainer;
            }
            if (name.equalsIgnoreCase("line")) {
                MenuSeparatorItem menuSeparatorItem = new MenuSeparatorItem();
                return menuSeparatorItem;
            }
            if (name.equalsIgnoreCase("action")) {
                MenuItem menuItem = this.parseElementAction(el);
                return menuItem;
            }
            MenuItem menuItem = null;
            return menuItem;
        }
        finally {
            if (!stack.empty()) {
                stack.pop();
            }
        }
    }

    public static String readAttr(Element actionElement, String fieldName, String defaultValue) {
        if (actionElement.hasAttribute(fieldName)) {
            String text = actionElement.getAttribute(fieldName);
            return text;
        }
        return defaultValue;
    }

    public static String readText(Element actionElement, String fieldName, String defaultValue) {
        for (Node n : XmlUtil.children((Node)actionElement)) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getNodeName().equals(fieldName)) continue;
            String text = e.getTextContent();
            return text;
        }
        return defaultValue;
    }

    public static String readAttrOrText(Element actionElement, String fieldName, String defaultValue) {
        String attr = XmlMenuBuilder.readAttr(actionElement, fieldName, null);
        if (attr != null) {
            return attr;
        }
        String text = XmlMenuBuilder.readText(actionElement, fieldName, null);
        if (text == null) {
            return defaultValue;
        }
        return text;
    }

    public Convertor<String, Action> getActionByNameResolver() {
        return this.actionByNameResolver;
    }

    public void setActionByNameResolver(Convertor<String, Action> actionByNameResolver) {
        this.actionByNameResolver = actionByNameResolver;
    }

    public Convertor<OnClick, Action> getActionByOnClickResolver() {
        return this.actionByOnClickResolver;
    }

    public void setActionByOnClickResolver(Convertor<OnClick, Action> actionByOnClickResolver) {
        this.actionByOnClickResolver = actionByOnClickResolver;
    }

    protected void fireCantCreateAction(Element el) {
        String xml = XmlUtil.toXMLString((Node)el);
        XmlMenuBuilder.logWarning("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c action, \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b ({0}) {1}", "name | class | onclick", xml);
    }

    public Reciver<RegAction> getActionReciver() {
        return this.actionReciver;
    }

    public void setActionReciver(Reciver<RegAction> actionReciver) {
        this.actionReciver = actionReciver;
    }

    public ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
        return this.scriptEngineManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected MenuItem parseElementAction(Element el) {
        KeyStroke ks;
        String keyStroke;
        String actionText;
        String type;
        BasicAction ba;
        Action act;
        MActionItem mi = null;
        Action action = null;
        String actionName = XmlMenuBuilder.readAttrOrText(el, "name", null);
        String actionClassName = XmlMenuBuilder.readAttrOrText(el, "class", null);
        String onClickScript = XmlMenuBuilder.readAttrOrText(el, "onclick", null);
        String onShowScript = XmlMenuBuilder.readAttrOrText(el, "onshow", null);
        String language = XmlMenuBuilder.readAttrOrText(el, "language", XmlMenuBuilder.readAttrOrText(el, "lang", null));
        String targetClassName = XmlMenuBuilder.readAttrOrText(el, "target", XmlMenuBuilder.readAttrOrText(el, "target", null));
        String targetVar = XmlMenuBuilder.readAttrOrText(el, "targetVar", "target");
        String actionVar = XmlMenuBuilder.readAttrOrText(el, "actionVar", "action");
        if (actionName != null && this.actionByNameResolver != null && (act = (Action)this.actionByNameResolver.convert((Object)actionName)) != null) {
            action = act;
            XmlMenuBuilder.logFiner("fetched action by name={0}", actionName);
        }
        if (action == null && actionClassName != null) {
            try {
                Class<?> clazz = Class.forName(actionClassName);
                Object o = clazz.newInstance();
                if (o instanceof Action) {
                    action = (Action)o;
                    XmlMenuBuilder.logFiner("created action by className={0}", actionClassName);
                }
            }
            catch (InstantiationException ex) {
                XmlMenuBuilder.logException(ex);
            }
            catch (IllegalAccessException ex) {
                XmlMenuBuilder.logException(ex);
            }
            catch (ClassNotFoundException ex) {
                XmlMenuBuilder.logException(ex);
            }
        }
        if (action == null && onClickScript != null && this.actionByOnClickResolver != null && (act = (Action)this.actionByOnClickResolver.convert((Object)new OnClick(onClickScript, language, el))) != null) {
            action = act;
            XmlMenuBuilder.logFiner("fetched action by onclick={0}", onClickScript);
        }
        Class<?> targetCls = null;
        if (targetClassName != null) {
            try {
                targetCls = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(XmlMenuBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (action == null && onClickScript != null) {
            ScriptEngineManager seman = this.getScriptEngineManager();
            String lang = language == null ? "JavaScript" : language;
            ScriptEngine se = this.scriptEngineMap.get(lang);
            if (se == null) {
                se = seman.getEngineByName(lang);
                this.scriptEngineMap.put(lang, se);
            }
            if (se != null) {
                MenuScriptAction ma = new MenuScriptAction();
                ma.setMenuElement(el);
                ma.setScript(onClickScript);
                ma.setScriptEngine(se);
                ma.setTargetVar(targetVar);
                ma.setTarget(targetCls);
                ma.setActionVar(actionVar);
                ma.setUpdateScript(onShowScript);
                action = ma;
                XmlMenuBuilder.logFiner("created action {1} by onclick={0}", onClickScript, actionName);
            }
        }
        if (action == null) {
            this.fireCantCreateAction(el);
            return null;
        }
        if (action instanceof BasicAction && targetCls != null && (ba = (BasicAction)action).getTarget() == null) {
            ba.setTarget(targetCls);
        }
        if (this.actionReciver != null) {
            this.actionReciver.recive((Object)new RegAction(action, el, actionName));
        }
        mi = new MActionItem();
        mi.setAction(action);
        XmlMenuBuilder.logFiner("created MenuActionItem name={0}, class={1}, onclick={2}", actionName, actionClassName, onClickScript);
        String id = XmlMenuBuilder.readAttrOrText(el, "id", null);
        if (id != null) {
            mi.setId(id);
            XmlMenuBuilder.logFiner("set MenuAction id={0}", id);
        }
        if ((type = XmlMenuBuilder.readAttrOrText(el, "type", null)) != null) {
            if (MenuActionItem.Type.Checked.name().equalsIgnoreCase(type)) {
                mi.setType(MenuActionItem.Type.Checked);
                XmlMenuBuilder.logFiner("set MenuAction type={0}", type);
            } else if (MenuActionItem.Type.Default.name().equalsIgnoreCase(type)) {
                mi.setType(MenuActionItem.Type.Default);
                XmlMenuBuilder.logFiner("set MenuAction type={0}", type);
            }
        }
        if ((actionText = XmlMenuBuilder.readAttrOrText(el, "text", null)) != null) {
            String txt = this.translate(actionText);
            if (this.listenTranslation && this.translate instanceof EventMap) {
                EventMap emap = (EventMap)this.translate;
                emap.addEventMapListener((EventMapListener)mi, true);
            }
            action.putValue("Name", txt);
            XmlMenuBuilder.logFiner("set MenuAction text={0} translated={1}", actionText, txt);
        }
        String shortDesc = XmlMenuBuilder.readAttrOrText(el, "desc", null);
        shortDesc = XmlMenuBuilder.readAttrOrText(el, "shortDesc", shortDesc);
        if ((shortDesc = XmlMenuBuilder.readAttrOrText(el, "title", shortDesc)) != null) {
            String txt = this.translate(shortDesc);
            action.putValue("ShortDescription", txt);
            XmlMenuBuilder.logFiner("set MenuAction short desc={0}, translated={1}", shortDesc, txt);
        }
        String longDesc = XmlMenuBuilder.readAttrOrText(el, "desc", null);
        if ((longDesc = XmlMenuBuilder.readAttrOrText(el, "longDesc", longDesc)) != null) {
            String txt = this.translate(longDesc);
            action.putValue("LongDescription", txt);
            XmlMenuBuilder.logFiner("set MenuAction long desc={0}, translated={1}", longDesc, txt);
        }
        if ((keyStroke = XmlMenuBuilder.readAttrOrText(el, "key", null)) == null) {
            keyStroke = XmlMenuBuilder.readAttrOrText(el, "keyStroke", null);
        }
        if (keyStroke != null && (ks = KeyStroke.getKeyStroke(keyStroke)) != null) {
            action.putValue("AcceleratorKey", ks);
            XmlMenuBuilder.logFiner("set MenuAction ACCELERATOR_KEY={0}", ks);
        }
        ArrayList<KeyboardShortcut> ksList = new ArrayList<KeyboardShortcut>();
        if (el.hasChildNodes()) {
            NodeList nl = el.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                KeyStroke ks2;
                Element ce;
                String tagName;
                Node cn = nl.item(i);
                if (!(cn instanceof Element) || !(tagName = (ce = (Element)cn).getNodeName()).equals("keys")) continue;
                String keyStr = null;
                String target = null;
                if (ce.hasAttribute("keyStroke")) {
                    keyStr = ce.getAttribute("keyStroke");
                }
                if (ce.hasAttribute("key")) {
                    keyStr = ce.getAttribute("key");
                }
                if (ce.hasAttribute("target")) {
                    target = ce.getAttribute("target");
                }
                if (keyStr == null || (ks2 = KeyStroke.getKeyStroke(keyStr)) == null) continue;
                Class<?> c1 = null;
                if (target != null) {
                    try {
                        c1 = Class.forName(target);
                    }
                    catch (ClassNotFoundException ex) {
                        XmlMenuBuilder.logException(ex);
                    }
                }
                KeyboardShortcut kst = new KeyboardShortcut();
                kst.setTarget(c1);
                kst.setKeyStroke(ks2);
                ksList.add(kst);
                XmlMenuBuilder.logFiner("set MenuAction KeyboardShortcut={0} target={1}", ks2, c1);
            }
            if (action instanceof BasicAction && ksList.size() > 0) {
                ((BasicAction)action).getKeyboardShortcuts().addAll(ksList);
                XmlMenuBuilder.logFiner("set MenuAction add keyboard shortcuts count={0}", ksList.size());
            }
        }
        String icoString = XmlMenuBuilder.readAttrOrText(el, "ico", null);
        String smallIcoString = XmlMenuBuilder.readAttrOrText(el, "icoSmall", icoString);
        String largeIcoString = XmlMenuBuilder.readAttrOrText(el, "icoLarge", icoString);
        javax.swing.Icon smallIco = this.readIco(smallIcoString, el);
        javax.swing.Icon largeIco = this.readIco(largeIcoString, el);
        if (smallIco != null) {
            action.putValue("SmallIcon", smallIco);
            XmlMenuBuilder.logFiner("set MenuAction small ico {0}", smallIco);
        }
        if (largeIco != null) {
            action.putValue("SwingLargeIconKey", largeIco);
            XmlMenuBuilder.logFiner("set MenuAction large ico {0}", largeIco);
        }
        XmlMenuBuilder.logFine("parsed menu action, name={0}", actionName);
        return mi;
    }

    protected javax.swing.Icon readIco(String icoString, Element el) {
        if (icoString == null) {
            return null;
        }
        Class<?> c = this.getClass();
        URL u = c.getResource(icoString);
        if (u != null) {
            Icon icon = new Icon(u);
            return icon;
        }
        return null;
    }

    public static class MActionItem
    extends MenuActionItem
    implements EventMapListener {
        private String listenKey;
        private Map listenMap;

        public String getListenKey() {
            return this.listenKey;
        }

        public void setListenKey(String k) {
            this.listenKey = k;
        }

        public Map getListenMap() {
            return this.listenMap;
        }

        public void setListenMap(Map m) {
            this.listenMap = m;
        }

        public void eventMap(MapEvent event) {
            Object v;
            if (this.listenMap != null && this.listenKey != null && (v = this.listenMap.get(this.listenKey)) != null && v instanceof String) {
                String str = (String)v;
                Action a = this.getAction();
                if (a != null) {
                    a.putValue("Name", str);
                }
            }
        }
    }

    public static class RegAction {
        private Element element;
        private Action action;
        private String name;

        public RegAction(Action action, Element el, String name) {
            this.action = action;
            this.element = el;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Element getElement() {
            return this.element;
        }

        public Action getAction() {
            return this.action;
        }
    }

    public class OnClick {
        private String script = null;
        private String language = null;
        private Element element = null;

        public OnClick(String script, String language, Element el) {
            this.element = el;
            this.script = script;
            this.language = language;
        }

        public String getScript() {
            return this.script;
        }

        public String getLanguage() {
            return this.language;
        }

        public Element getElement() {
            return this.element;
        }

        public String getName() {
            return XmlMenuBuilder.readAttrOrText(this.element, "name", null);
        }
    }

    public static class MContainer
    extends MenuContainer
    implements EventMapListener {
        private String listenKey;
        private Map listenMap;

        public String getListenKey() {
            return this.listenKey;
        }

        public void setListenKey(String k) {
            this.listenKey = k;
        }

        public Map getListenMap() {
            return this.listenMap;
        }

        public void setListenMap(Map m) {
            this.listenMap = m;
        }

        public void eventMap(MapEvent event) {
            Object v;
            if (this.listenMap != null && this.listenKey != null && (v = this.listenMap.get(this.listenKey)) != null && v instanceof String) {
                String str = (String)v;
                this.setText(str);
            }
        }
    }

    public static class VisitElement {
        protected Element el = null;
        protected Map<String, Object> pushVars = null;

        public VisitElement() {
            this.pushVars = new HashMap<String, Object>();
        }

        public VisitElement(Element el, Map<String, Object> map) {
            this.pushVars = map;
            this.el = el;
        }

        public VisitElement(Element el) {
            this.el = el;
        }

        public Element getEl() {
            return this.el;
        }

        public Map<String, Object> getPushVars() {
            if (this.pushVars == null) {
                this.pushVars = new HashMap<String, Object>();
            }
            return this.pushVars;
        }
    }
}

