/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import xyz.cofe.gui.swing.properties.PropertySheet;

public class Icons {
    private static final Logger logger = Logger.getLogger(Icons.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static Icon nullIcon;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Icons.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(Icons.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Icons.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getNullIcon() {
        Class<Icons> clazz = Icons.class;
        synchronized (Icons.class) {
            if (nullIcon != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return nullIcon;
            }
            URL icoUrl = PropertySheet.class.getResource("/xyz/cofe/gui/swing/properties/null-03-1.png");
            if (icoUrl != null) {
                nullIcon = new ImageIcon(icoUrl);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return nullIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNullIcon(Icon ico) {
        Class<Icons> clazz = Icons.class;
        synchronized (Icons.class) {
            nullIcon = ico;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        nullIcon = null;
    }
}

