/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedEntries {
    private static final Logger logger = Logger.getLogger(NamedEntries.class.getName());
    private volatile String name;
    private volatile Iterable entries;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = NamedEntries.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(NamedEntries.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(NamedEntries.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public NamedEntries(String name, Iterable entries) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (entries == null) {
            throw new IllegalArgumentException("entries==null");
        }
        this.name = name;
        this.entries = entries;
    }

    public String getName() {
        return this.name;
    }

    public Iterable getEntries() {
        return this.entries;
    }

    public String toString() {
        if (this.entries instanceof Collection) {
            return "count=" + ((Collection)this.entries).size();
        }
        return super.toString();
    }
}

