/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedEntry {
    private static final Logger logger = Logger.getLogger(NamedEntry.class.getName());
    protected volatile String name;
    protected volatile Object entry;
    protected volatile String asString = null;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = NamedEntry.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(NamedEntry.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(NamedEntry.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public NamedEntry(String name, Object entry) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (entry == null) {
            throw new IllegalArgumentException("entry==null");
        }
        this.name = name;
        this.entry = entry;
    }

    public String getName() {
        return this.name;
    }

    public Object getEntry() {
        return this.entry;
    }

    public String getAsString() {
        return this.asString;
    }

    public NamedEntry setAsString(String asString) {
        this.asString = asString;
        return this;
    }

    public String toString() {
        if (this.asString != null) {
            return this.asString;
        }
        return this.entry == null ? "null" : this.entry.toString();
    }
}

