/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.bean.UiBean;

public class Property {
    private static final Logger logger = Logger.getLogger(Property.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static final WeakHashMap<PropertyDescriptor, Boolean> uiBeanApplied;
    protected volatile UiBean uiBean;
    protected volatile PropertyDescriptor propertyDescriptor;
    protected volatile Object bean;
    protected volatile Func0 readFn;
    protected volatile Func1 writeFn;
    private static volatile WeakHashMap<Method, Boolean> accessibleIsSettedMap;
    protected volatile Boolean readOnly = null;
    protected volatile Boolean readOnlyDescent = null;
    protected volatile boolean notNull = false;
    protected volatile Class propertyType;
    protected volatile Method readMethod;
    protected volatile Method writeMethod;
    protected volatile boolean bound;
    protected volatile boolean constrained;
    protected volatile Class<?> propertyEditorClass;
    protected volatile String name;
    protected volatile String displayName;
    protected volatile boolean expret = false;
    protected volatile boolean hidden = false;
    protected volatile boolean preffered = false;
    protected volatile String shortDescription;
    protected volatile String htmlDescription;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Property.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Property.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(Property.class.getName(), method);
    }

    public Property() {
    }

    public Property(String name, Class type, Func0 read, Func1 write) {
        this.name = name;
        this.propertyType = type;
        this.readFn = read;
        this.writeFn = write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property(Property src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        Property property = src;
        synchronized (property) {
            this.propertyDescriptor = src.propertyDescriptor;
            this.bean = src.bean;
            this.bound = src.bound;
            this.constrained = src.constrained;
            this.displayName = src.displayName;
            this.expret = src.expret;
            this.hidden = src.hidden;
            this.name = src.name;
            this.notNull = src.notNull;
            this.preffered = src.preffered;
            this.propertyEditorClass = src.propertyEditorClass;
            this.propertyType = src.propertyType;
            this.readFn = src.readFn;
            this.readMethod = src.readMethod;
            this.readOnly = src.readOnly;
            this.shortDescription = src.shortDescription;
            this.uiBean = src.uiBean;
            this.writeFn = src.writeFn;
            this.writeMethod = src.writeMethod;
            this.htmlDescription = src.htmlDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property(Object bean, PropertyDescriptor src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        PropertyDescriptor propertyDescriptor = src;
        synchronized (propertyDescriptor) {
            this.bean = bean;
            this.propertyDescriptor = src;
            Method mread = this.propertyDescriptor.getReadMethod();
            Method mwrite = this.propertyDescriptor.getWriteMethod();
            UiBean uib = mread != null ? mread.getAnnotation(UiBean.class) : null;
            this.uiBean = uib = uib == null && mwrite != null ? mwrite.getAnnotation(UiBean.class) : uib;
            if (uib != null) {
                if (uib.forceReadOnly()) {
                    this.readOnly = true;
                }
                if (uib.forceReadOnlyDescent()) {
                    this.readOnlyDescent = true;
                }
                if (uib.forceNotNull()) {
                    this.notNull = true;
                }
                if (uib.htmlDescription().length() > 0) {
                    this.htmlDescription = uib.htmlDescription();
                }
                WeakHashMap<PropertyDescriptor, Boolean> weakHashMap = uiBeanApplied;
                synchronized (weakHashMap) {
                    Boolean applied = uiBeanApplied.get(src);
                    if (applied == null || !applied.booleanValue()) {
                        Class propEdit;
                        String existsDisplayName;
                        String displayName;
                        String existsShortDesc;
                        uiBeanApplied.put(src, true);
                        String shortDesc = uib.shortDescription();
                        if (shortDesc != null && shortDesc.length() > 0 && !shortDesc.equals(existsShortDesc = this.propertyDescriptor.getShortDescription())) {
                            this.propertyDescriptor.setShortDescription(shortDesc);
                        }
                        if ((displayName = uib.displayName()) != null && displayName.length() > 0 && !displayName.equals(existsDisplayName = this.propertyDescriptor.getDisplayName())) {
                            this.propertyDescriptor.setDisplayName(displayName);
                        }
                        if ((propEdit = uib.propertyEditor()) != null && !propEdit.equals(PropertyEditor.class)) {
                            this.propertyDescriptor.setPropertyEditorClass(propEdit);
                        }
                        if (uib.forceHidden()) {
                            this.propertyDescriptor.setHidden(true);
                        }
                    }
                }
            }
        }
    }

    public Property clone() {
        return new Property(this);
    }

    public String getPropertyName() {
        return this.getName();
    }

    public synchronized UiBean getUiBean() {
        return this.uiBean;
    }

    public synchronized void setUiBean(UiBean uiBean) {
        this.uiBean = uiBean;
    }

    public synchronized PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public synchronized void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public synchronized Object getBean() {
        return this.bean;
    }

    public synchronized void setBean(Object bean) {
        this.bean = bean;
    }

    public synchronized Func0 getReadFn() {
        return this.readFn;
    }

    public synchronized void setReadFn(Func0 readFn) {
        this.readFn = readFn;
    }

    public synchronized Func1 getWriteFn() {
        return this.writeFn;
    }

    public synchronized void setWriteFn(Func1 writeFn) {
        this.writeFn = writeFn;
    }

    private boolean readSetAccessible() {
        return true;
    }

    private boolean readKeepAccessible() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeakHashMap<Method, Boolean> accessibleIsSettedMap() {
        if (accessibleIsSettedMap != null) {
            return accessibleIsSettedMap;
        }
        Class<Property> clazz = Property.class;
        synchronized (Property.class) {
            if (accessibleIsSettedMap != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return accessibleIsSettedMap;
            }
            accessibleIsSettedMap = new WeakHashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return accessibleIsSettedMap;
        }
    }

    private boolean accessibleIsSetted(Method m) {
        Boolean v = Property.accessibleIsSettedMap().get(m);
        return v != null ? v : false;
    }

    private void accessibleSetted(Method m, boolean setted) {
        if (m != null) {
            Property.accessibleIsSettedMap().put(m, setted);
        }
    }

    public synchronized Object read() {
        if (this.readFn != null) {
            return this.readFn.apply();
        }
        Object bn = this.bean;
        if (bn == null) {
            throw new IllegalStateException("bean not set");
        }
        Method mread = this.getReadMethod();
        if (mread == null) {
            throw new IllegalStateException("can't read property " + this.getName() + " read method not set");
        }
        try {
            if (this.readSetAccessible() && !this.accessibleIsSetted(mread)) {
                mread.setAccessible(true);
                if (this.readKeepAccessible()) {
                    this.accessibleSetted(mread, true);
                }
            }
            Object val = mread.invoke(bn, new Object[0]);
            return val;
        }
        catch (IllegalAccessException ex) {
            Property.logSevere("can't read property " + this.getPropertyName() + " of " + bn.getClass() + " (method " + mread + ") " + ex.getMessage(), new Object[0]);
            throw new Error(ex);
        }
        catch (IllegalArgumentException ex) {
            Property.logSevere("can't read property " + this.getPropertyName() + " of " + bn.getClass() + " (method " + mread + ") " + ex.getMessage(), new Object[0]);
            throw new Error(ex);
        }
        catch (InvocationTargetException ex) {
            Property.logSevere("can't read property " + this.getPropertyName() + " of " + bn.getClass() + " (method " + mread + ") " + ex.getMessage(), new Object[0]);
            throw new Error(ex);
        }
    }

    public synchronized void write(Object val) {
        if (this.writeFn != null) {
            this.writeFn.apply(val);
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        Object bn = this.bean;
        if (bn == null) {
            throw new IllegalStateException("bean not set");
        }
        Method mwrite = this.getWriteMethod();
        if (mwrite == null) {
            throw new IllegalStateException("can't write property " + this.getName() + " write method not set");
        }
        try {
            mwrite.invoke(bn, val);
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new Error(ex);
        }
        catch (InvocationTargetException ex) {
            throw new Error(ex);
        }
    }

    public synchronized Closeable addPropertyChangeListener(final PropertyChangeListener listener) {
        final Object bin = this.bean;
        if (bin == null) {
            throw new IllegalStateException("property 'bean' not set");
        }
        Class<?> cbean = bin.getClass();
        try {
            Method mAdd = cbean.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            final Method mRemove = cbean.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            mAdd.invoke(bin, listener);
            Closeable c = new Closeable(){
                protected boolean closeCalled = false;

                @Override
                public void close() throws IOException {
                    try {
                        if (this.closeCalled) {
                            return;
                        }
                        this.closeCalled = true;
                        mRemove.invoke(bin, listener);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            return c;
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new Closeable(){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public synchronized boolean isReadOnly() {
        if (this.readOnly == null) {
            Method wmethod = this.getWriteMethod();
            boolean wmethodExists = wmethod != null;
            boolean wfnExists = this.writeFn != null;
            boolean ro = !wmethodExists && !wfnExists;
            return ro;
        }
        return this.readOnly;
    }

    public synchronized void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public synchronized Boolean getReadOnlyDescent() {
        return this.readOnlyDescent;
    }

    public synchronized void setReadOnlyDescent(Boolean readOnlyDescent) {
        this.readOnlyDescent = readOnlyDescent;
    }

    public synchronized boolean isNotNull() {
        Class<?> type = this.getPropertyType();
        if (type != null) {
            if (type.equals(Byte.TYPE)) {
                return true;
            }
            if (type.equals(Short.TYPE)) {
                return true;
            }
            if (type.equals(Integer.TYPE)) {
                return true;
            }
            if (type.equals(Long.TYPE)) {
                return true;
            }
            if (type.equals(Float.TYPE)) {
                return true;
            }
            if (type.equals(Double.TYPE)) {
                return true;
            }
            if (type.equals(Character.TYPE)) {
                return true;
            }
            if (type.equals(Boolean.TYPE)) {
                return true;
            }
        }
        return this.notNull;
    }

    public synchronized void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public synchronized Class<?> getPropertyType() {
        if (this.propertyDescriptor == null) {
            return this.propertyType;
        }
        return this.propertyDescriptor.getPropertyType();
    }

    public synchronized void setPropertyType(Class<?> pt) {
        this.propertyType = pt;
    }

    public synchronized void setValue(String attributeName, Object value) {
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setValue(attributeName, value);
    }

    public synchronized Object getValue(String attributeName) {
        if (this.propertyDescriptor == null) {
            return null;
        }
        return this.propertyDescriptor.getValue(attributeName);
    }

    public synchronized Enumeration<String> attributeNames() {
        if (this.propertyDescriptor == null) {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    return null;
                }
            };
        }
        return this.propertyDescriptor.attributeNames();
    }

    public synchronized Method getReadMethod() {
        if (this.propertyDescriptor == null) {
            return this.readMethod;
        }
        return this.propertyDescriptor.getReadMethod();
    }

    public synchronized void setReadMethod(Method readMethod) throws IntrospectionException {
        this.readMethod = readMethod;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setReadMethod(readMethod);
    }

    public synchronized Method getWriteMethod() {
        if (this.propertyDescriptor == null) {
            return this.writeMethod;
        }
        return this.propertyDescriptor.getWriteMethod();
    }

    public synchronized void setWriteMethod(Method writeMethod) throws IntrospectionException {
        this.writeMethod = writeMethod;
        if (this.propertyDescriptor != null) {
            this.propertyDescriptor.setWriteMethod(writeMethod);
        }
    }

    public synchronized boolean isBound() {
        if (this.propertyDescriptor == null) {
            return this.bound;
        }
        return this.propertyDescriptor.isBound();
    }

    public synchronized void setBound(boolean bound) {
        this.bound = bound;
        if (this.propertyDescriptor != null) {
            this.propertyDescriptor.setBound(bound);
        }
    }

    public synchronized boolean isConstrained() {
        if (this.propertyDescriptor != null) {
            return this.propertyDescriptor.isConstrained();
        }
        return this.constrained;
    }

    public synchronized void setConstrained(boolean constrained) {
        this.constrained = constrained;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setConstrained(constrained);
    }

    public synchronized void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setPropertyEditorClass(propertyEditorClass);
    }

    public synchronized Class<?> getPropertyEditorClass() {
        if (this.propertyDescriptor == null) {
            return this.propertyEditorClass;
        }
        return this.propertyDescriptor.getPropertyEditorClass();
    }

    public PropertyEditor createPropertyEditor(Object bean) {
        if (this.propertyDescriptor == null) {
            throw new IllegalArgumentException("propertyDescriptor is null");
        }
        return this.propertyDescriptor.createPropertyEditor(bean);
    }

    public synchronized String getName() {
        if (this.propertyDescriptor == null) {
            return this.name;
        }
        return this.propertyDescriptor.getName();
    }

    public synchronized void setName(String name) {
        this.name = name;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setName(name);
    }

    public synchronized String getDisplayName() {
        if (this.propertyDescriptor == null) {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.getName();
        }
        return this.propertyDescriptor.getDisplayName();
    }

    public synchronized void setDisplayName(String displayName) {
        this.displayName = displayName;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setDisplayName(displayName);
    }

    public synchronized boolean isExpert() {
        if (this.propertyDescriptor == null) {
            return this.expret;
        }
        return this.propertyDescriptor.isExpert();
    }

    public synchronized void setExpert(boolean expert) {
        this.expret = expert;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setExpert(expert);
    }

    public synchronized boolean isHidden() {
        if (this.propertyDescriptor == null) {
            return this.hidden;
        }
        return this.propertyDescriptor.isHidden();
    }

    public synchronized void setHidden(boolean hidden) {
        this.hidden = hidden;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setHidden(hidden);
    }

    public synchronized boolean isPreferred() {
        if (this.propertyDescriptor == null) {
            return this.preffered;
        }
        return this.propertyDescriptor.isPreferred();
    }

    public synchronized void setPreferred(boolean preferred) {
        this.preffered = preferred;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setPreferred(preferred);
    }

    public synchronized String getShortDescription() {
        if (this.propertyDescriptor == null) {
            return this.shortDescription;
        }
        return this.propertyDescriptor.getShortDescription();
    }

    public synchronized void setShortDescription(String text) {
        this.shortDescription = text;
        if (this.propertyDescriptor == null) {
            return;
        }
        this.propertyDescriptor.setShortDescription(text);
    }

    public synchronized String getHtmlDescription() {
        return this.htmlDescription;
    }

    public synchronized void setHtmlDescription(String htmlDescription) {
        this.htmlDescription = htmlDescription;
    }

    public static Set<Property> propertiesOf(Class cls, Object bean) {
        return Property.propertiesOf(cls, bean, (Predicate<PropertyDescriptor>)((Predicate)null));
    }

    public static PropertyQuery propertyQuery() {
        return new PropertyQuery();
    }

    public static Set<Property> propertiesOf(Class cls, Object bean, final boolean include, final String ... names) {
        Predicate<PropertyDescriptor> f = new Predicate<PropertyDescriptor>(){

            public boolean validate(PropertyDescriptor pd) {
                if (pd == null) {
                    return false;
                }
                if (pd.getPropertyType() == null) {
                    return false;
                }
                if (include) {
                    if (names == null || names.length == 0) {
                        return false;
                    }
                    for (String incName : names) {
                        String pname;
                        if (incName == null || !incName.equals(pname = pd.getName())) continue;
                        return true;
                    }
                    return false;
                }
                if (names == null || names.length == 0) {
                    return true;
                }
                for (String incName : names) {
                    String pname;
                    if (incName == null || !incName.equals(pname = pd.getName())) continue;
                    return false;
                }
                return true;
            }
        };
        return Property.propertiesOf(cls, bean, f);
    }

    public static Set<Property> propertiesOf(Class cls, Object bean, Predicate<PropertyDescriptor> filter) {
        return Property.propertiesOf(cls, bean, filter, null);
    }

    public static Set<Property> propertiesOf(Class cls, Object bean, Predicate<PropertyDescriptor> filter, Convertor<Pair<PropertyDescriptor, Object>, Property> propertyBuilder) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        LinkedHashSet<Property> props = new LinkedHashSet<Property>();
        LinkedHashSet<String> hiddenPropertyNames = new LinkedHashSet<String>();
        UiBean oUiBeanCls = cls.getAnnotation(UiBean.class);
        if (oUiBeanCls != null) {
            UiBean uibCls = oUiBeanCls;
            hiddenPropertyNames.addAll(Arrays.asList(uibCls.hiddenPeroperties()));
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (filter != null) {
                    if (!filter.validate((Object)pd)) continue;
                    props.add(new Property(bean, pd));
                    continue;
                }
                if (pd.getPropertyType() == null) continue;
                Property p = null;
                if (propertyBuilder != null) {
                    p = (Property)propertyBuilder.convert((Object)new BasicPair((Object)pd, bean));
                }
                if (p == null) {
                    p = new Property(bean, pd);
                }
                props.add(p);
            }
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(Property.class.getName()).log(Level.SEVERE, null, ex);
        }
        return props;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        uiBeanApplied = new WeakHashMap();
    }

    public static class PropertyQuery {
        protected Set<String> names = new LinkedHashSet<String>();
        protected boolean include = false;
        protected boolean skipHidden = true;

        public Set<String> getNames() {
            return this.names;
        }

        public PropertyQuery include(String ... names) {
            this.names.addAll(Arrays.asList(names));
            this.include = true;
            return this;
        }

        public PropertyQuery exclude(String ... names) {
            this.names.addAll(Arrays.asList(names));
            this.include = false;
            return this;
        }

        public Skip skip() {
            return new Skip();
        }

        public Predicate<PropertyDescriptor> build() {
            final LinkedHashSet<String> nms = new LinkedHashSet<String>();
            nms.addAll(this.names);
            final boolean inc = this.include;
            final boolean shidden = this.skipHidden;
            return new Predicate<PropertyDescriptor>(){

                public boolean validate(PropertyDescriptor pd) {
                    if (pd == null) {
                        return false;
                    }
                    if (pd.getPropertyType() == null) {
                        return false;
                    }
                    if (shidden && pd.isHidden()) {
                        return false;
                    }
                    if (inc) {
                        for (String incName : nms) {
                            String pname;
                            if (incName == null || !incName.equals(pname = pd.getName())) continue;
                            return true;
                        }
                        return false;
                    }
                    for (String incName : nms) {
                        String pname;
                        if (incName == null || !incName.equals(pname = pd.getName())) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        public class Skip {
            public PropertyQuery hidden(boolean skip) {
                PropertyQuery.this.skipHidden = skip;
                return PropertyQuery.this;
            }
        }
    }
}

