/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.properties.Property;

public class PropertyBuilderGeneric<T extends PropertyBuilderGeneric<?>> {
    private static final Logger logger = Logger.getLogger(PropertyBuilderGeneric.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private String name;
    private Object value;
    private Class type;
    private Func0 reader;
    private Func1 writer;
    private String category = "";
    private String shortDescription = "";
    private String htmlDescription = "";
    private String displayName = "";
    private Class propertyEditor = PropertyEditor.class;
    private boolean forceReadOnly = false;
    private boolean forceReadOnlyDescent = false;
    private boolean forceHidden = false;
    private String[] hiddenPeroperties = new String[0];
    private boolean forceNotNull = false;
    private String editorOpts = "";
    private Object bean = null;
    private Boolean bound = null;
    private Boolean preferred = null;
    private Boolean notNull = null;
    private Boolean hidden = null;
    private Boolean expert = null;
    private Boolean constrained = null;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PropertyBuilderGeneric.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(PropertyBuilderGeneric.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertyBuilderGeneric.class.getName(), method, result);
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T value(Object value) {
        this.value = value;
        return (T)this;
    }

    public T type(Class type) {
        this.type = type;
        return (T)this;
    }

    public T reader(Func0 reader) {
        this.reader = reader;
        return (T)this;
    }

    public T writer(Func1 writer) {
        this.writer = writer;
        return (T)this;
    }

    public T category(String category) {
        if (category == null) {
            category = "";
        }
        this.category = category;
        return (T)this;
    }

    public T shortDescription(String shortDescription) {
        if (shortDescription == null) {
            shortDescription = "";
        }
        this.shortDescription = shortDescription;
        return (T)this;
    }

    public T htmlDescription(String htmlDescription) {
        if (htmlDescription == null) {
            htmlDescription = "";
        }
        this.htmlDescription = htmlDescription;
        return (T)this;
    }

    public T displayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        this.displayName = displayName;
        return (T)this;
    }

    public T propertyEditor(Class<? extends PropertyEditor> propertyEditor) {
        if (propertyEditor == null) {
            propertyEditor = PropertyEditor.class;
        }
        this.propertyEditor = propertyEditor;
        return (T)this;
    }

    public T forceReadOnly(boolean forceReadOnly) {
        this.forceReadOnly = forceReadOnly;
        return (T)this;
    }

    public T forceReadOnlyDescent(boolean forceReadOnlyDescent) {
        this.forceReadOnlyDescent = forceReadOnlyDescent;
        return (T)this;
    }

    public T forceHidden(boolean forceHidden) {
        this.forceHidden = forceHidden;
        return (T)this;
    }

    public T hiddenPeroperties(String ... hiddenPeroperties) {
        ArrayList<String> props = new ArrayList<String>();
        if (hiddenPeroperties != null) {
            for (String p : hiddenPeroperties) {
                if (p == null) continue;
                props.add(p);
            }
        }
        this.hiddenPeroperties = props.toArray(new String[0]);
        return (T)this;
    }

    public T forceNotNull(boolean forceNotNull) {
        this.forceNotNull = forceNotNull;
        return (T)this;
    }

    public T editorOpts(String editorOpts) {
        this.editorOpts = editorOpts;
        return (T)this;
    }

    public T bean(Object bean) {
        this.bean = bean;
        return (T)this;
    }

    public T bound(Boolean bound) {
        this.bound = bound;
        return (T)this;
    }

    public T preferred(Boolean preferred) {
        this.preferred = preferred;
        return (T)this;
    }

    public T notNull(Boolean notNull) {
        this.notNull = notNull;
        return (T)this;
    }

    public T hidden(Boolean hidden) {
        this.hidden = hidden;
        return (T)this;
    }

    public T expert(Boolean expert) {
        this.expert = expert;
        return (T)this;
    }

    public T constrained(Boolean constrained) {
        this.constrained = constrained;
        return (T)this;
    }

    public Property build() {
        if (this.name == null) {
            throw new IllegalArgumentException("name not set");
        }
        if (this.value == null && (this.reader == null || this.type == null)) {
            throw new IllegalArgumentException("value/read+type not set");
        }
        Class<?> typ = null;
        Func0 rd = null;
        if (this.reader != null && this.type != null) {
            rd = this.reader;
            typ = this.type;
        } else if (this.value != null) {
            rd = new Func0(){

                public Object apply() {
                    return PropertyBuilderGeneric.this.value;
                }
            };
            typ = this.value.getClass();
        } else {
            throw new IllegalArgumentException("value/read+type not set");
        }
        Func1 wr = this.writer;
        Property prop = new Property(this.name, typ, rd, wr);
        UiBean uib = new UiBean(){

            public String category() {
                return PropertyBuilderGeneric.this.category;
            }

            public String shortDescription() {
                return PropertyBuilderGeneric.this.shortDescription;
            }

            public String htmlDescription() {
                return PropertyBuilderGeneric.this.htmlDescription;
            }

            public String displayName() {
                return PropertyBuilderGeneric.this.displayName;
            }

            public Class<? extends PropertyEditor> propertyEditor() {
                return PropertyBuilderGeneric.this.propertyEditor;
            }

            public boolean forceReadOnly() {
                return PropertyBuilderGeneric.this.forceReadOnly;
            }

            public boolean forceReadOnlyDescent() {
                return PropertyBuilderGeneric.this.forceReadOnlyDescent;
            }

            public boolean forceHidden() {
                return PropertyBuilderGeneric.this.forceHidden;
            }

            public String[] hiddenPeroperties() {
                return PropertyBuilderGeneric.this.hiddenPeroperties;
            }

            public boolean forceNotNull() {
                return PropertyBuilderGeneric.this.forceNotNull;
            }

            public String editorOpts() {
                return PropertyBuilderGeneric.this.editorOpts;
            }

            public Class<? extends Annotation> annotationType() {
                return UiBean.class;
            }
        };
        prop.setUiBean(uib);
        prop.setBean(this.bean);
        if (this.bound != null) {
            prop.setBound(this.bound);
        }
        if (this.constrained != null) {
            prop.setConstrained(this.constrained);
        }
        if (this.expert != null) {
            prop.setExpert(this.expert);
        }
        if (this.hidden != null) {
            prop.setHidden(this.hidden);
        }
        if (this.notNull != null) {
            prop.setNotNull(this.notNull);
        }
        if (this.preferred != null) {
            prop.setPreferred(this.preferred);
        }
        return prop;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

