/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.iterators.AddIterable;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.SyncEventMap;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.PropertyID;
import xyz.cofe.gui.swing.properties.PropertySettings;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.properties.ReadBeanArray;
import xyz.cofe.gui.swing.properties.ReadBeanList;
import xyz.cofe.gui.swing.properties.ReadBeanMap;
import xyz.cofe.gui.swing.properties.ReadBeanNodes;
import xyz.cofe.gui.swing.properties.ReadBeanProperties;
import xyz.cofe.gui.swing.properties.ReadBeanSet;
import xyz.cofe.gui.swing.properties.SetPropertyEditorOpts;
import xyz.cofe.gui.swing.properties.editor.AbstractPropertyEditor;
import xyz.cofe.gui.swing.properties.editor.CustomEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.text.Text;
import xyz.cofe.types.SimpleTypes;

public class PropertyDB {
    private static final Logger logger = Logger.getLogger(PropertyDB.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Object sync;
    protected final WeakHashMap<PropertyDescriptor, PropertyEditor> propertyDescEditorMap = new WeakHashMap();
    protected final WeakHashMap<Class, Boolean> failedPropertyEditor = new WeakHashMap();
    protected EventMap<String, PropertyEditor> namedEditors;
    protected final WeakHashMap<Property, PropertyEditor> assignedPropertyEditor = new WeakHashMap();
    protected final ClassMap<Set<PropertyEditor>> typeEditors = new ClassMap();
    protected final Map<PropertyEditor, Double> propertyEditorWeightMap = new LinkedHashMap<PropertyEditor, Double>();
    protected final LinkedHashSet<ReadBeanNodes> beanReaders = new LinkedHashSet();
    private volatile Map<String, Map<String, PropertySettings>> propertySettings;
    protected WeakHashMap<PropertyDescriptor, Boolean> appliedPropertySettings = new WeakHashMap();
    private String[] beanReadersOrder = new String[]{ReadBeanProperties.class.getName(), ReadBeanArray.class.getName(), ReadBeanMap.class.getName(), ReadBeanList.class.getName(), ReadBeanSet.class.getName()};
    protected boolean propertySettingsApplyAtRead = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PropertyDB.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertyDB.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(PropertyDB.class.getName(), method);
    }

    public PropertyDB() {
        this.sync = this;
        for (PropertyDBService srvc : ServiceLoader.load(PropertyDBService.class)) {
            if (srvc == null) continue;
            PropertyDB.logFine("loaded service: {0}", srvc.getClass().getName());
            srvc.register(this);
        }
    }

    private static PropertyEditor clonePE(PropertyEditor pe, Map<PropertyEditor, PropertyEditor> clones) {
        if (pe instanceof AbstractPropertyEditor) {
            AbstractPropertyEditor cpe = null;
            cpe = (AbstractPropertyEditor)clones.get(pe);
            if (cpe == null) {
                cpe = ((AbstractPropertyEditor)pe).clone();
                clones.put(pe, cpe);
            }
            return cpe;
        }
        if (pe instanceof CustomEditor) {
            CustomEditor cpe = null;
            cpe = (CustomEditor)clones.get(pe);
            if (cpe == null) {
                cpe = ((CustomEditor)pe).clone();
                clones.put(pe, cpe);
            }
            return cpe;
        }
        if (pe != null) {
            return pe;
        }
        return null;
    }

    public PropertyDB(PropertyDB sample) {
        this.sync = this;
        if (sample != null) {
            Object t;
            PropertyEditor pe;
            this.beanReaders.addAll(sample.beanReaders);
            this.beanReadersOrder = Arrays.copyOf(this.beanReadersOrder, this.beanReadersOrder.length);
            this.failedPropertyEditor.putAll(sample.failedPropertyEditor);
            EventMap<String, PropertyEditor> neditors = this.getNamedEditors();
            LinkedHashMap<PropertyEditor, PropertyEditor> clones = new LinkedHashMap<PropertyEditor, PropertyEditor>();
            for (Map.Entry entry : sample.getNamedEditors().entrySet()) {
                String name = (String)entry.getKey();
                pe = (PropertyEditor)entry.getValue();
                if (name == null || pe == null) continue;
                neditors.put(name, PropertyDB.clonePE(pe, clones));
            }
            for (Map.Entry entry : sample.propertyDescEditorMap.entrySet()) {
                PropertyDescriptor pd = (PropertyDescriptor)entry.getKey();
                pe = (PropertyEditor)entry.getValue();
                if (pd == null) continue;
                this.propertyDescEditorMap.put(pd, PropertyDB.clonePE(pe, clones));
            }
            for (Map.Entry entry : sample.typeEditors.entrySet()) {
                t = (Class)entry.getKey();
                Set pse = (Set)entry.getValue();
                if (t == null || pse == null) continue;
                LinkedHashSet<PropertyEditor> set = new LinkedHashSet<PropertyEditor>();
                for (PropertyEditor pe2 : pse) {
                    if (pe2 == null) continue;
                    set.add(PropertyDB.clonePE(pe2, clones));
                }
                this.typeEditors.put((Class)t, set);
            }
            for (Map.Entry entry : sample.propertyEditorWeightMap.entrySet()) {
                PropertyEditor pe3 = (PropertyEditor)entry.getKey();
                Double w = (Double)entry.getValue();
                if (pe3 == null || w == null) continue;
                this.propertyEditorWeightMap.put(PropertyDB.clonePE(pe3, clones), w);
            }
            for (Map.Entry entry : sample.getPropertySettingsMap().entrySet()) {
                t = (String)entry.getKey();
                Map names = (Map)entry.getValue();
                for (Map.Entry en2 : names.entrySet()) {
                    String pname = (String)en2.getKey();
                    PropertySettings ps = (PropertySettings)en2.getValue();
                    this.setPropertySettings((String)t, pname, ps.clone());
                }
            }
        } else {
            for (PropertyDBService srvc : ServiceLoader.load(PropertyDBService.class)) {
                if (srvc == null) continue;
                PropertyDB.logFine("loaded service: {0}", srvc.getClass().getName());
                srvc.register(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMap<String, PropertyEditor> getNamedEditors() {
        Object object = this.sync;
        synchronized (object) {
            if (this.namedEditors == null) {
                this.namedEditors = new SyncEventMap(new LinkedHashMap(), this.sync);
            }
            return this.namedEditors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamedEditors(EventMap<String, PropertyEditor> namedEditors) {
        PropertyDB propertyDB = this;
        synchronized (propertyDB) {
            this.namedEditors = namedEditors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEditor getPropertyEditorOf(PropertyValue pv) {
        Object object = this.sync;
        synchronized (object) {
            if (pv == null) {
                return null;
            }
            Property p = pv.getProperty();
            if (p == null) {
                return null;
            }
            UiBean uib = p.getUiBean();
            PropertyEditor pe = this.getPropertyEditorOf(pv.getProperty());
            if (pe != null) {
                return pe;
            }
            Object val = pv.getValue();
            if (val != null) {
                pe = this.getTypeEditor(val.getClass());
                if (pe instanceof SetPropertyEditorOpts) {
                    if (uib != null && uib.editorOpts() != null && uib.editorOpts().length() > 0) {
                        ((SetPropertyEditorOpts)((Object)pe)).setPropertyEditorOpts(uib.editorOpts());
                    } else {
                        ((SetPropertyEditorOpts)((Object)pe)).setPropertyEditorOpts("");
                    }
                }
                if (pe != null) {
                    return pe;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignEditor(Property prop, PropertyEditor pe) {
        if (prop == null) {
            throw new IllegalArgumentException("prop==null");
        }
        Object object = this.sync;
        synchronized (object) {
            if (pe != null) {
                this.assignedPropertyEditor.remove(prop);
            } else {
                this.assignedPropertyEditor.put(prop, pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEditor getPropertyEditorOf(Property p) {
        if (p == null) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            PropertyEditor ape = this.assignedPropertyEditor.get(p);
            PropertyEditor pe = ape != null ? ape : this.getPropertyEditorOf(p.getPropertyDescriptor());
            UiBean uib = p.getUiBean();
            if (pe instanceof SetPropertyEditorOpts) {
                if (uib != null && uib.editorOpts() != null && uib.editorOpts().length() > 0) {
                    ((SetPropertyEditorOpts)((Object)pe)).setPropertyEditorOpts(uib.editorOpts());
                } else {
                    ((SetPropertyEditorOpts)((Object)pe)).setPropertyEditorOpts("");
                }
            }
            if (pe == null) {
                PropertyEditor tpe = this.getTypeEditor(p.getPropertyType());
                if (tpe instanceof SetPropertyEditorOpts) {
                    if (uib != null && uib.editorOpts() != null && uib.editorOpts().length() > 0) {
                        ((SetPropertyEditorOpts)((Object)tpe)).setPropertyEditorOpts(uib.editorOpts());
                    } else {
                        ((SetPropertyEditorOpts)((Object)tpe)).setPropertyEditorOpts("");
                    }
                }
                if (tpe != null) {
                    return tpe;
                }
            }
            return pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEditor getPropertyEditorOf(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            return null;
        }
        PropertyEditor pe = null;
        Object object = this.sync;
        synchronized (object) {
            Class<?> cls = propertyDescriptor.getPropertyEditorClass();
            if (cls != null && !this.failedPropertyEditor.containsKey(cls)) {
                try {
                    Object o = cls.newInstance();
                    if (o instanceof PropertyEditor) {
                        pe = (PropertyEditor)o;
                        this.propertyDescEditorMap.put(propertyDescriptor, pe);
                    } else {
                        this.failedPropertyEditor.put(cls, true);
                    }
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(PropertyDB.class.getName()).log(Level.SEVERE, null, ex);
                    this.failedPropertyEditor.put(cls, true);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(PropertyDB.class.getName()).log(Level.SEVERE, null, ex);
                    this.failedPropertyEditor.put(cls, true);
                }
            }
        }
        return pe;
    }

    public Set<PropertyEditor> getPaintablesOf(Class type) {
        LinkedHashSet<PropertyEditor> res = new LinkedHashSet<PropertyEditor>();
        if (type == null) {
            return res;
        }
        Set peSet = (Set)this.getTypeEditors().fetch(type);
        for (PropertyEditor pe : peSet) {
            if (pe == null || !pe.isPaintable()) continue;
            res.add(pe);
        }
        return res;
    }

    public Set<TreeTableNodeGetFormatOf> getFormattersOf(Class type) {
        LinkedHashSet<TreeTableNodeGetFormatOf> res = new LinkedHashSet<TreeTableNodeGetFormatOf>();
        if (type == null) {
            return res;
        }
        Set peSet = (Set)this.getTypeEditors().fetch(type);
        if (peSet != null) {
            for (PropertyEditor pe : peSet) {
                if (pe == null || !(pe instanceof TreeTableNodeGetFormatOf)) continue;
                res.add((TreeTableNodeGetFormatOf)((Object)pe));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap<Set<PropertyEditor>> getTypeEditors() {
        Object object = this.sync;
        synchronized (object) {
            return this.typeEditors;
        }
    }

    public void registerTypeEditor(Class type, PropertyEditor pe) {
        this.registerTypeEditor(type, pe, null);
    }

    public void registerTypeEditor(Class type, PropertyEditor pe, Double weight) {
        this.registerTypeEditor(type, pe, weight, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTypeEditor(Class type, PropertyEditor pe, Double weight, String id) {
        Object object = this.sync;
        synchronized (object) {
            if (type == null) {
                throw new IllegalArgumentException("type==null");
            }
            if (pe == null) {
                throw new IllegalArgumentException("pe==null");
            }
            PropertyDB.logFine("registry {0} editor ({1})", type, pe.getClass());
            LinkedHashSet<PropertyEditor> editors = (LinkedHashSet<PropertyEditor>)this.typeEditors.get(type);
            if (editors == null) {
                editors = new LinkedHashSet<PropertyEditor>();
                this.typeEditors.put(type, editors);
            }
            editors.add(pe);
            this.failedPropertyEditor.clear();
            if (weight != null) {
                this.propertyEditorWeightMap.put(pe, weight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEditor getTypeEditor(Class type) {
        if (type == null) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            Set editors = (Set)this.typeEditors.fetch(type);
            if (editors == null || editors.isEmpty()) {
                return null;
            }
            Double minw = null;
            PropertyEditor minpe = null;
            Double maxw = null;
            PropertyEditor maxpe = null;
            for (PropertyEditor pe : editors) {
                double w = this.getWeightOf(pe);
                if (minw == null || minw > w) {
                    minw = w;
                    minpe = pe;
                }
                if (maxw != null && !(maxw < w)) continue;
                maxw = w;
                maxpe = pe;
            }
            return maxpe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWeightOf(PropertyEditor pe) {
        if (pe == null) {
            return -99.0;
        }
        Object object = this.sync;
        synchronized (object) {
            Double w = this.propertyEditorWeightMap.get(pe);
            if (w != null) {
                return w;
            }
            if (pe.supportsCustomEditor()) {
                return 2.0;
            }
            return 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWeightOf(PropertyEditor pe, double weight) {
        if (pe == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.propertyEditorWeightMap.put(pe, weight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpandableType(Class t) {
        Object object = this.sync;
        synchronized (object) {
            if (SimpleTypes.isSimple((Class)t)) {
                return false;
            }
            return t != String.class;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReadBeanNodes> getBeanNodeReaders() {
        Object object = this.sync;
        synchronized (object) {
            return this.beanReaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReadBeanNodes(ReadBeanNodes rb) {
        if (rb == null) {
            throw new IllegalArgumentException("rb==null");
        }
        Object object = this.sync;
        synchronized (object) {
            boolean addedNew = this.beanReaders.add(rb);
            if (addedNew) {
                PropertyDB.logFine("registerReadBean {0}", rb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Property> filter(Set<Property> properties, UiBean uib) {
        Object object = this.sync;
        synchronized (object) {
            if (properties == null) {
                throw new IllegalArgumentException("properties==null");
            }
            if (properties.isEmpty()) {
                return properties;
            }
            LinkedHashSet<String> hiddenProperties = new LinkedHashSet<String>();
            if (uib != null) {
                hiddenProperties.addAll(Arrays.asList(uib.hiddenPeroperties()));
            }
            LinkedHashSet<Property> removeset = new LinkedHashSet<Property>();
            for (Property prop2 : properties) {
                if (prop2.getReadMethod() == null && prop2.getReadFn() == null) {
                    removeset.add(prop2);
                    continue;
                }
                UiBean cuib = prop2.getUiBean();
                if (cuib != null && cuib.forceHidden()) {
                    removeset.add(prop2);
                    continue;
                }
                if (!hiddenProperties.contains(prop2.getName())) continue;
                removeset.add(prop2);
            }
            properties.removeAll(removeset);
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, PropertySettings>> getPropertySettingsMap() {
        if (this.propertySettings != null) {
            return this.propertySettings;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.propertySettings != null) {
                return this.propertySettings;
            }
            this.propertySettings = new TreeMap<String, Map<String, PropertySettings>>();
            return this.propertySettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PropertySettings> getPropertySettingsOf(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        Object object = this.sync;
        synchronized (object) {
            return this.getPropertySettingsOf(cls.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PropertySettings> getPropertySettingsOf(String clsName) {
        if (clsName == null) {
            throw new IllegalArgumentException("cls==null");
        }
        Object object = this.sync;
        synchronized (object) {
            Map<String, Map<String, PropertySettings>> mm = this.getPropertySettingsMap();
            Map<String, PropertySettings> m = mm.get(clsName);
            if (m == null) {
                m = new TreeMap<String, PropertySettings>();
                mm.put(clsName, m);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertySettingsOf(Class cls, Map<String, PropertySettings> m) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        Object object = this.sync;
        synchronized (object) {
            this.setPropertySettingsOf(cls.getName(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertySettingsOf(String clsName, Map<String, PropertySettings> m) {
        if (clsName == null) {
            throw new IllegalArgumentException("clsName==null");
        }
        Object object = this.sync;
        synchronized (object) {
            if (m == null) {
                this.getPropertySettingsMap().remove(clsName);
            } else {
                this.getPropertySettingsMap().put(clsName, m);
            }
        }
    }

    private PropertySettings hasPropertySettings(Class cls, String name) {
        if (cls == null || name == null) {
            return null;
        }
        Map<String, Map<String, PropertySettings>> psMap = this.getPropertySettingsMap();
        if (psMap == null) {
            return null;
        }
        if (!psMap.containsKey(cls.getName())) {
            return null;
        }
        Map<String, PropertySettings> m = psMap.get(cls.getName());
        if (m == null) {
            return null;
        }
        if (!m.containsKey(name)) {
            return null;
        }
        PropertySettings ps = m.get(name);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySettings getPropertySettingsOf(Class cls, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        Object object = this.sync;
        synchronized (object) {
            Map<String, PropertySettings> m = this.getPropertySettingsOf(cls);
            PropertySettings ps = m.get(name);
            if (ps == null) {
                ps = new PropertySettings();
                m.put(name, ps);
            }
            return ps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertySettingsOf(Class cls, String name, PropertySettings ps) {
        if (name == null) {
            this.setPropertySettingsOf(cls, null);
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            Map<String, PropertySettings> m = this.getPropertySettingsOf(cls);
            if (ps == null) {
                m.remove(name);
            } else {
                m.put(name, ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setPropertySettingsOf(String clsName, String name, PropertySettings ps) {
        if (name == null) {
            this.setPropertySettingsOf(clsName, null);
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            Map<String, PropertySettings> m = this.getPropertySettingsOf(clsName);
            if (ps == null) {
                m.remove(name);
            } else {
                m.put(name, ps);
            }
        }
    }

    public PropertySettings getPropertySettingsOf(PropertyDescriptor pd) {
        Class<?> cls;
        Method mread = pd.getReadMethod();
        Method mwrite = pd.getWriteMethod();
        Class<Object> clazz = mread != null ? mread.getDeclaringClass() : (cls = mwrite != null ? mwrite.getDeclaringClass() : null);
        if (cls == null) {
            return null;
        }
        String name = pd.getName();
        if (name == null) {
            return null;
        }
        return this.getPropertySettingsOf(cls, name);
    }

    public synchronized PropertySettings getPropertySetting(Class cls, String name) {
        return this.getPropertySettingsOf(cls, name);
    }

    public synchronized PropertySettings getPropertySettings(String clsName, String name, boolean createIfNotExists) {
        if (clsName == null) {
            throw new IllegalArgumentException("clsName==null");
        }
        Map<String, PropertySettings> m = this.getPropertySettingsOf(clsName);
        PropertySettings ps = m.get(name);
        if (ps == null && createIfNotExists) {
            ps = new PropertySettings();
            m.put(name, ps);
        }
        return ps;
    }

    public void setPropertySettings(Class clsName, String propertyName, PropertySettings ps) {
        if (clsName == null) {
            throw new IllegalArgumentException("clsName==null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName==null");
        }
        this.setPropertySettingsOf(clsName, propertyName, ps);
    }

    public void setPropertySettings(String clsName, String propertyName, PropertySettings ps) {
        if (clsName == null) {
            throw new IllegalArgumentException("clsName==null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName==null");
        }
        this.setPropertySettingsOf(clsName, propertyName, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertySettingsCacheDrop() {
        Object object = this.sync;
        synchronized (object) {
            this.appliedPropertySettings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void propertySettingsClear() {
        Object object = this.sync;
        synchronized (object) {
            this.appliedPropertySettings.clear();
            this.getPropertySettingsMap().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Property createProperty(Object bean, PropertyDescriptor pd) {
        Property prop = new Property(bean, pd);
        if (pd != null) {
            Object object = this.sync;
            synchronized (object) {
                PropertySettings ps;
                Boolean t = this.appliedPropertySettings.get(pd);
                if (t == null && (ps = this.getPropertySettingsOf(pd)) != null) {
                    ps.applyTo(prop, this);
                    this.appliedPropertySettings.put(pd, true);
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PropertyEditor> getAllPropertyEditors() {
        ArrayList<Collection> list = new ArrayList<Collection>();
        Object object = this.sync;
        synchronized (object) {
            for (Map.Entry en : this.getTypeEditors().entrySet()) {
                Class type = (Class)en.getKey();
                Set pset = (Set)en.getValue();
                list.add(pset);
            }
            if (this.propertyEditorWeightMap != null) {
                list.add(this.propertyEditorWeightMap.keySet());
            }
            if (this.namedEditors != null) {
                list.add(this.namedEditors.values());
            }
        }
        return Iterators.set((Iterable)new AddIterable(list));
    }

    public Export exports() {
        return new Export();
    }

    public Import imports() {
        return new Import();
    }

    public boolean isPropertySettingsApplyAtRead() {
        return this.propertySettingsApplyAtRead;
    }

    public void setPropertySettingsApplyAtRead(boolean propertySettingsApplyAtRead) {
        this.propertySettingsApplyAtRead = propertySettingsApplyAtRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable readBeadNodes(Object bean) {
        if (bean == null) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            LinkedHashSet<ReadBeanNodes> s;
            Iterable[] res = new Iterable[1];
            TreeMap<Integer, LinkedHashSet<ReadBeanNodes>> order = new TreeMap<Integer, LinkedHashSet<ReadBeanNodes>>();
            for (ReadBeanNodes readBeanNodes : this.beanReaders) {
                if (readBeanNodes == null) continue;
                int pos = Text.indexOf((String)readBeanNodes.getClass().getName(), (String[])this.beanReadersOrder);
                s = (LinkedHashSet<ReadBeanNodes>)order.get(pos);
                if (s == null) {
                    s = new LinkedHashSet<ReadBeanNodes>();
                    order.put(pos, s);
                }
                s.add(readBeanNodes);
            }
            for (Map.Entry entry : order.entrySet()) {
                Integer k = (Integer)entry.getKey();
                s = (Set)entry.getValue();
                for (ReadBeanNodes reader : s) {
                    Iterable ires = reader.readBeanNodes(bean);
                    if (ires == null) continue;
                    if (res[0] == null) {
                        res[0] = ires;
                        continue;
                    }
                    res[0] = Iterators.sequence((Iterable[])new Iterable[]{res[0], ires});
                }
            }
            Iterable iter = res[0];
            if (iter != null && this.propertySettingsApplyAtRead) {
                final Class<?> clazz = bean.getClass();
                UiBean uib = clazz.getAnnotation(UiBean.class);
                final String[] hiddenPropName = uib != null ? uib.hiddenPeroperties() : new String[]{};
                Predicate filter = new Predicate(){

                    public boolean validate(Object value) {
                        if (value instanceof Property) {
                            Property p = (Property)value;
                            if (p.isHidden()) {
                                return false;
                            }
                            if (Text.in((String)p.getName(), (String[])hiddenPropName)) {
                                return false;
                            }
                            PropertySettings ps = PropertyDB.this.hasPropertySettings(clazz, p.getName());
                            if (ps != null) {
                                Boolean constr;
                                String sdesc;
                                Boolean pref;
                                Boolean exp;
                                Boolean ro;
                                if (ps.getHidden() != null && ps.getHidden().booleanValue()) {
                                    return false;
                                }
                                String dname = ps.getDisplayName();
                                if (dname != null) {
                                    p.setDisplayName(dname);
                                }
                                if ((ro = ps.getReadOnly()) != null) {
                                    p.setReadOnly(ro);
                                }
                                if ((exp = ps.getExpert()) != null) {
                                    p.setExpert(exp);
                                }
                                if ((pref = ps.getPreferred()) != null) {
                                    p.setPreferred(pref);
                                }
                                if ((sdesc = ps.getShortDescription()) != null) {
                                    p.setShortDescription(sdesc);
                                }
                                if ((constr = ps.getConstrained()) != null) {
                                    p.setConstrained(constr);
                                }
                            }
                        }
                        return true;
                    }
                };
                iter = Iterators.predicate((Iterable)iter, (Predicate)filter);
            }
            return iter;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public class Import
    implements Runnable {
        protected Set<ImportPropertySettings> importPropSettings = new LinkedHashSet<ImportPropertySettings>();

        public Set<ImportPropertySettings> getPropertySettings() {
            return this.importPropSettings;
        }

        public ImportPropertySettings propertySettings() {
            ImportPropertySettings ips = new ImportPropertySettings();
            ips.setParent(this);
            return ips;
        }

        public Import propertySettings(Iterable<Pair<PropertyID, PropertySettings>> source) {
            ImportPropertySettings ips = new ImportPropertySettings();
            ips.setParent(this);
            ips.setSource(source);
            return this;
        }

        @Override
        public synchronized void run() {
            if (!this.importPropSettings.isEmpty()) {
                PropertyDB.this.appliedPropertySettings.clear();
                PropertyDB.this.getPropertySettingsMap().clear();
                for (ImportPropertySettings i : this.importPropSettings) {
                    i.run();
                }
            }
        }
    }

    public class ImportPropertySettings
    implements Runnable {
        protected Iterable<Pair<PropertyID, PropertySettings>> source;
        protected Import parent;

        public synchronized Iterable<Pair<PropertyID, PropertySettings>> getSource() {
            return this.source;
        }

        public synchronized void setSource(Iterable<Pair<PropertyID, PropertySettings>> source) {
            this.source = source;
        }

        public ImportPropertySettings source(Iterable<Pair<PropertyID, PropertySettings>> source) {
            this.setSource(source);
            return this;
        }

        public Import getParent() {
            return this.parent;
        }

        public void setParent(Import parent) {
            this.parent = parent;
        }

        public Import set() {
            if (this.parent != null) {
                this.parent.getPropertySettings().add(this);
            }
            return this.parent;
        }

        @Override
        public synchronized void run() {
            if (this.source != null) {
                for (Pair<PropertyID, PropertySettings> en : this.source) {
                    PropertyID pid = (PropertyID)en.A();
                    PropertySettings ps = (PropertySettings)en.B();
                    if (pid == null || ps == null || pid.getName() == null || pid.getType() == null) continue;
                    PropertyDB.this.setPropertySettingsOf(pid.getType(), pid.getName(), ps);
                }
            }
        }
    }

    public class Export
    implements Runnable {
        protected Set<Runnable> exports = new LinkedHashSet<Runnable>();

        public Export propertySettings(Reciver<Pair<PropertyID, PropertySettings>> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException("consumer==null");
            }
            ExportPropertySettings exp = new ExportPropertySettings();
            this.exports.add(exp);
            exp.setConsumer(consumer);
            return this;
        }

        @Override
        public void run() {
            for (Runnable e : this.exports) {
                if (e == null) continue;
                e.run();
            }
        }
    }

    public class ExportPropertySettings
    implements Runnable {
        protected Reciver<Pair<PropertyID, PropertySettings>> consumer;

        public synchronized Reciver<Pair<PropertyID, PropertySettings>> getConsumer() {
            return this.consumer;
        }

        public synchronized void setConsumer(Reciver<Pair<PropertyID, PropertySettings>> consumer) {
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (this.consumer == null) {
                return;
            }
            PropertyDB propertyDB = PropertyDB.this;
            synchronized (propertyDB) {
                for (Map.Entry en : PropertyDB.this.getPropertySettingsMap().entrySet()) {
                    String clsName = (String)en.getKey();
                    Map propMap = (Map)en.getValue();
                    for (Map.Entry en2 : propMap.entrySet()) {
                        String propName = (String)en2.getKey();
                        PropertySettings ps = (PropertySettings)en2.getValue();
                        if (propName == null) {
                            return;
                        }
                        if (ps == null) {
                            return;
                        }
                        PropertyID pid = new PropertyID(clsName, propName);
                        this.consumer.recive((Object)new BasicPair((Object)pid, (Object)ps));
                    }
                }
            }
        }
    }
}

