/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyID
implements Comparable<PropertyID> {
    private static final Logger logger = Logger.getLogger(PropertyID.class.getName());
    protected final String type;
    protected final String name;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = PropertyID.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = PropertyID.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = PropertyID.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = PropertyID.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = PropertyID.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = PropertyID.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(PropertyID.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertyID.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public PropertyID(PropertyDescriptor pd) {
        if (pd == null) {
            throw new IllegalArgumentException("pd==null");
        }
        Method mread = pd.getReadMethod();
        Method mwrite = pd.getWriteMethod();
        if (mread == null && mwrite == null) {
            throw new IllegalArgumentException("can't fetch property owner class, read/write method not exists");
        }
        Method meth = mread != null ? mread : mwrite;
        Class<?> decl = meth.getDeclaringClass();
        if (decl == null) {
            throw new IllegalArgumentException("can't fetch property owner class, mread/mwrite.getDeclaringClass() - return null");
        }
        this.type = decl.getName();
        this.name = pd.getName();
    }

    public PropertyID(String type, String name) {
        this.type = type;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyID(PropertyID sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        PropertyID propertyID = sample;
        synchronized (propertyID) {
            this.type = sample.type;
            this.name = sample.name;
        }
    }

    public PropertyID clone() {
        return new PropertyID(this);
    }

    public PropertyID cloneWith(String type, String name) {
        return new PropertyID(type, name);
    }

    public String getType() {
        return this.type;
    }

    public PropertyID type(String type) {
        return this.cloneWith(type, this.name);
    }

    public String getName() {
        return this.name;
    }

    public PropertyID name(String name) {
        return this.cloneWith(this.type, name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyID other = (PropertyID)obj;
        if (this.type == null && other.type == null && this.name == null && other.name == null) {
            return true;
        }
        if (this.type != null) {
            if (other.type == null) {
                return false;
            }
            if (!this.type.equals(other.type)) {
                return false;
            }
            if (this.name != null) {
                if (other.name == null) {
                    return false;
                }
                return this.name.equals(other.name);
            }
            return other.name == null;
        }
        if (other.type != null) {
            return false;
        }
        if (this.name != null) {
            if (other.name == null) {
                return false;
            }
            return this.name.equals(other.name);
        }
        return other.name == null;
    }

    @Override
    public int compareTo(PropertyID o) {
        if (o == null) {
            return -1;
        }
        if (!o.getClass().equals(PropertyID.class)) {
            throw new IllegalArgumentException("can't compare with " + o.getClass() + " = " + o);
        }
        PropertyID pid = o;
        int cmptype = 0;
        if (this.type == null && pid.type == null) {
            cmptype = 0;
        } else if (this.type != null && pid.type == null) {
            cmptype = -1;
        } else if (this.type == null && pid.type != null) {
            cmptype = 1;
        } else if (this.type != null && pid.type != null) {
            cmptype = this.type.compareTo(pid.type);
        }
        int cmpname = 0;
        if (this.name == null && pid.name == null) {
            cmpname = 0;
        } else if (this.name != null && pid.name == null) {
            cmpname = -1;
        } else if (this.name == null && pid.name != null) {
            cmpname = 1;
        } else if (this.name != null && pid.name != null) {
            cmpname = this.name.compareTo(pid.name);
        }
        if (cmptype != 0) {
            return cmptype;
        }
        return cmpname;
    }

    public String toString() {
        return "PropertyID{type=" + this.type + ", name=" + this.name + '}';
    }

    public static PropertyID parse(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        Pattern ptrn = Pattern.compile("(?is)^PropertyID\\s*\\{\\s*type=([^,]+),\\s*name=([^\\}]+)\\s*?\\}");
        Matcher m = ptrn.matcher(text);
        if (m.matches()) {
            String type = m.group(1);
            String name = m.group(2);
            if (type != null && name != null) {
                type = type.trim();
                name = name.trim();
                return new PropertyID(type, name);
            }
        }
        return null;
    }
}

