/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.beans.PropertyEditor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyDB;

public class PropertySettings {
    private static final Logger logger = Logger.getLogger(PropertySettings.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected volatile String displayName;
    protected volatile Boolean constrained;
    protected volatile Boolean expert;
    protected volatile Boolean hidden;
    protected volatile String name;
    protected volatile Boolean preferred;
    protected volatile String shortDescription;
    protected volatile String htmlDescription;
    protected volatile Boolean readOnly;
    protected volatile String editorName;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PropertySettings.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(PropertySettings.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertySettings.class.getName(), method, result);
    }

    public PropertySettings() {
    }

    public PropertySettings(PropertySettings sample) {
        if (sample != null) {
            this.displayName = sample.displayName;
            this.constrained = sample.constrained;
            this.expert = sample.expert;
            this.hidden = sample.hidden;
            this.name = sample.name;
            this.preferred = sample.preferred;
            this.shortDescription = sample.shortDescription;
            this.readOnly = sample.readOnly;
            this.editorName = sample.editorName;
        }
    }

    public PropertySettings clone() {
        return new PropertySettings(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T readLock(Func0<T> reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader == null");
        }
        try {
            Object result;
            this.readWriteLock.readLock().lock();
            Object object = result = reader.apply();
            return (T)object;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T writeLock(Func0<T> writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer == null");
        }
        try {
            Object result;
            this.readWriteLock.writeLock().lock();
            Object object = result = writer.apply();
            return (T)object;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public String getDisplayName() {
        return this.readLock(new Func0<String>(){

            public String apply() {
                return PropertySettings.this.displayName;
            }
        });
    }

    public void setDisplayName(final String displayName) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.displayName = displayName;
                return null;
            }
        });
    }

    public Boolean getConstrained() {
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                return PropertySettings.this.constrained;
            }
        });
    }

    public void setConstrained(final Boolean constrained) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.constrained = constrained;
                return null;
            }
        });
    }

    public Boolean getExpert() {
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                return PropertySettings.this.expert;
            }
        });
    }

    public void setExpert(final Boolean expert) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.expert = expert;
                return null;
            }
        });
    }

    public Boolean getHidden() {
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                return PropertySettings.this.hidden;
            }
        });
    }

    public void setHidden(final Boolean hidden) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.hidden = hidden;
                return null;
            }
        });
    }

    public String getName() {
        return this.readLock(new Func0<String>(){

            public String apply() {
                return PropertySettings.this.name;
            }
        });
    }

    protected void setName(final String name) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.name = name;
                return null;
            }
        });
    }

    public Boolean getPreferred() {
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                return PropertySettings.this.preferred;
            }
        });
    }

    public void setPreferred(final Boolean preferred) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.preferred = preferred;
                return null;
            }
        });
    }

    public String getShortDescription() {
        return this.readLock(new Func0<String>(){

            public String apply() {
                return PropertySettings.this.shortDescription;
            }
        });
    }

    public void setShortDescription(final String shortDescription) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.shortDescription = shortDescription;
                return null;
            }
        });
    }

    public String getHtmlDescription() {
        return this.readLock(new Func0<String>(){

            public String apply() {
                return PropertySettings.this.htmlDescription;
            }
        });
    }

    public void setHtmlDescription(final String htmlDescription) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.htmlDescription = htmlDescription;
                return null;
            }
        });
    }

    public Boolean getReadOnly() {
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                return PropertySettings.this.readOnly;
            }
        });
    }

    public void setReadOnly(final Boolean readOnly) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.readOnly = readOnly;
                return null;
            }
        });
    }

    public String getEditorName() {
        return this.readLock(new Func0<String>(){

            public String apply() {
                return PropertySettings.this.editorName;
            }
        });
    }

    public void setEditorName(final String editorName) {
        this.writeLock(new Func0<Object>(){

            public Object apply() {
                PropertySettings.this.editorName = editorName;
                return null;
            }
        });
    }

    public void applyTo(final Property p, final PropertyDB pdb) {
        if (p == null) {
            throw new IllegalArgumentException("p==null");
        }
        this.readLock(new Func0<Object>(){

            public Object apply() {
                PropertyEditor pe;
                if (PropertySettings.this.displayName != null) {
                    p.setDisplayName(PropertySettings.this.displayName);
                }
                if (PropertySettings.this.constrained != null) {
                    p.setConstrained(PropertySettings.this.constrained);
                }
                if (PropertySettings.this.expert != null) {
                    p.setExpert(PropertySettings.this.expert);
                }
                if (PropertySettings.this.hidden != null) {
                    p.setHidden(PropertySettings.this.hidden);
                }
                if (PropertySettings.this.name != null) {
                    p.setName(PropertySettings.this.name);
                }
                if (PropertySettings.this.preferred != null) {
                    p.setPreferred(PropertySettings.this.preferred);
                }
                if (PropertySettings.this.shortDescription != null) {
                    p.setShortDescription(PropertySettings.this.shortDescription);
                }
                if (PropertySettings.this.htmlDescription != null) {
                    p.setHtmlDescription(PropertySettings.this.htmlDescription);
                }
                if (PropertySettings.this.readOnly != null) {
                    p.setReadOnly(PropertySettings.this.readOnly);
                }
                if (PropertySettings.this.editorName != null && pdb != null && (pe = (PropertyEditor)pdb.getNamedEditors().get((Object)PropertySettings.this.editorName)) != null) {
                    pdb.assignEditor(p, pe);
                }
                return null;
            }
        });
    }

    public int hashCode() {
        return this.readLock(new Func0<Integer>(){

            public Integer apply() {
                int hash = 5;
                hash = 89 * hash + (PropertySettings.this.displayName != null ? PropertySettings.this.displayName.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.constrained != null ? PropertySettings.this.constrained.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.expert != null ? PropertySettings.this.expert.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.hidden != null ? PropertySettings.this.hidden.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.name != null ? PropertySettings.this.name.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.preferred != null ? PropertySettings.this.preferred.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.shortDescription != null ? PropertySettings.this.shortDescription.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.readOnly != null ? PropertySettings.this.readOnly.hashCode() : 0);
                hash = 89 * hash + (PropertySettings.this.editorName != null ? PropertySettings.this.editorName.hashCode() : 0);
                return hash;
            }
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        final PropertySettings other = (PropertySettings)obj;
        return this.readLock(new Func0<Boolean>(){

            public Boolean apply() {
                if (PropertySettings.this.displayName == null ? other.displayName != null : !PropertySettings.this.displayName.equals(other.displayName)) {
                    return false;
                }
                if (PropertySettings.this.name == null ? other.name != null : !PropertySettings.this.name.equals(other.name)) {
                    return false;
                }
                if (PropertySettings.this.shortDescription == null ? other.shortDescription != null : !PropertySettings.this.shortDescription.equals(other.shortDescription)) {
                    return false;
                }
                if (PropertySettings.this.htmlDescription == null ? other.htmlDescription != null : !PropertySettings.this.htmlDescription.equals(other.htmlDescription)) {
                    return false;
                }
                if (PropertySettings.this.editorName == null ? other.editorName != null : !PropertySettings.this.editorName.equals(other.editorName)) {
                    return false;
                }
                if (!(PropertySettings.this.constrained == other.constrained || PropertySettings.this.constrained != null && PropertySettings.this.constrained.equals(other.constrained))) {
                    return false;
                }
                if (!(PropertySettings.this.expert == other.expert || PropertySettings.this.expert != null && PropertySettings.this.expert.equals(other.expert))) {
                    return false;
                }
                if (!(PropertySettings.this.hidden == other.hidden || PropertySettings.this.hidden != null && PropertySettings.this.hidden.equals(other.hidden))) {
                    return false;
                }
                if (!(PropertySettings.this.preferred == other.preferred || PropertySettings.this.preferred != null && PropertySettings.this.preferred.equals(other.preferred))) {
                    return false;
                }
                if (!(PropertySettings.this.readOnly == other.readOnly || PropertySettings.this.readOnly != null && PropertySettings.this.readOnly.equals(other.readOnly))) {
                    return false;
                }
                return true;
            }
        });
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

