/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.properties.Icons;
import xyz.cofe.gui.swing.properties.NamedEntries;
import xyz.cofe.gui.swing.properties.NamedEntry;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyBuilderGeneric;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertySheetEdit;
import xyz.cofe.gui.swing.properties.PropertySheetEvent;
import xyz.cofe.gui.swing.properties.PropertySheetListener;
import xyz.cofe.gui.swing.properties.PropertySheetReadFail;
import xyz.cofe.gui.swing.properties.PropertySheetWriteFail;
import xyz.cofe.gui.swing.properties.PropertySheetWrited;
import xyz.cofe.gui.swing.properties.editor.EnumEditor;
import xyz.cofe.gui.swing.properties.editor.TreeTableWrapEditor;
import xyz.cofe.gui.swing.table.TableFocusListener;
import xyz.cofe.gui.swing.tree.TreeTable;
import xyz.cofe.gui.swing.tree.TreeTableHelper;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;
import xyz.cofe.text.Output;
import xyz.cofe.text.Text;

public class PropertySheet
extends JPanel {
    private static final Logger logger = Logger.getLogger(PropertySheet.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final ListenersHelper<PropertySheetListener, PropertySheetEvent> listeners = new ListenersHelper((Func2)new Func2<Object, PropertySheetListener, PropertySheetEvent>(){

        public Object apply(PropertySheetListener ls, PropertySheetEvent ev) {
            if (ls != null) {
                ls.propertySheetEvent(ev);
            }
            return null;
        }
    });
    protected TreeTable table;
    protected JScrollPane scroll;
    protected JSplitPane splitPane;
    protected JPanel descriptionPanel;
    private int setDescriptionVisible_cnt = 0;
    protected volatile PropertyDB pdb;
    protected volatile Icon nullIcon = null;
    protected volatile TreeTableNodeFormat nullValueFormat;
    private Func1<String, Property> propertyNamingFn = new Func1<String, Property>(){

        public String apply(Property prop) {
            return prop.getDisplayName();
        }
    };
    private Func1<Object, Property> propertyValueReaderFn = new Func1<Object, Property>(){

        public Object apply(Property prop) {
            try {
                Object val = prop.read();
                return val;
            }
            catch (Throwable err) {
                PropertySheet.this.fireEvent(new PropertySheetReadFail(PropertySheet.this, prop, err));
                return null;
            }
        }
    };
    private Func2<Object, Property, Object> propertyValueWriterFn = new Func2<Object, Property, Object>(){

        public Object apply(Property prop, Object val) {
            try {
                prop.write(val);
                PropertySheet.this.fireEvent(new PropertySheetWrited(PropertySheet.this, prop, val));
            }
            catch (Throwable err) {
                PropertySheet.this.fireEvent(new PropertySheetWriteFail(PropertySheet.this, prop, val, err));
            }
            return val;
        }
    };
    private Func2<TreeTableNodeValueEditor.Editor, Property, TreeTableNode> propertyValueEditorFn = new Func2<TreeTableNodeValueEditor.Editor, Property, TreeTableNode>(){

        public TreeTableNodeValueEditor.Editor apply(Property prop, TreeTableNode ttn) {
            PropertyEditor pe;
            if (prop.isReadOnly()) {
                return null;
            }
            List<Object> dataPath = ttn.getDataPath();
            AbstractList pdataPath = null;
            if (dataPath == null) {
                pdataPath = new ArrayList();
            } else {
                pdataPath = new LinkedList<Object>(dataPath);
                if (!pdataPath.isEmpty()) {
                    pdataPath.remove(pdataPath.size() - 1);
                }
            }
            Collections.reverse(pdataPath);
            for (Object pd : pdataPath) {
                Property p;
                Boolean ro;
                if (!(pd instanceof Property) || (ro = (p = (Property)pd).getReadOnlyDescent()) == null || !ro.booleanValue()) continue;
                return null;
            }
            Class<?> ptype = prop.getPropertyType();
            if (ptype != null && ptype.isEnum()) {
                return new EnumEditor(ptype, true);
            }
            PropertyDB cpdb = PropertySheet.this.getPropertyDB();
            if (cpdb != null && (pe = cpdb.getPropertyEditorOf(prop)) != null) {
                if (pe instanceof TreeTableNodeValueEditor.Editor) {
                    return (TreeTableNodeValueEditor.Editor)((Object)pe);
                }
                return new TreeTableWrapEditor(pe);
            }
            return null;
        }
    };
    private Func2<TreeTableNodeFormat, Property, TreeTableNode> propertyValueFormatFn = new Func2<TreeTableNodeFormat, Property, TreeTableNode>(){

        public TreeTableNodeFormat apply(Property prop, TreeTableNode node) {
            TreeTableNodeFormat cfmt;
            TreeTableNodeGetFormatOf getNF;
            Set<TreeTableNodeGetFormatOf> propFormats;
            PropertyDB cpdb;
            Class<?> propType;
            TreeTableNodeFormat nfmt;
            TreeTableNodeFormatBasic fmt = new TreeTableNodeFormatBasic();
            Object val = null;
            try {
                val = prop.read();
            }
            catch (Throwable ex) {
                fmt.setConvertor(new Convertor<Object, String>(){

                    public String convert(Object from) {
                        String err = ex.getMessage();
                        String errc = ex.getClass().getSimpleName();
                        return errc + (err != null ? " " + err : "");
                    }
                });
                fmt.setForeground(Color.RED);
                return fmt;
            }
            if (val == null && (nfmt = PropertySheet.this.getNullValueFormat()) != null) {
                fmt.merge(nfmt);
            }
            boolean readOnly = prop.isReadOnly();
            List<Object> dataPath = node.getDataPath();
            AbstractList pdataPath = null;
            if (dataPath == null) {
                pdataPath = new ArrayList();
            } else {
                pdataPath = new LinkedList<Object>(dataPath);
                if (!pdataPath.isEmpty()) {
                    pdataPath.remove(pdataPath.size() - 1);
                }
            }
            Collections.reverse(pdataPath);
            for (Object pd : pdataPath) {
                Property p;
                Boolean ro;
                if (!(pd instanceof Property) || (ro = (p = (Property)pd).getReadOnlyDescent()) == null || !ro.booleanValue()) continue;
                readOnly = true;
                break;
            }
            if (readOnly) {
                fmt.setForeground(Color.gray);
            }
            if ((propType = prop.getPropertyType()) != null && (cpdb = PropertySheet.this.getPropertyDB()) != null && (propFormats = cpdb.getFormattersOf(propType)) != null && !propFormats.isEmpty() && (getNF = propFormats.iterator().next()) != null && (cfmt = getNF.getTreeTableNodeFormatOf(val)) != null) {
                fmt.merge(cfmt);
            }
            return fmt;
        }
    };
    private Func2<Class, Property, TreeTableNode> propertyValueTypeFn = new Func2<Class, Property, TreeTableNode>(){

        public Class apply(Property prop, TreeTableNode node) {
            return prop.getPropertyType();
        }
    };
    private Func1<Boolean, Property> propertyValueFollowableFn = new Func1<Boolean, Property>(){

        public Boolean apply(Property prop) {
            PropertyDB pdb = PropertySheet.this.getPropertyDB();
            return pdb.isExpandableType(prop.getPropertyType());
        }
    };
    private NodesExtracter<Property, Object> propertyValueFollowFn = new NodesExtracter<Property, Object>(){

        public Iterable<Object> extract(Property prop) {
            Object propval = prop.read();
            if (propval != null) {
                String[] hidden;
                PropertyDB pdb = PropertySheet.this.getPropertyDB();
                Iterable iter = pdb.readBeadNodes(propval);
                UiBean uib = prop.getUiBean();
                if (uib != null && (hidden = uib.hiddenPeroperties()) != null && hidden.length > 0) {
                    Predicate filterHidden = new Predicate(){

                        public boolean validate(Object value) {
                            Property prop;
                            return !(value instanceof Property) || !Text.in((String)(prop = (Property)value).getName(), (String[])hidden);
                        }
                    };
                    iter = Iterators.predicate((Iterable)iter, (Predicate)filterHidden);
                }
                iter = Iterators.notNullFilter((Iterable)iter);
                ArrayList<Object> result = new ArrayList<Object>();
                TreeMap categories = new TreeMap();
                ArrayList uncategoried = new ArrayList();
                for (Object nodeData : iter) {
                    String cat = null;
                    if (nodeData instanceof Property && (uib = ((Property)nodeData).getUiBean()) != null && uib.category().length() > 0) {
                        cat = uib.category();
                    }
                    if (cat != null) {
                        ArrayList l = (ArrayList)categories.get(cat);
                        if (l == null) {
                            l = new ArrayList();
                            categories.put(cat, l);
                        }
                        l.add(nodeData);
                        continue;
                    }
                    uncategoried.add(nodeData);
                }
                if (!categories.isEmpty()) {
                    for (String cat : categories.keySet()) {
                        List catv = (List)categories.get(cat);
                        NamedEntries ne = new NamedEntries(cat, catv);
                        result.add(ne);
                    }
                }
                for (Object nodeData : uncategoried) {
                    result.add(nodeData);
                }
                return result;
            }
            return null;
        }
    };

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PropertySheet.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(PropertySheet.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PropertySheet.class.getName(), method, result);
    }

    public PropertySheet() {
        this.buildUI();
        this.configureTreeTable(this.getTreeTable());
        this.listen(PropertySheetReadFail.class, new Reciver<PropertySheetReadFail>(){

            public void recive(PropertySheetReadFail ev) {
                logger.log(Level.SEVERE, "read property " + ev.getProperty().getName() + " : " + ev.getProperty().getPropertyType() + " fail", ev.getError());
            }
        });
        this.listen(PropertySheetWriteFail.class, new Reciver<PropertySheetWriteFail>(){

            public void recive(PropertySheetWriteFail ev) {
                logger.log(Level.SEVERE, "write property " + ev.getProperty().getName() + " : " + ev.getProperty().getPropertyType() + " fail", ev.getError());
            }
        });
        if (this.table != null) {
            TableFocusListener tableFocusListener = new TableFocusListener(this.table, true){

                @Override
                protected void onFocusedRowChanged(JTable jtable, int oldRow, int curRow) {
                    TreeTableNodeBasic ttnb;
                    Object op;
                    TreeTableNode o = PropertySheet.this.table.getFocusedNode();
                    if (o instanceof TreeTableNodeBasic && (op = (ttnb = (TreeTableNodeBasic)o).getData()) instanceof Property) {
                        Property p = (Property)op;
                        if (PropertySheet.this.descriptionPanel != null && PropertySheet.this.isDescriptionVisible()) {
                            PropertySheet.this.buildDescription(PropertySheet.this.descriptionPanel, p);
                        }
                    }
                }
            };
        }
    }

    public boolean hasListener(PropertySheetListener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<PropertySheetListener> getListeners() {
        return this.listeners.getListeners();
    }

    public Closeable addListener(PropertySheetListener listener) {
        return this.listeners.addListener((Object)listener);
    }

    public Closeable addListener(PropertySheetListener listener, boolean weakLink) {
        return this.listeners.addListener((Object)listener, weakLink);
    }

    public void removeListener(PropertySheetListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void fireEvent(PropertySheetEvent event) {
        this.listeners.fireEvent((Object)event);
    }

    public <T extends PropertySheetEvent> Closeable listen(final Class<T> cls, final Reciver<T> consumer) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer == null");
        }
        return this.addListener(new PropertySheetListener(){

            @Override
            public void propertySheetEvent(PropertySheetEvent ev) {
                if (ev == null) {
                    return;
                }
                if (ev.getClass().equals(cls)) {
                    consumer.recive((Object)ev);
                }
            }
        });
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    public JScrollPane getTreeTableScroll() {
        return this.scroll;
    }

    public JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.splitPane.setResizeWeight(1.0);
            this.splitPane.setDividerLocation(0.75);
        }
        this.splitPane.setRightComponent(this.getDescriptionPanel());
        return this.splitPane;
    }

    public JPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new JPanel();
        }
        return this.descriptionPanel;
    }

    public boolean isDescriptionVisible() {
        return this.descriptionPanel != null && this.descriptionPanel.isVisible();
    }

    public void setDescriptionVisible(boolean visible) {
        if (Objects.equals(this.isDescriptionVisible(), visible)) {
            return;
        }
        if (visible) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(this.getSplitPane());
            this.scroll = new JScrollPane(this.table);
            this.getSplitPane().setLeftComponent(this.scroll);
            ++this.setDescriptionVisible_cnt;
            if (this.setDescriptionVisible_cnt == 1) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        PropertySheet.this.getSplitPane().setDividerLocation(0.75);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        } else {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.scroll = new JScrollPane(this.table);
            this.add(this.scroll);
        }
        this.revalidate();
        this.invalidate();
        this.repaint();
    }

    protected void buildDescription(JPanel descPanel, Property property) {
        if (descPanel == null) {
            return;
        }
        descPanel.removeAll();
        if (property == null) {
            return;
        }
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        descPanel.setLayout(new BorderLayout());
        descPanel.add(new JScrollPane(textPane));
        StringWriter sw = new StringWriter();
        Output out = new Output((Writer)sw, true);
        String desc = property.getShortDescription();
        desc = desc == null ? "" : Text.join((Iterable)Text.convert((Iterable)Text.splitNewLinesIterable((String)desc), (Convertor)Text.Convertors.htmlEncode), (String)"<br/>");
        out.template("<div><b>${name}</b> : ${type}</div>${shortDesc}").bind("name", (Object)Text.htmlEncode((String)property.getName())).bind("type", (Object)Text.htmlEncode((String)(property.getPropertyType() != null ? property.getPropertyType().getName() : ""))).bind("shortDesc", (Object)desc).println();
        out.flush();
        textPane.setText(sw.toString());
        String htmlDesc = property.getHtmlDescription();
        if (htmlDesc != null && htmlDesc.trim().length() > 0) {
            textPane.setText(htmlDesc);
        }
        descPanel.revalidate();
        descPanel.repaint();
    }

    protected void buildUI() {
        this.table = new TreeTable();
        this.table.setFillsViewportHeight(true);
        this.scroll = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add(this.scroll);
        this.revalidate();
        this.invalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDB getPropertyDB() {
        if (this.pdb != null) {
            return this.pdb;
        }
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            if (this.pdb != null) {
                return this.pdb;
            }
            this.pdb = new PropertyDB();
            return this.pdb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyDB(PropertyDB newPdb) {
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            this.pdb = newPdb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getNullIcon() {
        if (this.nullIcon != null) {
            return this.nullIcon;
        }
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            if (this.nullIcon != null) {
                return this.nullIcon;
            }
            this.nullIcon = Icons.getNullIcon();
            return this.nullIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNullIcon(Icon ico) {
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            this.nullIcon = ico;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeFormat getNullValueFormat() {
        TreeTableNodeFormat fmt = this.nullValueFormat;
        if (fmt != null) {
            return fmt;
        }
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            fmt = this.nullValueFormat;
            if (fmt != null) {
                return fmt;
            }
            fmt = new TreeTableNodeFormatBasic();
            fmt.setItalic(true);
            Icon ico = this.getNullIcon();
            if (ico != null) {
                fmt.getIcons().add(ico);
            }
            this.nullValueFormat = fmt;
            return this.nullValueFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNullValueFormat(TreeTableNodeFormat nullValueFormat) {
        PropertySheet propertySheet = this;
        synchronized (propertySheet) {
            this.nullValueFormat = nullValueFormat;
        }
    }

    private void configureTreeTable(TreeTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table==null");
        }
        table.setRowHeight(20);
        table.setRootVisible(false);
        table.setNodeColumnName("property");
        table.setNodeColumnHeaderValue("property");
        TreeTableNodeBasic root = new TreeTableNodeBasic();
        root.expand();
        root.setCacheLifeTime(5000L);
        table.setRoot(root);
        TreeTableHelper helper = new TreeTableHelper(table);
        helper.node(Set.class).follow((NodesExtracter<Set, Set>)new NodesExtracter<Set, Object>(){

            public Iterable<Object> extract(Set from) {
                return from;
            }
        }).apply();
        this.configureTreeTableProperty(helper);
        helper.node(NamedEntries.class).naming(new Func1<String, NamedEntries>(){

            public String apply(NamedEntries named) {
                return named.getName();
            }
        }).follow((NodesExtracter<NamedEntries, NamedEntries>)new NodesExtracter<NamedEntries, Object>(){

            public Iterable<Object> extract(NamedEntries named) {
                return named.getEntries();
            }
        }).column("value").reader(new Func1<Object, NamedEntries>(){

            public Object apply(NamedEntries arg) {
                return "";
            }
        }).apply().apply();
        helper.node(NamedEntry.class).naming(new Func1<String, NamedEntry>(){

            public String apply(NamedEntry named) {
                return named.getName();
            }
        }).follow((NodesExtracter<NamedEntry, NamedEntry>)new NodesExtracter<NamedEntry, Object>(){

            public Iterable<Object> extract(NamedEntry named) {
                Object en = named.getEntry();
                if (en != null) {
                    PropertyDB pdb = PropertySheet.this.getPropertyDB();
                    return pdb.readBeadNodes(en);
                }
                return null;
            }
        }).apply();
        helper.node(NamedEntry.class).column("value").reader(new Func1<Object, NamedEntry>(){

            public Object apply(NamedEntry en) {
                return en.getEntry();
            }
        }).apply();
    }

    private void configureTreeTableProperty(TreeTableHelper helper) {
        helper.node(Property.class).naming(this.propertyNamingFn).column("value").reader(this.propertyValueReaderFn).writer(this.propertyValueWriterFn).editor(this.propertyValueEditorFn).type(this.propertyValueTypeFn).format(this.propertyValueFormatFn).apply().followable(this.propertyValueFollowableFn).follow(this.propertyValueFollowFn).apply();
    }

    public void edit(Object bean) {
        this.edit(bean, null);
    }

    public void edit(Object bean, Iterable<Property> extraProperties) {
        PropertySheetEdit editEvent = new PropertySheetEdit(this);
        editEvent.setBean(bean);
        TreeTableNodeBasic root = this.table.getRoot();
        if (root != null) {
            UiBean uib;
            String cat;
            root.dropCache();
            root.getChildrenList().clear();
            TreeTableNodeBasic nroot = root.clone(false, true);
            nroot.setData(bean);
            nroot.setExpanded(true);
            TreeMap<String, ArrayList<Object>> categories = new TreeMap<String, ArrayList<Object>>();
            ArrayList<Object> uncategoried = new ArrayList<Object>();
            PropertyDB pdb = this.getPropertyDB();
            if (bean != null) {
                for (Object nodeData : pdb.readBeadNodes(bean)) {
                    cat = null;
                    if (nodeData instanceof Property && (uib = ((Property)nodeData).getUiBean()) != null && uib.category().length() > 0) {
                        cat = uib.category();
                    }
                    if (cat != null) {
                        ArrayList<Object> l = (ArrayList<Object>)categories.get(cat);
                        if (l == null) {
                            l = new ArrayList<Object>();
                            categories.put(cat, l);
                        }
                        l.add(nodeData);
                        continue;
                    }
                    uncategoried.add(nodeData);
                }
            }
            if (extraProperties != null) {
                for (Property p : extraProperties) {
                    if (p == null) continue;
                    cat = null;
                    uib = p.getUiBean();
                    if (uib != null && uib.category().length() > 0) {
                        cat = uib.category();
                    }
                    if (cat != null) {
                        ArrayList<Property> l = (ArrayList<Property>)categories.get(cat);
                        if (l == null) {
                            l = new ArrayList<Property>();
                            categories.put(cat, l);
                        }
                        l.add(p);
                        continue;
                    }
                    uncategoried.add(p);
                }
            }
            if (!categories.isEmpty()) {
                for (String cat2 : categories.keySet()) {
                    List catv = (List)categories.get(cat2);
                    NamedEntries ne = new NamedEntries(cat2, catv);
                    TreeTableNodeBasic node = new TreeTableNodeBasic(ne);
                    nroot.getChildrenList().add((Object)node);
                    List catValues = (List)categories.get(cat2);
                    if (catValues == null) continue;
                    for (Object p : catValues) {
                        if (!(p instanceof Property)) continue;
                        editEvent.getProperties().add((Property)p);
                    }
                }
            }
            for (Object nodeData : uncategoried) {
                TreeTableNodeBasic node = new TreeTableNodeBasic(nodeData);
                nroot.getChildrenList().add((Object)node);
                if (!(nodeData instanceof Property)) continue;
                editEvent.getProperties().add((Property)nodeData);
            }
            this.table.setRoot(nroot);
            this.fireEvent(editEvent);
        }
        this.revalidate();
    }

    public Edit edit() {
        return new Edit(this);
    }

    public Long getCacheLifeTime() {
        return this.table.getRoot().getCacheLifeTime();
    }

    public void setCacheLifeTime(Long lifeTime) {
        this.table.getRoot().setCacheLifeTime(lifeTime);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class Edit {
        protected PropertySheet ps;
        protected Object bean;
        protected List<Property> properties;

        public Edit(PropertySheet ps) {
            if (ps == null) {
                throw new IllegalArgumentException("ps==null");
            }
            this.ps = ps;
        }

        public Edit bean(Object bean) {
            this.bean = bean;
            return this;
        }

        public List<Property> getProperties() {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>();
            }
            return this.properties;
        }

        public Edit properties(Iterable<Property> properties) {
            this.getProperties().clear();
            if (properties != null) {
                for (Property p : properties) {
                    if (p == null) continue;
                    this.getProperties().add(p);
                }
            }
            return this;
        }

        public EditProperties properties() {
            return new EditProperties(this);
        }

        public void apply() {
            this.ps.edit(this.bean, this.getProperties());
        }
    }

    public static class EditProperties {
        protected Edit edit;

        public EditProperties(Edit edit) {
            if (edit == null) {
                throw new IllegalArgumentException("edit==null");
            }
            this.edit = edit;
        }

        public Edit add(Property prop) {
            if (prop == null) {
                throw new IllegalArgumentException("prop==null");
            }
            this.edit.getProperties().add(prop);
            return this.edit;
        }

        public Edit addAsProperty(Object value, String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value==null");
            }
            PropBuilder pb = (PropBuilder)new PropBuilder(this).name(name);
            pb.value(value);
            return this.add(pb.build());
        }

        public Edit include(Object bean, String ... properties) {
            if (bean == null) {
                throw new IllegalArgumentException("bean == null");
            }
            if (properties == null) {
                throw new IllegalArgumentException("properties == null");
            }
            Set<Property> pset = Property.propertiesOf(bean.getClass(), bean, Property.propertyQuery().include(properties).build());
            this.edit.getProperties().addAll(pset);
            return this.edit;
        }

        public Edit exclude(Object bean, String ... properties) {
            if (bean == null) {
                throw new IllegalArgumentException("bean == null");
            }
            if (properties == null) {
                throw new IllegalArgumentException("properties == null");
            }
            Set<Property> pset = Property.propertiesOf(bean.getClass(), bean, Property.propertyQuery().exclude(properties).build());
            this.edit.getProperties().addAll(pset);
            return this.edit;
        }

        public <T> Edit add(String name, Class<T> type, Func0<T> r) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            if (type == null) {
                throw new IllegalArgumentException("type==null");
            }
            if (r == null) {
                throw new IllegalArgumentException("r==null");
            }
            PropBuilder pb = (PropBuilder)new PropBuilder(this).name(name);
            pb.type(type);
            pb.reader(r);
            return this.add(pb.build());
        }

        public <T> Edit add(String name, Class<T> type, Func0<T> r, Func1<Object, T> w) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            if (type == null) {
                throw new IllegalArgumentException("type==null");
            }
            if (r == null) {
                throw new IllegalArgumentException("r==null");
            }
            PropBuilder pb = (PropBuilder)new PropBuilder(this).name(name);
            pb.type(type);
            pb.reader(r);
            pb.writer(w);
            return this.add(pb.build());
        }

        public PropBuilder create(String name) {
            return (PropBuilder)new PropBuilder(this).name(name);
        }
    }

    public static class PropBuilder
    extends PropertyBuilderGeneric<PropBuilder> {
        protected EditProperties editProperties;

        public PropBuilder(EditProperties editProperties) {
            if (editProperties == null) {
                throw new IllegalArgumentException("editProperties==null");
            }
            this.editProperties = editProperties;
        }

        public EditProperties add() {
            Property p = this.build();
            if (p != null) {
                this.editProperties.add(p);
            }
            return this.editProperties;
        }
    }
}

