/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.properties.NamedEntries;
import xyz.cofe.gui.swing.properties.NamedEntry;
import xyz.cofe.gui.swing.properties.PropertyDB;
import xyz.cofe.gui.swing.properties.PropertyDBService;
import xyz.cofe.gui.swing.properties.ReadBeanNodes;
import xyz.cofe.types.SimpleTypes;

public class ReadBeanSet
implements ReadBeanNodes,
PropertyDBService {
    private static final Logger logger = Logger.getLogger(ReadBeanSet.class.getName());
    private volatile PropertyDB pdb;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = ReadBeanSet.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(ReadBeanSet.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ReadBeanSet.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Override
    public void register(PropertyDB pdb) {
        if (pdb != null) {
            ReadBeanSet rbp = new ReadBeanSet();
            rbp.setPdb(pdb);
            pdb.registerReadBeanNodes(rbp);
        }
    }

    public synchronized PropertyDB getPdb() {
        return this.pdb;
    }

    public synchronized void setPdb(PropertyDB pdb) {
        this.pdb = pdb;
    }

    @Override
    public synchronized Iterable readBeanNodes(Object bean) {
        if (bean == null) {
            return null;
        }
        Class<?> beanCls = bean.getClass();
        boolean exp = true;
        if (this.pdb != null) {
            exp = this.pdb.isExpandableType(beanCls);
        } else if (bean instanceof String) {
            exp = false;
        } else if (SimpleTypes.isSimple(beanCls)) {
            exp = false;
        }
        if (!exp) {
            return null;
        }
        if (!(bean instanceof Set)) {
            return null;
        }
        ArrayList<NamedEntry> res = new ArrayList<NamedEntry>();
        int li = -1;
        for (Object le : (Set)bean) {
            ++li;
            exp = true;
            if (this.pdb != null && le != null) {
                exp = this.pdb.isExpandableType(le.getClass());
            }
            res.add(new NamedEntry("item#" + li, le).setAsString(le == null || exp ? null : le.getClass().toString()));
        }
        LinkedList<NamedEntries> single = new LinkedList<NamedEntries>();
        single.add(new NamedEntries("set interface", res));
        return single;
    }
}

