/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.properties.editor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.ListenersHelper;

public abstract class AbstractPropertyEditor
implements PropertyEditor {
    private static final Logger logger = Logger.getLogger(AbstractPropertyEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final ListenersHelper<PropertyChangeListener, PropertyChangeEvent> propertiesListeners = new ListenersHelper((Func2)new Func2<Object, PropertyChangeListener, PropertyChangeEvent>(){

        public Object apply(PropertyChangeListener lsntr, PropertyChangeEvent ev) {
            lsntr.propertyChange(ev);
            return null;
        }
    });

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(AbstractPropertyEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(AbstractPropertyEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(AbstractPropertyEditor.class.getName(), method, result);
    }

    public abstract AbstractPropertyEditor clone();

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getTags() {
        return new String[0];
    }

    @Override
    public Component getCustomEditor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertiesListeners.addListener((Object)listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertiesListeners.removeListener((Object)listener);
        }
    }

    public void firePropertyChanged(String name, Object oldValue, Object newValue) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.propertiesListeners.fireEvent((Object)new PropertyChangeEvent(this, name, oldValue, newValue));
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

